/*
 * Decompiled with CFR 0.152.
 */
package com.google.ortools.modelbuilder;

import com.google.ortools.modelbuilder.mainJNI;

public class ModelBuilderHelper {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected ModelBuilderHelper(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(ModelBuilderHelper obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected static long swigRelease(ModelBuilderHelper obj) {
        long ptr = 0L;
        if (obj != null) {
            if (!obj.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            ptr = obj.swigCPtr;
            obj.swigCMemOwn = false;
            obj.delete();
        }
        return ptr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                mainJNI.delete_ModelBuilderHelper(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public void overwriteModel(ModelBuilderHelper other_helper) {
        mainJNI.ModelBuilderHelper_overwriteModel(this.swigCPtr, this, ModelBuilderHelper.getCPtr(other_helper), other_helper);
    }

    public boolean writeModelToFile(String filename) {
        return mainJNI.ModelBuilderHelper_writeModelToFile(this.swigCPtr, this, filename);
    }

    public boolean importFromMpsString(String mps_string) {
        return mainJNI.ModelBuilderHelper_importFromMpsString(this.swigCPtr, this, mps_string);
    }

    public boolean importFromMpsFile(String mps_file) {
        return mainJNI.ModelBuilderHelper_importFromMpsFile(this.swigCPtr, this, mps_file);
    }

    public boolean importFromLpString(String lp_string) {
        return mainJNI.ModelBuilderHelper_importFromLpString(this.swigCPtr, this, lp_string);
    }

    public boolean importFromLpFile(String lp_file) {
        return mainJNI.ModelBuilderHelper_importFromLpFile(this.swigCPtr, this, lp_file);
    }

    public int addVar() {
        return mainJNI.ModelBuilderHelper_addVar(this.swigCPtr, this);
    }

    public void setVarLowerBound(int var_index, double lb) {
        mainJNI.ModelBuilderHelper_setVarLowerBound(this.swigCPtr, this, var_index, lb);
    }

    public void setVarUpperBound(int var_index, double ub) {
        mainJNI.ModelBuilderHelper_setVarUpperBound(this.swigCPtr, this, var_index, ub);
    }

    public void setVarIntegrality(int var_index, boolean is_integer) {
        mainJNI.ModelBuilderHelper_setVarIntegrality(this.swigCPtr, this, var_index, is_integer);
    }

    public void setVarObjectiveCoefficient(int var_index, double coeff) {
        mainJNI.ModelBuilderHelper_setVarObjectiveCoefficient(this.swigCPtr, this, var_index, coeff);
    }

    public void setVarName(int var_index, String name) {
        mainJNI.ModelBuilderHelper_setVarName(this.swigCPtr, this, var_index, name);
    }

    public double getVarLowerBound(int var_index) {
        return mainJNI.ModelBuilderHelper_getVarLowerBound(this.swigCPtr, this, var_index);
    }

    public double getVarUpperBound(int var_index) {
        return mainJNI.ModelBuilderHelper_getVarUpperBound(this.swigCPtr, this, var_index);
    }

    public boolean getVarIntegrality(int var_index) {
        return mainJNI.ModelBuilderHelper_getVarIntegrality(this.swigCPtr, this, var_index);
    }

    public double getVarObjectiveCoefficient(int var_index) {
        return mainJNI.ModelBuilderHelper_getVarObjectiveCoefficient(this.swigCPtr, this, var_index);
    }

    public String getVarName(int var_index) {
        return mainJNI.ModelBuilderHelper_getVarName(this.swigCPtr, this, var_index);
    }

    public double getConstraintLowerBound(int ct_index) {
        return mainJNI.ModelBuilderHelper_getConstraintLowerBound(this.swigCPtr, this, ct_index);
    }

    public double getConstraintUpperBound(int ct_index) {
        return mainJNI.ModelBuilderHelper_getConstraintUpperBound(this.swigCPtr, this, ct_index);
    }

    public int addLinearConstraint() {
        return mainJNI.ModelBuilderHelper_addLinearConstraint(this.swigCPtr, this);
    }

    public String getConstraintName(int ct_index) {
        return mainJNI.ModelBuilderHelper_getConstraintName(this.swigCPtr, this, ct_index);
    }

    public double[] getConstraintCoefficients(int ct_index) {
        return mainJNI.ModelBuilderHelper_getConstraintCoefficients(this.swigCPtr, this, ct_index);
    }

    public int[] getConstraintVarIndices(int ct_index) {
        return mainJNI.ModelBuilderHelper_getConstraintVarIndices(this.swigCPtr, this, ct_index);
    }

    public void addConstraintTerm(int ct_index, int var_index, double coeff) {
        mainJNI.ModelBuilderHelper_addConstraintTerm(this.swigCPtr, this, ct_index, var_index, coeff);
    }

    public void clearConstraintTerms(int ct_index) {
        mainJNI.ModelBuilderHelper_clearConstraintTerms(this.swigCPtr, this, ct_index);
    }

    public void safeAddConstraintTerm(int ct_index, int var_index, double coeff) {
        mainJNI.ModelBuilderHelper_safeAddConstraintTerm(this.swigCPtr, this, ct_index, var_index, coeff);
    }

    public void setConstraintCoefficient(int ct_index, int var_index, double coeff) {
        mainJNI.ModelBuilderHelper_setConstraintCoefficient(this.swigCPtr, this, ct_index, var_index, coeff);
    }

    public void setConstraintLowerBound(int ct_index, double lb) {
        mainJNI.ModelBuilderHelper_setConstraintLowerBound(this.swigCPtr, this, ct_index, lb);
    }

    public void setConstraintName(int ct_index, String name) {
        mainJNI.ModelBuilderHelper_setConstraintName(this.swigCPtr, this, ct_index, name);
    }

    public void setConstraintUpperBound(int ct_index, double ub) {
        mainJNI.ModelBuilderHelper_setConstraintUpperBound(this.swigCPtr, this, ct_index, ub);
    }

    public boolean getEnforcedIndicatorValue(int ct_index) {
        return mainJNI.ModelBuilderHelper_getEnforcedIndicatorValue(this.swigCPtr, this, ct_index);
    }

    public boolean isEnforcedConstraint(int ct_index) {
        return mainJNI.ModelBuilderHelper_isEnforcedConstraint(this.swigCPtr, this, ct_index);
    }

    public double getEnforcedConstraintLowerBound(int ct_index) {
        return mainJNI.ModelBuilderHelper_getEnforcedConstraintLowerBound(this.swigCPtr, this, ct_index);
    }

    public double getEnforcedConstraintUpperBound(int ct_index) {
        return mainJNI.ModelBuilderHelper_getEnforcedConstraintUpperBound(this.swigCPtr, this, ct_index);
    }

    public int addEnforcedLinearConstraint() {
        return mainJNI.ModelBuilderHelper_addEnforcedLinearConstraint(this.swigCPtr, this);
    }

    public int getEnforcedIndicatorVariableIndex(int ct_index) {
        return mainJNI.ModelBuilderHelper_getEnforcedIndicatorVariableIndex(this.swigCPtr, this, ct_index);
    }

    public String getEnforcedConstraintName(int ct_index) {
        return mainJNI.ModelBuilderHelper_getEnforcedConstraintName(this.swigCPtr, this, ct_index);
    }

    public double[] getEnforcedConstraintCoefficients(int ct_index) {
        return mainJNI.ModelBuilderHelper_getEnforcedConstraintCoefficients(this.swigCPtr, this, ct_index);
    }

    public int[] getEnforcedConstraintVarIndices(int ct_index) {
        return mainJNI.ModelBuilderHelper_getEnforcedConstraintVarIndices(this.swigCPtr, this, ct_index);
    }

    public void addEnforcedConstraintTerm(int ct_index, int var_index, double coeff) {
        mainJNI.ModelBuilderHelper_addEnforcedConstraintTerm(this.swigCPtr, this, ct_index, var_index, coeff);
    }

    public void clearEnforcedConstraintTerms(int ct_index) {
        mainJNI.ModelBuilderHelper_clearEnforcedConstraintTerms(this.swigCPtr, this, ct_index);
    }

    public void safeAddEnforcedConstraintTerm(int ct_index, int var_index, double coeff) {
        mainJNI.ModelBuilderHelper_safeAddEnforcedConstraintTerm(this.swigCPtr, this, ct_index, var_index, coeff);
    }

    public void setEnforcedConstraintCoefficient(int ct_index, int var_index, double coeff) {
        mainJNI.ModelBuilderHelper_setEnforcedConstraintCoefficient(this.swigCPtr, this, ct_index, var_index, coeff);
    }

    public void setEnforcedConstraintLowerBound(int ct_index, double lb) {
        mainJNI.ModelBuilderHelper_setEnforcedConstraintLowerBound(this.swigCPtr, this, ct_index, lb);
    }

    public void setEnforcedConstraintName(int ct_index, String name) {
        mainJNI.ModelBuilderHelper_setEnforcedConstraintName(this.swigCPtr, this, ct_index, name);
    }

    public void setEnforcedConstraintUpperBound(int ct_index, double ub) {
        mainJNI.ModelBuilderHelper_setEnforcedConstraintUpperBound(this.swigCPtr, this, ct_index, ub);
    }

    public void setEnforcedIndicatorValue(int ct_index, boolean positive) {
        mainJNI.ModelBuilderHelper_setEnforcedIndicatorValue(this.swigCPtr, this, ct_index, positive);
    }

    public void setEnforcedIndicatorVariableIndex(int ct_index, int var_index) {
        mainJNI.ModelBuilderHelper_setEnforcedIndicatorVariableIndex(this.swigCPtr, this, ct_index, var_index);
    }

    public int numConstraints() {
        return mainJNI.ModelBuilderHelper_numConstraints(this.swigCPtr, this);
    }

    public int numVariables() {
        return mainJNI.ModelBuilderHelper_numVariables(this.swigCPtr, this);
    }

    public String getName() {
        return mainJNI.ModelBuilderHelper_getName(this.swigCPtr, this);
    }

    public void setName(String name) {
        mainJNI.ModelBuilderHelper_setName(this.swigCPtr, this, name);
    }

    public void clearObjective() {
        mainJNI.ModelBuilderHelper_clearObjective(this.swigCPtr, this);
    }

    public boolean getMaximize() {
        return mainJNI.ModelBuilderHelper_getMaximize(this.swigCPtr, this);
    }

    public void setMaximize(boolean maximize) {
        mainJNI.ModelBuilderHelper_setMaximize(this.swigCPtr, this, maximize);
    }

    public double getObjectiveOffset() {
        return mainJNI.ModelBuilderHelper_getObjectiveOffset(this.swigCPtr, this);
    }

    public void setObjectiveOffset(double offset) {
        mainJNI.ModelBuilderHelper_setObjectiveOffset(this.swigCPtr, this, offset);
    }

    public void clearHints() {
        mainJNI.ModelBuilderHelper_clearHints(this.swigCPtr, this);
    }

    public void addHint(int var_index, double var_value) {
        mainJNI.ModelBuilderHelper_addHint(this.swigCPtr, this, var_index, var_value);
    }

    public String exportToMpsString(boolean obfuscate) {
        return mainJNI.ModelBuilderHelper_exportToMpsString(this.swigCPtr, this, obfuscate);
    }

    public String exportToLpString(boolean obfuscate) {
        return mainJNI.ModelBuilderHelper_exportToLpString(this.swigCPtr, this, obfuscate);
    }

    public ModelBuilderHelper() {
        this(mainJNI.new_ModelBuilderHelper(), true);
    }
}

