/*
 * Decompiled with CFR 0.152.
 */
package com.google.ortools.modelbuilder;

import com.google.ortools.modelbuilder.EnforcedLinearConstraint;
import com.google.ortools.modelbuilder.LinearArgument;
import com.google.ortools.modelbuilder.LinearConstraint;
import com.google.ortools.modelbuilder.LinearExpr;
import com.google.ortools.modelbuilder.LinearExprBuilder;
import com.google.ortools.modelbuilder.ModelBuilderHelper;
import com.google.ortools.modelbuilder.Variable;
import java.util.LinkedHashMap;
import java.util.Map;

public final class ModelBuilder {
    private final ModelBuilderHelper helper = new ModelBuilderHelper();
    private final Map<Double, Integer> constantMap = new LinkedHashMap<Double, Integer>();

    public ModelBuilder getClone() {
        ModelBuilder clonedModel = new ModelBuilder();
        clonedModel.getHelper().overwriteModel(this.helper);
        clonedModel.constantMap.putAll(this.constantMap);
        return clonedModel;
    }

    public Variable newVar(double lb, double ub, boolean isIntegral, String name) {
        return new Variable(this.helper, lb, ub, isIntegral, name);
    }

    public Variable newNumVar(double lb, double ub, String name) {
        return new Variable(this.helper, lb, ub, false, name);
    }

    public Variable newIntVar(double lb, double ub, String name) {
        return new Variable(this.helper, lb, ub, true, name);
    }

    public Variable newBoolVar(String name) {
        return new Variable(this.helper, 0.0, 1.0, true, name);
    }

    public Variable newConstant(double value) {
        if (this.constantMap.containsKey(value)) {
            return new Variable(this.helper, this.constantMap.get(value));
        }
        Variable cste = new Variable(this.helper, value, value, false, "");
        this.constantMap.put(value, cste.getIndex());
        return cste;
    }

    public Variable varFromIndex(int index) {
        return new Variable(this.helper, index);
    }

    public LinearConstraint addLinearConstraint(LinearArgument expr, double lb, double ub) {
        LinearConstraint lin = new LinearConstraint(this.helper);
        LinearExpr e = expr.build();
        for (int i = 0; i < e.numElements(); ++i) {
            this.helper.addConstraintTerm(lin.getIndex(), e.getVariableIndex(i), e.getCoefficient(i));
        }
        double offset = e.getOffset();
        if (lb == Double.NEGATIVE_INFINITY || lb == Double.POSITIVE_INFINITY) {
            lin.setLowerBound(lb);
        } else {
            lin.setLowerBound(lb - offset);
        }
        if (ub == Double.NEGATIVE_INFINITY || ub == Double.POSITIVE_INFINITY) {
            lin.setUpperBound(ub);
        } else {
            lin.setUpperBound(ub - offset);
        }
        return lin;
    }

    public LinearConstraint addEquality(LinearArgument expr, double value) {
        return this.addLinearConstraint(expr, value, value);
    }

    public LinearConstraint addEquality(LinearArgument left, LinearArgument right) {
        LinearExprBuilder difference = LinearExpr.newBuilder();
        difference.addTerm(left, 1.0);
        difference.addTerm(right, -1.0);
        return this.addLinearConstraint(difference, 0.0, 0.0);
    }

    public LinearConstraint addLessOrEqual(LinearArgument expr, double value) {
        return this.addLinearConstraint(expr, Double.NEGATIVE_INFINITY, value);
    }

    public LinearConstraint addLessOrEqual(LinearArgument left, LinearArgument right) {
        LinearExprBuilder difference = LinearExpr.newBuilder();
        difference.addTerm(left, 1.0);
        difference.addTerm(right, -1.0);
        return this.addLinearConstraint(difference, Double.NEGATIVE_INFINITY, 0.0);
    }

    public LinearConstraint addGreaterOrEqual(LinearArgument expr, double value) {
        return this.addLinearConstraint(expr, value, Double.POSITIVE_INFINITY);
    }

    public LinearConstraint addGreaterOrEqual(LinearArgument left, LinearArgument right) {
        LinearExprBuilder difference = LinearExpr.newBuilder();
        difference.addTerm(left, 1.0);
        difference.addTerm(right, -1.0);
        return this.addLinearConstraint(difference, 0.0, Double.POSITIVE_INFINITY);
    }

    public LinearConstraint constraintFromIndex(int index) {
        return new LinearConstraint(this.helper, index);
    }

    public EnforcedLinearConstraint addEnforcedLinearConstraint(LinearArgument expr, double lb, double ub, Variable iVar, boolean iValue) {
        EnforcedLinearConstraint lin = new EnforcedLinearConstraint(this.helper);
        lin.setIndicatorVariable(iVar);
        lin.setIndicatorValue(iValue);
        LinearExpr e = expr.build();
        for (int i = 0; i < e.numElements(); ++i) {
            this.helper.addEnforcedConstraintTerm(lin.getIndex(), e.getVariableIndex(i), e.getCoefficient(i));
        }
        double offset = e.getOffset();
        if (lb == Double.NEGATIVE_INFINITY || lb == Double.POSITIVE_INFINITY) {
            lin.setLowerBound(lb);
        } else {
            lin.setLowerBound(lb - offset);
        }
        if (ub == Double.NEGATIVE_INFINITY || ub == Double.POSITIVE_INFINITY) {
            lin.setUpperBound(ub);
        } else {
            lin.setUpperBound(ub - offset);
        }
        return lin;
    }

    public EnforcedLinearConstraint addEnforcedEquality(LinearArgument expr, double value, Variable iVar, boolean iValue) {
        return this.addEnforcedLinearConstraint(expr, value, value, iVar, iValue);
    }

    public EnforcedLinearConstraint addEnforcedEquality(LinearArgument left, LinearArgument right, Variable iVar, boolean iValue) {
        LinearExprBuilder difference = LinearExpr.newBuilder();
        difference.addTerm(left, 1.0);
        difference.addTerm(right, -1.0);
        return this.addEnforcedLinearConstraint(difference, 0.0, 0.0, iVar, iValue);
    }

    public EnforcedLinearConstraint addEnforcedLessOrEqual(LinearArgument expr, double value, Variable iVar, boolean iValue) {
        return this.addEnforcedLinearConstraint(expr, Double.NEGATIVE_INFINITY, value, iVar, iValue);
    }

    public EnforcedLinearConstraint addEnforcedLessOrEqual(LinearArgument left, LinearArgument right, Variable iVar, boolean iValue) {
        LinearExprBuilder difference = LinearExpr.newBuilder();
        difference.addTerm(left, 1.0);
        difference.addTerm(right, -1.0);
        return this.addEnforcedLinearConstraint(difference, Double.NEGATIVE_INFINITY, 0.0, iVar, iValue);
    }

    public EnforcedLinearConstraint addEnforcedGreaterOrEqual(LinearArgument expr, double value, Variable iVar, boolean iValue) {
        return this.addEnforcedLinearConstraint(expr, value, Double.POSITIVE_INFINITY, iVar, iValue);
    }

    public EnforcedLinearConstraint addEnforcedGreaterOrEqual(LinearArgument left, LinearArgument right, Variable iVar, boolean iValue) {
        LinearExprBuilder difference = LinearExpr.newBuilder();
        difference.addTerm(left, 1.0);
        difference.addTerm(right, -1.0);
        return this.addEnforcedLinearConstraint(difference, 0.0, Double.POSITIVE_INFINITY, iVar, iValue);
    }

    public EnforcedLinearConstraint enforcedConstraintFromIndex(int index) {
        return new EnforcedLinearConstraint(this.helper, index);
    }

    public void minimize(LinearArgument obj) {
        this.optimize(obj, false);
    }

    public void maximize(LinearArgument obj) {
        this.optimize(obj, true);
    }

    public void optimize(LinearArgument obj, boolean maximize) {
        this.helper.clearObjective();
        LinearExpr e = obj.build();
        LinkedHashMap<Integer, Double> coeffMap = new LinkedHashMap<Integer, Double>();
        for (int i = 0; i < e.numElements(); ++i) {
            coeffMap.merge(e.getVariableIndex(i), e.getCoefficient(i), Double::sum);
        }
        for (Map.Entry entry : coeffMap.entrySet()) {
            if ((Double)entry.getValue() == 0.0) continue;
            this.helper.setVarObjectiveCoefficient((Integer)entry.getKey(), (Double)entry.getValue());
        }
        this.helper.setObjectiveOffset(e.getOffset());
        this.helper.setMaximize(maximize);
    }

    double getObjectiveOffset() {
        return this.helper.getObjectiveOffset();
    }

    void setObjectiveOffset(double offset) {
        this.helper.setObjectiveOffset(offset);
    }

    void clearHints() {
        this.helper.clearHints();
    }

    void addHint(Variable v, double value) {
        this.helper.addHint(v.getIndex(), value);
    }

    public int numVariables() {
        return this.helper.numVariables();
    }

    public int numConstraints() {
        return this.helper.numConstraints();
    }

    public String getName() {
        return this.helper.getName();
    }

    public void setName(String name) {
        this.helper.setName(name);
    }

    public boolean exportToFile(String file) {
        return this.helper.writeModelToProtoFile(file);
    }

    public boolean importFromFile(String file) {
        return this.helper.readModelFromProtoFile(file);
    }

    public String exportToMpsString(boolean obfuscate) {
        return this.helper.exportToMpsString(obfuscate);
    }

    public String exportToLpString(boolean obfuscate) {
        return this.helper.exportToLpString(obfuscate);
    }

    public boolean writeToMpsFile(String filename, boolean obfuscate) {
        return this.helper.writeToMpsFile(filename, obfuscate);
    }

    public boolean importFromMpsString(String mpsString) {
        return this.helper.importFromMpsString(mpsString);
    }

    public boolean importFromMpsFile(String mpsFile) {
        return this.helper.importFromMpsString(mpsFile);
    }

    public boolean importFromLpString(String lpString) {
        return this.helper.importFromLpString(lpString);
    }

    public boolean importFromLpFile(String lpFile) {
        return this.helper.importFromMpsString(lpFile);
    }

    public ModelBuilderHelper getHelper() {
        return this.helper;
    }

    public static class WrongLength
    extends ModelBuilderException {
        public WrongLength(String methodName, String msg) {
            super(methodName, msg);
        }
    }

    public static class MismatchedArrayLengths
    extends ModelBuilderException {
        public MismatchedArrayLengths(String methodName, String array1Name, String array2Name) {
            super(methodName, array1Name + " and " + array2Name + " have mismatched lengths");
        }
    }

    static class ModelBuilderException
    extends RuntimeException {
        public ModelBuilderException(String methodName, String msg) {
            super(methodName + ": " + msg);
        }
    }
}

