/*
 * Decompiled with CFR 0.152.
 */
package com.google.ortools.constraintsolver;

import com.google.ortools.constraintsolver.mainJNI;

public class RoutingIndexManager {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    public RoutingIndexManager(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    public static long getCPtr(RoutingIndexManager obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    public static long swigRelease(RoutingIndexManager obj) {
        long ptr = 0L;
        if (obj != null) {
            if (!obj.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            ptr = obj.swigCPtr;
            obj.swigCMemOwn = false;
            obj.delete();
        }
        return ptr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                mainJNI.delete_RoutingIndexManager(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public RoutingIndexManager(int num_nodes, int num_vehicles, int depot) {
        this(mainJNI.new_RoutingIndexManager__SWIG_0(num_nodes, num_vehicles, depot), true);
    }

    public RoutingIndexManager(int num_nodes, int num_vehicles, int[] starts, int[] ends) {
        this(mainJNI.new_RoutingIndexManager__SWIG_1(num_nodes, num_vehicles, starts, ends), true);
    }

    public int getNumberOfNodes() {
        return mainJNI.RoutingIndexManager_getNumberOfNodes(this.swigCPtr, this);
    }

    public int getNumberOfVehicles() {
        return mainJNI.RoutingIndexManager_getNumberOfVehicles(this.swigCPtr, this);
    }

    public int getNumberOfIndices() {
        return mainJNI.RoutingIndexManager_getNumberOfIndices(this.swigCPtr, this);
    }

    public long getStartIndex(int vehicle) {
        return mainJNI.RoutingIndexManager_getStartIndex(this.swigCPtr, this, vehicle);
    }

    public long getEndIndex(int vehicle) {
        return mainJNI.RoutingIndexManager_getEndIndex(this.swigCPtr, this, vehicle);
    }

    public long nodeToIndex(int node) {
        return mainJNI.RoutingIndexManager_nodeToIndex(this.swigCPtr, this, node);
    }

    public long[] nodesToIndices(int[] nodes) {
        return mainJNI.RoutingIndexManager_nodesToIndices(this.swigCPtr, this, nodes);
    }

    public int indexToNode(long index) {
        return mainJNI.RoutingIndexManager_indexToNode(this.swigCPtr, this, index);
    }
}

