/*
 * Decompiled with CFR 0.152.
 */
package com.google.ortools.constraintsolver;

import com.google.ortools.constraintsolver.Demon;
import com.google.ortools.constraintsolver.IntVar;
import com.google.ortools.constraintsolver.ModelVisitor;
import com.google.ortools.constraintsolver.PropagationBaseObject;
import com.google.ortools.constraintsolver.mainJNI;

public class IntExpr
extends PropagationBaseObject {
    private transient long swigCPtr;

    public IntExpr(long cPtr, boolean cMemoryOwn) {
        super(mainJNI.IntExpr_SWIGUpcast(cPtr), cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    public static long getCPtr(IntExpr obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    public static long swigRelease(IntExpr obj) {
        long ptr = 0L;
        if (obj != null) {
            if (!obj.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            ptr = obj.swigCPtr;
            obj.swigCMemOwn = false;
            obj.delete();
        }
        return ptr;
    }

    @Override
    protected void finalize() {
        this.delete();
    }

    @Override
    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                mainJNI.delete_IntExpr(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public long min() {
        return mainJNI.IntExpr_min(this.swigCPtr, this);
    }

    public void setMin(long m) {
        mainJNI.IntExpr_setMin(this.swigCPtr, this, m);
    }

    public long max() {
        return mainJNI.IntExpr_max(this.swigCPtr, this);
    }

    public void setMax(long m) {
        mainJNI.IntExpr_setMax(this.swigCPtr, this, m);
    }

    public void range(long[] l, long[] u) {
        mainJNI.IntExpr_range(this.swigCPtr, this, l, u);
    }

    public void setRange(long l, long u) {
        mainJNI.IntExpr_setRange(this.swigCPtr, this, l, u);
    }

    public void setValue(long v) {
        mainJNI.IntExpr_setValue(this.swigCPtr, this, v);
    }

    public boolean bound() {
        return mainJNI.IntExpr_bound(this.swigCPtr, this);
    }

    public boolean isVar() {
        return mainJNI.IntExpr_isVar(this.swigCPtr, this);
    }

    public IntVar var() {
        long cPtr = mainJNI.IntExpr_var(this.swigCPtr, this);
        return cPtr == 0L ? null : new IntVar(cPtr, false);
    }

    public IntVar varWithName(String name) {
        long cPtr = mainJNI.IntExpr_varWithName(this.swigCPtr, this, name);
        return cPtr == 0L ? null : new IntVar(cPtr, false);
    }

    public void whenRange(Demon d) {
        mainJNI.IntExpr_whenRange__SWIG_0(this.swigCPtr, this, Demon.getCPtr(d), d);
    }

    public void whenRange(Runnable closure) {
        mainJNI.IntExpr_whenRange__SWIG_1(this.swigCPtr, this, closure);
    }

    public void accept(ModelVisitor visitor) {
        mainJNI.IntExpr_accept(this.swigCPtr, this, ModelVisitor.getCPtr(visitor), visitor);
    }
}

