/*
 * Decompiled with CFR 0.152.
 */
package com.google.ortools.constraintsolver;

import com.google.ortools.constraintsolver.AssignmentIntContainer;
import com.google.ortools.constraintsolver.AssignmentIntervalContainer;
import com.google.ortools.constraintsolver.AssignmentSequenceContainer;
import com.google.ortools.constraintsolver.IntVar;
import com.google.ortools.constraintsolver.IntVarElement;
import com.google.ortools.constraintsolver.IntervalVar;
import com.google.ortools.constraintsolver.IntervalVarElement;
import com.google.ortools.constraintsolver.PropagationBaseObject;
import com.google.ortools.constraintsolver.SWIGTYPE_p_operations_research__AssignmentProto;
import com.google.ortools.constraintsolver.SequenceVar;
import com.google.ortools.constraintsolver.SequenceVarElement;
import com.google.ortools.constraintsolver.Solver;
import com.google.ortools.constraintsolver.mainJNI;

public class Assignment
extends PropagationBaseObject {
    private transient long swigCPtr;

    public Assignment(long cPtr, boolean cMemoryOwn) {
        super(mainJNI.Assignment_SWIGUpcast(cPtr), cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    public static long getCPtr(Assignment obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    public static long swigRelease(Assignment obj) {
        long ptr = 0L;
        if (obj != null) {
            if (!obj.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            ptr = obj.swigCPtr;
            obj.swigCMemOwn = false;
            obj.delete();
        }
        return ptr;
    }

    @Override
    protected void finalize() {
        this.delete();
    }

    @Override
    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                mainJNI.delete_Assignment(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public Assignment(Solver solver) {
        this(mainJNI.new_Assignment__SWIG_0(Solver.getCPtr(solver), solver), true);
    }

    public Assignment(Assignment copy) {
        this(mainJNI.new_Assignment__SWIG_1(Assignment.getCPtr(copy), copy), true);
    }

    public void clear() {
        mainJNI.Assignment_clear(this.swigCPtr, this);
    }

    public boolean empty() {
        return mainJNI.Assignment_empty(this.swigCPtr, this);
    }

    public int size() {
        return mainJNI.Assignment_size(this.swigCPtr, this);
    }

    public int numIntVars() {
        return mainJNI.Assignment_numIntVars(this.swigCPtr, this);
    }

    public int numIntervalVars() {
        return mainJNI.Assignment_numIntervalVars(this.swigCPtr, this);
    }

    public int numSequenceVars() {
        return mainJNI.Assignment_numSequenceVars(this.swigCPtr, this);
    }

    public void store() {
        mainJNI.Assignment_store(this.swigCPtr, this);
    }

    public void restore() {
        mainJNI.Assignment_restore(this.swigCPtr, this);
    }

    public boolean load(String filename) {
        return mainJNI.Assignment_load(this.swigCPtr, this, filename);
    }

    public boolean save(String filename) {
        return mainJNI.Assignment_save__SWIG_0(this.swigCPtr, this, filename);
    }

    public void save(SWIGTYPE_p_operations_research__AssignmentProto assignment_proto) {
        mainJNI.Assignment_save__SWIG_1(this.swigCPtr, this, SWIGTYPE_p_operations_research__AssignmentProto.getCPtr(assignment_proto));
    }

    public void addObjective(IntVar v) {
        mainJNI.Assignment_addObjective(this.swigCPtr, this, IntVar.getCPtr(v), v);
    }

    public void AddObjectives(IntVar[] vars) {
        mainJNI.Assignment_AddObjectives(this.swigCPtr, this, vars);
    }

    public void ClearObjective() {
        mainJNI.Assignment_ClearObjective(this.swigCPtr, this);
    }

    public int NumObjectives() {
        return mainJNI.Assignment_NumObjectives(this.swigCPtr, this);
    }

    public IntVar objective() {
        long cPtr = mainJNI.Assignment_objective(this.swigCPtr, this);
        return cPtr == 0L ? null : new IntVar(cPtr, false);
    }

    public IntVar ObjectiveFromIndex(int index) {
        long cPtr = mainJNI.Assignment_ObjectiveFromIndex(this.swigCPtr, this, index);
        return cPtr == 0L ? null : new IntVar(cPtr, false);
    }

    public boolean hasObjective() {
        return mainJNI.Assignment_hasObjective(this.swigCPtr, this);
    }

    public boolean HasObjectiveFromIndex(int index) {
        return mainJNI.Assignment_HasObjectiveFromIndex(this.swigCPtr, this, index);
    }

    public long objectiveMin() {
        return mainJNI.Assignment_objectiveMin(this.swigCPtr, this);
    }

    public long objectiveMax() {
        return mainJNI.Assignment_objectiveMax(this.swigCPtr, this);
    }

    public long objectiveValue() {
        return mainJNI.Assignment_objectiveValue(this.swigCPtr, this);
    }

    public boolean objectiveBound() {
        return mainJNI.Assignment_objectiveBound(this.swigCPtr, this);
    }

    public void setObjectiveMin(long m) {
        mainJNI.Assignment_setObjectiveMin(this.swigCPtr, this, m);
    }

    public void setObjectiveMax(long m) {
        mainJNI.Assignment_setObjectiveMax(this.swigCPtr, this, m);
    }

    public void setObjectiveValue(long value) {
        mainJNI.Assignment_setObjectiveValue(this.swigCPtr, this, value);
    }

    public void setObjectiveRange(long l, long u) {
        mainJNI.Assignment_setObjectiveRange(this.swigCPtr, this, l, u);
    }

    public long ObjectiveMinFromIndex(int index) {
        return mainJNI.Assignment_ObjectiveMinFromIndex(this.swigCPtr, this, index);
    }

    public long ObjectiveMaxFromIndex(int index) {
        return mainJNI.Assignment_ObjectiveMaxFromIndex(this.swigCPtr, this, index);
    }

    public long ObjectiveValueFromIndex(int index) {
        return mainJNI.Assignment_ObjectiveValueFromIndex(this.swigCPtr, this, index);
    }

    public boolean ObjectiveBoundFromIndex(int index) {
        return mainJNI.Assignment_ObjectiveBoundFromIndex(this.swigCPtr, this, index);
    }

    public void SetObjectiveMinFromIndex(int index, long m) {
        mainJNI.Assignment_SetObjectiveMinFromIndex(this.swigCPtr, this, index, m);
    }

    public void SetObjectiveMaxFromIndex(int index, long m) {
        mainJNI.Assignment_SetObjectiveMaxFromIndex(this.swigCPtr, this, index, m);
    }

    public void SetObjectiveValueFromIndex(int index, long value) {
        mainJNI.Assignment_SetObjectiveValueFromIndex(this.swigCPtr, this, index, value);
    }

    public void SetObjectiveRangeFromIndex(int index, long l, long u) {
        mainJNI.Assignment_SetObjectiveRangeFromIndex(this.swigCPtr, this, index, l, u);
    }

    public IntVarElement add(IntVar var) {
        long cPtr = mainJNI.Assignment_add__SWIG_0(this.swigCPtr, this, IntVar.getCPtr(var), var);
        return cPtr == 0L ? null : new IntVarElement(cPtr, false);
    }

    public void add(IntVar[] vars) {
        mainJNI.Assignment_add__SWIG_1(this.swigCPtr, this, vars);
    }

    public IntVarElement fastAdd(IntVar var) {
        long cPtr = mainJNI.Assignment_fastAdd__SWIG_0(this.swigCPtr, this, IntVar.getCPtr(var), var);
        return cPtr == 0L ? null : new IntVarElement(cPtr, false);
    }

    public long min(IntVar var) {
        return mainJNI.Assignment_min(this.swigCPtr, this, IntVar.getCPtr(var), var);
    }

    public long max(IntVar var) {
        return mainJNI.Assignment_max(this.swigCPtr, this, IntVar.getCPtr(var), var);
    }

    public long value(IntVar var) {
        return mainJNI.Assignment_value(this.swigCPtr, this, IntVar.getCPtr(var), var);
    }

    public boolean bound(IntVar var) {
        return mainJNI.Assignment_bound(this.swigCPtr, this, IntVar.getCPtr(var), var);
    }

    public void setMin(IntVar var, long m) {
        mainJNI.Assignment_setMin(this.swigCPtr, this, IntVar.getCPtr(var), var, m);
    }

    public void setMax(IntVar var, long m) {
        mainJNI.Assignment_setMax(this.swigCPtr, this, IntVar.getCPtr(var), var, m);
    }

    public void setRange(IntVar var, long l, long u) {
        mainJNI.Assignment_setRange(this.swigCPtr, this, IntVar.getCPtr(var), var, l, u);
    }

    public void setValue(IntVar var, long value) {
        mainJNI.Assignment_setValue(this.swigCPtr, this, IntVar.getCPtr(var), var, value);
    }

    public IntervalVarElement add(IntervalVar var) {
        long cPtr = mainJNI.Assignment_add__SWIG_2(this.swigCPtr, this, IntervalVar.getCPtr(var), var);
        return cPtr == 0L ? null : new IntervalVarElement(cPtr, false);
    }

    public void add(IntervalVar[] vars) {
        mainJNI.Assignment_add__SWIG_3(this.swigCPtr, this, vars);
    }

    public IntervalVarElement fastAdd(IntervalVar var) {
        long cPtr = mainJNI.Assignment_fastAdd__SWIG_1(this.swigCPtr, this, IntervalVar.getCPtr(var), var);
        return cPtr == 0L ? null : new IntervalVarElement(cPtr, false);
    }

    public long startMin(IntervalVar var) {
        return mainJNI.Assignment_startMin(this.swigCPtr, this, IntervalVar.getCPtr(var), var);
    }

    public long startMax(IntervalVar var) {
        return mainJNI.Assignment_startMax(this.swigCPtr, this, IntervalVar.getCPtr(var), var);
    }

    public long startValue(IntervalVar var) {
        return mainJNI.Assignment_startValue(this.swigCPtr, this, IntervalVar.getCPtr(var), var);
    }

    public long durationMin(IntervalVar var) {
        return mainJNI.Assignment_durationMin(this.swigCPtr, this, IntervalVar.getCPtr(var), var);
    }

    public long durationMax(IntervalVar var) {
        return mainJNI.Assignment_durationMax(this.swigCPtr, this, IntervalVar.getCPtr(var), var);
    }

    public long durationValue(IntervalVar var) {
        return mainJNI.Assignment_durationValue(this.swigCPtr, this, IntervalVar.getCPtr(var), var);
    }

    public long endMin(IntervalVar var) {
        return mainJNI.Assignment_endMin(this.swigCPtr, this, IntervalVar.getCPtr(var), var);
    }

    public long endMax(IntervalVar var) {
        return mainJNI.Assignment_endMax(this.swigCPtr, this, IntervalVar.getCPtr(var), var);
    }

    public long endValue(IntervalVar var) {
        return mainJNI.Assignment_endValue(this.swigCPtr, this, IntervalVar.getCPtr(var), var);
    }

    public long performedMin(IntervalVar var) {
        return mainJNI.Assignment_performedMin(this.swigCPtr, this, IntervalVar.getCPtr(var), var);
    }

    public long performedMax(IntervalVar var) {
        return mainJNI.Assignment_performedMax(this.swigCPtr, this, IntervalVar.getCPtr(var), var);
    }

    public long performedValue(IntervalVar var) {
        return mainJNI.Assignment_performedValue(this.swigCPtr, this, IntervalVar.getCPtr(var), var);
    }

    public void setStartMin(IntervalVar var, long m) {
        mainJNI.Assignment_setStartMin(this.swigCPtr, this, IntervalVar.getCPtr(var), var, m);
    }

    public void setStartMax(IntervalVar var, long m) {
        mainJNI.Assignment_setStartMax(this.swigCPtr, this, IntervalVar.getCPtr(var), var, m);
    }

    public void setStartRange(IntervalVar var, long mi, long ma) {
        mainJNI.Assignment_setStartRange(this.swigCPtr, this, IntervalVar.getCPtr(var), var, mi, ma);
    }

    public void setStartValue(IntervalVar var, long value) {
        mainJNI.Assignment_setStartValue(this.swigCPtr, this, IntervalVar.getCPtr(var), var, value);
    }

    public void setDurationMin(IntervalVar var, long m) {
        mainJNI.Assignment_setDurationMin(this.swigCPtr, this, IntervalVar.getCPtr(var), var, m);
    }

    public void setDurationMax(IntervalVar var, long m) {
        mainJNI.Assignment_setDurationMax(this.swigCPtr, this, IntervalVar.getCPtr(var), var, m);
    }

    public void setDurationRange(IntervalVar var, long mi, long ma) {
        mainJNI.Assignment_setDurationRange(this.swigCPtr, this, IntervalVar.getCPtr(var), var, mi, ma);
    }

    public void setDurationValue(IntervalVar var, long value) {
        mainJNI.Assignment_setDurationValue(this.swigCPtr, this, IntervalVar.getCPtr(var), var, value);
    }

    public void setEndMin(IntervalVar var, long m) {
        mainJNI.Assignment_setEndMin(this.swigCPtr, this, IntervalVar.getCPtr(var), var, m);
    }

    public void setEndMax(IntervalVar var, long m) {
        mainJNI.Assignment_setEndMax(this.swigCPtr, this, IntervalVar.getCPtr(var), var, m);
    }

    public void setEndRange(IntervalVar var, long mi, long ma) {
        mainJNI.Assignment_setEndRange(this.swigCPtr, this, IntervalVar.getCPtr(var), var, mi, ma);
    }

    public void setEndValue(IntervalVar var, long value) {
        mainJNI.Assignment_setEndValue(this.swigCPtr, this, IntervalVar.getCPtr(var), var, value);
    }

    public void setPerformedMin(IntervalVar var, long m) {
        mainJNI.Assignment_setPerformedMin(this.swigCPtr, this, IntervalVar.getCPtr(var), var, m);
    }

    public void setPerformedMax(IntervalVar var, long m) {
        mainJNI.Assignment_setPerformedMax(this.swigCPtr, this, IntervalVar.getCPtr(var), var, m);
    }

    public void setPerformedRange(IntervalVar var, long mi, long ma) {
        mainJNI.Assignment_setPerformedRange(this.swigCPtr, this, IntervalVar.getCPtr(var), var, mi, ma);
    }

    public void setPerformedValue(IntervalVar var, long value) {
        mainJNI.Assignment_setPerformedValue(this.swigCPtr, this, IntervalVar.getCPtr(var), var, value);
    }

    public SequenceVarElement add(SequenceVar var) {
        long cPtr = mainJNI.Assignment_add__SWIG_4(this.swigCPtr, this, SequenceVar.getCPtr(var), var);
        return cPtr == 0L ? null : new SequenceVarElement(cPtr, false);
    }

    public void add(SequenceVar[] vars) {
        mainJNI.Assignment_add__SWIG_5(this.swigCPtr, this, vars);
    }

    public SequenceVarElement fastAdd(SequenceVar var) {
        long cPtr = mainJNI.Assignment_fastAdd__SWIG_2(this.swigCPtr, this, SequenceVar.getCPtr(var), var);
        return cPtr == 0L ? null : new SequenceVarElement(cPtr, false);
    }

    public int[] forwardSequence(SequenceVar var) {
        return mainJNI.Assignment_forwardSequence(this.swigCPtr, this, SequenceVar.getCPtr(var), var);
    }

    public int[] backwardSequence(SequenceVar var) {
        return mainJNI.Assignment_backwardSequence(this.swigCPtr, this, SequenceVar.getCPtr(var), var);
    }

    public int[] unperformed(SequenceVar var) {
        return mainJNI.Assignment_unperformed(this.swigCPtr, this, SequenceVar.getCPtr(var), var);
    }

    public void setSequence(SequenceVar var, int[] forward_sequence, int[] backward_sequence, int[] unperformed) {
        mainJNI.Assignment_setSequence(this.swigCPtr, this, SequenceVar.getCPtr(var), var, forward_sequence, backward_sequence, unperformed);
    }

    public void setForwardSequence(SequenceVar var, int[] forward_sequence) {
        mainJNI.Assignment_setForwardSequence(this.swigCPtr, this, SequenceVar.getCPtr(var), var, forward_sequence);
    }

    public void setBackwardSequence(SequenceVar var, int[] backward_sequence) {
        mainJNI.Assignment_setBackwardSequence(this.swigCPtr, this, SequenceVar.getCPtr(var), var, backward_sequence);
    }

    public void setUnperformed(SequenceVar var, int[] unperformed) {
        mainJNI.Assignment_setUnperformed(this.swigCPtr, this, SequenceVar.getCPtr(var), var, unperformed);
    }

    public void activate(IntVar var) {
        mainJNI.Assignment_activate__SWIG_0(this.swigCPtr, this, IntVar.getCPtr(var), var);
    }

    public void deactivate(IntVar var) {
        mainJNI.Assignment_deactivate__SWIG_0(this.swigCPtr, this, IntVar.getCPtr(var), var);
    }

    public boolean activated(IntVar var) {
        return mainJNI.Assignment_activated__SWIG_0(this.swigCPtr, this, IntVar.getCPtr(var), var);
    }

    public void activate(IntervalVar var) {
        mainJNI.Assignment_activate__SWIG_1(this.swigCPtr, this, IntervalVar.getCPtr(var), var);
    }

    public void deactivate(IntervalVar var) {
        mainJNI.Assignment_deactivate__SWIG_1(this.swigCPtr, this, IntervalVar.getCPtr(var), var);
    }

    public boolean activated(IntervalVar var) {
        return mainJNI.Assignment_activated__SWIG_1(this.swigCPtr, this, IntervalVar.getCPtr(var), var);
    }

    public void activate(SequenceVar var) {
        mainJNI.Assignment_activate__SWIG_2(this.swigCPtr, this, SequenceVar.getCPtr(var), var);
    }

    public void deactivate(SequenceVar var) {
        mainJNI.Assignment_deactivate__SWIG_2(this.swigCPtr, this, SequenceVar.getCPtr(var), var);
    }

    public boolean activated(SequenceVar var) {
        return mainJNI.Assignment_activated__SWIG_2(this.swigCPtr, this, SequenceVar.getCPtr(var), var);
    }

    public void activateObjective() {
        mainJNI.Assignment_activateObjective(this.swigCPtr, this);
    }

    public void deactivateObjective() {
        mainJNI.Assignment_deactivateObjective(this.swigCPtr, this);
    }

    public boolean activatedObjective() {
        return mainJNI.Assignment_activatedObjective(this.swigCPtr, this);
    }

    public void ActivateObjectiveFromIndex(int index) {
        mainJNI.Assignment_ActivateObjectiveFromIndex(this.swigCPtr, this, index);
    }

    public void DeactivateObjectiveFromIndex(int index) {
        mainJNI.Assignment_DeactivateObjectiveFromIndex(this.swigCPtr, this, index);
    }

    public boolean ActivatedObjectiveFromIndex(int index) {
        return mainJNI.Assignment_ActivatedObjectiveFromIndex(this.swigCPtr, this, index);
    }

    @Override
    public String toString() {
        return mainJNI.Assignment_toString(this.swigCPtr, this);
    }

    public boolean AreAllElementsBound() {
        return mainJNI.Assignment_AreAllElementsBound(this.swigCPtr, this);
    }

    public boolean contains(IntVar var) {
        return mainJNI.Assignment_contains__SWIG_0(this.swigCPtr, this, IntVar.getCPtr(var), var);
    }

    public boolean contains(IntervalVar var) {
        return mainJNI.Assignment_contains__SWIG_1(this.swigCPtr, this, IntervalVar.getCPtr(var), var);
    }

    public boolean contains(SequenceVar var) {
        return mainJNI.Assignment_contains__SWIG_2(this.swigCPtr, this, SequenceVar.getCPtr(var), var);
    }

    public void copyIntersection(Assignment assignment) {
        mainJNI.Assignment_copyIntersection(this.swigCPtr, this, Assignment.getCPtr(assignment), assignment);
    }

    public void copy(Assignment assignment) {
        mainJNI.Assignment_copy(this.swigCPtr, this, Assignment.getCPtr(assignment), assignment);
    }

    public AssignmentIntContainer intVarContainer() {
        return new AssignmentIntContainer(mainJNI.Assignment_intVarContainer(this.swigCPtr, this), false);
    }

    public AssignmentIntContainer mutableIntVarContainer() {
        long cPtr = mainJNI.Assignment_mutableIntVarContainer(this.swigCPtr, this);
        return cPtr == 0L ? null : new AssignmentIntContainer(cPtr, false);
    }

    public AssignmentIntervalContainer intervalVarContainer() {
        return new AssignmentIntervalContainer(mainJNI.Assignment_intervalVarContainer(this.swigCPtr, this), false);
    }

    public AssignmentIntervalContainer mutableIntervalVarContainer() {
        long cPtr = mainJNI.Assignment_mutableIntervalVarContainer(this.swigCPtr, this);
        return cPtr == 0L ? null : new AssignmentIntervalContainer(cPtr, false);
    }

    public AssignmentSequenceContainer sequenceVarContainer() {
        return new AssignmentSequenceContainer(mainJNI.Assignment_sequenceVarContainer(this.swigCPtr, this), false);
    }

    public AssignmentSequenceContainer mutableSequenceVarContainer() {
        long cPtr = mainJNI.Assignment_mutableSequenceVarContainer(this.swigCPtr, this);
        return cPtr == 0L ? null : new AssignmentSequenceContainer(cPtr, false);
    }
}

