/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.auth.oauth2;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.auth.oauth2.CredentialRefreshListener;
import com.google.api.client.auth.oauth2.CredentialStore;
import com.google.api.client.auth.oauth2.TokenErrorResponse;
import com.google.api.client.auth.oauth2.TokenResponse;
import com.google.common.base.Preconditions;

public final class CredentialStoreRefreshListener
implements CredentialRefreshListener {
    private final CredentialStore credentialStore;
    private final String userId;

    public CredentialStoreRefreshListener(String userId, CredentialStore credentialStore) {
        this.userId = (String)Preconditions.checkNotNull((Object)userId);
        this.credentialStore = (CredentialStore)Preconditions.checkNotNull((Object)credentialStore);
    }

    public void onTokenResponse(Credential credential, TokenResponse tokenResponse) {
        this.makePersistent(credential);
    }

    public void onTokenErrorResponse(Credential credential, TokenErrorResponse tokenErrorResponse) {
        this.makePersistent(credential);
    }

    public CredentialStore getCredentialStore() {
        return this.credentialStore;
    }

    public void makePersistent(Credential credential) {
        this.credentialStore.store(this.userId, credential);
    }
}

