/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.auth.jsontoken;

import com.google.api.client.auth.jsontoken.JsonWebSignature;
import com.google.api.client.auth.jsontoken.JsonWebToken;
import com.google.api.client.json.JsonFactory;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.Signature;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.StringUtils;

public class RsaSHA256Signer {
    public static String sign(PrivateKey privateKey, JsonFactory jsonFactory, JsonWebSignature.Header header, JsonWebToken.Payload payload) throws GeneralSecurityException {
        String content = Base64.encodeBase64URLSafeString((byte[])jsonFactory.toByteArray((Object)header)) + "." + Base64.encodeBase64URLSafeString((byte[])jsonFactory.toByteArray((Object)payload));
        byte[] contentBytes = StringUtils.getBytesUtf8((String)content);
        Signature signer = Signature.getInstance("SHA256withRSA");
        signer.initSign(privateKey);
        signer.update(contentBytes);
        byte[] signature = signer.sign();
        return content + "." + Base64.encodeBase64URLSafeString((byte[])signature);
    }

    private RsaSHA256Signer() {
    }
}

