/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.auth.oauth2;

import com.google.api.client.auth.oauth2.CredentialRefreshListener;
import com.google.api.client.auth.oauth2.RefreshTokenRequest;
import com.google.api.client.auth.oauth2.TokenResponse;
import com.google.api.client.auth.oauth2.TokenResponseException;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.HttpUnsuccessfulResponseHandler;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Clock;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Credential
implements HttpExecuteInterceptor,
HttpRequestInitializer,
HttpUnsuccessfulResponseHandler {
    static final Logger LOGGER = Logger.getLogger(Credential.class.getName());
    private final Lock lock = new ReentrantLock();
    private final AccessMethod method;
    private final Clock clock;
    private String accessToken;
    private Long expirationTimeMilliseconds;
    private String refreshToken;
    private final HttpTransport transport;
    private final HttpExecuteInterceptor clientAuthentication;
    private final JsonFactory jsonFactory;
    private final String tokenServerEncodedUrl;
    private final List<CredentialRefreshListener> refreshListeners;
    private final HttpRequestInitializer requestInitializer;

    public Credential(AccessMethod method) {
        this(method, null, null, null, null, null, null);
    }

    protected Credential(AccessMethod method, HttpTransport transport, JsonFactory jsonFactory, String tokenServerEncodedUrl, HttpExecuteInterceptor clientAuthentication, HttpRequestInitializer requestInitializer, List<CredentialRefreshListener> refreshListeners) {
        this(method, transport, jsonFactory, tokenServerEncodedUrl, clientAuthentication, requestInitializer, refreshListeners, Clock.SYSTEM);
    }

    protected Credential(AccessMethod method, HttpTransport transport, JsonFactory jsonFactory, String tokenServerEncodedUrl, HttpExecuteInterceptor clientAuthentication, HttpRequestInitializer requestInitializer, List<CredentialRefreshListener> refreshListeners, Clock clock) {
        this.method = (AccessMethod)Preconditions.checkNotNull((Object)method);
        this.transport = transport;
        this.jsonFactory = jsonFactory;
        this.tokenServerEncodedUrl = tokenServerEncodedUrl;
        this.clientAuthentication = clientAuthentication;
        this.requestInitializer = requestInitializer;
        this.refreshListeners = refreshListeners == null ? Collections.emptyList() : Collections.unmodifiableList(refreshListeners);
        this.clock = (Clock)Preconditions.checkNotNull((Object)clock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void intercept(HttpRequest request) throws IOException {
        this.lock.lock();
        try {
            Long expiresIn = this.getExpiresInSeconds();
            if (this.accessToken == null || expiresIn != null && expiresIn <= 60L) {
                this.refreshToken();
                if (this.accessToken == null) {
                    return;
                }
            }
            this.method.intercept(request, this.accessToken);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleResponse(HttpRequest request, HttpResponse response, boolean supportsRetry) {
        if (response.getStatusCode() == 401) {
            this.lock.lock();
            try {
                boolean bl = !Objects.equal((Object)this.accessToken, (Object)this.method.getAccessTokenFromRequest(request)) || this.refreshToken();
                this.lock.unlock();
                return bl;
            }
            catch (Throwable throwable) {
                try {
                    this.lock.unlock();
                    throw throwable;
                }
                catch (IOException exception) {
                    LOGGER.log(Level.SEVERE, "unable to refresh token", exception);
                }
            }
        }
        return false;
    }

    public void initialize(HttpRequest request) throws IOException {
        request.setInterceptor((HttpExecuteInterceptor)this);
        request.setUnsuccessfulResponseHandler((HttpUnsuccessfulResponseHandler)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getAccessToken() {
        this.lock.lock();
        try {
            String string = this.accessToken;
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Credential setAccessToken(String accessToken) {
        this.lock.lock();
        try {
            this.accessToken = accessToken;
        }
        finally {
            this.lock.unlock();
        }
        return this;
    }

    public final AccessMethod getMethod() {
        return this.method;
    }

    public final Clock getClock() {
        return this.clock;
    }

    public final HttpTransport getTransport() {
        return this.transport;
    }

    public final JsonFactory getJsonFactory() {
        return this.jsonFactory;
    }

    public final String getTokenServerEncodedUrl() {
        return this.tokenServerEncodedUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getRefreshToken() {
        this.lock.lock();
        try {
            String string = this.refreshToken;
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Credential setRefreshToken(String refreshToken) {
        this.lock.lock();
        try {
            if (refreshToken != null) {
                Preconditions.checkArgument((this.jsonFactory != null && this.transport != null && this.clientAuthentication != null && this.tokenServerEncodedUrl != null ? 1 : 0) != 0, (Object)"Please use the Builder and call setJsonFactory, setTransport, setClientAuthentication and setTokenServerUrl/setTokenServerEncodedUrl");
            }
            this.refreshToken = refreshToken;
        }
        finally {
            this.lock.unlock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Long getExpirationTimeMilliseconds() {
        this.lock.lock();
        try {
            Long l = this.expirationTimeMilliseconds;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Credential setExpirationTimeMilliseconds(Long expirationTimeMilliseconds) {
        this.lock.lock();
        try {
            this.expirationTimeMilliseconds = expirationTimeMilliseconds;
        }
        finally {
            this.lock.unlock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Long getExpiresInSeconds() {
        this.lock.lock();
        try {
            if (this.expirationTimeMilliseconds == null) {
                Long l = null;
                return l;
            }
            Long l = (this.expirationTimeMilliseconds - this.clock.currentTimeMillis()) / 1000L;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    public Credential setExpiresInSeconds(Long expiresIn) {
        return this.setExpirationTimeMilliseconds(expiresIn == null ? null : Long.valueOf(this.clock.currentTimeMillis() + expiresIn * 1000L));
    }

    public final HttpExecuteInterceptor getClientAuthentication() {
        return this.clientAuthentication;
    }

    public final HttpRequestInitializer getRequestInitializer() {
        return this.requestInitializer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean refreshToken() throws IOException {
        this.lock.lock();
        try {
            TokenResponse tokenResponse = this.executeRefreshToken();
            if (tokenResponse == null) return false;
            this.setFromTokenResponse(tokenResponse);
            Iterator<CredentialRefreshListener> i$2 = this.refreshListeners.iterator();
            while (true) {
                if (!i$2.hasNext()) {
                    boolean i$2 = true;
                    this.lock.unlock();
                    return i$2;
                }
                CredentialRefreshListener refreshListener = i$2.next();
                refreshListener.onTokenResponse(this, tokenResponse);
            }
        }
        catch (TokenResponseException e) {
            boolean statusCode4xx;
            boolean bl = statusCode4xx = 400 <= e.getStatusCode() && e.getStatusCode() < 500;
            if (e.getDetails() != null && statusCode4xx) {
                this.setAccessToken(null);
                this.setExpiresInSeconds(null);
            }
            for (CredentialRefreshListener refreshListener : this.refreshListeners) {
                refreshListener.onTokenErrorResponse(this, e.getDetails());
            }
            if (!statusCode4xx) return false;
            throw e;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
    }

    public Credential setFromTokenResponse(TokenResponse tokenResponse) {
        this.setAccessToken(tokenResponse.getAccessToken());
        if (tokenResponse.getRefreshToken() != null) {
            this.setRefreshToken(tokenResponse.getRefreshToken());
        }
        this.setExpiresInSeconds(tokenResponse.getExpiresInSeconds());
        return this;
    }

    protected TokenResponse executeRefreshToken() throws IOException {
        if (this.refreshToken == null) {
            return null;
        }
        return new RefreshTokenRequest(this.transport, this.jsonFactory, new GenericUrl(this.tokenServerEncodedUrl), this.refreshToken).setClientAuthentication(this.clientAuthentication).setRequestInitializer(this.requestInitializer).execute();
    }

    public final List<CredentialRefreshListener> getRefreshListeners() {
        return this.refreshListeners;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder {
        private final AccessMethod method;
        private HttpTransport transport;
        private JsonFactory jsonFactory;
        private GenericUrl tokenServerUrl;
        private Clock clock = Clock.SYSTEM;
        private HttpExecuteInterceptor clientAuthentication;
        private HttpRequestInitializer requestInitializer;
        private List<CredentialRefreshListener> refreshListeners = new ArrayList<CredentialRefreshListener>();

        public Builder(AccessMethod method) {
            this.method = (AccessMethod)Preconditions.checkNotNull((Object)method);
        }

        public Credential build() {
            return new Credential(this.method, this.transport, this.jsonFactory, this.tokenServerUrl == null ? null : this.tokenServerUrl.build(), this.clientAuthentication, this.requestInitializer, this.refreshListeners, this.clock);
        }

        public final AccessMethod getMethod() {
            return this.method;
        }

        public final HttpTransport getTransport() {
            return this.transport;
        }

        public Builder setTransport(HttpTransport transport) {
            this.transport = transport;
            return this;
        }

        public final Clock getClock() {
            return this.clock;
        }

        public Builder setClock(Clock clock) {
            this.clock = (Clock)Preconditions.checkNotNull((Object)clock);
            return this;
        }

        public final JsonFactory getJsonFactory() {
            return this.jsonFactory;
        }

        public Builder setJsonFactory(JsonFactory jsonFactory) {
            this.jsonFactory = jsonFactory;
            return this;
        }

        public final GenericUrl getTokenServerUrl() {
            return this.tokenServerUrl;
        }

        public Builder setTokenServerUrl(GenericUrl tokenServerUrl) {
            this.tokenServerUrl = tokenServerUrl;
            return this;
        }

        public Builder setTokenServerEncodedUrl(String tokenServerEncodedUrl) {
            this.tokenServerUrl = tokenServerEncodedUrl == null ? null : new GenericUrl(tokenServerEncodedUrl);
            return this;
        }

        public final HttpExecuteInterceptor getClientAuthentication() {
            return this.clientAuthentication;
        }

        public Builder setClientAuthentication(HttpExecuteInterceptor clientAuthentication) {
            this.clientAuthentication = clientAuthentication;
            return this;
        }

        public final HttpRequestInitializer getRequestInitializer() {
            return this.requestInitializer;
        }

        public Builder setRequestInitializer(HttpRequestInitializer requestInitializer) {
            this.requestInitializer = requestInitializer;
            return this;
        }

        public Builder addRefreshListener(CredentialRefreshListener refreshListener) {
            this.refreshListeners.add((CredentialRefreshListener)Preconditions.checkNotNull((Object)refreshListener));
            return this;
        }

        public final List<CredentialRefreshListener> getRefreshListeners() {
            return this.refreshListeners;
        }

        public Builder setRefreshListeners(List<CredentialRefreshListener> refreshListeners) {
            this.refreshListeners = refreshListeners;
            return this;
        }
    }

    public static interface AccessMethod {
        public void intercept(HttpRequest var1, String var2) throws IOException;

        public String getAccessTokenFromRequest(HttpRequest var1);
    }
}

