/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.extensions.jdo.auth.oauth2;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.auth.oauth2.CredentialStore;
import com.google.api.client.auth.oauth2.StoredCredential;
import com.google.api.client.extensions.jdo.JdoDataStoreFactory;
import com.google.api.client.extensions.jdo.auth.oauth2.JdoPersistedCredential;
import com.google.api.client.util.Beta;
import com.google.api.client.util.Preconditions;
import com.google.api.client.util.store.DataStore;
import com.google.api.client.util.store.DataStoreFactory;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.jdo.JDOObjectNotFoundException;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.Query;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
@Beta
public class JdoCredentialStore
implements CredentialStore {
    private final PersistenceManagerFactory persistenceManagerFactory;
    private final Lock lock = new ReentrantLock();

    public JdoCredentialStore(PersistenceManagerFactory persistenceManagerFactory) {
        this.persistenceManagerFactory = (PersistenceManagerFactory)Preconditions.checkNotNull((Object)persistenceManagerFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(String userId, Credential credential) {
        PersistenceManager persistenceManager = this.persistenceManagerFactory.getPersistenceManager();
        this.lock.lock();
        try {
            try {
                JdoPersistedCredential persistedCredential = (JdoPersistedCredential)persistenceManager.getObjectById(JdoPersistedCredential.class, (Object)userId);
                persistedCredential.update(credential);
            }
            catch (JDOObjectNotFoundException e) {
                JdoPersistedCredential persistedCredential = new JdoPersistedCredential(userId, credential);
                persistenceManager.makePersistent((Object)persistedCredential);
            }
        }
        finally {
            this.lock.unlock();
            persistenceManager.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(String userId, Credential credential) {
        PersistenceManager persistenceManager = this.persistenceManagerFactory.getPersistenceManager();
        this.lock.lock();
        try {
            JdoPersistedCredential persistedCredential = (JdoPersistedCredential)persistenceManager.getObjectById(JdoPersistedCredential.class, (Object)userId);
            persistenceManager.deletePersistent((Object)persistedCredential);
        }
        finally {
            this.lock.unlock();
            persistenceManager.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean load(String userId, Credential credential) {
        PersistenceManager persistenceManager = this.persistenceManagerFactory.getPersistenceManager();
        this.lock.lock();
        try {
            JdoPersistedCredential persistedCredential = (JdoPersistedCredential)persistenceManager.getObjectById(JdoPersistedCredential.class, (Object)userId);
            persistedCredential.load(credential);
            boolean bl = true;
            return bl;
        }
        catch (JDOObjectNotFoundException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
            persistenceManager.close();
        }
    }

    public final void migrateTo(JdoDataStoreFactory dataStoreFactory) throws IOException {
        this.migrateTo((DataStore<StoredCredential>)StoredCredential.getDefaultDataStore((DataStoreFactory)dataStoreFactory));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void migrateTo(DataStore<StoredCredential> credentialDataStore) throws IOException {
        PersistenceManager persistenceManager = this.persistenceManagerFactory.getPersistenceManager();
        this.lock.lock();
        try {
            Query query = persistenceManager.newQuery(JdoPersistedCredential.class);
            try {
                Collection queryResults = (Collection)query.execute();
                for (JdoPersistedCredential persistedCredential : queryResults) {
                    credentialDataStore.set(persistedCredential.getUserId(), (Serializable)persistedCredential.toStoredCredential());
                }
            }
            finally {
                query.closeAll();
            }
        }
        finally {
            this.lock.unlock();
            persistenceManager.close();
        }
    }
}

