/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.extensions.jdo.auth.oauth2;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.auth.oauth2.CredentialStore;
import com.google.api.client.extensions.jdo.auth.oauth2.JdoPersistedCredential;
import com.google.api.client.util.Beta;
import com.google.api.client.util.Preconditions;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.jdo.JDOObjectNotFoundException;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;

@Beta
public class JdoCredentialStore
implements CredentialStore {
    private final PersistenceManagerFactory persistenceManagerFactory;
    private final Lock lock = new ReentrantLock();

    public JdoCredentialStore(PersistenceManagerFactory persistenceManagerFactory) {
        this.persistenceManagerFactory = (PersistenceManagerFactory)Preconditions.checkNotNull((Object)persistenceManagerFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(String userId, Credential credential) {
        PersistenceManager persistenceManager = this.persistenceManagerFactory.getPersistenceManager();
        this.lock.lock();
        try {
            try {
                JdoPersistedCredential persistedCredential = (JdoPersistedCredential)persistenceManager.getObjectById(JdoPersistedCredential.class, (Object)userId);
                persistedCredential.update(credential);
            }
            catch (JDOObjectNotFoundException e) {
                JdoPersistedCredential persistedCredential = new JdoPersistedCredential(userId, credential);
                persistenceManager.makePersistent((Object)persistedCredential);
            }
        }
        finally {
            this.lock.unlock();
            persistenceManager.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(String userId, Credential credential) {
        PersistenceManager persistenceManager = this.persistenceManagerFactory.getPersistenceManager();
        this.lock.lock();
        try {
            JdoPersistedCredential persistedCredential = (JdoPersistedCredential)persistenceManager.getObjectById(JdoPersistedCredential.class, (Object)userId);
            persistenceManager.deletePersistent((Object)persistedCredential);
        }
        finally {
            this.lock.unlock();
            persistenceManager.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean load(String userId, Credential credential) {
        PersistenceManager persistenceManager = this.persistenceManagerFactory.getPersistenceManager();
        this.lock.lock();
        try {
            JdoPersistedCredential persistedCredential = (JdoPersistedCredential)persistenceManager.getObjectById(JdoPersistedCredential.class, (Object)userId);
            persistedCredential.load(credential);
            boolean bl = true;
            return bl;
        }
        catch (JDOObjectNotFoundException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
            persistenceManager.close();
        }
    }
}

