/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.extensions.jetty.auth.oauth2;

import com.google.api.client.extensions.java6.auth.oauth2.VerificationCodeReceiver;
import com.google.api.client.util.Throwables;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.AbstractHandler;

public final class LocalServerReceiver
implements VerificationCodeReceiver {
    private static final String CALLBACK_PATH = "/Callback";
    private Server server;
    String code;
    String error;
    final Lock lock = new ReentrantLock();
    final Condition gotAuthorizationResponse = this.lock.newCondition();
    private int port;
    private final String host;

    public LocalServerReceiver() {
        this("localhost", -1);
    }

    LocalServerReceiver(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public String getRedirectUri() throws IOException {
        if (this.port == -1) {
            this.port = LocalServerReceiver.getUnusedPort();
        }
        this.server = new Server(this.port);
        for (Connector c : this.server.getConnectors()) {
            c.setHost(this.host);
        }
        this.server.addHandler((Handler)new CallbackHandler());
        try {
            this.server.start();
        }
        catch (Exception e) {
            Throwables.propagateIfPossible((Throwable)e);
            throw new IOException(e);
        }
        return "http://" + this.host + ":" + this.port + CALLBACK_PATH;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String waitForCode() throws IOException {
        this.lock.lock();
        try {
            while (this.code == null && this.error == null) {
                this.gotAuthorizationResponse.awaitUninterruptibly();
            }
            if (this.error != null) {
                throw new IOException("User authorization failed (" + this.error + ")");
            }
            String string = this.code;
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void stop() throws IOException {
        if (this.server != null) {
            try {
                this.server.stop();
            }
            catch (Exception e) {
                Throwables.propagateIfPossible((Throwable)e);
                throw new IOException(e);
            }
            this.server = null;
        }
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getUnusedPort() throws IOException {
        Socket s = new Socket();
        s.bind(null);
        try {
            int n = s.getLocalPort();
            return n;
        }
        finally {
            s.close();
        }
    }

    class CallbackHandler
    extends AbstractHandler {
        CallbackHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handle(String target, HttpServletRequest request, HttpServletResponse response, int dispatch) throws IOException {
            if (!LocalServerReceiver.CALLBACK_PATH.equals(target)) {
                return;
            }
            this.writeLandingHtml(response);
            response.flushBuffer();
            ((Request)request).setHandled(true);
            LocalServerReceiver.this.lock.lock();
            try {
                LocalServerReceiver.this.error = request.getParameter("error");
                LocalServerReceiver.this.code = request.getParameter("code");
                LocalServerReceiver.this.gotAuthorizationResponse.signal();
            }
            finally {
                LocalServerReceiver.this.lock.unlock();
            }
        }

        private void writeLandingHtml(HttpServletResponse response) throws IOException {
            response.setStatus(200);
            response.setContentType("text/html");
            PrintWriter doc = response.getWriter();
            doc.println("<html>");
            doc.println("<head><title>OAuth 2.0 Authentication Token Recieved</title></head>");
            doc.println("<body>");
            doc.println("Received verification code. You may now close this window...");
            doc.println("</body>");
            doc.println("</HTML>");
            doc.flush();
        }
    }

    public static final class Builder {
        private String host = "localhost";
        private int port = -1;

        public LocalServerReceiver build() {
            return new LocalServerReceiver(this.host, this.port);
        }

        public String getHost() {
            return this.host;
        }

        public Builder setHost(String host) {
            this.host = host;
            return this;
        }

        public int getPort() {
            return this.port;
        }

        public Builder setPort(int port) {
            this.port = port;
            return this;
        }
    }
}

