/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.extensions.auth.helpers.oauth2.draft10;

import com.google.api.client.auth.oauth2.draft10.AccessProtectedResource;
import com.google.api.client.extensions.auth.helpers.Credential;
import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.HttpUnsuccessfulResponseHandler;
import com.google.api.client.json.JsonFactory;
import com.google.common.base.Preconditions;
import java.io.IOException;
import javax.jdo.InstanceCallbacks;
import javax.jdo.JDOFatalInternalException;
import javax.jdo.PersistenceManager;
import javax.jdo.annotations.NotPersistent;
import javax.jdo.annotations.Persistent;
import javax.jdo.annotations.PrimaryKey;
import javax.jdo.identity.StringIdentity;
import javax.jdo.spi.JDOImplHelper;
import javax.jdo.spi.PersistenceCapable;
import javax.jdo.spi.StateManager;

@javax.jdo.annotations.PersistenceCapable
public final class OAuth2Credential
implements Credential,
InstanceCallbacks,
PersistenceCapable {
    @PrimaryKey
    private String userId;
    @Persistent
    private volatile String accessToken;
    @Persistent
    private String refreshToken;
    @NotPersistent
    AccessProtectedResource authInterceptor;
    protected transient StateManager jdoStateManager;
    protected transient byte jdoFlags;
    private static final byte[] jdoFieldFlags;
    private static final Class jdoPersistenceCapableSuperclass;
    private static final Class[] jdoFieldTypes;
    private static final String[] jdoFieldNames;
    private static final int jdoInheritedFieldCount;

    public OAuth2Credential(String userId, String accessToken, String refreshToken) {
        this.userId = (String)Preconditions.checkNotNull((Object)userId);
        this.accessToken = (String)Preconditions.checkNotNull((Object)accessToken);
        this.refreshToken = refreshToken;
        this.initializeAfterConstruction();
    }

    public OAuth2Credential(String userId, String accessToken) {
        this(userId, accessToken, null);
    }

    private void initializeAfterConstruction() {
        this.authInterceptor = new AccessProtectedResource(OAuth2Credential.jdoGetaccessToken(this), AccessProtectedResource.Method.AUTHORIZATION_HEADER);
    }

    public boolean refresh(HttpTransport transport, JsonFactory factory) throws IOException {
        return this.authInterceptor.refreshToken();
    }

    public void initialize(HttpRequest request) throws IOException {
        request.setInterceptor((HttpExecuteInterceptor)this.authInterceptor);
        request.setUnsuccessfulResponseHandler((HttpUnsuccessfulResponseHandler)this.authInterceptor);
    }

    public void intercept(HttpRequest request) throws IOException {
        this.authInterceptor.intercept(request);
    }

    public boolean handleResponse(HttpRequest request, HttpResponse response, boolean retrySupported) {
        return this.authInterceptor.handleResponse(request, response, retrySupported);
    }

    public void initializeForRefresh(String clientId, String clientSecret, String refreshUrl, JsonFactory jsonFactory, HttpTransport transport) {
        this.authInterceptor = new AccessProtectedResource(OAuth2Credential.jdoGetaccessToken(this), AccessProtectedResource.Method.AUTHORIZATION_HEADER, transport, jsonFactory, refreshUrl, clientId, clientSecret, OAuth2Credential.jdoGetrefreshToken(this)){

            protected void onAccessToken(String accessToken) {
                OAuth2Credential.this.setAccessToken(accessToken);
            }
        };
    }

    public String getAccessToken() {
        return this.authInterceptor.getAccessToken();
    }

    public void setAccessToken(String accessToken) {
        OAuth2Credential.jdoSetaccessToken(this, accessToken);
    }

    public String getRefreshToken() {
        return OAuth2Credential.jdoGetrefreshToken(this);
    }

    public void jdoPreClear() {
    }

    public void jdoPreDelete() {
    }

    public void jdoPostLoad() {
        this.initializeAfterConstruction();
    }

    public void jdoPreStore() {
    }

    public boolean isInvalid() {
        return OAuth2Credential.jdoGetaccessToken(this) == null;
    }

    static {
        jdoFieldNames = OAuth2Credential.__jdoFieldNamesInit();
        jdoFieldTypes = OAuth2Credential.__jdoFieldTypesInit();
        jdoFieldFlags = OAuth2Credential.__jdoFieldFlagsInit();
        jdoInheritedFieldCount = OAuth2Credential.__jdoGetInheritedFieldCount();
        jdoPersistenceCapableSuperclass = OAuth2Credential.__jdoPersistenceCapableSuperclassInit();
        JDOImplHelper.registerClass((Class)OAuth2Credential.___jdo$loadClass("com.google.api.client.extensions.auth.helpers.oauth2.draft10.OAuth2Credential"), (String[])jdoFieldNames, (Class[])jdoFieldTypes, (byte[])jdoFieldFlags, (Class)jdoPersistenceCapableSuperclass, (PersistenceCapable)new OAuth2Credential());
    }

    protected OAuth2Credential() {
    }

    public void jdoCopyKeyFieldsFromObjectId(PersistenceCapable.ObjectIdFieldConsumer fc, Object oid) {
        if (fc == null) {
            throw new IllegalArgumentException("ObjectIdFieldConsumer is null");
        }
        if (!(oid instanceof StringIdentity)) {
            throw new ClassCastException("oid is not instanceof javax.jdo.identity.StringIdentity");
        }
        StringIdentity o = (StringIdentity)oid;
        fc.storeStringField(2, o.getKey());
    }

    protected void jdoCopyKeyFieldsFromObjectId(Object oid) {
        if (!(oid instanceof StringIdentity)) {
            throw new ClassCastException("key class is not javax.jdo.identity.StringIdentity or null");
        }
        StringIdentity o = (StringIdentity)oid;
        this.userId = o.getKey();
    }

    public final void jdoCopyKeyFieldsToObjectId(Object oid) {
        throw new JDOFatalInternalException("It's illegal to call jdoCopyKeyFieldsToObjectId for a class with SingleFieldIdentity.");
    }

    public final void jdoCopyKeyFieldsToObjectId(PersistenceCapable.ObjectIdFieldSupplier fs, Object object) {
        throw new JDOFatalInternalException("It's illegal to call jdoCopyKeyFieldsToObjectId for a class with SingleFieldIdentity.");
    }

    public final Object jdoGetObjectId() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.getObjectId((PersistenceCapable)this);
        }
        return null;
    }

    public final Object jdoGetVersion() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.getVersion((PersistenceCapable)this);
        }
        return null;
    }

    protected final void jdoPreSerialize() {
        if (this.jdoStateManager != null) {
            this.jdoStateManager.preSerialize((PersistenceCapable)this);
        }
    }

    public final PersistenceManager jdoGetPersistenceManager() {
        return this.jdoStateManager != null ? this.jdoStateManager.getPersistenceManager((PersistenceCapable)this) : null;
    }

    public final Object jdoGetTransactionalObjectId() {
        return this.jdoStateManager != null ? this.jdoStateManager.getTransactionalObjectId((PersistenceCapable)this) : null;
    }

    public final boolean jdoIsDeleted() {
        return this.jdoStateManager != null ? this.jdoStateManager.isDeleted((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsDirty() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.isDirty((PersistenceCapable)this);
        }
        return false;
    }

    public final boolean jdoIsNew() {
        return this.jdoStateManager != null ? this.jdoStateManager.isNew((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsPersistent() {
        return this.jdoStateManager != null ? this.jdoStateManager.isPersistent((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsTransactional() {
        return this.jdoStateManager != null ? this.jdoStateManager.isTransactional((PersistenceCapable)this) : false;
    }

    public void jdoMakeDirty(String fieldName) {
        if (this.jdoStateManager != null) {
            this.jdoStateManager.makeDirty((PersistenceCapable)this, fieldName);
        }
    }

    public final Object jdoNewObjectIdInstance() {
        return new StringIdentity(this.getClass(), this.userId);
    }

    public final Object jdoNewObjectIdInstance(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        if (!(key instanceof String)) {
            return new StringIdentity(this.getClass(), (String)key);
        }
        return new StringIdentity(this.getClass(), (String)key);
    }

    public final void jdoProvideFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argment is null");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.jdoProvideField(indices[i]);
            } while (--i >= 0);
        }
    }

    public final void jdoReplaceFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argument is null");
        }
        int i = indices.length;
        if (i > 0) {
            int j = 0;
            do {
                this.jdoReplaceField(indices[j]);
            } while (++j < i);
        }
    }

    public final void jdoReplaceFlags() {
        if (this.jdoStateManager != null) {
            this.jdoFlags = this.jdoStateManager.replacingFlags((PersistenceCapable)this);
        }
    }

    public final synchronized void jdoReplaceStateManager(StateManager sm) {
        if (this.jdoStateManager != null) {
            this.jdoStateManager = this.jdoStateManager.replacingStateManager((PersistenceCapable)this, sm);
        } else {
            JDOImplHelper.checkAuthorizedStateManager((StateManager)sm);
            this.jdoStateManager = sm;
            this.jdoFlags = 1;
        }
    }

    public boolean jdoIsDetached() {
        return false;
    }

    public PersistenceCapable jdoNewInstance(StateManager sm) {
        OAuth2Credential result = new OAuth2Credential();
        result.jdoFlags = 1;
        result.jdoStateManager = sm;
        return result;
    }

    public PersistenceCapable jdoNewInstance(StateManager sm, Object obj) {
        OAuth2Credential result = new OAuth2Credential();
        result.jdoFlags = 1;
        result.jdoStateManager = sm;
        result.jdoCopyKeyFieldsFromObjectId(obj);
        return result;
    }

    public void jdoReplaceField(int index) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.accessToken = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 1: {
                this.refreshToken = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 2: {
                this.userId = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void jdoProvideField(int index) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.accessToken);
                break;
            }
            case 1: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.refreshToken);
                break;
            }
            case 2: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.userId);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    protected final void jdoCopyField(OAuth2Credential obj, int index) {
        switch (index) {
            case 0: {
                this.accessToken = obj.accessToken;
                break;
            }
            case 1: {
                this.refreshToken = obj.refreshToken;
                break;
            }
            case 2: {
                this.userId = obj.userId;
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void jdoCopyFields(Object obj, int[] indices) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        if (indices == null) {
            throw new IllegalStateException("fieldNumbers is null");
        }
        if (!(obj instanceof OAuth2Credential)) {
            throw new IllegalArgumentException("object is not an object of type com.google.api.client.extensions.auth.helpers.oauth2.draft10.OAuth2Credential");
        }
        OAuth2Credential other = (OAuth2Credential)obj;
        if (this.jdoStateManager != other.jdoStateManager) {
            throw new IllegalArgumentException("state managers do not match");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.jdoCopyField(other, indices[i]);
            } while (--i >= 0);
        }
    }

    private static final String[] __jdoFieldNamesInit() {
        return new String[]{"accessToken", "refreshToken", "userId"};
    }

    private static final Class[] __jdoFieldTypesInit() {
        return new Class[]{OAuth2Credential.___jdo$loadClass("java.lang.String"), OAuth2Credential.___jdo$loadClass("java.lang.String"), OAuth2Credential.___jdo$loadClass("java.lang.String")};
    }

    private static final byte[] __jdoFieldFlagsInit() {
        return new byte[]{21, 21, 24};
    }

    protected static int __jdoGetInheritedFieldCount() {
        return 0;
    }

    protected static int jdoGetManagedFieldCount() {
        return 3;
    }

    private static Class __jdoPersistenceCapableSuperclassInit() {
        return null;
    }

    public static Class ___jdo$loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    private Object jdoSuperClone() throws CloneNotSupportedException {
        OAuth2Credential o = (OAuth2Credential)super.clone();
        o.jdoFlags = 0;
        o.jdoStateManager = null;
        return o;
    }

    private static String jdoGetaccessToken(OAuth2Credential objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 0)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 0, objPC.accessToken);
        }
        return objPC.accessToken;
    }

    private static void jdoSetaccessToken(OAuth2Credential objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 0, objPC.accessToken, val);
        } else {
            objPC.accessToken = val;
        }
    }

    private static String jdoGetrefreshToken(OAuth2Credential objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 1)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 1, objPC.refreshToken);
        }
        return objPC.refreshToken;
    }

    private static void jdoSetrefreshToken(OAuth2Credential objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 1, objPC.refreshToken, val);
        } else {
            objPC.refreshToken = val;
        }
    }

    private static String jdoGetuserId(OAuth2Credential objPC) {
        return objPC.userId;
    }

    private static void jdoSetuserId(OAuth2Credential objPC, String val) {
        if (objPC.jdoStateManager == null) {
            objPC.userId = val;
        } else {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 2, objPC.userId, val);
        }
    }
}

