/*
 * Decompiled with CFR 0.152.
 */
package com.google.mlkit.vision.common.internal;

import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.media.Image;
import androidx.annotation.NonNull;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.OnLifecycleEvent;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.GmsLogger;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.mlkit_vision_common.zzlx;
import com.google.android.gms.tasks.CancellationTokenSource;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.android.odml.image.MlImage;
import com.google.mlkit.common.MlKitException;
import com.google.mlkit.common.sdkinternal.MLTask;
import com.google.mlkit.common.sdkinternal.MLTaskInput;
import com.google.mlkit.vision.common.InputImage;
import com.google.mlkit.vision.common.internal.CommonConvertUtils;
import com.google.mlkit.vision.common.internal.zza;
import com.google.mlkit.vision.common.internal.zzb;
import com.google.mlkit.vision.common.internal.zzc;
import com.google.mlkit.vision.common.internal.zzd;
import com.google.mlkit.vision.common.internal.zze;
import java.io.Closeable;
import java.nio.ByteBuffer;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;

@KeepForSdk
public class MobileVisionBase<DetectionResultT>
implements Closeable,
LifecycleObserver {
    private static final GmsLogger zzb = new GmsLogger("MobileVisionBase", "");
    private final AtomicBoolean zzc = new AtomicBoolean(false);
    private final MLTask zzd;
    private final CancellationTokenSource zze;
    private final Executor zzf;
    private final Task zzg;
    public static final /* synthetic */ int zza;

    @KeepForSdk
    @NonNull
    public synchronized Task<Void> closeWithTask() {
        if (!this.zzc.getAndSet(true)) {
            this.zze.cancel();
            return this.zzd.unpinWithTask(this.zzf);
        }
        return Tasks.forResult(null);
    }

    @KeepForSdk
    @NonNull
    public synchronized Task<Void> getInitTaskBase() {
        return this.zzg;
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    @NonNull
    public Task<DetectionResultT> process(@NonNull Bitmap bitmap, int rotationDegrees) {
        void var2_2;
        void var1_1;
        return this.processBase(InputImage.fromBitmap((Bitmap)var1_1, (int)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    @NonNull
    public Task<DetectionResultT> process(@NonNull Image image, int rotationDegrees) {
        void var2_2;
        void var1_1;
        return this.processBase(InputImage.fromMediaImage((Image)var1_1, (int)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    @NonNull
    public Task<DetectionResultT> process(@NonNull Image image, int rotationDegrees, @NonNull Matrix coordinatesMatrix) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.processBase(InputImage.fromMediaImage((Image)var1_1, (int)var2_2, (Matrix)var3_3));
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    @NonNull
    public Task<DetectionResultT> process(@NonNull ByteBuffer byteBuffer, int width, int height, int rotationDegrees, int format) {
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        return this.processBase(InputImage.fromByteBuffer((ByteBuffer)var1_1, (int)var2_2, (int)var3_3, (int)var4_4, (int)var5_5));
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    @NonNull
    public synchronized Task<DetectionResultT> processBase(@NonNull MlImage image) {
        void var1_1;
        Preconditions.checkNotNull((Object)image, (Object)"MlImage can not be null");
        if (this.zzc.get()) {
            return Tasks.forException((Exception)new MlKitException("This detector is already closed!", 14));
        }
        if (var1_1.getWidth() >= 32 && var1_1.getHeight() >= 32) {
            var1_1.getInternal().acquire();
            return this.zzd.callAfterLoad(this.zzf, (Callable)new zzd(this, (MlImage)var1_1), this.zze.getToken()).addOnCompleteListener((OnCompleteListener)new zze((MlImage)var1_1));
        }
        return Tasks.forException((Exception)new MlKitException("MlImage width and height should be at least 32!", 3));
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    @NonNull
    public synchronized Task<DetectionResultT> processBase(@NonNull InputImage image) {
        void var1_1;
        Preconditions.checkNotNull((Object)image, (Object)"InputImage can not be null");
        if (this.zzc.get()) {
            return Tasks.forException((Exception)new MlKitException("This detector is already closed!", 14));
        }
        if (var1_1.getWidth() >= 32 && var1_1.getHeight() >= 32) {
            return this.zzd.callAfterLoad(this.zzf, (Callable)new zza(this, (InputImage)var1_1), this.zze.getToken());
        }
        return Tasks.forException((Exception)new MlKitException("InputImage width and height should be at least 32!", 3));
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public MobileVisionBase(@NonNull MLTask<DetectionResultT, InputImage> detectorTaskWithResource, @NonNull Executor executor) {
        void var2_2;
        void var1_1;
        this.zzd = var1_1;
        this.zze = new CancellationTokenSource();
        this.zzf = var2_2;
        var1_1.pin();
        this.zzg = var1_1.callAfterLoad(this.zzf, (Callable)com.google.mlkit.vision.common.internal.zzb.zza, this.zze.getToken()).addOnFailureListener((OnFailureListener)com.google.mlkit.vision.common.internal.zzc.zza);
    }

    @Override
    @OnLifecycleEvent(value=Lifecycle.Event.ON_DESTROY)
    @KeepForSdk
    public synchronized void close() {
        if (!this.zzc.getAndSet(true)) {
            this.zze.cancel();
            this.zzd.unpin(this.zzf);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final /* synthetic */ Object zza(InputImage inputImage) throws Exception {
        zzlx zzlx2 = zzlx.zze("detectorTaskWithResource#run");
        zzlx2.zzb();
        try {
            Object object = ((MobileVisionBase)object).zzd.run((MLTaskInput)inputImage);
            zzlx2.close();
            return object;
        }
        catch (Throwable throwable) {
            try {
                zzlx2.close();
            }
            catch (Throwable throwable2) {
                try {
                    Throwable.class.getDeclaredMethod("addSuppressed", Throwable.class).invoke((Object)throwable, throwable2);
                    throw throwable;
                }
                catch (Exception exception) {
                    throw throwable;
                }
            }
            throw throwable;
        }
    }

    final /* synthetic */ Object zzb(MlImage object) throws Exception {
        if ((object = CommonConvertUtils.convertMlImagetoInputImage(object)) == null) {
            throw new MlKitException("Current type of MlImage is not supported.", 13);
        }
        return this.zzd.run((MLTaskInput)object);
    }

    static /* synthetic */ void zzc(Exception exception) {
        zzb.e("MobileVisionBase", "Error preloading model resource", (Throwable)exception);
    }
}

