/*
 * Decompiled with CFR 0.152.
 */
package com.google.mlkit.common.sdkinternal.model;

import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.GmsLogger;
import com.google.android.gms.common.internal.Preconditions;
import com.google.mlkit.common.MlKitException;
import com.google.mlkit.common.sdkinternal.MlKitContext;
import com.google.mlkit.common.sdkinternal.ModelType;
import java.io.File;

@KeepForSdk
public class ModelFileHelper {
    @KeepForSdk
    public static final int INVALID_INDEX = -1;
    private static final GmsLogger zzd = new GmsLogger("ModelFileHelper", "");
    @VisibleForTesting
    @NonNull
    public static final String zza;
    @VisibleForTesting
    @NonNull
    public static final String zzb;
    @VisibleForTesting
    static final String zzc;
    private final MlKitContext zze;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    @KeepForSdk
    public int getLatestCachedModelVersion(@NonNull File modelDir) {
        int n;
        File[] fileArray = modelDir.listFiles();
        if (fileArray == null || (n = fileArray.length) == 0) {
            return -1;
        }
        int n2 = -1;
        int n3 = 0;
        while (n3 < n) {
            Object object = fileArray[n3];
            try {
                n2 = Math.max(n2, Integer.parseInt(((File)object).getName()));
            }
            catch (NumberFormatException numberFormatException) {
                object = String.valueOf(((File)object).getName());
                String string = "Contains non-integer file name ";
                zzd.d("ModelFileHelper", string.concat((String)object));
            }
            ++n3;
        }
        return n2;
    }

    /*
     * WARNING - void declaration
     */
    @WorkerThread
    @KeepForSdk
    @NonNull
    public File getModelDir(@NonNull String modelName, @NonNull ModelType modelType) throws MlKitException {
        void var2_2;
        void var1_1;
        return this.zzc((String)var1_1, (ModelType)var2_2, false);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @WorkerThread
    @KeepForSdk
    @NonNull
    public File getModelDirUnsafe(@NonNull String modelName, @NonNull ModelType modelType, boolean isTemp) {
        void var1_1;
        void var3_3;
        String string;
        switch (((Enum)((Object)string)).ordinal()) {
            case 1: {
                string = zzc;
                break;
            }
            case 4: {
                string = zzb;
                break;
            }
            default: {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Unknown model type ");
                stringBuilder.append(((Enum)((Object)string)).name());
                stringBuilder.append(". Cannot find a dir to store the downloaded model.");
                throw new IllegalArgumentException(stringBuilder.toString());
            }
            case 2: {
                string = zza;
            }
        }
        Object object = Build.VERSION.SDK_INT >= 21 ? new File(((ModelFileHelper)object).zze.getApplicationContext().getNoBackupFilesDir(), string) : ((ModelFileHelper)object).zze.getApplicationContext().getDir(string, 0);
        if (var3_3 != false) {
            string = "temp";
            object = new File((File)object, string);
        }
        return new File((File)object, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @WorkerThread
    @KeepForSdk
    @NonNull
    public File getModelTempDir(@NonNull String modelName, @NonNull ModelType modelType) throws MlKitException {
        void var2_2;
        void var1_1;
        return this.zzc((String)var1_1, (ModelType)var2_2, true);
    }

    /*
     * WARNING - void declaration
     */
    @WorkerThread
    @KeepForSdk
    @NonNull
    public File getTempFileInPrivateFolder(@NonNull String modelName, @NonNull ModelType modelType, @NonNull String fileName) throws MlKitException {
        void var3_3;
        String string;
        String string2;
        if (!((File)(this_ = ((ModelFileHelper)this_).zzc(string2, (ModelType)((Object)string), true))).exists() || !((File)this_).isFile() || ((File)this_).delete()) {
            if (!((File)this_).exists()) {
                string2 = String.valueOf(((File)this_).getAbsolutePath());
                string = "Temp labels folder does not exist, creating one: ";
                zzd.d("ModelFileHelper", string.concat(string2));
                if (!((File)this_).mkdirs()) {
                    throw new MlKitException("Failed to create a directory to hold the AutoML model's labels file.", 13);
                }
            }
        } else {
            Object this_ = String.valueOf(((File)this_).getAbsolutePath());
            throw new MlKitException("Failed to delete the temp labels file: ".concat((String)this_), 13);
        }
        return new File((File)this_, (String)var3_3);
    }

    static {
        String string = "translate";
        Object[] objectArray = new Object[]{string};
        zza = String.format("com.google.mlkit.%s.models", objectArray);
        string = "custom";
        objectArray = new Object[]{string};
        zzb = String.format("com.google.mlkit.%s.models", objectArray);
        string = "base";
        objectArray = new Object[]{string};
        zzc = String.format("com.google.mlkit.%s.models", objectArray);
    }

    public ModelFileHelper(@NonNull MlKitContext mlKitContext) {
        this.zze = mlKitContext;
    }

    /*
     * WARNING - void declaration
     */
    @WorkerThread
    @KeepForSdk
    public synchronized void deleteAllModels(@NonNull ModelType modelType, @NonNull String modelName) {
        void var1_1;
        void var2_2;
        ModelFileHelper modelFileHelper = this;
        modelFileHelper.deleteRecursively(modelFileHelper.getModelDirUnsafe((String)var2_2, (ModelType)var1_1, false));
        ModelFileHelper modelFileHelper2 = this;
        modelFileHelper2.deleteRecursively(modelFileHelper2.getModelDirUnsafe((String)var2_2, (ModelType)var1_1, true));
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    @KeepForSdk
    public void deleteTempFilesInPrivateFolder(@NonNull String modelName, @NonNull ModelType modelType) throws MlKitException {
        GmsLogger gmsLogger;
        Object object;
        if (((ModelFileHelper)this_).deleteRecursively((File)(object = ((ModelFileHelper)this_).zzc((String)object, (ModelType)gmsLogger, true)))) {
            return;
        }
        gmsLogger = zzd;
        Object this_ = object != null ? ((File)object).getAbsolutePath() : null;
        object = "Failed to delete the temp labels file directory: ";
        this_ = String.valueOf(this_);
        gmsLogger.e("ModelFileHelper", ((String)object).concat((String)this_));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @WorkerThread
    @KeepForSdk
    public boolean deleteRecursively(@Nullable File root) {
        block9: {
            void var1_1;
            block8: {
                if (root == null) {
                    return false;
                }
                if (!var1_1.isDirectory()) break block8;
                File[] fileArray = (File[])Preconditions.checkNotNull((Object)var1_1.listFiles());
                int n = fileArray.length;
                boolean bl = true;
                for (int i = 0; i < n; ++i) {
                    File file = fileArray[i];
                    if (bl) {
                        if (this.deleteRecursively(file)) {
                            bl = true;
                            continue;
                        }
                        bl = false;
                        continue;
                    }
                    bl = false;
                }
                if (!bl) break block9;
            }
            if (var1_1.delete()) {
                return true;
            }
        }
        return false;
    }

    @WorkerThread
    @KeepForSdk
    public boolean modelExistsLocally(@NonNull String modelName, @NonNull ModelType modelType) throws MlKitException {
        File file;
        Object object;
        if (modelType == ModelType.UNKNOWN) {
            return false;
        }
        if ((object2 = ((ModelFileHelper)object2).zzb((String)object, (ModelType)((Object)file))) == null) {
            return false;
        }
        object = new File((String)object2);
        if (!((File)object).exists()) {
            return false;
        }
        Object object2 = "model.tflite";
        file = new File((File)object, (String)object2);
        object2 = String.valueOf(file.getAbsolutePath());
        object = "Model file path: ";
        zzd.i("ModelFileHelper", ((String)object).concat((String)object2));
        return file.exists();
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    private final File zzc(@NonNull String string, @NonNull ModelType object, boolean bl) throws MlKitException {
        Object object2;
        if (!((File)(object2 = ((ModelFileHelper)object2).getModelDirUnsafe(string, (ModelType)((Object)object), bl))).exists()) {
            string = String.valueOf(((File)object2).getAbsolutePath());
            object = "model folder does not exist, creating one: ";
            zzd.d("ModelFileHelper", ((String)object).concat(string));
            if (((File)object2).mkdirs()) return object2;
            object2 = String.valueOf(String.valueOf(object2));
            throw new MlKitException("Failed to create model folder: ".concat((String)object2), 13);
        }
        if (((File)object2).isDirectory()) {
            return object2;
        }
        object2 = String.valueOf(String.valueOf(object2));
        throw new MlKitException("Can not create model folder, since an existing file has the same name: ".concat((String)object2), 6);
    }

    @WorkerThread
    @NonNull
    public final File zza(@NonNull String string, @NonNull ModelType modelType) throws MlKitException {
        return this.zzc(string, modelType, true);
    }

    @WorkerThread
    @Nullable
    public final String zzb(@NonNull String object, @NonNull ModelType modelType) throws MlKitException {
        int n = this.getLatestCachedModelVersion((File)(object = this.getModelDir((String)object, modelType)));
        if (n == -1) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(((File)object).getAbsolutePath());
        stringBuilder.append("/");
        stringBuilder.append(n);
        return stringBuilder.toString();
    }
}

