/*
 * Decompiled with CFR 0.152.
 */
package com.google.mlkit.common.sdkinternal.model;

import android.app.DownloadManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.os.Build;
import android.os.Handler;
import android.os.ParcelFileDescriptor;
import android.util.LongSparseArray;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import androidx.core.content.ContextCompat;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.GmsLogger;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.mlkit_common.zzmu;
import com.google.android.gms.internal.mlkit_common.zzna;
import com.google.android.gms.internal.mlkit_common.zzry;
import com.google.android.gms.internal.mlkit_common.zzsh;
import com.google.android.gms.internal.mlkit_common.zzsk;
import com.google.android.gms.internal.mlkit_common.zzss;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import com.google.mlkit.common.MlKitException;
import com.google.mlkit.common.model.DownloadConditions;
import com.google.mlkit.common.model.RemoteModel;
import com.google.mlkit.common.sdkinternal.CommonUtils;
import com.google.mlkit.common.sdkinternal.MLTaskExecutor;
import com.google.mlkit.common.sdkinternal.MlKitContext;
import com.google.mlkit.common.sdkinternal.ModelInfo;
import com.google.mlkit.common.sdkinternal.ModelType;
import com.google.mlkit.common.sdkinternal.SharedPrefManager;
import com.google.mlkit.common.sdkinternal.model.ModelFileHelper;
import com.google.mlkit.common.sdkinternal.model.ModelInfoRetrieverInterop;
import com.google.mlkit.common.sdkinternal.model.RemoteModelFileManager;
import com.google.mlkit.common.sdkinternal.model.zzc;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.Map;

@KeepForSdk
public class RemoteModelDownloadManager {
    private static final GmsLogger zza = new GmsLogger("ModelDownloadManager", "");
    @GuardedBy(value="RemoteModelDownloadManager.class")
    private static final Map zzb = new HashMap();
    @GuardedBy(value="this")
    private final LongSparseArray zzc = new LongSparseArray();
    @GuardedBy(value="this")
    private final LongSparseArray zzd = new LongSparseArray();
    private final MlKitContext zze;
    @Nullable
    private final DownloadManager zzf;
    private final RemoteModel zzg;
    private final ModelType zzh;
    private final zzsh zzi;
    private final SharedPrefManager zzj;
    private final ModelFileHelper zzk;
    @Nullable
    private final ModelInfoRetrieverInterop zzl;
    private final RemoteModelFileManager zzm;
    private DownloadConditions zzn;

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @KeepForSdk
    public int getFailureReason(@NonNull Long downloadId) {
        void var1_1;
        RemoteModelDownloadManager this_ = this_.zzf;
        if (this_ == null) return 0;
        if (var1_1 == null) {
            return 0;
        }
        this_ = this_.query(new DownloadManager.Query().setFilterById(new long[]{var1_1.longValue()}));
        if (this_ == null) return 0;
        if (!this_.moveToFirst()) return 0;
        int n = this_.getColumnIndex("reason");
        if (n == -1) return 0;
        return this_.getInt(n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    @KeepForSdk
    public synchronized ParcelFileDescriptor getDownloadedFile() {
        DownloadManager downloadManager = ((RemoteModelDownloadManager)((Object)this_)).zzf;
        Long this_ = ((RemoteModelDownloadManager)((Object)this_)).getDownloadingId();
        if (downloadManager == null) return null;
        if (this_ == null) return null;
        try {
            return downloadManager.openDownloadedFile(this_.longValue());
        }
        catch (FileNotFoundException fileNotFoundException) {
            zza.e("ModelDownloadManager", "Downloaded file is not found");
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    @KeepForSdk
    @NonNull
    public Task<Void> ensureModelDownloaded() {
        Object object;
        Object object2;
        this.zzi.zzf(zzsk.zzg(), this.zzg, zzmu.zza, false, ModelType.UNKNOWN, zzna.zzb);
        try {
            object2 = this.zzg();
            object = null;
        }
        catch (MlKitException mlKitException) {
            object2 = null;
        }
        try {
            int n;
            Object object3 = this.getDownloadingModelStatusCode();
            Long l = this.getDownloadingId();
            int n2 = this.modelExistsLocally();
            if (n2 != 0 || object3 != null && (n2 = ((Integer)object3).intValue()) == 8) {
                if (object2 == null) return Tasks.forResult(null);
                RemoteModelDownloadManager remoteModelDownloadManager = this;
                object = remoteModelDownloadManager.zzo((ModelInfo)object2, remoteModelDownloadManager.zzn);
                if (object != null) {
                    return this.zzj((Long)object);
                }
                zza.i("ModelDownloadManager", "Didn't schedule download for the updated model");
                return Tasks.forResult(null);
            }
            if (object3 != null && (n2 = ((Integer)object3).intValue()) == 16) {
                MlKitException mlKitException = this.zzl(l);
                this.removeOrCancelDownload();
                return Tasks.forException((Exception)mlKitException);
            }
            if (object3 != null && ((n2 = ((Integer)object3).intValue()) == 4 || (n2 = ((Integer)object3).intValue()) == 2 || (n = ((Integer)object3).intValue()) == 1) && l != null && (object3 = this.getDownloadingModelHash()) != null) {
                object = this.zzi;
                object2 = zzsk.zzg();
                object3 = this.zzg;
                zzmu zzmu2 = zzmu.zza;
                Object object4 = object3;
                ((zzsh)object).zzf((zzry)object2, (RemoteModel)object4, zzmu2, false, ((RemoteModel)object4).getModelType(), zzna.zzg);
                return this.zzj(l);
            }
            if (object2 == null) {
                object2 = null;
            } else {
                RemoteModelDownloadManager remoteModelDownloadManager = this;
                object2 = remoteModelDownloadManager.zzo((ModelInfo)object2, remoteModelDownloadManager.zzn);
            }
            if (object2 != null) return this.zzj((Long)object2);
            return Tasks.forException((Exception)new MlKitException("Failed to schedule the download task", 13, (Throwable)object));
        }
        catch (MlKitException mlKitException) {
            return Tasks.forException((Exception)new MlKitException("Failed to ensure the model is downloaded.", 13, mlKitException));
        }
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    @NonNull
    public static synchronized RemoteModelDownloadManager getInstance(@NonNull MlKitContext mlKitContext, @NonNull RemoteModel remoteModel, @NonNull ModelFileHelper modelFileHelper, @NonNull RemoteModelFileManager remoteModelFileManager, @Nullable ModelInfoRetrieverInterop retrieverInterop) {
        void var1_1;
        if (!zzb.containsKey(var1_1)) {
            void var4_4;
            void var3_3;
            void var2_2;
            MlKitContext mlKitContext2;
            String string = "common";
            RemoteModelDownloadManager remoteModelDownloadManager = new RemoteModelDownloadManager(mlKitContext2, (RemoteModel)var1_1, (ModelFileHelper)var2_2, (RemoteModelFileManager)var3_3, (ModelInfoRetrieverInterop)var4_4, zzss.zzb(string));
            zzb.put(var1_1, remoteModelDownloadManager);
        }
        return (RemoteModelDownloadManager)zzb.get(var1_1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    @KeepForSdk
    public synchronized Integer getDownloadingModelStatusCode() {
        DownloadManager downloadManager;
        block11: {
            Object this_;
            block10: {
                downloadManager = ((RemoteModelDownloadManager)this_).zzf;
                this_ = ((RemoteModelDownloadManager)this_).getDownloadingId();
                if (downloadManager == null) return null;
                if (this_ == null) {
                    return null;
                }
                if ((downloadManager = downloadManager.query(new DownloadManager.Query().setFilterById(new long[]{(Long)this_}))) != null) {
                    boolean bl = downloadManager.moveToFirst();
                    if (bl) {
                        DownloadManager downloadManager2 = downloadManager;
                        this_ = downloadManager2.getInt(downloadManager2.getColumnIndex("status"));
                        break block10;
                    } else {
                        this_ = null;
                    }
                    break block10;
                }
                this_ = null;
            }
            if (this_ == null) {
                if (downloadManager == null) return null;
                downloadManager.close();
                return null;
            }
            try {
                int n = (Integer)this_;
                if (n == 2 || (n = ((Integer)this_).intValue()) == 4 || (n = ((Integer)this_).intValue()) == 1 || (n = ((Integer)this_).intValue()) == 8 || (n = ((Integer)this_).intValue()) == 16) break block11;
                this_ = null;
            }
            catch (Throwable throwable) {
                try {
                    downloadManager.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                    throw throwable;
                }
                throw throwable;
            }
        }
        downloadManager.close();
        return this_;
    }

    @Nullable
    @KeepForSdk
    public synchronized Long getDownloadingId() {
        return this.zzj.getDownloadingModelId(this.zzg);
    }

    @Nullable
    @KeepForSdk
    public synchronized String getDownloadingModelHash() {
        return this.zzj.getDownloadingModelHash(this.zzg);
    }

    /*
     * Enabled aggressive block sorting
     */
    @KeepForSdk
    public synchronized void removeOrCancelDownload() throws MlKitException {
        Object object;
        block3: {
            block2: {
                object = this.getDownloadingId();
                if (this.zzf == null || object == null) break block2;
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Cancel or remove existing downloading task: ");
                stringBuilder.append(object);
                String string = "Cancel or remove existing downloading task: ".concat(object.toString());
                zza.d("ModelDownloadManager", string);
                if (this.zzf.remove(new long[]{(Long)object}) > 0 || this.getDownloadingModelStatusCode() == null) break block3;
            }
            return;
        }
        object = this.zzg;
        this.zzk.deleteTempFilesInPrivateFolder(((RemoteModel)object).getUniqueModelNameForPersist(), ((RemoteModel)object).getModelType());
        this.zzj.clearDownloadingModelInfo(this.zzg);
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public void setDownloadConditions(@NonNull DownloadConditions downloadConditions) {
        void var1_1;
        Preconditions.checkNotNull((Object)downloadConditions, (Object)"DownloadConditions can not be null");
        this.zzn = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public synchronized void updateLatestModelHashAndType(@NonNull String hash) throws MlKitException {
        void var1_1;
        this.zzj.setLatestModelHash(this.zzg, (String)var1_1);
        this.removeOrCancelDownload();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    @KeepForSdk
    public boolean isModelDownloadedAndValid() throws MlKitException {
        try {
            boolean bl = this.modelExistsLocally();
            if (bl) {
                return true;
            }
        }
        catch (MlKitException mlKitException) {
            zza.d("ModelDownloadManager", "Failed to check if the model exist locally.");
        }
        String string = this.getDownloadingModelHash();
        if (this.getDownloadingId() == null || string == null) {
            zza.d("ModelDownloadManager", "No new model is downloading.");
            this.removeOrCancelDownload();
            return false;
        }
        Integer n = this.getDownloadingModelStatusCode();
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = "Download Status code: ";
        stringBuilder.append(string2);
        stringBuilder.append(n);
        String string3 = String.valueOf(n);
        zza.d("ModelDownloadManager", string2.concat(string3));
        if (n == null) {
            this.removeOrCancelDownload();
            return false;
        }
        if (!Objects.equal((Object)n, (Object)8)) {
            return false;
        }
        return this.zzi(string) != null;
    }

    @KeepForSdk
    public boolean modelExistsLocally() throws MlKitException {
        RemoteModel remoteModel = this.zzg;
        return this.zzk.modelExistsLocally(remoteModel.getUniqueModelNameForPersist(), this.zzh);
    }

    static /* bridge */ /* synthetic */ LongSparseArray zza(RemoteModelDownloadManager remoteModelDownloadManager) {
        return remoteModelDownloadManager.zzc;
    }

    static /* bridge */ /* synthetic */ LongSparseArray zzb(RemoteModelDownloadManager remoteModelDownloadManager) {
        return remoteModelDownloadManager.zzd;
    }

    static /* bridge */ /* synthetic */ GmsLogger zzc() {
        return zza;
    }

    private final Task zzj(long l) {
        zzc zzc2 = this.zzm(l);
        ContextCompat.registerReceiver((Context)this.zze.getApplicationContext(), (BroadcastReceiver)zzc2, (IntentFilter)new IntentFilter("android.intent.action.DOWNLOAD_COMPLETE"), null, (Handler)MLTaskExecutor.getInstance().getHandler(), (int)2);
        return this.zzk(l).getTask();
    }

    private final synchronized TaskCompletionSource zzk(long l) {
        TaskCompletionSource taskCompletionSource = (TaskCompletionSource)this.zzd.get(l);
        if (taskCompletionSource == null) {
            taskCompletionSource = new TaskCompletionSource();
            this.zzd.put(l, (Object)taskCompletionSource);
            return taskCompletionSource;
        }
        return taskCompletionSource;
    }

    static /* bridge */ /* synthetic */ MlKitException zzd(RemoteModelDownloadManager remoteModelDownloadManager, Long l) {
        return remoteModelDownloadManager.zzl(l);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final MlKitException zzl(@Nullable Long object) {
        int n;
        Object object2 = ((RemoteModelDownloadManager)object2).zzf;
        object2 = object2 != null ? (object == null ? null : object2.query(new DownloadManager.Query().setFilterById(new long[]{(Long)object}))) : null;
        object = "Model downloading failed";
        if (object2 == null) {
            n = 13;
            return new MlKitException((String)object, n);
        }
        if (!object2.moveToFirst()) {
            n = 13;
            return new MlKitException((String)object, n);
        }
        RemoteModelDownloadManager remoteModelDownloadManager = object2;
        n = remoteModelDownloadManager.getInt(remoteModelDownloadManager.getColumnIndex("reason"));
        if (n == 1006) {
            n = 101;
            object = "Model downloading failed due to insufficient space on the device.";
            return new MlKitException((String)object, n);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Model downloading failed due to error code: ");
        stringBuilder.append(n);
        stringBuilder.append(" from Android DownloadManager");
        n = 13;
        object = stringBuilder.toString();
        return new MlKitException((String)object, n);
    }

    static /* bridge */ /* synthetic */ RemoteModel zze(RemoteModelDownloadManager remoteModelDownloadManager) {
        return remoteModelDownloadManager.zzg;
    }

    static /* bridge */ /* synthetic */ MlKitContext zzf(RemoteModelDownloadManager remoteModelDownloadManager) {
        return remoteModelDownloadManager.zze;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    @WorkerThread
    final synchronized ModelInfo zzg() throws MlKitException {
        boolean bl;
        boolean bl2;
        boolean bl3;
        block13: {
            Object object;
            bl3 = ((RemoteModelDownloadManager)((Object)remoteModel)).modelExistsLocally();
            if (bl3) {
                Object object2 = object = ((RemoteModelDownloadManager)((Object)remoteModel)).zzg;
                ((RemoteModelDownloadManager)((Object)remoteModel)).zzi.zzf(zzsk.zzg(), (RemoteModel)object2, zzmu.zza, false, ((RemoteModel)object2).getModelType(), zzna.zzj);
            }
            if ((object = ((RemoteModelDownloadManager)((Object)remoteModel)).zzl) == null) {
                throw new MlKitException("Please include com.google.mlkit:linkfirebase sdk as your dependency when you try to download from Firebase.", 14);
            }
            ModelInfo modelInfo = object.retrieveRemoteModelInfo(((RemoteModelDownloadManager)((Object)remoteModel)).zzg);
            if (modelInfo == null) {
                return null;
            }
            object = ((RemoteModelDownloadManager)((Object)remoteModel)).zze;
            Object object3 = ((RemoteModelDownloadManager)((Object)remoteModel)).zzg;
            Object object4 = SharedPrefManager.getInstance((MlKitContext)object);
            if (modelInfo.getModelHash().equals(((SharedPrefManager)object4).getIncompatibleModelHash((RemoteModel)object3))) {
                if (CommonUtils.getAppVersion(((MlKitContext)object).getApplicationContext()).equals(((SharedPrefManager)object4).getPreviousAppVersion())) {
                    zza.e("ModelDownloadManager", "The model is incompatible with TFLite and the app is not upgraded, do not download");
                    bl2 = false;
                } else {
                    bl2 = true;
                }
            } else {
                bl2 = true;
            }
            if (!bl3) {
                ((RemoteModelDownloadManager)((Object)remoteModel)).zzj.clearLatestModelHash(((RemoteModelDownloadManager)((Object)remoteModel)).zzg);
            }
            object3 = ((RemoteModelDownloadManager)((Object)remoteModel)).zze;
            object4 = ((RemoteModelDownloadManager)((Object)remoteModel)).zzg;
            boolean bl4 = modelInfo.getModelHash().equals(SharedPrefManager.getInstance((MlKitContext)object3).getLatestModelHash((RemoteModel)object4)) ^ true;
            if (bl2) {
                if (bl3 && !bl4) {
                    bl = false;
                    break block13;
                } else {
                    return modelInfo;
                }
            }
            bl = bl4;
        }
        if (bl3 && bl ^ bl2) {
            return null;
        }
        RemoteModel remoteModel = ((RemoteModelDownloadManager)((Object)remoteModel)).zzg;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("The model ");
        stringBuilder.append(remoteModel.getModelName());
        stringBuilder.append(" is incompatible with TFLite runtime");
        throw new MlKitException(stringBuilder.toString(), 100);
    }

    private final synchronized zzc zzm(long l) {
        zzc zzc2 = (zzc)((Object)this.zzc.get(l));
        if (zzc2 == null) {
            RemoteModelDownloadManager remoteModelDownloadManager = this;
            long l2 = l;
            zzc2 = new zzc(remoteModelDownloadManager, l2, remoteModelDownloadManager.zzk(l2), null);
            this.zzc.put(l, (Object)zzc2);
            return zzc2;
        }
        return zzc2;
    }

    static /* bridge */ /* synthetic */ zzsh zzh(RemoteModelDownloadManager remoteModelDownloadManager) {
        return remoteModelDownloadManager.zzi;
    }

    @Nullable
    public final File zzi(@NonNull String object) throws MlKitException {
        zza.d("ModelDownloadManager", "Model downloaded successfully");
        this.zzi.zzf(zzsk.zzg(), this.zzg, zzmu.zza, true, this.zzh, zzna.zzh);
        ParcelFileDescriptor parcelFileDescriptor = this.getDownloadedFile();
        if (parcelFileDescriptor == null) {
            this.removeOrCancelDownload();
            return null;
        }
        zza.d("ModelDownloadManager", "moving downloaded model from external storage to private folder.");
        try {
            object = this.zzm.moveModelToPrivateFolder(parcelFileDescriptor, (String)object, this.zzg);
        }
        catch (Throwable throwable) {
            this.removeOrCancelDownload();
            throw throwable;
        }
        this.removeOrCancelDownload();
        return object;
    }

    @Nullable
    private final synchronized Long zzn(@NonNull DownloadManager.Request object, @NonNull ModelInfo modelInfo) {
        DownloadManager downloadManager = ((RemoteModelDownloadManager)((Object)remoteModel)).zzf;
        if (downloadManager == null) {
            return null;
        }
        long l = downloadManager.enqueue(object);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Schedule a new downloading task: ");
        stringBuilder.append(l);
        object = stringBuilder.toString();
        zza.d("ModelDownloadManager", (String)object);
        ((RemoteModelDownloadManager)((Object)remoteModel)).zzj.setDownloadingModelInfo(l, modelInfo);
        RemoteModel remoteModel = ((RemoteModelDownloadManager)((Object)remoteModel)).zzg;
        ((RemoteModelDownloadManager)((Object)remoteModel)).zzi.zzf(zzsk.zzg(), remoteModel, zzmu.zza, false, modelInfo.getModelType(), zzna.zzf);
        return l;
    }

    @Nullable
    @WorkerThread
    private final synchronized Long zzo(@NonNull ModelInfo object, @NonNull DownloadConditions downloadConditions) throws MlKitException {
        Preconditions.checkNotNull((Object)downloadConditions, (Object)"DownloadConditions can not be null");
        String string = ((RemoteModelDownloadManager)this).zzj.getDownloadingModelHash(((RemoteModelDownloadManager)this).zzg);
        Object object2 = ((RemoteModelDownloadManager)this).getDownloadingModelStatusCode();
        if (string != null && string.equals(((ModelInfo)object).getModelHash()) && object2 != null) {
            object = ((RemoteModelDownloadManager)this).getDownloadingModelStatusCode();
            if (object == null || (Integer)object != 8 && (Integer)object != 16) {
                Object object3 = this = ((RemoteModelDownloadManager)this).zzg;
                ((RemoteModelDownloadManager)this).zzi.zzf(zzsk.zzg(), (RemoteModel)object3, zzmu.zza, false, ((RemoteModel)object3).getModelType(), zzna.zzg);
            }
            zza.d("ModelDownloadManager", "New model is already in downloading, do nothing.");
            return null;
        }
        zza.d("ModelDownloadManager", "Need to download a new model.");
        ((RemoteModelDownloadManager)this).removeOrCancelDownload();
        string = new DownloadManager.Request(((ModelInfo)object).getModelUri());
        if (((RemoteModelDownloadManager)this).zzk.modelExistsLocally(((ModelInfo)object).getModelNameForPersist(), ((ModelInfo)object).getModelType())) {
            zza.d("ModelDownloadManager", "Model update is enabled and have a previous downloaded model, use download condition");
            object2 = ((RemoteModelDownloadManager)this).zzg;
            ((RemoteModelDownloadManager)this).zzi.zzf(zzsk.zzg(), (RemoteModel)object2, zzmu.zza, false, ((ModelInfo)object).getModelType(), zzna.zzk);
        }
        if (Build.VERSION.SDK_INT >= 24) {
            string.setRequiresCharging(downloadConditions.isChargingRequired());
        }
        if (downloadConditions.isWifiRequired()) {
            string.setAllowedNetworkTypes(2);
        }
        return super.zzn((DownloadManager.Request)string, (ModelInfo)object);
    }

    @VisibleForTesting
    RemoteModelDownloadManager(@NonNull MlKitContext mlKitContext, @NonNull RemoteModel remoteModel, @NonNull ModelFileHelper modelFileHelper, @NonNull RemoteModelFileManager remoteModelFileManager, @Nullable ModelInfoRetrieverInterop modelInfoRetrieverInterop, @NonNull zzsh zzsh2) {
        this.zze = mlKitContext;
        this.zzh = remoteModel.getModelType();
        this.zzg = remoteModel;
        this.zzf = (DownloadManager)mlKitContext.getApplicationContext().getSystemService("download");
        this.zzi = zzsh2;
        if (this.zzf == null) {
            zza.d("ModelDownloadManager", "Download manager service is not available in the service.");
        }
        this.zzk = modelFileHelper;
        this.zzj = SharedPrefManager.getInstance(mlKitContext);
        this.zzl = modelInfoRetrieverInterop;
        this.zzm = remoteModelFileManager;
    }
}

