/*
 * Decompiled with CFR 0.152.
 */
package com.google.mlkit.vision.barcode.common;

import android.graphics.Matrix;
import android.graphics.Point;
import android.graphics.Rect;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.mlkit.vision.barcode.common.internal.BarcodeSource;
import com.google.mlkit.vision.common.internal.CommonConvertUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.List;

public class Barcode {
    public static final int FORMAT_UNKNOWN = -1;
    public static final int FORMAT_ALL_FORMATS = 0;
    public static final int FORMAT_CODE_128 = 1;
    public static final int FORMAT_CODE_39 = 2;
    public static final int FORMAT_CODE_93 = 4;
    public static final int FORMAT_CODABAR = 8;
    public static final int FORMAT_DATA_MATRIX = 16;
    public static final int FORMAT_EAN_13 = 32;
    public static final int FORMAT_EAN_8 = 64;
    public static final int FORMAT_ITF = 128;
    public static final int FORMAT_QR_CODE = 256;
    public static final int FORMAT_UPC_A = 512;
    public static final int FORMAT_UPC_E = 1024;
    public static final int FORMAT_PDF417 = 2048;
    public static final int FORMAT_AZTEC = 4096;
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_CONTACT_INFO = 1;
    public static final int TYPE_EMAIL = 2;
    public static final int TYPE_ISBN = 3;
    public static final int TYPE_PHONE = 4;
    public static final int TYPE_PRODUCT = 5;
    public static final int TYPE_SMS = 6;
    public static final int TYPE_TEXT = 7;
    public static final int TYPE_URL = 8;
    public static final int TYPE_WIFI = 9;
    public static final int TYPE_GEO = 10;
    public static final int TYPE_CALENDAR_EVENT = 11;
    public static final int TYPE_DRIVER_LICENSE = 12;
    private final BarcodeSource zza;
    @Nullable
    private final Rect zzb;
    @Nullable
    private final Point[] zzc;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @BarcodeFormat
    public int getFormat() {
        int n = this.zza.getFormat();
        if (n > 4096) return -1;
        if (n != 0) return n;
        return -1;
    }

    @BarcodeValueType
    public int getValueType() {
        return this.zza.getValueType();
    }

    @Nullable
    public Rect getBoundingBox() {
        return this.zzb;
    }

    @Nullable
    public CalendarEvent getCalendarEvent() {
        return this.zza.getCalendarEvent();
    }

    @Nullable
    public ContactInfo getContactInfo() {
        return this.zza.getContactInfo();
    }

    @Nullable
    public DriverLicense getDriverLicense() {
        return this.zza.getDriverLicense();
    }

    @Nullable
    public Email getEmail() {
        return this.zza.getEmail();
    }

    @Nullable
    public GeoPoint getGeoPoint() {
        return this.zza.getGeoPoint();
    }

    @Nullable
    public Phone getPhone() {
        return this.zza.getPhone();
    }

    @Nullable
    public Sms getSms() {
        return this.zza.getSms();
    }

    @Nullable
    public UrlBookmark getUrl() {
        return this.zza.getUrl();
    }

    @Nullable
    public WiFi getWifi() {
        return this.zza.getWifi();
    }

    @Nullable
    public String getDisplayValue() {
        return this.zza.getDisplayValue();
    }

    @Nullable
    public String getRawValue() {
        return this.zza.getRawValue();
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public Barcode(@NonNull BarcodeSource barcodeSource) {
        this((BarcodeSource)var1_1, null);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public Barcode(@NonNull BarcodeSource barcodeSource, @Nullable Matrix coordinatesMatrix) {
        void var2_2;
        Point[] pointArray;
        this.zza = (BarcodeSource)Preconditions.checkNotNull((Object)pointArray);
        Rect rect = pointArray.getBoundingBox();
        if (rect != null && var2_2 != null) {
            CommonConvertUtils.transformRect((Rect)rect, (Matrix)var2_2);
        }
        this.zzb = rect;
        if ((pointArray = pointArray.getCornerPoints()) != null && var2_2 != null) {
            CommonConvertUtils.transformPointArray((Point[])pointArray, (Matrix)var2_2);
        }
        this.zzc = pointArray;
    }

    @Nullable
    public byte[] getRawBytes() {
        Object this_ = ((Barcode)this_).zza.getRawBytes();
        if (this_ != null) {
            return Arrays.copyOf((byte[])this_, ((Object)this_).length);
        }
        return null;
    }

    @Nullable
    public Point[] getCornerPoints() {
        return this.zzc;
    }

    public static class WiFi {
        public static final int TYPE_OPEN = 1;
        public static final int TYPE_WPA = 2;
        public static final int TYPE_WEP = 3;
        @Nullable
        private final String zza;
        @Nullable
        private final String zzb;
        private final int zzc;

        @EncryptionType
        public int getEncryptionType() {
            return this.zzc;
        }

        @Nullable
        public String getPassword() {
            return this.zzb;
        }

        @Nullable
        public String getSsid() {
            return this.zza;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        public WiFi(@Nullable String ssid, @Nullable String password, int encryptionType) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.zza = var1_1;
            this.zzb = var2_2;
            this.zzc = var3_3;
        }

        @Retention(value=RetentionPolicy.CLASS)
        public static @interface EncryptionType {
        }
    }

    public static class UrlBookmark {
        @Nullable
        private final String zza;
        @Nullable
        private final String zzb;

        @Nullable
        public String getTitle() {
            return this.zza;
        }

        @Nullable
        public String getUrl() {
            return this.zzb;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        public UrlBookmark(@Nullable String title, @Nullable String url) {
            void var2_2;
            void var1_1;
            this.zza = var1_1;
            this.zzb = var2_2;
        }
    }

    public static class Sms {
        @Nullable
        private final String zza;
        @Nullable
        private final String zzb;

        @Nullable
        public String getMessage() {
            return this.zza;
        }

        @Nullable
        public String getPhoneNumber() {
            return this.zzb;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        public Sms(@Nullable String message, @Nullable String phoneNumber) {
            void var2_2;
            void var1_1;
            this.zza = var1_1;
            this.zzb = var2_2;
        }
    }

    public static class GeoPoint {
        private final double zza;
        private final double zzb;

        public double getLat() {
            return this.zza;
        }

        public double getLng() {
            return this.zzb;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        public GeoPoint(double lat, double lng) {
            void var3_2;
            void var1_1;
            this.zza = var1_1;
            this.zzb = var3_2;
        }
    }

    public static class ContactInfo {
        @Nullable
        private final PersonName zza;
        @Nullable
        private final String zzb;
        @Nullable
        private final String zzc;
        private final List zzd;
        private final List zze;
        private final List zzf;
        private final List zzg;

        @Nullable
        public PersonName getName() {
            return this.zza;
        }

        @Nullable
        public String getOrganization() {
            return this.zzb;
        }

        @Nullable
        public String getTitle() {
            return this.zzc;
        }

        @NonNull
        public List<Address> getAddresses() {
            return this.zzg;
        }

        @NonNull
        public List<Email> getEmails() {
            return this.zze;
        }

        @NonNull
        public List<Phone> getPhones() {
            return this.zzd;
        }

        @NonNull
        public List<String> getUrls() {
            return this.zzf;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        public ContactInfo(@Nullable PersonName name, @Nullable String organization, @Nullable String title, @NonNull List<Phone> phones, @NonNull List<Email> emails, @NonNull List<String> urls, @NonNull List<Address> addresses) {
            void var7_7;
            void var6_6;
            void var5_5;
            void var4_4;
            void var3_3;
            void var2_2;
            void var1_1;
            this.zza = var1_1;
            this.zzb = var2_2;
            this.zzc = var3_3;
            this.zzd = var4_4;
            this.zze = var5_5;
            this.zzf = var6_6;
            this.zzg = var7_7;
        }
    }

    public static class Email {
        public static final int TYPE_UNKNOWN = 0;
        public static final int TYPE_WORK = 1;
        public static final int TYPE_HOME = 2;
        private final int zza;
        @Nullable
        private final String zzb;
        @Nullable
        private final String zzc;
        @Nullable
        private final String zzd;

        @FormatType
        public int getType() {
            return this.zza;
        }

        @Nullable
        public String getAddress() {
            return this.zzb;
        }

        @Nullable
        public String getBody() {
            return this.zzd;
        }

        @Nullable
        public String getSubject() {
            return this.zzc;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        public Email(int type, @Nullable String address, @Nullable String subject, @Nullable String body) {
            void var4_4;
            void var3_3;
            void var2_2;
            void var1_1;
            this.zza = var1_1;
            this.zzb = var2_2;
            this.zzc = var3_3;
            this.zzd = var4_4;
        }

        @Retention(value=RetentionPolicy.CLASS)
        public static @interface FormatType {
        }
    }

    public static class Phone {
        public static final int TYPE_UNKNOWN = 0;
        public static final int TYPE_WORK = 1;
        public static final int TYPE_HOME = 2;
        public static final int TYPE_FAX = 3;
        public static final int TYPE_MOBILE = 4;
        @Nullable
        private final String zza;
        private final int zzb;

        @FormatType
        public int getType() {
            return this.zzb;
        }

        @Nullable
        public String getNumber() {
            return this.zza;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        public Phone(@Nullable String number, int type) {
            void var2_2;
            void var1_1;
            this.zza = var1_1;
            this.zzb = var2_2;
        }

        @Retention(value=RetentionPolicy.CLASS)
        public static @interface FormatType {
        }
    }

    public static class PersonName {
        @Nullable
        private final String zza;
        @Nullable
        private final String zzb;
        @Nullable
        private final String zzc;
        @Nullable
        private final String zzd;
        @Nullable
        private final String zze;
        @Nullable
        private final String zzf;
        @Nullable
        private final String zzg;

        @Nullable
        public String getFirst() {
            return this.zzd;
        }

        @Nullable
        public String getFormattedName() {
            return this.zza;
        }

        @Nullable
        public String getLast() {
            return this.zzf;
        }

        @Nullable
        public String getMiddle() {
            return this.zze;
        }

        @Nullable
        public String getPrefix() {
            return this.zzc;
        }

        @Nullable
        public String getPronunciation() {
            return this.zzb;
        }

        @Nullable
        public String getSuffix() {
            return this.zzg;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        public PersonName(@Nullable String formattedName, @Nullable String pronunciation, @Nullable String prefix, @Nullable String first, @Nullable String middle, @Nullable String last, @Nullable String suffix) {
            void var7_7;
            void var6_6;
            void var5_5;
            void var4_4;
            void var3_3;
            void var2_2;
            void var1_1;
            this.zza = var1_1;
            this.zzb = var2_2;
            this.zzc = var3_3;
            this.zzd = var4_4;
            this.zze = var5_5;
            this.zzf = var6_6;
            this.zzg = var7_7;
        }
    }

    public static class DriverLicense {
        @Nullable
        private final String zza;
        @Nullable
        private final String zzb;
        @Nullable
        private final String zzc;
        @Nullable
        private final String zzd;
        @Nullable
        private final String zze;
        @Nullable
        private final String zzf;
        @Nullable
        private final String zzg;
        @Nullable
        private final String zzh;
        @Nullable
        private final String zzi;
        @Nullable
        private final String zzj;
        @Nullable
        private final String zzk;
        @Nullable
        private final String zzl;
        @Nullable
        private final String zzm;
        @Nullable
        private final String zzn;

        @Nullable
        public String getAddressCity() {
            return this.zzg;
        }

        @Nullable
        public String getAddressState() {
            return this.zzh;
        }

        @Nullable
        public String getAddressStreet() {
            return this.zzf;
        }

        @Nullable
        public String getAddressZip() {
            return this.zzi;
        }

        @Nullable
        public String getBirthDate() {
            return this.zzm;
        }

        @Nullable
        public String getDocumentType() {
            return this.zza;
        }

        @Nullable
        public String getExpiryDate() {
            return this.zzl;
        }

        @Nullable
        public String getFirstName() {
            return this.zzb;
        }

        @Nullable
        public String getGender() {
            return this.zze;
        }

        @Nullable
        public String getIssueDate() {
            return this.zzk;
        }

        @Nullable
        public String getIssuingCountry() {
            return this.zzn;
        }

        @Nullable
        public String getLastName() {
            return this.zzd;
        }

        @Nullable
        public String getLicenseNumber() {
            return this.zzj;
        }

        @Nullable
        public String getMiddleName() {
            return this.zzc;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        public DriverLicense(@Nullable String documentType, @Nullable String firstName, @Nullable String middleName, @Nullable String lastName, @Nullable String gender, @Nullable String addressStreet, @Nullable String addressCity, @Nullable String addressState, @Nullable String addressZip, @Nullable String licenseNumber, @Nullable String issueDate, @Nullable String expiryDate, @Nullable String birthDate, @Nullable String issuingCountry) {
            void var14_14;
            void var13_13;
            void var12_12;
            void var11_11;
            void var10_10;
            void var9_9;
            void var8_8;
            void var7_7;
            void var6_6;
            void var5_5;
            void var4_4;
            void var3_3;
            void var2_2;
            void var1_1;
            this.zza = var1_1;
            this.zzb = var2_2;
            this.zzc = var3_3;
            this.zzd = var4_4;
            this.zze = var5_5;
            this.zzf = var6_6;
            this.zzg = var7_7;
            this.zzh = var8_8;
            this.zzi = var9_9;
            this.zzj = var10_10;
            this.zzk = var11_11;
            this.zzl = var12_12;
            this.zzm = var13_13;
            this.zzn = var14_14;
        }
    }

    public static class CalendarEvent {
        @Nullable
        private final String zza;
        @Nullable
        private final String zzb;
        @Nullable
        private final String zzc;
        @Nullable
        private final String zzd;
        @Nullable
        private final String zze;
        @Nullable
        private final CalendarDateTime zzf;
        @Nullable
        private final CalendarDateTime zzg;

        @Nullable
        public CalendarDateTime getEnd() {
            return this.zzg;
        }

        @Nullable
        public CalendarDateTime getStart() {
            return this.zzf;
        }

        @Nullable
        public String getDescription() {
            return this.zzb;
        }

        @Nullable
        public String getLocation() {
            return this.zzc;
        }

        @Nullable
        public String getOrganizer() {
            return this.zzd;
        }

        @Nullable
        public String getStatus() {
            return this.zze;
        }

        @Nullable
        public String getSummary() {
            return this.zza;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        public CalendarEvent(@Nullable String summary, @Nullable String description, @Nullable String location, @Nullable String organizer, @Nullable String status, @Nullable CalendarDateTime start, @Nullable CalendarDateTime end) {
            void var7_7;
            void var6_6;
            void var5_5;
            void var4_4;
            void var3_3;
            void var2_2;
            void var1_1;
            this.zza = var1_1;
            this.zzb = var2_2;
            this.zzc = var3_3;
            this.zzd = var4_4;
            this.zze = var5_5;
            this.zzf = var6_6;
            this.zzg = var7_7;
        }
    }

    public static class CalendarDateTime {
        private final int zza;
        private final int zzb;
        private final int zzc;
        private final int zzd;
        private final int zze;
        private final int zzf;
        private final boolean zzg;
        @Nullable
        private final String zzh;

        public int getDay() {
            return this.zzc;
        }

        public int getHours() {
            return this.zzd;
        }

        public int getMinutes() {
            return this.zze;
        }

        public int getMonth() {
            return this.zzb;
        }

        public int getSeconds() {
            return this.zzf;
        }

        public int getYear() {
            return this.zza;
        }

        @Nullable
        public String getRawValue() {
            return this.zzh;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        public CalendarDateTime(int year, int month, int day, int hours, int minutes, int seconds, boolean isUtc, @Nullable String rawValue) {
            void var8_8;
            void var7_7;
            void var6_6;
            void var5_5;
            void var4_4;
            void var3_3;
            void var2_2;
            void var1_1;
            this.zza = var1_1;
            this.zzb = var2_2;
            this.zzc = var3_3;
            this.zzd = var4_4;
            this.zze = var5_5;
            this.zzf = var6_6;
            this.zzg = var7_7;
            this.zzh = var8_8;
        }

        public boolean isUtc() {
            return this.zzg;
        }
    }

    public static class Address {
        public static final int TYPE_UNKNOWN = 0;
        public static final int TYPE_WORK = 1;
        public static final int TYPE_HOME = 2;
        private final int zza;
        private final String[] zzb;

        @AddressType
        public int getType() {
            return this.zza;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        public Address(int type, @NonNull String[] addressLines) {
            void var2_2;
            void var1_1;
            this.zza = var1_1;
            this.zzb = var2_2;
        }

        @NonNull
        public String[] getAddressLines() {
            return this.zzb;
        }

        @Retention(value=RetentionPolicy.CLASS)
        public static @interface AddressType {
        }
    }

    @Retention(value=RetentionPolicy.CLASS)
    public static @interface BarcodeValueType {
    }

    @Retention(value=RetentionPolicy.CLASS)
    public static @interface BarcodeFormat {
    }
}

