/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.routeoptimization.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.maps.routeoptimization.v1.BatchOptimizeToursMetadata;
import com.google.maps.routeoptimization.v1.BatchOptimizeToursRequest;
import com.google.maps.routeoptimization.v1.BatchOptimizeToursResponse;
import com.google.maps.routeoptimization.v1.OptimizeToursLongRunningMetadata;
import com.google.maps.routeoptimization.v1.OptimizeToursRequest;
import com.google.maps.routeoptimization.v1.OptimizeToursResponse;
import com.google.maps.routeoptimization.v1.OptimizeToursUriMetadata;
import com.google.maps.routeoptimization.v1.OptimizeToursUriRequest;
import com.google.maps.routeoptimization.v1.OptimizeToursUriResponse;
import com.google.maps.routeoptimization.v1.RouteOptimizationSettings;
import com.google.maps.routeoptimization.v1.stub.RouteOptimizationStub;
import com.google.maps.routeoptimization.v1.stub.RouteOptimizationStubSettings;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class RouteOptimizationClient
implements BackgroundResource {
    private final RouteOptimizationSettings settings;
    private final RouteOptimizationStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final RouteOptimizationClient create() throws IOException {
        return RouteOptimizationClient.create(RouteOptimizationSettings.newBuilder().build());
    }

    public static final RouteOptimizationClient create(RouteOptimizationSettings settings) throws IOException {
        return new RouteOptimizationClient(settings);
    }

    public static final RouteOptimizationClient create(RouteOptimizationStub stub) {
        return new RouteOptimizationClient(stub);
    }

    protected RouteOptimizationClient(RouteOptimizationSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((RouteOptimizationStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected RouteOptimizationClient(RouteOptimizationStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final RouteOptimizationSettings getSettings() {
        return this.settings;
    }

    public RouteOptimizationStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final OptimizeToursResponse optimizeTours(OptimizeToursRequest request) {
        return (OptimizeToursResponse)this.optimizeToursCallable().call((Object)request);
    }

    public final UnaryCallable<OptimizeToursRequest, OptimizeToursResponse> optimizeToursCallable() {
        return this.stub.optimizeToursCallable();
    }

    public final OperationFuture<BatchOptimizeToursResponse, BatchOptimizeToursMetadata> batchOptimizeToursAsync(BatchOptimizeToursRequest request) {
        return this.batchOptimizeToursOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<BatchOptimizeToursRequest, BatchOptimizeToursResponse, BatchOptimizeToursMetadata> batchOptimizeToursOperationCallable() {
        return this.stub.batchOptimizeToursOperationCallable();
    }

    public final UnaryCallable<BatchOptimizeToursRequest, Operation> batchOptimizeToursCallable() {
        return this.stub.batchOptimizeToursCallable();
    }

    public final OperationFuture<OptimizeToursResponse, OptimizeToursLongRunningMetadata> optimizeToursLongRunningAsync(OptimizeToursRequest request) {
        return this.optimizeToursLongRunningOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<OptimizeToursRequest, OptimizeToursResponse, OptimizeToursLongRunningMetadata> optimizeToursLongRunningOperationCallable() {
        return this.stub.optimizeToursLongRunningOperationCallable();
    }

    public final UnaryCallable<OptimizeToursRequest, Operation> optimizeToursLongRunningCallable() {
        return this.stub.optimizeToursLongRunningCallable();
    }

    public final OperationFuture<OptimizeToursUriResponse, OptimizeToursUriMetadata> optimizeToursUriAsync(OptimizeToursUriRequest request) {
        return this.optimizeToursUriOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<OptimizeToursUriRequest, OptimizeToursUriResponse, OptimizeToursUriMetadata> optimizeToursUriOperationCallable() {
        return this.stub.optimizeToursUriOperationCallable();
    }

    public final UnaryCallable<OptimizeToursUriRequest, Operation> optimizeToursUriCallable() {
        return this.stub.optimizeToursUriCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

