/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.places.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.maps.places.v1.AutocompletePlacesRequest;
import com.google.maps.places.v1.AutocompletePlacesResponse;
import com.google.maps.places.v1.GetPhotoMediaRequest;
import com.google.maps.places.v1.GetPlaceRequest;
import com.google.maps.places.v1.PhotoMedia;
import com.google.maps.places.v1.Place;
import com.google.maps.places.v1.SearchNearbyRequest;
import com.google.maps.places.v1.SearchNearbyResponse;
import com.google.maps.places.v1.SearchTextRequest;
import com.google.maps.places.v1.SearchTextResponse;
import com.google.maps.places.v1.stub.GrpcPlacesCallableFactory;
import com.google.maps.places.v1.stub.PlacesStub;
import com.google.maps.places.v1.stub.PlacesStubSettings;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcPlacesStub
extends PlacesStub {
    private static final MethodDescriptor<SearchNearbyRequest, SearchNearbyResponse> searchNearbyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.maps.places.v1.Places/SearchNearby").setRequestMarshaller(ProtoUtils.marshaller((Message)SearchNearbyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)SearchNearbyResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<SearchTextRequest, SearchTextResponse> searchTextMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.maps.places.v1.Places/SearchText").setRequestMarshaller(ProtoUtils.marshaller((Message)SearchTextRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)SearchTextResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetPhotoMediaRequest, PhotoMedia> getPhotoMediaMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.maps.places.v1.Places/GetPhotoMedia").setRequestMarshaller(ProtoUtils.marshaller((Message)GetPhotoMediaRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)PhotoMedia.getDefaultInstance())).build();
    private static final MethodDescriptor<GetPlaceRequest, Place> getPlaceMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.maps.places.v1.Places/GetPlace").setRequestMarshaller(ProtoUtils.marshaller((Message)GetPlaceRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Place.getDefaultInstance())).build();
    private static final MethodDescriptor<AutocompletePlacesRequest, AutocompletePlacesResponse> autocompletePlacesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.maps.places.v1.Places/AutocompletePlaces").setRequestMarshaller(ProtoUtils.marshaller((Message)AutocompletePlacesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)AutocompletePlacesResponse.getDefaultInstance())).build();
    private final UnaryCallable<SearchNearbyRequest, SearchNearbyResponse> searchNearbyCallable;
    private final UnaryCallable<SearchTextRequest, SearchTextResponse> searchTextCallable;
    private final UnaryCallable<GetPhotoMediaRequest, PhotoMedia> getPhotoMediaCallable;
    private final UnaryCallable<GetPlaceRequest, Place> getPlaceCallable;
    private final UnaryCallable<AutocompletePlacesRequest, AutocompletePlacesResponse> autocompletePlacesCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcPlacesStub create(PlacesStubSettings settings) throws IOException {
        return new GrpcPlacesStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcPlacesStub create(ClientContext clientContext) throws IOException {
        return new GrpcPlacesStub(PlacesStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcPlacesStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcPlacesStub(PlacesStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcPlacesStub(PlacesStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcPlacesCallableFactory());
    }

    protected GrpcPlacesStub(PlacesStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings searchNearbyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(searchNearbyMethodDescriptor).build();
        GrpcCallSettings searchTextTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(searchTextMethodDescriptor).build();
        GrpcCallSettings getPhotoMediaTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getPhotoMediaMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getPlaceTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getPlaceMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings autocompletePlacesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(autocompletePlacesMethodDescriptor).build();
        this.searchNearbyCallable = callableFactory.createUnaryCallable(searchNearbyTransportSettings, settings.searchNearbySettings(), clientContext);
        this.searchTextCallable = callableFactory.createUnaryCallable(searchTextTransportSettings, settings.searchTextSettings(), clientContext);
        this.getPhotoMediaCallable = callableFactory.createUnaryCallable(getPhotoMediaTransportSettings, settings.getPhotoMediaSettings(), clientContext);
        this.getPlaceCallable = callableFactory.createUnaryCallable(getPlaceTransportSettings, settings.getPlaceSettings(), clientContext);
        this.autocompletePlacesCallable = callableFactory.createUnaryCallable(autocompletePlacesTransportSettings, settings.autocompletePlacesSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<SearchNearbyRequest, SearchNearbyResponse> searchNearbyCallable() {
        return this.searchNearbyCallable;
    }

    @Override
    public UnaryCallable<SearchTextRequest, SearchTextResponse> searchTextCallable() {
        return this.searchTextCallable;
    }

    @Override
    public UnaryCallable<GetPhotoMediaRequest, PhotoMedia> getPhotoMediaCallable() {
        return this.getPhotoMediaCallable;
    }

    @Override
    public UnaryCallable<GetPlaceRequest, Place> getPlaceCallable() {
        return this.getPlaceCallable;
    }

    @Override
    public UnaryCallable<AutocompletePlacesRequest, AutocompletePlacesResponse> autocompletePlacesCallable() {
        return this.autocompletePlacesCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

