/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.places.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.maps.places.v1.AutocompletePlacesRequest;
import com.google.maps.places.v1.AutocompletePlacesResponse;
import com.google.maps.places.v1.GetPhotoMediaRequest;
import com.google.maps.places.v1.GetPlaceRequest;
import com.google.maps.places.v1.PhotoMedia;
import com.google.maps.places.v1.Place;
import com.google.maps.places.v1.SearchNearbyRequest;
import com.google.maps.places.v1.SearchNearbyResponse;
import com.google.maps.places.v1.SearchTextRequest;
import com.google.maps.places.v1.SearchTextResponse;
import com.google.maps.places.v1.stub.GrpcPlacesStub;
import com.google.maps.places.v1.stub.HttpJsonPlacesStub;
import com.google.maps.places.v1.stub.PlacesStub;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class PlacesStubSettings
extends StubSettings<PlacesStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().build();
    private final UnaryCallSettings<SearchNearbyRequest, SearchNearbyResponse> searchNearbySettings;
    private final UnaryCallSettings<SearchTextRequest, SearchTextResponse> searchTextSettings;
    private final UnaryCallSettings<GetPhotoMediaRequest, PhotoMedia> getPhotoMediaSettings;
    private final UnaryCallSettings<GetPlaceRequest, Place> getPlaceSettings;
    private final UnaryCallSettings<AutocompletePlacesRequest, AutocompletePlacesResponse> autocompletePlacesSettings;

    public UnaryCallSettings<SearchNearbyRequest, SearchNearbyResponse> searchNearbySettings() {
        return this.searchNearbySettings;
    }

    public UnaryCallSettings<SearchTextRequest, SearchTextResponse> searchTextSettings() {
        return this.searchTextSettings;
    }

    public UnaryCallSettings<GetPhotoMediaRequest, PhotoMedia> getPhotoMediaSettings() {
        return this.getPhotoMediaSettings;
    }

    public UnaryCallSettings<GetPlaceRequest, Place> getPlaceSettings() {
        return this.getPlaceSettings;
    }

    public UnaryCallSettings<AutocompletePlacesRequest, AutocompletePlacesResponse> autocompletePlacesSettings() {
        return this.autocompletePlacesSettings;
    }

    public PlacesStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcPlacesStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonPlacesStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "places";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "places.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "places.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return PlacesStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(PlacesStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(PlacesStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return PlacesStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected PlacesStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.searchNearbySettings = settingsBuilder.searchNearbySettings().build();
        this.searchTextSettings = settingsBuilder.searchTextSettings().build();
        this.getPhotoMediaSettings = settingsBuilder.getPhotoMediaSettings().build();
        this.getPlaceSettings = settingsBuilder.getPlaceSettings().build();
        this.autocompletePlacesSettings = settingsBuilder.autocompletePlacesSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<PlacesStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<SearchNearbyRequest, SearchNearbyResponse> searchNearbySettings;
        private final UnaryCallSettings.Builder<SearchTextRequest, SearchTextResponse> searchTextSettings;
        private final UnaryCallSettings.Builder<GetPhotoMediaRequest, PhotoMedia> getPhotoMediaSettings;
        private final UnaryCallSettings.Builder<GetPlaceRequest, Place> getPlaceSettings;
        private final UnaryCallSettings.Builder<AutocompletePlacesRequest, AutocompletePlacesResponse> autocompletePlacesSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.searchNearbySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.searchTextSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getPhotoMediaSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getPlaceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.autocompletePlacesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.searchNearbySettings, this.searchTextSettings, this.getPhotoMediaSettings, this.getPlaceSettings, this.autocompletePlacesSettings);
            Builder.initDefaults(this);
        }

        protected Builder(PlacesStubSettings settings) {
            super((StubSettings)settings);
            this.searchNearbySettings = settings.searchNearbySettings.toBuilder();
            this.searchTextSettings = settings.searchTextSettings.toBuilder();
            this.getPhotoMediaSettings = settings.getPhotoMediaSettings.toBuilder();
            this.getPlaceSettings = settings.getPlaceSettings.toBuilder();
            this.autocompletePlacesSettings = settings.autocompletePlacesSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.searchNearbySettings, this.searchTextSettings, this.getPhotoMediaSettings, this.getPlaceSettings, this.autocompletePlacesSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(PlacesStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)PlacesStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)PlacesStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(PlacesStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)PlacesStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)PlacesStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)PlacesStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(PlacesStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.searchNearbySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.searchTextSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getPhotoMediaSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getPlaceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.autocompletePlacesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<SearchNearbyRequest, SearchNearbyResponse> searchNearbySettings() {
            return this.searchNearbySettings;
        }

        public UnaryCallSettings.Builder<SearchTextRequest, SearchTextResponse> searchTextSettings() {
            return this.searchTextSettings;
        }

        public UnaryCallSettings.Builder<GetPhotoMediaRequest, PhotoMedia> getPhotoMediaSettings() {
            return this.getPhotoMediaSettings;
        }

        public UnaryCallSettings.Builder<GetPlaceRequest, Place> getPlaceSettings() {
            return this.getPlaceSettings;
        }

        public UnaryCallSettings.Builder<AutocompletePlacesRequest, AutocompletePlacesResponse> autocompletePlacesSettings() {
            return this.autocompletePlacesSettings;
        }

        public PlacesStubSettings build() throws IOException {
            return new PlacesStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

