/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.mapsplatformdatasets.v1alpha.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.maps.mapsplatformdatasets.v1alpha.CreateDatasetRequest;
import com.google.maps.mapsplatformdatasets.v1alpha.Dataset;
import com.google.maps.mapsplatformdatasets.v1alpha.DeleteDatasetRequest;
import com.google.maps.mapsplatformdatasets.v1alpha.DeleteDatasetVersionRequest;
import com.google.maps.mapsplatformdatasets.v1alpha.GetDatasetRequest;
import com.google.maps.mapsplatformdatasets.v1alpha.ListDatasetVersionsRequest;
import com.google.maps.mapsplatformdatasets.v1alpha.ListDatasetVersionsResponse;
import com.google.maps.mapsplatformdatasets.v1alpha.ListDatasetsRequest;
import com.google.maps.mapsplatformdatasets.v1alpha.ListDatasetsResponse;
import com.google.maps.mapsplatformdatasets.v1alpha.MapsPlatformDatasetsV1AlphaClient;
import com.google.maps.mapsplatformdatasets.v1alpha.UpdateDatasetMetadataRequest;
import com.google.maps.mapsplatformdatasets.v1alpha.stub.GrpcMapsPlatformDatasetsV1AlphaStub;
import com.google.maps.mapsplatformdatasets.v1alpha.stub.HttpJsonMapsPlatformDatasetsV1AlphaStub;
import com.google.maps.mapsplatformdatasets.v1alpha.stub.MapsPlatformDatasetsV1AlphaStub;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class MapsPlatformDatasetsV1AlphaStubSettings
extends StubSettings<MapsPlatformDatasetsV1AlphaStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<CreateDatasetRequest, Dataset> createDatasetSettings;
    private final UnaryCallSettings<UpdateDatasetMetadataRequest, Dataset> updateDatasetMetadataSettings;
    private final UnaryCallSettings<GetDatasetRequest, Dataset> getDatasetSettings;
    private final PagedCallSettings<ListDatasetVersionsRequest, ListDatasetVersionsResponse, MapsPlatformDatasetsV1AlphaClient.ListDatasetVersionsPagedResponse> listDatasetVersionsSettings;
    private final PagedCallSettings<ListDatasetsRequest, ListDatasetsResponse, MapsPlatformDatasetsV1AlphaClient.ListDatasetsPagedResponse> listDatasetsSettings;
    private final UnaryCallSettings<DeleteDatasetRequest, Empty> deleteDatasetSettings;
    private final UnaryCallSettings<DeleteDatasetVersionRequest, Empty> deleteDatasetVersionSettings;
    private static final PagedListDescriptor<ListDatasetVersionsRequest, ListDatasetVersionsResponse, Dataset> LIST_DATASET_VERSIONS_PAGE_STR_DESC = new PagedListDescriptor<ListDatasetVersionsRequest, ListDatasetVersionsResponse, Dataset>(){

        public String emptyToken() {
            return "";
        }

        public ListDatasetVersionsRequest injectToken(ListDatasetVersionsRequest payload, String token) {
            return ListDatasetVersionsRequest.newBuilder((ListDatasetVersionsRequest)payload).setPageToken(token).build();
        }

        public ListDatasetVersionsRequest injectPageSize(ListDatasetVersionsRequest payload, int pageSize) {
            return ListDatasetVersionsRequest.newBuilder((ListDatasetVersionsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListDatasetVersionsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListDatasetVersionsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Dataset> extractResources(ListDatasetVersionsResponse payload) {
            return payload.getDatasetsList() == null ? ImmutableList.of() : payload.getDatasetsList();
        }
    };
    private static final PagedListDescriptor<ListDatasetsRequest, ListDatasetsResponse, Dataset> LIST_DATASETS_PAGE_STR_DESC = new PagedListDescriptor<ListDatasetsRequest, ListDatasetsResponse, Dataset>(){

        public String emptyToken() {
            return "";
        }

        public ListDatasetsRequest injectToken(ListDatasetsRequest payload, String token) {
            return ListDatasetsRequest.newBuilder((ListDatasetsRequest)payload).setPageToken(token).build();
        }

        public ListDatasetsRequest injectPageSize(ListDatasetsRequest payload, int pageSize) {
            return ListDatasetsRequest.newBuilder((ListDatasetsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListDatasetsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListDatasetsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Dataset> extractResources(ListDatasetsResponse payload) {
            return payload.getDatasetsList() == null ? ImmutableList.of() : payload.getDatasetsList();
        }
    };
    private static final PagedListResponseFactory<ListDatasetVersionsRequest, ListDatasetVersionsResponse, MapsPlatformDatasetsV1AlphaClient.ListDatasetVersionsPagedResponse> LIST_DATASET_VERSIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListDatasetVersionsRequest, ListDatasetVersionsResponse, MapsPlatformDatasetsV1AlphaClient.ListDatasetVersionsPagedResponse>(){

        public ApiFuture<MapsPlatformDatasetsV1AlphaClient.ListDatasetVersionsPagedResponse> getFuturePagedResponse(UnaryCallable<ListDatasetVersionsRequest, ListDatasetVersionsResponse> callable, ListDatasetVersionsRequest request, ApiCallContext context, ApiFuture<ListDatasetVersionsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_DATASET_VERSIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return MapsPlatformDatasetsV1AlphaClient.ListDatasetVersionsPagedResponse.createAsync((PageContext<ListDatasetVersionsRequest, ListDatasetVersionsResponse, Dataset>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListDatasetsRequest, ListDatasetsResponse, MapsPlatformDatasetsV1AlphaClient.ListDatasetsPagedResponse> LIST_DATASETS_PAGE_STR_FACT = new PagedListResponseFactory<ListDatasetsRequest, ListDatasetsResponse, MapsPlatformDatasetsV1AlphaClient.ListDatasetsPagedResponse>(){

        public ApiFuture<MapsPlatformDatasetsV1AlphaClient.ListDatasetsPagedResponse> getFuturePagedResponse(UnaryCallable<ListDatasetsRequest, ListDatasetsResponse> callable, ListDatasetsRequest request, ApiCallContext context, ApiFuture<ListDatasetsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_DATASETS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return MapsPlatformDatasetsV1AlphaClient.ListDatasetsPagedResponse.createAsync((PageContext<ListDatasetsRequest, ListDatasetsResponse, Dataset>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateDatasetRequest, Dataset> createDatasetSettings() {
        return this.createDatasetSettings;
    }

    public UnaryCallSettings<UpdateDatasetMetadataRequest, Dataset> updateDatasetMetadataSettings() {
        return this.updateDatasetMetadataSettings;
    }

    public UnaryCallSettings<GetDatasetRequest, Dataset> getDatasetSettings() {
        return this.getDatasetSettings;
    }

    public PagedCallSettings<ListDatasetVersionsRequest, ListDatasetVersionsResponse, MapsPlatformDatasetsV1AlphaClient.ListDatasetVersionsPagedResponse> listDatasetVersionsSettings() {
        return this.listDatasetVersionsSettings;
    }

    public PagedCallSettings<ListDatasetsRequest, ListDatasetsResponse, MapsPlatformDatasetsV1AlphaClient.ListDatasetsPagedResponse> listDatasetsSettings() {
        return this.listDatasetsSettings;
    }

    public UnaryCallSettings<DeleteDatasetRequest, Empty> deleteDatasetSettings() {
        return this.deleteDatasetSettings;
    }

    public UnaryCallSettings<DeleteDatasetVersionRequest, Empty> deleteDatasetVersionSettings() {
        return this.deleteDatasetVersionSettings;
    }

    public MapsPlatformDatasetsV1AlphaStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcMapsPlatformDatasetsV1AlphaStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonMapsPlatformDatasetsV1AlphaStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getEndpoint() {
        if (super.getEndpoint() != null) {
            return super.getEndpoint();
        }
        return MapsPlatformDatasetsV1AlphaStubSettings.getDefaultEndpoint();
    }

    public String getServiceName() {
        return "mapsplatformdatasets";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "mapsplatformdatasets.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "mapsplatformdatasets.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return MapsPlatformDatasetsV1AlphaStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(MapsPlatformDatasetsV1AlphaStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(MapsPlatformDatasetsV1AlphaStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return MapsPlatformDatasetsV1AlphaStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected MapsPlatformDatasetsV1AlphaStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createDatasetSettings = settingsBuilder.createDatasetSettings().build();
        this.updateDatasetMetadataSettings = settingsBuilder.updateDatasetMetadataSettings().build();
        this.getDatasetSettings = settingsBuilder.getDatasetSettings().build();
        this.listDatasetVersionsSettings = settingsBuilder.listDatasetVersionsSettings().build();
        this.listDatasetsSettings = settingsBuilder.listDatasetsSettings().build();
        this.deleteDatasetSettings = settingsBuilder.deleteDatasetSettings().build();
        this.deleteDatasetVersionSettings = settingsBuilder.deleteDatasetVersionSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<MapsPlatformDatasetsV1AlphaStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateDatasetRequest, Dataset> createDatasetSettings;
        private final UnaryCallSettings.Builder<UpdateDatasetMetadataRequest, Dataset> updateDatasetMetadataSettings;
        private final UnaryCallSettings.Builder<GetDatasetRequest, Dataset> getDatasetSettings;
        private final PagedCallSettings.Builder<ListDatasetVersionsRequest, ListDatasetVersionsResponse, MapsPlatformDatasetsV1AlphaClient.ListDatasetVersionsPagedResponse> listDatasetVersionsSettings;
        private final PagedCallSettings.Builder<ListDatasetsRequest, ListDatasetsResponse, MapsPlatformDatasetsV1AlphaClient.ListDatasetsPagedResponse> listDatasetsSettings;
        private final UnaryCallSettings.Builder<DeleteDatasetRequest, Empty> deleteDatasetSettings;
        private final UnaryCallSettings.Builder<DeleteDatasetVersionRequest, Empty> deleteDatasetVersionSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createDatasetSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateDatasetMetadataSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getDatasetSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listDatasetVersionsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_DATASET_VERSIONS_PAGE_STR_FACT);
            this.listDatasetsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_DATASETS_PAGE_STR_FACT);
            this.deleteDatasetSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteDatasetVersionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createDatasetSettings, this.updateDatasetMetadataSettings, this.getDatasetSettings, this.listDatasetVersionsSettings, this.listDatasetsSettings, this.deleteDatasetSettings, this.deleteDatasetVersionSettings);
            Builder.initDefaults(this);
        }

        protected Builder(MapsPlatformDatasetsV1AlphaStubSettings settings) {
            super((StubSettings)settings);
            this.createDatasetSettings = settings.createDatasetSettings.toBuilder();
            this.updateDatasetMetadataSettings = settings.updateDatasetMetadataSettings.toBuilder();
            this.getDatasetSettings = settings.getDatasetSettings.toBuilder();
            this.listDatasetVersionsSettings = settings.listDatasetVersionsSettings.toBuilder();
            this.listDatasetsSettings = settings.listDatasetsSettings.toBuilder();
            this.deleteDatasetSettings = settings.deleteDatasetSettings.toBuilder();
            this.deleteDatasetVersionSettings = settings.deleteDatasetVersionSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createDatasetSettings, this.updateDatasetMetadataSettings, this.getDatasetSettings, this.listDatasetVersionsSettings, this.listDatasetsSettings, this.deleteDatasetSettings, this.deleteDatasetVersionSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(MapsPlatformDatasetsV1AlphaStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)MapsPlatformDatasetsV1AlphaStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)MapsPlatformDatasetsV1AlphaStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(MapsPlatformDatasetsV1AlphaStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)MapsPlatformDatasetsV1AlphaStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)MapsPlatformDatasetsV1AlphaStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)MapsPlatformDatasetsV1AlphaStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(MapsPlatformDatasetsV1AlphaStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createDatasetSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.updateDatasetMetadataSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.getDatasetSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.listDatasetVersionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.listDatasetsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.deleteDatasetSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.deleteDatasetVersionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateDatasetRequest, Dataset> createDatasetSettings() {
            return this.createDatasetSettings;
        }

        public UnaryCallSettings.Builder<UpdateDatasetMetadataRequest, Dataset> updateDatasetMetadataSettings() {
            return this.updateDatasetMetadataSettings;
        }

        public UnaryCallSettings.Builder<GetDatasetRequest, Dataset> getDatasetSettings() {
            return this.getDatasetSettings;
        }

        public PagedCallSettings.Builder<ListDatasetVersionsRequest, ListDatasetVersionsResponse, MapsPlatformDatasetsV1AlphaClient.ListDatasetVersionsPagedResponse> listDatasetVersionsSettings() {
            return this.listDatasetVersionsSettings;
        }

        public PagedCallSettings.Builder<ListDatasetsRequest, ListDatasetsResponse, MapsPlatformDatasetsV1AlphaClient.ListDatasetsPagedResponse> listDatasetsSettings() {
            return this.listDatasetsSettings;
        }

        public UnaryCallSettings.Builder<DeleteDatasetRequest, Empty> deleteDatasetSettings() {
            return this.deleteDatasetSettings;
        }

        public UnaryCallSettings.Builder<DeleteDatasetVersionRequest, Empty> deleteDatasetVersionSettings() {
            return this.deleteDatasetVersionSettings;
        }

        public String getEndpoint() {
            if (super.getEndpoint() != null) {
                return super.getEndpoint();
            }
            return MapsPlatformDatasetsV1AlphaStubSettings.getDefaultEndpoint();
        }

        public MapsPlatformDatasetsV1AlphaStubSettings build() throws IOException {
            return new MapsPlatformDatasetsV1AlphaStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"retry_policy_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"no_retry_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)10000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

