/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.mapsplatformdatasets.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.maps.mapsplatformdatasets.v1.CreateDatasetRequest;
import com.google.maps.mapsplatformdatasets.v1.Dataset;
import com.google.maps.mapsplatformdatasets.v1.DeleteDatasetRequest;
import com.google.maps.mapsplatformdatasets.v1.GetDatasetRequest;
import com.google.maps.mapsplatformdatasets.v1.ListDatasetsRequest;
import com.google.maps.mapsplatformdatasets.v1.ListDatasetsResponse;
import com.google.maps.mapsplatformdatasets.v1.MapsPlatformDatasetsClient;
import com.google.maps.mapsplatformdatasets.v1.UpdateDatasetMetadataRequest;
import com.google.maps.mapsplatformdatasets.v1.stub.GrpcMapsPlatformDatasetsStub;
import com.google.maps.mapsplatformdatasets.v1.stub.HttpJsonMapsPlatformDatasetsStub;
import com.google.maps.mapsplatformdatasets.v1.stub.MapsPlatformDatasetsStub;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class MapsPlatformDatasetsStubSettings
extends StubSettings<MapsPlatformDatasetsStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<CreateDatasetRequest, Dataset> createDatasetSettings;
    private final UnaryCallSettings<UpdateDatasetMetadataRequest, Dataset> updateDatasetMetadataSettings;
    private final UnaryCallSettings<GetDatasetRequest, Dataset> getDatasetSettings;
    private final PagedCallSettings<ListDatasetsRequest, ListDatasetsResponse, MapsPlatformDatasetsClient.ListDatasetsPagedResponse> listDatasetsSettings;
    private final UnaryCallSettings<DeleteDatasetRequest, Empty> deleteDatasetSettings;
    private static final PagedListDescriptor<ListDatasetsRequest, ListDatasetsResponse, Dataset> LIST_DATASETS_PAGE_STR_DESC = new PagedListDescriptor<ListDatasetsRequest, ListDatasetsResponse, Dataset>(){

        public String emptyToken() {
            return "";
        }

        public ListDatasetsRequest injectToken(ListDatasetsRequest payload, String token) {
            return ListDatasetsRequest.newBuilder((ListDatasetsRequest)payload).setPageToken(token).build();
        }

        public ListDatasetsRequest injectPageSize(ListDatasetsRequest payload, int pageSize) {
            return ListDatasetsRequest.newBuilder((ListDatasetsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListDatasetsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListDatasetsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Dataset> extractResources(ListDatasetsResponse payload) {
            return payload.getDatasetsList() == null ? ImmutableList.of() : payload.getDatasetsList();
        }
    };
    private static final PagedListResponseFactory<ListDatasetsRequest, ListDatasetsResponse, MapsPlatformDatasetsClient.ListDatasetsPagedResponse> LIST_DATASETS_PAGE_STR_FACT = new PagedListResponseFactory<ListDatasetsRequest, ListDatasetsResponse, MapsPlatformDatasetsClient.ListDatasetsPagedResponse>(){

        public ApiFuture<MapsPlatformDatasetsClient.ListDatasetsPagedResponse> getFuturePagedResponse(UnaryCallable<ListDatasetsRequest, ListDatasetsResponse> callable, ListDatasetsRequest request, ApiCallContext context, ApiFuture<ListDatasetsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_DATASETS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return MapsPlatformDatasetsClient.ListDatasetsPagedResponse.createAsync((PageContext<ListDatasetsRequest, ListDatasetsResponse, Dataset>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateDatasetRequest, Dataset> createDatasetSettings() {
        return this.createDatasetSettings;
    }

    public UnaryCallSettings<UpdateDatasetMetadataRequest, Dataset> updateDatasetMetadataSettings() {
        return this.updateDatasetMetadataSettings;
    }

    public UnaryCallSettings<GetDatasetRequest, Dataset> getDatasetSettings() {
        return this.getDatasetSettings;
    }

    public PagedCallSettings<ListDatasetsRequest, ListDatasetsResponse, MapsPlatformDatasetsClient.ListDatasetsPagedResponse> listDatasetsSettings() {
        return this.listDatasetsSettings;
    }

    public UnaryCallSettings<DeleteDatasetRequest, Empty> deleteDatasetSettings() {
        return this.deleteDatasetSettings;
    }

    public MapsPlatformDatasetsStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcMapsPlatformDatasetsStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonMapsPlatformDatasetsStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "mapsplatformdatasets";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "mapsplatformdatasets.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "mapsplatformdatasets.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return MapsPlatformDatasetsStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(MapsPlatformDatasetsStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(MapsPlatformDatasetsStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return MapsPlatformDatasetsStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected MapsPlatformDatasetsStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createDatasetSettings = settingsBuilder.createDatasetSettings().build();
        this.updateDatasetMetadataSettings = settingsBuilder.updateDatasetMetadataSettings().build();
        this.getDatasetSettings = settingsBuilder.getDatasetSettings().build();
        this.listDatasetsSettings = settingsBuilder.listDatasetsSettings().build();
        this.deleteDatasetSettings = settingsBuilder.deleteDatasetSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<MapsPlatformDatasetsStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateDatasetRequest, Dataset> createDatasetSettings;
        private final UnaryCallSettings.Builder<UpdateDatasetMetadataRequest, Dataset> updateDatasetMetadataSettings;
        private final UnaryCallSettings.Builder<GetDatasetRequest, Dataset> getDatasetSettings;
        private final PagedCallSettings.Builder<ListDatasetsRequest, ListDatasetsResponse, MapsPlatformDatasetsClient.ListDatasetsPagedResponse> listDatasetsSettings;
        private final UnaryCallSettings.Builder<DeleteDatasetRequest, Empty> deleteDatasetSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createDatasetSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateDatasetMetadataSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getDatasetSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listDatasetsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_DATASETS_PAGE_STR_FACT);
            this.deleteDatasetSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createDatasetSettings, this.updateDatasetMetadataSettings, this.getDatasetSettings, this.listDatasetsSettings, this.deleteDatasetSettings);
            Builder.initDefaults(this);
        }

        protected Builder(MapsPlatformDatasetsStubSettings settings) {
            super((StubSettings)settings);
            this.createDatasetSettings = settings.createDatasetSettings.toBuilder();
            this.updateDatasetMetadataSettings = settings.updateDatasetMetadataSettings.toBuilder();
            this.getDatasetSettings = settings.getDatasetSettings.toBuilder();
            this.listDatasetsSettings = settings.listDatasetsSettings.toBuilder();
            this.deleteDatasetSettings = settings.deleteDatasetSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createDatasetSettings, this.updateDatasetMetadataSettings, this.getDatasetSettings, this.listDatasetsSettings, this.deleteDatasetSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(MapsPlatformDatasetsStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)MapsPlatformDatasetsStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)MapsPlatformDatasetsStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(MapsPlatformDatasetsStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(MapsPlatformDatasetsStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)MapsPlatformDatasetsStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)MapsPlatformDatasetsStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)MapsPlatformDatasetsStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(MapsPlatformDatasetsStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(MapsPlatformDatasetsStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createDatasetSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.updateDatasetMetadataSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.getDatasetSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.listDatasetsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.deleteDatasetSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateDatasetRequest, Dataset> createDatasetSettings() {
            return this.createDatasetSettings;
        }

        public UnaryCallSettings.Builder<UpdateDatasetMetadataRequest, Dataset> updateDatasetMetadataSettings() {
            return this.updateDatasetMetadataSettings;
        }

        public UnaryCallSettings.Builder<GetDatasetRequest, Dataset> getDatasetSettings() {
            return this.getDatasetSettings;
        }

        public PagedCallSettings.Builder<ListDatasetsRequest, ListDatasetsResponse, MapsPlatformDatasetsClient.ListDatasetsPagedResponse> listDatasetsSettings() {
            return this.listDatasetsSettings;
        }

        public UnaryCallSettings.Builder<DeleteDatasetRequest, Empty> deleteDatasetSettings() {
            return this.deleteDatasetSettings;
        }

        public MapsPlatformDatasetsStubSettings build() throws IOException {
            return new MapsPlatformDatasetsStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"retry_policy_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"no_retry_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)10000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_1_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

