/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.fleetengine.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.maps.fleetengine.v1.CreateTripRequest;
import com.google.maps.fleetengine.v1.DeleteTripRequest;
import com.google.maps.fleetengine.v1.GetTripRequest;
import com.google.maps.fleetengine.v1.ReportBillableTripRequest;
import com.google.maps.fleetengine.v1.SearchTripsRequest;
import com.google.maps.fleetengine.v1.SearchTripsResponse;
import com.google.maps.fleetengine.v1.Trip;
import com.google.maps.fleetengine.v1.TripServiceClient;
import com.google.maps.fleetengine.v1.UpdateTripRequest;
import com.google.maps.fleetengine.v1.stub.GrpcTripServiceStub;
import com.google.maps.fleetengine.v1.stub.TripServiceStub;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class TripServiceStubSettings
extends StubSettings<TripServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<CreateTripRequest, Trip> createTripSettings;
    private final UnaryCallSettings<GetTripRequest, Trip> getTripSettings;
    private final UnaryCallSettings<DeleteTripRequest, Empty> deleteTripSettings;
    private final UnaryCallSettings<ReportBillableTripRequest, Empty> reportBillableTripSettings;
    private final PagedCallSettings<SearchTripsRequest, SearchTripsResponse, TripServiceClient.SearchTripsPagedResponse> searchTripsSettings;
    private final UnaryCallSettings<UpdateTripRequest, Trip> updateTripSettings;
    private static final PagedListDescriptor<SearchTripsRequest, SearchTripsResponse, Trip> SEARCH_TRIPS_PAGE_STR_DESC = new PagedListDescriptor<SearchTripsRequest, SearchTripsResponse, Trip>(){

        public String emptyToken() {
            return "";
        }

        public SearchTripsRequest injectToken(SearchTripsRequest payload, String token) {
            return SearchTripsRequest.newBuilder((SearchTripsRequest)payload).setPageToken(token).build();
        }

        public SearchTripsRequest injectPageSize(SearchTripsRequest payload, int pageSize) {
            return SearchTripsRequest.newBuilder((SearchTripsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(SearchTripsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(SearchTripsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Trip> extractResources(SearchTripsResponse payload) {
            return payload.getTripsList();
        }
    };
    private static final PagedListResponseFactory<SearchTripsRequest, SearchTripsResponse, TripServiceClient.SearchTripsPagedResponse> SEARCH_TRIPS_PAGE_STR_FACT = new PagedListResponseFactory<SearchTripsRequest, SearchTripsResponse, TripServiceClient.SearchTripsPagedResponse>(){

        public ApiFuture<TripServiceClient.SearchTripsPagedResponse> getFuturePagedResponse(UnaryCallable<SearchTripsRequest, SearchTripsResponse> callable, SearchTripsRequest request, ApiCallContext context, ApiFuture<SearchTripsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)SEARCH_TRIPS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return TripServiceClient.SearchTripsPagedResponse.createAsync((PageContext<SearchTripsRequest, SearchTripsResponse, Trip>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateTripRequest, Trip> createTripSettings() {
        return this.createTripSettings;
    }

    public UnaryCallSettings<GetTripRequest, Trip> getTripSettings() {
        return this.getTripSettings;
    }

    public UnaryCallSettings<DeleteTripRequest, Empty> deleteTripSettings() {
        return this.deleteTripSettings;
    }

    public UnaryCallSettings<ReportBillableTripRequest, Empty> reportBillableTripSettings() {
        return this.reportBillableTripSettings;
    }

    public PagedCallSettings<SearchTripsRequest, SearchTripsResponse, TripServiceClient.SearchTripsPagedResponse> searchTripsSettings() {
        return this.searchTripsSettings;
    }

    public UnaryCallSettings<UpdateTripRequest, Trip> updateTripSettings() {
        return this.updateTripSettings;
    }

    public TripServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcTripServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "fleetengine";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "fleetengine.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "fleetengine.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return TripServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(TripServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected TripServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createTripSettings = settingsBuilder.createTripSettings().build();
        this.getTripSettings = settingsBuilder.getTripSettings().build();
        this.deleteTripSettings = settingsBuilder.deleteTripSettings().build();
        this.reportBillableTripSettings = settingsBuilder.reportBillableTripSettings().build();
        this.searchTripsSettings = settingsBuilder.searchTripsSettings().build();
        this.updateTripSettings = settingsBuilder.updateTripSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<TripServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateTripRequest, Trip> createTripSettings;
        private final UnaryCallSettings.Builder<GetTripRequest, Trip> getTripSettings;
        private final UnaryCallSettings.Builder<DeleteTripRequest, Empty> deleteTripSettings;
        private final UnaryCallSettings.Builder<ReportBillableTripRequest, Empty> reportBillableTripSettings;
        private final PagedCallSettings.Builder<SearchTripsRequest, SearchTripsResponse, TripServiceClient.SearchTripsPagedResponse> searchTripsSettings;
        private final UnaryCallSettings.Builder<UpdateTripRequest, Trip> updateTripSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createTripSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getTripSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteTripSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.reportBillableTripSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.searchTripsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)SEARCH_TRIPS_PAGE_STR_FACT);
            this.updateTripSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createTripSettings, this.getTripSettings, this.deleteTripSettings, this.reportBillableTripSettings, this.searchTripsSettings, this.updateTripSettings);
            Builder.initDefaults(this);
        }

        protected Builder(TripServiceStubSettings settings) {
            super((StubSettings)settings);
            this.createTripSettings = settings.createTripSettings.toBuilder();
            this.getTripSettings = settings.getTripSettings.toBuilder();
            this.deleteTripSettings = settings.deleteTripSettings.toBuilder();
            this.reportBillableTripSettings = settings.reportBillableTripSettings.toBuilder();
            this.searchTripsSettings = settings.searchTripsSettings.toBuilder();
            this.updateTripSettings = settings.updateTripSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createTripSettings, this.getTripSettings, this.deleteTripSettings, this.reportBillableTripSettings, this.searchTripsSettings, this.updateTripSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(TripServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)TripServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)TripServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(TripServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createTripSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getTripSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteTripSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.reportBillableTripSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.searchTripsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateTripSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateTripRequest, Trip> createTripSettings() {
            return this.createTripSettings;
        }

        public UnaryCallSettings.Builder<GetTripRequest, Trip> getTripSettings() {
            return this.getTripSettings;
        }

        public UnaryCallSettings.Builder<DeleteTripRequest, Empty> deleteTripSettings() {
            return this.deleteTripSettings;
        }

        public UnaryCallSettings.Builder<ReportBillableTripRequest, Empty> reportBillableTripSettings() {
            return this.reportBillableTripSettings;
        }

        public PagedCallSettings.Builder<SearchTripsRequest, SearchTripsResponse, TripServiceClient.SearchTripsPagedResponse> searchTripsSettings() {
            return this.searchTripsSettings;
        }

        public UnaryCallSettings.Builder<UpdateTripRequest, Trip> updateTripSettings() {
            return this.updateTripSettings;
        }

        public TripServiceStubSettings build() throws IOException {
            return new TripServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelayDuration(Duration.ofMillis(10000L)).setInitialRpcTimeoutDuration(Duration.ofMillis(15000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(15000L)).setTotalTimeoutDuration(Duration.ofMillis(15000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

