/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.routeoptimization.v1;

import com.google.maps.routeoptimization.v1.RouteOptimizationServiceProto;
import com.google.maps.routeoptimization.v1.Shipment;
import com.google.maps.routeoptimization.v1.ShipmentModelOrBuilder;
import com.google.maps.routeoptimization.v1.ShipmentOrBuilder;
import com.google.maps.routeoptimization.v1.ShipmentTypeIncompatibility;
import com.google.maps.routeoptimization.v1.ShipmentTypeIncompatibilityOrBuilder;
import com.google.maps.routeoptimization.v1.ShipmentTypeRequirement;
import com.google.maps.routeoptimization.v1.ShipmentTypeRequirementOrBuilder;
import com.google.maps.routeoptimization.v1.TransitionAttributes;
import com.google.maps.routeoptimization.v1.TransitionAttributesOrBuilder;
import com.google.maps.routeoptimization.v1.Vehicle;
import com.google.maps.routeoptimization.v1.VehicleOrBuilder;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Duration;
import com.google.protobuf.DurationOrBuilder;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessage;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.LazyStringArrayList;
import com.google.protobuf.LazyStringList;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.Parser;
import com.google.protobuf.ProtocolMessageEnum;
import com.google.protobuf.ProtocolStringList;
import com.google.protobuf.RepeatedFieldBuilder;
import com.google.protobuf.RuntimeVersion;
import com.google.protobuf.SingleFieldBuilder;
import com.google.protobuf.Timestamp;
import com.google.protobuf.TimestampOrBuilder;
import com.google.protobuf.UninitializedMessageException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class ShipmentModel
extends GeneratedMessage
implements ShipmentModelOrBuilder {
    private static final long serialVersionUID = 0L;
    private int bitField0_;
    public static final int SHIPMENTS_FIELD_NUMBER = 1;
    private List<Shipment> shipments_;
    public static final int VEHICLES_FIELD_NUMBER = 2;
    private List<Vehicle> vehicles_;
    public static final int OBJECTIVES_FIELD_NUMBER = 17;
    private List<Objective> objectives_;
    public static final int MAX_ACTIVE_VEHICLES_FIELD_NUMBER = 4;
    private int maxActiveVehicles_ = 0;
    public static final int GLOBAL_START_TIME_FIELD_NUMBER = 5;
    private Timestamp globalStartTime_;
    public static final int GLOBAL_END_TIME_FIELD_NUMBER = 6;
    private Timestamp globalEndTime_;
    public static final int GLOBAL_DURATION_COST_PER_HOUR_FIELD_NUMBER = 7;
    private double globalDurationCostPerHour_ = 0.0;
    public static final int DURATION_DISTANCE_MATRICES_FIELD_NUMBER = 8;
    private List<DurationDistanceMatrix> durationDistanceMatrices_;
    public static final int DURATION_DISTANCE_MATRIX_SRC_TAGS_FIELD_NUMBER = 9;
    private LazyStringArrayList durationDistanceMatrixSrcTags_ = LazyStringArrayList.emptyList();
    public static final int DURATION_DISTANCE_MATRIX_DST_TAGS_FIELD_NUMBER = 10;
    private LazyStringArrayList durationDistanceMatrixDstTags_ = LazyStringArrayList.emptyList();
    public static final int TRANSITION_ATTRIBUTES_FIELD_NUMBER = 11;
    private List<TransitionAttributes> transitionAttributes_;
    public static final int SHIPMENT_TYPE_INCOMPATIBILITIES_FIELD_NUMBER = 12;
    private List<ShipmentTypeIncompatibility> shipmentTypeIncompatibilities_;
    public static final int SHIPMENT_TYPE_REQUIREMENTS_FIELD_NUMBER = 13;
    private List<ShipmentTypeRequirement> shipmentTypeRequirements_;
    public static final int PRECEDENCE_RULES_FIELD_NUMBER = 14;
    private List<PrecedenceRule> precedenceRules_;
    private byte memoizedIsInitialized = (byte)-1;
    private static final ShipmentModel DEFAULT_INSTANCE;
    private static final Parser<ShipmentModel> PARSER;

    private ShipmentModel(GeneratedMessage.Builder<?> builder) {
        super(builder);
    }

    private ShipmentModel() {
        this.shipments_ = Collections.emptyList();
        this.vehicles_ = Collections.emptyList();
        this.objectives_ = Collections.emptyList();
        this.durationDistanceMatrices_ = Collections.emptyList();
        this.durationDistanceMatrixSrcTags_ = LazyStringArrayList.emptyList();
        this.durationDistanceMatrixDstTags_ = LazyStringArrayList.emptyList();
        this.transitionAttributes_ = Collections.emptyList();
        this.shipmentTypeIncompatibilities_ = Collections.emptyList();
        this.shipmentTypeRequirements_ = Collections.emptyList();
        this.precedenceRules_ = Collections.emptyList();
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return RouteOptimizationServiceProto.internal_static_google_maps_routeoptimization_v1_ShipmentModel_descriptor;
    }

    protected GeneratedMessage.FieldAccessorTable internalGetFieldAccessorTable() {
        return RouteOptimizationServiceProto.internal_static_google_maps_routeoptimization_v1_ShipmentModel_fieldAccessorTable.ensureFieldAccessorsInitialized(ShipmentModel.class, Builder.class);
    }

    @Override
    public List<Shipment> getShipmentsList() {
        return this.shipments_;
    }

    @Override
    public List<? extends ShipmentOrBuilder> getShipmentsOrBuilderList() {
        return this.shipments_;
    }

    @Override
    public int getShipmentsCount() {
        return this.shipments_.size();
    }

    @Override
    public Shipment getShipments(int index) {
        return this.shipments_.get(index);
    }

    @Override
    public ShipmentOrBuilder getShipmentsOrBuilder(int index) {
        return this.shipments_.get(index);
    }

    @Override
    public List<Vehicle> getVehiclesList() {
        return this.vehicles_;
    }

    @Override
    public List<? extends VehicleOrBuilder> getVehiclesOrBuilderList() {
        return this.vehicles_;
    }

    @Override
    public int getVehiclesCount() {
        return this.vehicles_.size();
    }

    @Override
    public Vehicle getVehicles(int index) {
        return this.vehicles_.get(index);
    }

    @Override
    public VehicleOrBuilder getVehiclesOrBuilder(int index) {
        return this.vehicles_.get(index);
    }

    @Override
    public List<Objective> getObjectivesList() {
        return this.objectives_;
    }

    @Override
    public List<? extends ObjectiveOrBuilder> getObjectivesOrBuilderList() {
        return this.objectives_;
    }

    @Override
    public int getObjectivesCount() {
        return this.objectives_.size();
    }

    @Override
    public Objective getObjectives(int index) {
        return this.objectives_.get(index);
    }

    @Override
    public ObjectiveOrBuilder getObjectivesOrBuilder(int index) {
        return this.objectives_.get(index);
    }

    @Override
    public boolean hasMaxActiveVehicles() {
        return (this.bitField0_ & 1) != 0;
    }

    @Override
    public int getMaxActiveVehicles() {
        return this.maxActiveVehicles_;
    }

    @Override
    public boolean hasGlobalStartTime() {
        return (this.bitField0_ & 2) != 0;
    }

    @Override
    public Timestamp getGlobalStartTime() {
        return this.globalStartTime_ == null ? Timestamp.getDefaultInstance() : this.globalStartTime_;
    }

    @Override
    public TimestampOrBuilder getGlobalStartTimeOrBuilder() {
        return this.globalStartTime_ == null ? Timestamp.getDefaultInstance() : this.globalStartTime_;
    }

    @Override
    public boolean hasGlobalEndTime() {
        return (this.bitField0_ & 4) != 0;
    }

    @Override
    public Timestamp getGlobalEndTime() {
        return this.globalEndTime_ == null ? Timestamp.getDefaultInstance() : this.globalEndTime_;
    }

    @Override
    public TimestampOrBuilder getGlobalEndTimeOrBuilder() {
        return this.globalEndTime_ == null ? Timestamp.getDefaultInstance() : this.globalEndTime_;
    }

    @Override
    public double getGlobalDurationCostPerHour() {
        return this.globalDurationCostPerHour_;
    }

    @Override
    public List<DurationDistanceMatrix> getDurationDistanceMatricesList() {
        return this.durationDistanceMatrices_;
    }

    @Override
    public List<? extends DurationDistanceMatrixOrBuilder> getDurationDistanceMatricesOrBuilderList() {
        return this.durationDistanceMatrices_;
    }

    @Override
    public int getDurationDistanceMatricesCount() {
        return this.durationDistanceMatrices_.size();
    }

    @Override
    public DurationDistanceMatrix getDurationDistanceMatrices(int index) {
        return this.durationDistanceMatrices_.get(index);
    }

    @Override
    public DurationDistanceMatrixOrBuilder getDurationDistanceMatricesOrBuilder(int index) {
        return this.durationDistanceMatrices_.get(index);
    }

    public ProtocolStringList getDurationDistanceMatrixSrcTagsList() {
        return this.durationDistanceMatrixSrcTags_;
    }

    @Override
    public int getDurationDistanceMatrixSrcTagsCount() {
        return this.durationDistanceMatrixSrcTags_.size();
    }

    @Override
    public String getDurationDistanceMatrixSrcTags(int index) {
        return this.durationDistanceMatrixSrcTags_.get(index);
    }

    @Override
    public ByteString getDurationDistanceMatrixSrcTagsBytes(int index) {
        return this.durationDistanceMatrixSrcTags_.getByteString(index);
    }

    public ProtocolStringList getDurationDistanceMatrixDstTagsList() {
        return this.durationDistanceMatrixDstTags_;
    }

    @Override
    public int getDurationDistanceMatrixDstTagsCount() {
        return this.durationDistanceMatrixDstTags_.size();
    }

    @Override
    public String getDurationDistanceMatrixDstTags(int index) {
        return this.durationDistanceMatrixDstTags_.get(index);
    }

    @Override
    public ByteString getDurationDistanceMatrixDstTagsBytes(int index) {
        return this.durationDistanceMatrixDstTags_.getByteString(index);
    }

    @Override
    public List<TransitionAttributes> getTransitionAttributesList() {
        return this.transitionAttributes_;
    }

    @Override
    public List<? extends TransitionAttributesOrBuilder> getTransitionAttributesOrBuilderList() {
        return this.transitionAttributes_;
    }

    @Override
    public int getTransitionAttributesCount() {
        return this.transitionAttributes_.size();
    }

    @Override
    public TransitionAttributes getTransitionAttributes(int index) {
        return this.transitionAttributes_.get(index);
    }

    @Override
    public TransitionAttributesOrBuilder getTransitionAttributesOrBuilder(int index) {
        return this.transitionAttributes_.get(index);
    }

    @Override
    public List<ShipmentTypeIncompatibility> getShipmentTypeIncompatibilitiesList() {
        return this.shipmentTypeIncompatibilities_;
    }

    @Override
    public List<? extends ShipmentTypeIncompatibilityOrBuilder> getShipmentTypeIncompatibilitiesOrBuilderList() {
        return this.shipmentTypeIncompatibilities_;
    }

    @Override
    public int getShipmentTypeIncompatibilitiesCount() {
        return this.shipmentTypeIncompatibilities_.size();
    }

    @Override
    public ShipmentTypeIncompatibility getShipmentTypeIncompatibilities(int index) {
        return this.shipmentTypeIncompatibilities_.get(index);
    }

    @Override
    public ShipmentTypeIncompatibilityOrBuilder getShipmentTypeIncompatibilitiesOrBuilder(int index) {
        return this.shipmentTypeIncompatibilities_.get(index);
    }

    @Override
    public List<ShipmentTypeRequirement> getShipmentTypeRequirementsList() {
        return this.shipmentTypeRequirements_;
    }

    @Override
    public List<? extends ShipmentTypeRequirementOrBuilder> getShipmentTypeRequirementsOrBuilderList() {
        return this.shipmentTypeRequirements_;
    }

    @Override
    public int getShipmentTypeRequirementsCount() {
        return this.shipmentTypeRequirements_.size();
    }

    @Override
    public ShipmentTypeRequirement getShipmentTypeRequirements(int index) {
        return this.shipmentTypeRequirements_.get(index);
    }

    @Override
    public ShipmentTypeRequirementOrBuilder getShipmentTypeRequirementsOrBuilder(int index) {
        return this.shipmentTypeRequirements_.get(index);
    }

    @Override
    public List<PrecedenceRule> getPrecedenceRulesList() {
        return this.precedenceRules_;
    }

    @Override
    public List<? extends PrecedenceRuleOrBuilder> getPrecedenceRulesOrBuilderList() {
        return this.precedenceRules_;
    }

    @Override
    public int getPrecedenceRulesCount() {
        return this.precedenceRules_.size();
    }

    @Override
    public PrecedenceRule getPrecedenceRules(int index) {
        return this.precedenceRules_.get(index);
    }

    @Override
    public PrecedenceRuleOrBuilder getPrecedenceRulesOrBuilder(int index) {
        return this.precedenceRules_.get(index);
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        int i;
        for (i = 0; i < this.shipments_.size(); ++i) {
            output.writeMessage(1, (MessageLite)this.shipments_.get(i));
        }
        for (i = 0; i < this.vehicles_.size(); ++i) {
            output.writeMessage(2, (MessageLite)this.vehicles_.get(i));
        }
        if ((this.bitField0_ & 1) != 0) {
            output.writeInt32(4, this.maxActiveVehicles_);
        }
        if ((this.bitField0_ & 2) != 0) {
            output.writeMessage(5, (MessageLite)this.getGlobalStartTime());
        }
        if ((this.bitField0_ & 4) != 0) {
            output.writeMessage(6, (MessageLite)this.getGlobalEndTime());
        }
        if (Double.doubleToRawLongBits(this.globalDurationCostPerHour_) != 0L) {
            output.writeDouble(7, this.globalDurationCostPerHour_);
        }
        for (i = 0; i < this.durationDistanceMatrices_.size(); ++i) {
            output.writeMessage(8, (MessageLite)this.durationDistanceMatrices_.get(i));
        }
        for (i = 0; i < this.durationDistanceMatrixSrcTags_.size(); ++i) {
            GeneratedMessage.writeString((CodedOutputStream)output, (int)9, (Object)this.durationDistanceMatrixSrcTags_.getRaw(i));
        }
        for (i = 0; i < this.durationDistanceMatrixDstTags_.size(); ++i) {
            GeneratedMessage.writeString((CodedOutputStream)output, (int)10, (Object)this.durationDistanceMatrixDstTags_.getRaw(i));
        }
        for (i = 0; i < this.transitionAttributes_.size(); ++i) {
            output.writeMessage(11, (MessageLite)this.transitionAttributes_.get(i));
        }
        for (i = 0; i < this.shipmentTypeIncompatibilities_.size(); ++i) {
            output.writeMessage(12, (MessageLite)this.shipmentTypeIncompatibilities_.get(i));
        }
        for (i = 0; i < this.shipmentTypeRequirements_.size(); ++i) {
            output.writeMessage(13, (MessageLite)this.shipmentTypeRequirements_.get(i));
        }
        for (i = 0; i < this.precedenceRules_.size(); ++i) {
            output.writeMessage(14, (MessageLite)this.precedenceRules_.get(i));
        }
        for (i = 0; i < this.objectives_.size(); ++i) {
            output.writeMessage(17, (MessageLite)this.objectives_.get(i));
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int i;
        int i2;
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        for (i2 = 0; i2 < this.shipments_.size(); ++i2) {
            size += CodedOutputStream.computeMessageSize((int)1, (MessageLite)((MessageLite)this.shipments_.get(i2)));
        }
        for (i2 = 0; i2 < this.vehicles_.size(); ++i2) {
            size += CodedOutputStream.computeMessageSize((int)2, (MessageLite)((MessageLite)this.vehicles_.get(i2)));
        }
        if ((this.bitField0_ & 1) != 0) {
            size += CodedOutputStream.computeInt32Size((int)4, (int)this.maxActiveVehicles_);
        }
        if ((this.bitField0_ & 2) != 0) {
            size += CodedOutputStream.computeMessageSize((int)5, (MessageLite)this.getGlobalStartTime());
        }
        if ((this.bitField0_ & 4) != 0) {
            size += CodedOutputStream.computeMessageSize((int)6, (MessageLite)this.getGlobalEndTime());
        }
        if (Double.doubleToRawLongBits(this.globalDurationCostPerHour_) != 0L) {
            size += CodedOutputStream.computeDoubleSize((int)7, (double)this.globalDurationCostPerHour_);
        }
        for (i2 = 0; i2 < this.durationDistanceMatrices_.size(); ++i2) {
            size += CodedOutputStream.computeMessageSize((int)8, (MessageLite)((MessageLite)this.durationDistanceMatrices_.get(i2)));
        }
        int dataSize = 0;
        for (i = 0; i < this.durationDistanceMatrixSrcTags_.size(); ++i) {
            dataSize += ShipmentModel.computeStringSizeNoTag((Object)this.durationDistanceMatrixSrcTags_.getRaw(i));
        }
        size += dataSize;
        size += 1 * this.getDurationDistanceMatrixSrcTagsList().size();
        dataSize = 0;
        for (i = 0; i < this.durationDistanceMatrixDstTags_.size(); ++i) {
            dataSize += ShipmentModel.computeStringSizeNoTag((Object)this.durationDistanceMatrixDstTags_.getRaw(i));
        }
        size += dataSize;
        size += 1 * this.getDurationDistanceMatrixDstTagsList().size();
        for (i2 = 0; i2 < this.transitionAttributes_.size(); ++i2) {
            size += CodedOutputStream.computeMessageSize((int)11, (MessageLite)((MessageLite)this.transitionAttributes_.get(i2)));
        }
        for (i2 = 0; i2 < this.shipmentTypeIncompatibilities_.size(); ++i2) {
            size += CodedOutputStream.computeMessageSize((int)12, (MessageLite)((MessageLite)this.shipmentTypeIncompatibilities_.get(i2)));
        }
        for (i2 = 0; i2 < this.shipmentTypeRequirements_.size(); ++i2) {
            size += CodedOutputStream.computeMessageSize((int)13, (MessageLite)((MessageLite)this.shipmentTypeRequirements_.get(i2)));
        }
        for (i2 = 0; i2 < this.precedenceRules_.size(); ++i2) {
            size += CodedOutputStream.computeMessageSize((int)14, (MessageLite)((MessageLite)this.precedenceRules_.get(i2)));
        }
        for (i2 = 0; i2 < this.objectives_.size(); ++i2) {
            size += CodedOutputStream.computeMessageSize((int)17, (MessageLite)((MessageLite)this.objectives_.get(i2)));
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ShipmentModel)) {
            return super.equals(obj);
        }
        ShipmentModel other = (ShipmentModel)obj;
        if (!this.getShipmentsList().equals(other.getShipmentsList())) {
            return false;
        }
        if (!this.getVehiclesList().equals(other.getVehiclesList())) {
            return false;
        }
        if (!this.getObjectivesList().equals(other.getObjectivesList())) {
            return false;
        }
        if (this.hasMaxActiveVehicles() != other.hasMaxActiveVehicles()) {
            return false;
        }
        if (this.hasMaxActiveVehicles() && this.getMaxActiveVehicles() != other.getMaxActiveVehicles()) {
            return false;
        }
        if (this.hasGlobalStartTime() != other.hasGlobalStartTime()) {
            return false;
        }
        if (this.hasGlobalStartTime() && !this.getGlobalStartTime().equals((Object)other.getGlobalStartTime())) {
            return false;
        }
        if (this.hasGlobalEndTime() != other.hasGlobalEndTime()) {
            return false;
        }
        if (this.hasGlobalEndTime() && !this.getGlobalEndTime().equals((Object)other.getGlobalEndTime())) {
            return false;
        }
        if (Double.doubleToLongBits(this.getGlobalDurationCostPerHour()) != Double.doubleToLongBits(other.getGlobalDurationCostPerHour())) {
            return false;
        }
        if (!this.getDurationDistanceMatricesList().equals(other.getDurationDistanceMatricesList())) {
            return false;
        }
        if (!this.getDurationDistanceMatrixSrcTagsList().equals(other.getDurationDistanceMatrixSrcTagsList())) {
            return false;
        }
        if (!this.getDurationDistanceMatrixDstTagsList().equals(other.getDurationDistanceMatrixDstTagsList())) {
            return false;
        }
        if (!this.getTransitionAttributesList().equals(other.getTransitionAttributesList())) {
            return false;
        }
        if (!this.getShipmentTypeIncompatibilitiesList().equals(other.getShipmentTypeIncompatibilitiesList())) {
            return false;
        }
        if (!this.getShipmentTypeRequirementsList().equals(other.getShipmentTypeRequirementsList())) {
            return false;
        }
        if (!this.getPrecedenceRulesList().equals(other.getPrecedenceRulesList())) {
            return false;
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + ShipmentModel.getDescriptor().hashCode();
        if (this.getShipmentsCount() > 0) {
            hash = 37 * hash + 1;
            hash = 53 * hash + this.getShipmentsList().hashCode();
        }
        if (this.getVehiclesCount() > 0) {
            hash = 37 * hash + 2;
            hash = 53 * hash + this.getVehiclesList().hashCode();
        }
        if (this.getObjectivesCount() > 0) {
            hash = 37 * hash + 17;
            hash = 53 * hash + this.getObjectivesList().hashCode();
        }
        if (this.hasMaxActiveVehicles()) {
            hash = 37 * hash + 4;
            hash = 53 * hash + this.getMaxActiveVehicles();
        }
        if (this.hasGlobalStartTime()) {
            hash = 37 * hash + 5;
            hash = 53 * hash + this.getGlobalStartTime().hashCode();
        }
        if (this.hasGlobalEndTime()) {
            hash = 37 * hash + 6;
            hash = 53 * hash + this.getGlobalEndTime().hashCode();
        }
        hash = 37 * hash + 7;
        hash = 53 * hash + Internal.hashLong((long)Double.doubleToLongBits(this.getGlobalDurationCostPerHour()));
        if (this.getDurationDistanceMatricesCount() > 0) {
            hash = 37 * hash + 8;
            hash = 53 * hash + this.getDurationDistanceMatricesList().hashCode();
        }
        if (this.getDurationDistanceMatrixSrcTagsCount() > 0) {
            hash = 37 * hash + 9;
            hash = 53 * hash + this.getDurationDistanceMatrixSrcTagsList().hashCode();
        }
        if (this.getDurationDistanceMatrixDstTagsCount() > 0) {
            hash = 37 * hash + 10;
            hash = 53 * hash + this.getDurationDistanceMatrixDstTagsList().hashCode();
        }
        if (this.getTransitionAttributesCount() > 0) {
            hash = 37 * hash + 11;
            hash = 53 * hash + this.getTransitionAttributesList().hashCode();
        }
        if (this.getShipmentTypeIncompatibilitiesCount() > 0) {
            hash = 37 * hash + 12;
            hash = 53 * hash + this.getShipmentTypeIncompatibilitiesList().hashCode();
        }
        if (this.getShipmentTypeRequirementsCount() > 0) {
            hash = 37 * hash + 13;
            hash = 53 * hash + this.getShipmentTypeRequirementsList().hashCode();
        }
        if (this.getPrecedenceRulesCount() > 0) {
            hash = 37 * hash + 14;
            hash = 53 * hash + this.getPrecedenceRulesList().hashCode();
        }
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static ShipmentModel parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (ShipmentModel)PARSER.parseFrom(data);
    }

    public static ShipmentModel parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (ShipmentModel)PARSER.parseFrom(data, extensionRegistry);
    }

    public static ShipmentModel parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (ShipmentModel)PARSER.parseFrom(data);
    }

    public static ShipmentModel parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (ShipmentModel)PARSER.parseFrom(data, extensionRegistry);
    }

    public static ShipmentModel parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (ShipmentModel)PARSER.parseFrom(data);
    }

    public static ShipmentModel parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (ShipmentModel)PARSER.parseFrom(data, extensionRegistry);
    }

    public static ShipmentModel parseFrom(InputStream input) throws IOException {
        return (ShipmentModel)GeneratedMessage.parseWithIOException(PARSER, (InputStream)input);
    }

    public static ShipmentModel parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (ShipmentModel)GeneratedMessage.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static ShipmentModel parseDelimitedFrom(InputStream input) throws IOException {
        return (ShipmentModel)GeneratedMessage.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static ShipmentModel parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (ShipmentModel)GeneratedMessage.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static ShipmentModel parseFrom(CodedInputStream input) throws IOException {
        return (ShipmentModel)GeneratedMessage.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static ShipmentModel parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (ShipmentModel)GeneratedMessage.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return ShipmentModel.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(ShipmentModel prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(AbstractMessage.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static ShipmentModel getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<ShipmentModel> parser() {
        return PARSER;
    }

    public Parser<ShipmentModel> getParserForType() {
        return PARSER;
    }

    public ShipmentModel getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    static {
        RuntimeVersion.validateProtobufGencodeVersion((RuntimeVersion.RuntimeDomain)RuntimeVersion.RuntimeDomain.PUBLIC, (int)4, (int)33, (int)0, (String)"", (String)"ShipmentModel");
        DEFAULT_INSTANCE = new ShipmentModel();
        PARSER = new AbstractParser<ShipmentModel>(){

            public ShipmentModel parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                Builder builder = ShipmentModel.newBuilder();
                try {
                    builder.mergeFrom(input, extensionRegistry);
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (UninitializedMessageException e) {
                    throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (IOException e) {
                    throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                return builder.buildPartial();
            }
        };
    }

    public static final class Builder
    extends GeneratedMessage.Builder<Builder>
    implements ShipmentModelOrBuilder {
        private int bitField0_;
        private List<Shipment> shipments_ = Collections.emptyList();
        private RepeatedFieldBuilder<Shipment, Shipment.Builder, ShipmentOrBuilder> shipmentsBuilder_;
        private List<Vehicle> vehicles_ = Collections.emptyList();
        private RepeatedFieldBuilder<Vehicle, Vehicle.Builder, VehicleOrBuilder> vehiclesBuilder_;
        private List<Objective> objectives_ = Collections.emptyList();
        private RepeatedFieldBuilder<Objective, Objective.Builder, ObjectiveOrBuilder> objectivesBuilder_;
        private int maxActiveVehicles_;
        private Timestamp globalStartTime_;
        private SingleFieldBuilder<Timestamp, Timestamp.Builder, TimestampOrBuilder> globalStartTimeBuilder_;
        private Timestamp globalEndTime_;
        private SingleFieldBuilder<Timestamp, Timestamp.Builder, TimestampOrBuilder> globalEndTimeBuilder_;
        private double globalDurationCostPerHour_;
        private List<DurationDistanceMatrix> durationDistanceMatrices_ = Collections.emptyList();
        private RepeatedFieldBuilder<DurationDistanceMatrix, DurationDistanceMatrix.Builder, DurationDistanceMatrixOrBuilder> durationDistanceMatricesBuilder_;
        private LazyStringArrayList durationDistanceMatrixSrcTags_ = LazyStringArrayList.emptyList();
        private LazyStringArrayList durationDistanceMatrixDstTags_ = LazyStringArrayList.emptyList();
        private List<TransitionAttributes> transitionAttributes_ = Collections.emptyList();
        private RepeatedFieldBuilder<TransitionAttributes, TransitionAttributes.Builder, TransitionAttributesOrBuilder> transitionAttributesBuilder_;
        private List<ShipmentTypeIncompatibility> shipmentTypeIncompatibilities_ = Collections.emptyList();
        private RepeatedFieldBuilder<ShipmentTypeIncompatibility, ShipmentTypeIncompatibility.Builder, ShipmentTypeIncompatibilityOrBuilder> shipmentTypeIncompatibilitiesBuilder_;
        private List<ShipmentTypeRequirement> shipmentTypeRequirements_ = Collections.emptyList();
        private RepeatedFieldBuilder<ShipmentTypeRequirement, ShipmentTypeRequirement.Builder, ShipmentTypeRequirementOrBuilder> shipmentTypeRequirementsBuilder_;
        private List<PrecedenceRule> precedenceRules_ = Collections.emptyList();
        private RepeatedFieldBuilder<PrecedenceRule, PrecedenceRule.Builder, PrecedenceRuleOrBuilder> precedenceRulesBuilder_;

        public static final Descriptors.Descriptor getDescriptor() {
            return RouteOptimizationServiceProto.internal_static_google_maps_routeoptimization_v1_ShipmentModel_descriptor;
        }

        protected GeneratedMessage.FieldAccessorTable internalGetFieldAccessorTable() {
            return RouteOptimizationServiceProto.internal_static_google_maps_routeoptimization_v1_ShipmentModel_fieldAccessorTable.ensureFieldAccessorsInitialized(ShipmentModel.class, Builder.class);
        }

        private Builder() {
            this.maybeForceBuilderInitialization();
        }

        private Builder(AbstractMessage.BuilderParent parent) {
            super(parent);
            this.maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
            if (alwaysUseFieldBuilders) {
                this.internalGetShipmentsFieldBuilder();
                this.internalGetVehiclesFieldBuilder();
                this.internalGetObjectivesFieldBuilder();
                this.internalGetGlobalStartTimeFieldBuilder();
                this.internalGetGlobalEndTimeFieldBuilder();
                this.internalGetDurationDistanceMatricesFieldBuilder();
                this.internalGetTransitionAttributesFieldBuilder();
                this.internalGetShipmentTypeIncompatibilitiesFieldBuilder();
                this.internalGetShipmentTypeRequirementsFieldBuilder();
                this.internalGetPrecedenceRulesFieldBuilder();
            }
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            if (this.shipmentsBuilder_ == null) {
                this.shipments_ = Collections.emptyList();
            } else {
                this.shipments_ = null;
                this.shipmentsBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFFFE;
            if (this.vehiclesBuilder_ == null) {
                this.vehicles_ = Collections.emptyList();
            } else {
                this.vehicles_ = null;
                this.vehiclesBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFFFD;
            if (this.objectivesBuilder_ == null) {
                this.objectives_ = Collections.emptyList();
            } else {
                this.objectives_ = null;
                this.objectivesBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFFFB;
            this.maxActiveVehicles_ = 0;
            this.globalStartTime_ = null;
            if (this.globalStartTimeBuilder_ != null) {
                this.globalStartTimeBuilder_.dispose();
                this.globalStartTimeBuilder_ = null;
            }
            this.globalEndTime_ = null;
            if (this.globalEndTimeBuilder_ != null) {
                this.globalEndTimeBuilder_.dispose();
                this.globalEndTimeBuilder_ = null;
            }
            this.globalDurationCostPerHour_ = 0.0;
            if (this.durationDistanceMatricesBuilder_ == null) {
                this.durationDistanceMatrices_ = Collections.emptyList();
            } else {
                this.durationDistanceMatrices_ = null;
                this.durationDistanceMatricesBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFF7F;
            this.durationDistanceMatrixSrcTags_ = LazyStringArrayList.emptyList();
            this.durationDistanceMatrixDstTags_ = LazyStringArrayList.emptyList();
            if (this.transitionAttributesBuilder_ == null) {
                this.transitionAttributes_ = Collections.emptyList();
            } else {
                this.transitionAttributes_ = null;
                this.transitionAttributesBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFBFF;
            if (this.shipmentTypeIncompatibilitiesBuilder_ == null) {
                this.shipmentTypeIncompatibilities_ = Collections.emptyList();
            } else {
                this.shipmentTypeIncompatibilities_ = null;
                this.shipmentTypeIncompatibilitiesBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFF7FF;
            if (this.shipmentTypeRequirementsBuilder_ == null) {
                this.shipmentTypeRequirements_ = Collections.emptyList();
            } else {
                this.shipmentTypeRequirements_ = null;
                this.shipmentTypeRequirementsBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFEFFF;
            if (this.precedenceRulesBuilder_ == null) {
                this.precedenceRules_ = Collections.emptyList();
            } else {
                this.precedenceRules_ = null;
                this.precedenceRulesBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFDFFF;
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return RouteOptimizationServiceProto.internal_static_google_maps_routeoptimization_v1_ShipmentModel_descriptor;
        }

        public ShipmentModel getDefaultInstanceForType() {
            return ShipmentModel.getDefaultInstance();
        }

        public ShipmentModel build() {
            ShipmentModel result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public ShipmentModel buildPartial() {
            ShipmentModel result = new ShipmentModel(this);
            this.buildPartialRepeatedFields(result);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.onBuilt();
            return result;
        }

        private void buildPartialRepeatedFields(ShipmentModel result) {
            if (this.shipmentsBuilder_ == null) {
                if ((this.bitField0_ & 1) != 0) {
                    this.shipments_ = Collections.unmodifiableList(this.shipments_);
                    this.bitField0_ &= 0xFFFFFFFE;
                }
                result.shipments_ = this.shipments_;
            } else {
                result.shipments_ = this.shipmentsBuilder_.build();
            }
            if (this.vehiclesBuilder_ == null) {
                if ((this.bitField0_ & 2) != 0) {
                    this.vehicles_ = Collections.unmodifiableList(this.vehicles_);
                    this.bitField0_ &= 0xFFFFFFFD;
                }
                result.vehicles_ = this.vehicles_;
            } else {
                result.vehicles_ = this.vehiclesBuilder_.build();
            }
            if (this.objectivesBuilder_ == null) {
                if ((this.bitField0_ & 4) != 0) {
                    this.objectives_ = Collections.unmodifiableList(this.objectives_);
                    this.bitField0_ &= 0xFFFFFFFB;
                }
                result.objectives_ = this.objectives_;
            } else {
                result.objectives_ = this.objectivesBuilder_.build();
            }
            if (this.durationDistanceMatricesBuilder_ == null) {
                if ((this.bitField0_ & 0x80) != 0) {
                    this.durationDistanceMatrices_ = Collections.unmodifiableList(this.durationDistanceMatrices_);
                    this.bitField0_ &= 0xFFFFFF7F;
                }
                result.durationDistanceMatrices_ = this.durationDistanceMatrices_;
            } else {
                result.durationDistanceMatrices_ = this.durationDistanceMatricesBuilder_.build();
            }
            if (this.transitionAttributesBuilder_ == null) {
                if ((this.bitField0_ & 0x400) != 0) {
                    this.transitionAttributes_ = Collections.unmodifiableList(this.transitionAttributes_);
                    this.bitField0_ &= 0xFFFFFBFF;
                }
                result.transitionAttributes_ = this.transitionAttributes_;
            } else {
                result.transitionAttributes_ = this.transitionAttributesBuilder_.build();
            }
            if (this.shipmentTypeIncompatibilitiesBuilder_ == null) {
                if ((this.bitField0_ & 0x800) != 0) {
                    this.shipmentTypeIncompatibilities_ = Collections.unmodifiableList(this.shipmentTypeIncompatibilities_);
                    this.bitField0_ &= 0xFFFFF7FF;
                }
                result.shipmentTypeIncompatibilities_ = this.shipmentTypeIncompatibilities_;
            } else {
                result.shipmentTypeIncompatibilities_ = this.shipmentTypeIncompatibilitiesBuilder_.build();
            }
            if (this.shipmentTypeRequirementsBuilder_ == null) {
                if ((this.bitField0_ & 0x1000) != 0) {
                    this.shipmentTypeRequirements_ = Collections.unmodifiableList(this.shipmentTypeRequirements_);
                    this.bitField0_ &= 0xFFFFEFFF;
                }
                result.shipmentTypeRequirements_ = this.shipmentTypeRequirements_;
            } else {
                result.shipmentTypeRequirements_ = this.shipmentTypeRequirementsBuilder_.build();
            }
            if (this.precedenceRulesBuilder_ == null) {
                if ((this.bitField0_ & 0x2000) != 0) {
                    this.precedenceRules_ = Collections.unmodifiableList(this.precedenceRules_);
                    this.bitField0_ &= 0xFFFFDFFF;
                }
                result.precedenceRules_ = this.precedenceRules_;
            } else {
                result.precedenceRules_ = this.precedenceRulesBuilder_.build();
            }
        }

        private void buildPartial0(ShipmentModel result) {
            int from_bitField0_ = this.bitField0_;
            int to_bitField0_ = 0;
            if ((from_bitField0_ & 8) != 0) {
                result.maxActiveVehicles_ = this.maxActiveVehicles_;
                to_bitField0_ |= 1;
            }
            if ((from_bitField0_ & 0x10) != 0) {
                result.globalStartTime_ = this.globalStartTimeBuilder_ == null ? this.globalStartTime_ : (Timestamp)this.globalStartTimeBuilder_.build();
                to_bitField0_ |= 2;
            }
            if ((from_bitField0_ & 0x20) != 0) {
                result.globalEndTime_ = this.globalEndTimeBuilder_ == null ? this.globalEndTime_ : (Timestamp)this.globalEndTimeBuilder_.build();
                to_bitField0_ |= 4;
            }
            if ((from_bitField0_ & 0x40) != 0) {
                result.globalDurationCostPerHour_ = this.globalDurationCostPerHour_;
            }
            if ((from_bitField0_ & 0x100) != 0) {
                this.durationDistanceMatrixSrcTags_.makeImmutable();
                result.durationDistanceMatrixSrcTags_ = this.durationDistanceMatrixSrcTags_;
            }
            if ((from_bitField0_ & 0x200) != 0) {
                this.durationDistanceMatrixDstTags_.makeImmutable();
                result.durationDistanceMatrixDstTags_ = this.durationDistanceMatrixDstTags_;
            }
            ShipmentModel shipmentModel = result;
            shipmentModel.bitField0_ = shipmentModel.bitField0_ | to_bitField0_;
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof ShipmentModel) {
                return this.mergeFrom((ShipmentModel)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(ShipmentModel other) {
            if (other == ShipmentModel.getDefaultInstance()) {
                return this;
            }
            if (this.shipmentsBuilder_ == null) {
                if (!other.shipments_.isEmpty()) {
                    if (this.shipments_.isEmpty()) {
                        this.shipments_ = other.shipments_;
                        this.bitField0_ &= 0xFFFFFFFE;
                    } else {
                        this.ensureShipmentsIsMutable();
                        this.shipments_.addAll(other.shipments_);
                    }
                    this.onChanged();
                }
            } else if (!other.shipments_.isEmpty()) {
                if (this.shipmentsBuilder_.isEmpty()) {
                    this.shipmentsBuilder_.dispose();
                    this.shipmentsBuilder_ = null;
                    this.shipments_ = other.shipments_;
                    this.bitField0_ &= 0xFFFFFFFE;
                    this.shipmentsBuilder_ = alwaysUseFieldBuilders ? this.internalGetShipmentsFieldBuilder() : null;
                } else {
                    this.shipmentsBuilder_.addAllMessages((Iterable)other.shipments_);
                }
            }
            if (this.vehiclesBuilder_ == null) {
                if (!other.vehicles_.isEmpty()) {
                    if (this.vehicles_.isEmpty()) {
                        this.vehicles_ = other.vehicles_;
                        this.bitField0_ &= 0xFFFFFFFD;
                    } else {
                        this.ensureVehiclesIsMutable();
                        this.vehicles_.addAll(other.vehicles_);
                    }
                    this.onChanged();
                }
            } else if (!other.vehicles_.isEmpty()) {
                if (this.vehiclesBuilder_.isEmpty()) {
                    this.vehiclesBuilder_.dispose();
                    this.vehiclesBuilder_ = null;
                    this.vehicles_ = other.vehicles_;
                    this.bitField0_ &= 0xFFFFFFFD;
                    this.vehiclesBuilder_ = alwaysUseFieldBuilders ? this.internalGetVehiclesFieldBuilder() : null;
                } else {
                    this.vehiclesBuilder_.addAllMessages((Iterable)other.vehicles_);
                }
            }
            if (this.objectivesBuilder_ == null) {
                if (!other.objectives_.isEmpty()) {
                    if (this.objectives_.isEmpty()) {
                        this.objectives_ = other.objectives_;
                        this.bitField0_ &= 0xFFFFFFFB;
                    } else {
                        this.ensureObjectivesIsMutable();
                        this.objectives_.addAll(other.objectives_);
                    }
                    this.onChanged();
                }
            } else if (!other.objectives_.isEmpty()) {
                if (this.objectivesBuilder_.isEmpty()) {
                    this.objectivesBuilder_.dispose();
                    this.objectivesBuilder_ = null;
                    this.objectives_ = other.objectives_;
                    this.bitField0_ &= 0xFFFFFFFB;
                    this.objectivesBuilder_ = alwaysUseFieldBuilders ? this.internalGetObjectivesFieldBuilder() : null;
                } else {
                    this.objectivesBuilder_.addAllMessages((Iterable)other.objectives_);
                }
            }
            if (other.hasMaxActiveVehicles()) {
                this.setMaxActiveVehicles(other.getMaxActiveVehicles());
            }
            if (other.hasGlobalStartTime()) {
                this.mergeGlobalStartTime(other.getGlobalStartTime());
            }
            if (other.hasGlobalEndTime()) {
                this.mergeGlobalEndTime(other.getGlobalEndTime());
            }
            if (Double.doubleToRawLongBits(other.getGlobalDurationCostPerHour()) != 0L) {
                this.setGlobalDurationCostPerHour(other.getGlobalDurationCostPerHour());
            }
            if (this.durationDistanceMatricesBuilder_ == null) {
                if (!other.durationDistanceMatrices_.isEmpty()) {
                    if (this.durationDistanceMatrices_.isEmpty()) {
                        this.durationDistanceMatrices_ = other.durationDistanceMatrices_;
                        this.bitField0_ &= 0xFFFFFF7F;
                    } else {
                        this.ensureDurationDistanceMatricesIsMutable();
                        this.durationDistanceMatrices_.addAll(other.durationDistanceMatrices_);
                    }
                    this.onChanged();
                }
            } else if (!other.durationDistanceMatrices_.isEmpty()) {
                if (this.durationDistanceMatricesBuilder_.isEmpty()) {
                    this.durationDistanceMatricesBuilder_.dispose();
                    this.durationDistanceMatricesBuilder_ = null;
                    this.durationDistanceMatrices_ = other.durationDistanceMatrices_;
                    this.bitField0_ &= 0xFFFFFF7F;
                    this.durationDistanceMatricesBuilder_ = alwaysUseFieldBuilders ? this.internalGetDurationDistanceMatricesFieldBuilder() : null;
                } else {
                    this.durationDistanceMatricesBuilder_.addAllMessages((Iterable)other.durationDistanceMatrices_);
                }
            }
            if (!other.durationDistanceMatrixSrcTags_.isEmpty()) {
                if (this.durationDistanceMatrixSrcTags_.isEmpty()) {
                    this.durationDistanceMatrixSrcTags_ = other.durationDistanceMatrixSrcTags_;
                    this.bitField0_ |= 0x100;
                } else {
                    this.ensureDurationDistanceMatrixSrcTagsIsMutable();
                    this.durationDistanceMatrixSrcTags_.addAll((Collection)other.durationDistanceMatrixSrcTags_);
                }
                this.onChanged();
            }
            if (!other.durationDistanceMatrixDstTags_.isEmpty()) {
                if (this.durationDistanceMatrixDstTags_.isEmpty()) {
                    this.durationDistanceMatrixDstTags_ = other.durationDistanceMatrixDstTags_;
                    this.bitField0_ |= 0x200;
                } else {
                    this.ensureDurationDistanceMatrixDstTagsIsMutable();
                    this.durationDistanceMatrixDstTags_.addAll((Collection)other.durationDistanceMatrixDstTags_);
                }
                this.onChanged();
            }
            if (this.transitionAttributesBuilder_ == null) {
                if (!other.transitionAttributes_.isEmpty()) {
                    if (this.transitionAttributes_.isEmpty()) {
                        this.transitionAttributes_ = other.transitionAttributes_;
                        this.bitField0_ &= 0xFFFFFBFF;
                    } else {
                        this.ensureTransitionAttributesIsMutable();
                        this.transitionAttributes_.addAll(other.transitionAttributes_);
                    }
                    this.onChanged();
                }
            } else if (!other.transitionAttributes_.isEmpty()) {
                if (this.transitionAttributesBuilder_.isEmpty()) {
                    this.transitionAttributesBuilder_.dispose();
                    this.transitionAttributesBuilder_ = null;
                    this.transitionAttributes_ = other.transitionAttributes_;
                    this.bitField0_ &= 0xFFFFFBFF;
                    this.transitionAttributesBuilder_ = alwaysUseFieldBuilders ? this.internalGetTransitionAttributesFieldBuilder() : null;
                } else {
                    this.transitionAttributesBuilder_.addAllMessages((Iterable)other.transitionAttributes_);
                }
            }
            if (this.shipmentTypeIncompatibilitiesBuilder_ == null) {
                if (!other.shipmentTypeIncompatibilities_.isEmpty()) {
                    if (this.shipmentTypeIncompatibilities_.isEmpty()) {
                        this.shipmentTypeIncompatibilities_ = other.shipmentTypeIncompatibilities_;
                        this.bitField0_ &= 0xFFFFF7FF;
                    } else {
                        this.ensureShipmentTypeIncompatibilitiesIsMutable();
                        this.shipmentTypeIncompatibilities_.addAll(other.shipmentTypeIncompatibilities_);
                    }
                    this.onChanged();
                }
            } else if (!other.shipmentTypeIncompatibilities_.isEmpty()) {
                if (this.shipmentTypeIncompatibilitiesBuilder_.isEmpty()) {
                    this.shipmentTypeIncompatibilitiesBuilder_.dispose();
                    this.shipmentTypeIncompatibilitiesBuilder_ = null;
                    this.shipmentTypeIncompatibilities_ = other.shipmentTypeIncompatibilities_;
                    this.bitField0_ &= 0xFFFFF7FF;
                    this.shipmentTypeIncompatibilitiesBuilder_ = alwaysUseFieldBuilders ? this.internalGetShipmentTypeIncompatibilitiesFieldBuilder() : null;
                } else {
                    this.shipmentTypeIncompatibilitiesBuilder_.addAllMessages((Iterable)other.shipmentTypeIncompatibilities_);
                }
            }
            if (this.shipmentTypeRequirementsBuilder_ == null) {
                if (!other.shipmentTypeRequirements_.isEmpty()) {
                    if (this.shipmentTypeRequirements_.isEmpty()) {
                        this.shipmentTypeRequirements_ = other.shipmentTypeRequirements_;
                        this.bitField0_ &= 0xFFFFEFFF;
                    } else {
                        this.ensureShipmentTypeRequirementsIsMutable();
                        this.shipmentTypeRequirements_.addAll(other.shipmentTypeRequirements_);
                    }
                    this.onChanged();
                }
            } else if (!other.shipmentTypeRequirements_.isEmpty()) {
                if (this.shipmentTypeRequirementsBuilder_.isEmpty()) {
                    this.shipmentTypeRequirementsBuilder_.dispose();
                    this.shipmentTypeRequirementsBuilder_ = null;
                    this.shipmentTypeRequirements_ = other.shipmentTypeRequirements_;
                    this.bitField0_ &= 0xFFFFEFFF;
                    this.shipmentTypeRequirementsBuilder_ = alwaysUseFieldBuilders ? this.internalGetShipmentTypeRequirementsFieldBuilder() : null;
                } else {
                    this.shipmentTypeRequirementsBuilder_.addAllMessages((Iterable)other.shipmentTypeRequirements_);
                }
            }
            if (this.precedenceRulesBuilder_ == null) {
                if (!other.precedenceRules_.isEmpty()) {
                    if (this.precedenceRules_.isEmpty()) {
                        this.precedenceRules_ = other.precedenceRules_;
                        this.bitField0_ &= 0xFFFFDFFF;
                    } else {
                        this.ensurePrecedenceRulesIsMutable();
                        this.precedenceRules_.addAll(other.precedenceRules_);
                    }
                    this.onChanged();
                }
            } else if (!other.precedenceRules_.isEmpty()) {
                if (this.precedenceRulesBuilder_.isEmpty()) {
                    this.precedenceRulesBuilder_.dispose();
                    this.precedenceRulesBuilder_ = null;
                    this.precedenceRules_ = other.precedenceRules_;
                    this.bitField0_ &= 0xFFFFDFFF;
                    this.precedenceRulesBuilder_ = alwaysUseFieldBuilders ? this.internalGetPrecedenceRulesFieldBuilder() : null;
                } else {
                    this.precedenceRulesBuilder_.addAllMessages((Iterable)other.precedenceRules_);
                }
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block22: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block22;
                        }
                        case 10: {
                            GeneratedMessage m = (Shipment)input.readMessage(Shipment.parser(), extensionRegistry);
                            if (this.shipmentsBuilder_ == null) {
                                this.ensureShipmentsIsMutable();
                                this.shipments_.add((Shipment)m);
                                continue block22;
                            }
                            this.shipmentsBuilder_.addMessage(m);
                            continue block22;
                        }
                        case 18: {
                            GeneratedMessage m = (Vehicle)input.readMessage(Vehicle.parser(), extensionRegistry);
                            if (this.vehiclesBuilder_ == null) {
                                this.ensureVehiclesIsMutable();
                                this.vehicles_.add((Vehicle)m);
                                continue block22;
                            }
                            this.vehiclesBuilder_.addMessage(m);
                            continue block22;
                        }
                        case 32: {
                            this.maxActiveVehicles_ = input.readInt32();
                            this.bitField0_ |= 8;
                            continue block22;
                        }
                        case 42: {
                            input.readMessage((MessageLite.Builder)this.internalGetGlobalStartTimeFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x10;
                            continue block22;
                        }
                        case 50: {
                            input.readMessage((MessageLite.Builder)this.internalGetGlobalEndTimeFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x20;
                            continue block22;
                        }
                        case 57: {
                            this.globalDurationCostPerHour_ = input.readDouble();
                            this.bitField0_ |= 0x40;
                            continue block22;
                        }
                        case 66: {
                            GeneratedMessage m = (DurationDistanceMatrix)input.readMessage(DurationDistanceMatrix.parser(), extensionRegistry);
                            if (this.durationDistanceMatricesBuilder_ == null) {
                                this.ensureDurationDistanceMatricesIsMutable();
                                this.durationDistanceMatrices_.add((DurationDistanceMatrix)m);
                                continue block22;
                            }
                            this.durationDistanceMatricesBuilder_.addMessage(m);
                            continue block22;
                        }
                        case 74: {
                            String s = input.readStringRequireUtf8();
                            this.ensureDurationDistanceMatrixSrcTagsIsMutable();
                            this.durationDistanceMatrixSrcTags_.add(s);
                            continue block22;
                        }
                        case 82: {
                            String s = input.readStringRequireUtf8();
                            this.ensureDurationDistanceMatrixDstTagsIsMutable();
                            this.durationDistanceMatrixDstTags_.add(s);
                            continue block22;
                        }
                        case 90: {
                            GeneratedMessage m = (TransitionAttributes)input.readMessage(TransitionAttributes.parser(), extensionRegistry);
                            if (this.transitionAttributesBuilder_ == null) {
                                this.ensureTransitionAttributesIsMutable();
                                this.transitionAttributes_.add((TransitionAttributes)m);
                                continue block22;
                            }
                            this.transitionAttributesBuilder_.addMessage(m);
                            continue block22;
                        }
                        case 98: {
                            GeneratedMessage m = (ShipmentTypeIncompatibility)input.readMessage(ShipmentTypeIncompatibility.parser(), extensionRegistry);
                            if (this.shipmentTypeIncompatibilitiesBuilder_ == null) {
                                this.ensureShipmentTypeIncompatibilitiesIsMutable();
                                this.shipmentTypeIncompatibilities_.add((ShipmentTypeIncompatibility)m);
                                continue block22;
                            }
                            this.shipmentTypeIncompatibilitiesBuilder_.addMessage(m);
                            continue block22;
                        }
                        case 106: {
                            GeneratedMessage m = (ShipmentTypeRequirement)input.readMessage(ShipmentTypeRequirement.parser(), extensionRegistry);
                            if (this.shipmentTypeRequirementsBuilder_ == null) {
                                this.ensureShipmentTypeRequirementsIsMutable();
                                this.shipmentTypeRequirements_.add((ShipmentTypeRequirement)m);
                                continue block22;
                            }
                            this.shipmentTypeRequirementsBuilder_.addMessage(m);
                            continue block22;
                        }
                        case 114: {
                            GeneratedMessage m = (PrecedenceRule)input.readMessage(PrecedenceRule.parser(), extensionRegistry);
                            if (this.precedenceRulesBuilder_ == null) {
                                this.ensurePrecedenceRulesIsMutable();
                                this.precedenceRules_.add((PrecedenceRule)m);
                                continue block22;
                            }
                            this.precedenceRulesBuilder_.addMessage(m);
                            continue block22;
                        }
                        case 138: {
                            GeneratedMessage m = (Objective)input.readMessage(Objective.parser(), extensionRegistry);
                            if (this.objectivesBuilder_ == null) {
                                this.ensureObjectivesIsMutable();
                                this.objectives_.add((Objective)m);
                                continue block22;
                            }
                            this.objectivesBuilder_.addMessage(m);
                            continue block22;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        private void ensureShipmentsIsMutable() {
            if ((this.bitField0_ & 1) == 0) {
                this.shipments_ = new ArrayList<Shipment>(this.shipments_);
                this.bitField0_ |= 1;
            }
        }

        @Override
        public List<Shipment> getShipmentsList() {
            if (this.shipmentsBuilder_ == null) {
                return Collections.unmodifiableList(this.shipments_);
            }
            return this.shipmentsBuilder_.getMessageList();
        }

        @Override
        public int getShipmentsCount() {
            if (this.shipmentsBuilder_ == null) {
                return this.shipments_.size();
            }
            return this.shipmentsBuilder_.getCount();
        }

        @Override
        public Shipment getShipments(int index) {
            if (this.shipmentsBuilder_ == null) {
                return this.shipments_.get(index);
            }
            return (Shipment)this.shipmentsBuilder_.getMessage(index);
        }

        public Builder setShipments(int index, Shipment value) {
            if (this.shipmentsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureShipmentsIsMutable();
                this.shipments_.set(index, value);
                this.onChanged();
            } else {
                this.shipmentsBuilder_.setMessage(index, (GeneratedMessage)value);
            }
            return this;
        }

        public Builder setShipments(int index, Shipment.Builder builderForValue) {
            if (this.shipmentsBuilder_ == null) {
                this.ensureShipmentsIsMutable();
                this.shipments_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.shipmentsBuilder_.setMessage(index, (GeneratedMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addShipments(Shipment value) {
            if (this.shipmentsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureShipmentsIsMutable();
                this.shipments_.add(value);
                this.onChanged();
            } else {
                this.shipmentsBuilder_.addMessage((GeneratedMessage)value);
            }
            return this;
        }

        public Builder addShipments(int index, Shipment value) {
            if (this.shipmentsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureShipmentsIsMutable();
                this.shipments_.add(index, value);
                this.onChanged();
            } else {
                this.shipmentsBuilder_.addMessage(index, (GeneratedMessage)value);
            }
            return this;
        }

        public Builder addShipments(Shipment.Builder builderForValue) {
            if (this.shipmentsBuilder_ == null) {
                this.ensureShipmentsIsMutable();
                this.shipments_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.shipmentsBuilder_.addMessage((GeneratedMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addShipments(int index, Shipment.Builder builderForValue) {
            if (this.shipmentsBuilder_ == null) {
                this.ensureShipmentsIsMutable();
                this.shipments_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.shipmentsBuilder_.addMessage(index, (GeneratedMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllShipments(Iterable<? extends Shipment> values) {
            if (this.shipmentsBuilder_ == null) {
                this.ensureShipmentsIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.shipments_);
                this.onChanged();
            } else {
                this.shipmentsBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearShipments() {
            if (this.shipmentsBuilder_ == null) {
                this.shipments_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFFE;
                this.onChanged();
            } else {
                this.shipmentsBuilder_.clear();
            }
            return this;
        }

        public Builder removeShipments(int index) {
            if (this.shipmentsBuilder_ == null) {
                this.ensureShipmentsIsMutable();
                this.shipments_.remove(index);
                this.onChanged();
            } else {
                this.shipmentsBuilder_.remove(index);
            }
            return this;
        }

        public Shipment.Builder getShipmentsBuilder(int index) {
            return (Shipment.Builder)this.internalGetShipmentsFieldBuilder().getBuilder(index);
        }

        @Override
        public ShipmentOrBuilder getShipmentsOrBuilder(int index) {
            if (this.shipmentsBuilder_ == null) {
                return this.shipments_.get(index);
            }
            return (ShipmentOrBuilder)this.shipmentsBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends ShipmentOrBuilder> getShipmentsOrBuilderList() {
            if (this.shipmentsBuilder_ != null) {
                return this.shipmentsBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.shipments_);
        }

        public Shipment.Builder addShipmentsBuilder() {
            return (Shipment.Builder)this.internalGetShipmentsFieldBuilder().addBuilder((GeneratedMessage)Shipment.getDefaultInstance());
        }

        public Shipment.Builder addShipmentsBuilder(int index) {
            return (Shipment.Builder)this.internalGetShipmentsFieldBuilder().addBuilder(index, (GeneratedMessage)Shipment.getDefaultInstance());
        }

        public List<Shipment.Builder> getShipmentsBuilderList() {
            return this.internalGetShipmentsFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilder<Shipment, Shipment.Builder, ShipmentOrBuilder> internalGetShipmentsFieldBuilder() {
            if (this.shipmentsBuilder_ == null) {
                this.shipmentsBuilder_ = new RepeatedFieldBuilder(this.shipments_, (this.bitField0_ & 1) != 0, this.getParentForChildren(), this.isClean());
                this.shipments_ = null;
            }
            return this.shipmentsBuilder_;
        }

        private void ensureVehiclesIsMutable() {
            if ((this.bitField0_ & 2) == 0) {
                this.vehicles_ = new ArrayList<Vehicle>(this.vehicles_);
                this.bitField0_ |= 2;
            }
        }

        @Override
        public List<Vehicle> getVehiclesList() {
            if (this.vehiclesBuilder_ == null) {
                return Collections.unmodifiableList(this.vehicles_);
            }
            return this.vehiclesBuilder_.getMessageList();
        }

        @Override
        public int getVehiclesCount() {
            if (this.vehiclesBuilder_ == null) {
                return this.vehicles_.size();
            }
            return this.vehiclesBuilder_.getCount();
        }

        @Override
        public Vehicle getVehicles(int index) {
            if (this.vehiclesBuilder_ == null) {
                return this.vehicles_.get(index);
            }
            return (Vehicle)this.vehiclesBuilder_.getMessage(index);
        }

        public Builder setVehicles(int index, Vehicle value) {
            if (this.vehiclesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureVehiclesIsMutable();
                this.vehicles_.set(index, value);
                this.onChanged();
            } else {
                this.vehiclesBuilder_.setMessage(index, (GeneratedMessage)value);
            }
            return this;
        }

        public Builder setVehicles(int index, Vehicle.Builder builderForValue) {
            if (this.vehiclesBuilder_ == null) {
                this.ensureVehiclesIsMutable();
                this.vehicles_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.vehiclesBuilder_.setMessage(index, (GeneratedMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addVehicles(Vehicle value) {
            if (this.vehiclesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureVehiclesIsMutable();
                this.vehicles_.add(value);
                this.onChanged();
            } else {
                this.vehiclesBuilder_.addMessage((GeneratedMessage)value);
            }
            return this;
        }

        public Builder addVehicles(int index, Vehicle value) {
            if (this.vehiclesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureVehiclesIsMutable();
                this.vehicles_.add(index, value);
                this.onChanged();
            } else {
                this.vehiclesBuilder_.addMessage(index, (GeneratedMessage)value);
            }
            return this;
        }

        public Builder addVehicles(Vehicle.Builder builderForValue) {
            if (this.vehiclesBuilder_ == null) {
                this.ensureVehiclesIsMutable();
                this.vehicles_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.vehiclesBuilder_.addMessage((GeneratedMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addVehicles(int index, Vehicle.Builder builderForValue) {
            if (this.vehiclesBuilder_ == null) {
                this.ensureVehiclesIsMutable();
                this.vehicles_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.vehiclesBuilder_.addMessage(index, (GeneratedMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllVehicles(Iterable<? extends Vehicle> values) {
            if (this.vehiclesBuilder_ == null) {
                this.ensureVehiclesIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.vehicles_);
                this.onChanged();
            } else {
                this.vehiclesBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearVehicles() {
            if (this.vehiclesBuilder_ == null) {
                this.vehicles_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFFD;
                this.onChanged();
            } else {
                this.vehiclesBuilder_.clear();
            }
            return this;
        }

        public Builder removeVehicles(int index) {
            if (this.vehiclesBuilder_ == null) {
                this.ensureVehiclesIsMutable();
                this.vehicles_.remove(index);
                this.onChanged();
            } else {
                this.vehiclesBuilder_.remove(index);
            }
            return this;
        }

        public Vehicle.Builder getVehiclesBuilder(int index) {
            return (Vehicle.Builder)this.internalGetVehiclesFieldBuilder().getBuilder(index);
        }

        @Override
        public VehicleOrBuilder getVehiclesOrBuilder(int index) {
            if (this.vehiclesBuilder_ == null) {
                return this.vehicles_.get(index);
            }
            return (VehicleOrBuilder)this.vehiclesBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends VehicleOrBuilder> getVehiclesOrBuilderList() {
            if (this.vehiclesBuilder_ != null) {
                return this.vehiclesBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.vehicles_);
        }

        public Vehicle.Builder addVehiclesBuilder() {
            return (Vehicle.Builder)this.internalGetVehiclesFieldBuilder().addBuilder((GeneratedMessage)Vehicle.getDefaultInstance());
        }

        public Vehicle.Builder addVehiclesBuilder(int index) {
            return (Vehicle.Builder)this.internalGetVehiclesFieldBuilder().addBuilder(index, (GeneratedMessage)Vehicle.getDefaultInstance());
        }

        public List<Vehicle.Builder> getVehiclesBuilderList() {
            return this.internalGetVehiclesFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilder<Vehicle, Vehicle.Builder, VehicleOrBuilder> internalGetVehiclesFieldBuilder() {
            if (this.vehiclesBuilder_ == null) {
                this.vehiclesBuilder_ = new RepeatedFieldBuilder(this.vehicles_, (this.bitField0_ & 2) != 0, this.getParentForChildren(), this.isClean());
                this.vehicles_ = null;
            }
            return this.vehiclesBuilder_;
        }

        private void ensureObjectivesIsMutable() {
            if ((this.bitField0_ & 4) == 0) {
                this.objectives_ = new ArrayList<Objective>(this.objectives_);
                this.bitField0_ |= 4;
            }
        }

        @Override
        public List<Objective> getObjectivesList() {
            if (this.objectivesBuilder_ == null) {
                return Collections.unmodifiableList(this.objectives_);
            }
            return this.objectivesBuilder_.getMessageList();
        }

        @Override
        public int getObjectivesCount() {
            if (this.objectivesBuilder_ == null) {
                return this.objectives_.size();
            }
            return this.objectivesBuilder_.getCount();
        }

        @Override
        public Objective getObjectives(int index) {
            if (this.objectivesBuilder_ == null) {
                return this.objectives_.get(index);
            }
            return (Objective)this.objectivesBuilder_.getMessage(index);
        }

        public Builder setObjectives(int index, Objective value) {
            if (this.objectivesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureObjectivesIsMutable();
                this.objectives_.set(index, value);
                this.onChanged();
            } else {
                this.objectivesBuilder_.setMessage(index, (GeneratedMessage)value);
            }
            return this;
        }

        public Builder setObjectives(int index, Objective.Builder builderForValue) {
            if (this.objectivesBuilder_ == null) {
                this.ensureObjectivesIsMutable();
                this.objectives_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.objectivesBuilder_.setMessage(index, (GeneratedMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addObjectives(Objective value) {
            if (this.objectivesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureObjectivesIsMutable();
                this.objectives_.add(value);
                this.onChanged();
            } else {
                this.objectivesBuilder_.addMessage((GeneratedMessage)value);
            }
            return this;
        }

        public Builder addObjectives(int index, Objective value) {
            if (this.objectivesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureObjectivesIsMutable();
                this.objectives_.add(index, value);
                this.onChanged();
            } else {
                this.objectivesBuilder_.addMessage(index, (GeneratedMessage)value);
            }
            return this;
        }

        public Builder addObjectives(Objective.Builder builderForValue) {
            if (this.objectivesBuilder_ == null) {
                this.ensureObjectivesIsMutable();
                this.objectives_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.objectivesBuilder_.addMessage((GeneratedMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addObjectives(int index, Objective.Builder builderForValue) {
            if (this.objectivesBuilder_ == null) {
                this.ensureObjectivesIsMutable();
                this.objectives_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.objectivesBuilder_.addMessage(index, (GeneratedMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllObjectives(Iterable<? extends Objective> values) {
            if (this.objectivesBuilder_ == null) {
                this.ensureObjectivesIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.objectives_);
                this.onChanged();
            } else {
                this.objectivesBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearObjectives() {
            if (this.objectivesBuilder_ == null) {
                this.objectives_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFFB;
                this.onChanged();
            } else {
                this.objectivesBuilder_.clear();
            }
            return this;
        }

        public Builder removeObjectives(int index) {
            if (this.objectivesBuilder_ == null) {
                this.ensureObjectivesIsMutable();
                this.objectives_.remove(index);
                this.onChanged();
            } else {
                this.objectivesBuilder_.remove(index);
            }
            return this;
        }

        public Objective.Builder getObjectivesBuilder(int index) {
            return (Objective.Builder)this.internalGetObjectivesFieldBuilder().getBuilder(index);
        }

        @Override
        public ObjectiveOrBuilder getObjectivesOrBuilder(int index) {
            if (this.objectivesBuilder_ == null) {
                return this.objectives_.get(index);
            }
            return (ObjectiveOrBuilder)this.objectivesBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends ObjectiveOrBuilder> getObjectivesOrBuilderList() {
            if (this.objectivesBuilder_ != null) {
                return this.objectivesBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.objectives_);
        }

        public Objective.Builder addObjectivesBuilder() {
            return (Objective.Builder)this.internalGetObjectivesFieldBuilder().addBuilder((GeneratedMessage)Objective.getDefaultInstance());
        }

        public Objective.Builder addObjectivesBuilder(int index) {
            return (Objective.Builder)this.internalGetObjectivesFieldBuilder().addBuilder(index, (GeneratedMessage)Objective.getDefaultInstance());
        }

        public List<Objective.Builder> getObjectivesBuilderList() {
            return this.internalGetObjectivesFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilder<Objective, Objective.Builder, ObjectiveOrBuilder> internalGetObjectivesFieldBuilder() {
            if (this.objectivesBuilder_ == null) {
                this.objectivesBuilder_ = new RepeatedFieldBuilder(this.objectives_, (this.bitField0_ & 4) != 0, this.getParentForChildren(), this.isClean());
                this.objectives_ = null;
            }
            return this.objectivesBuilder_;
        }

        @Override
        public boolean hasMaxActiveVehicles() {
            return (this.bitField0_ & 8) != 0;
        }

        @Override
        public int getMaxActiveVehicles() {
            return this.maxActiveVehicles_;
        }

        public Builder setMaxActiveVehicles(int value) {
            this.maxActiveVehicles_ = value;
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        public Builder clearMaxActiveVehicles() {
            this.bitField0_ &= 0xFFFFFFF7;
            this.maxActiveVehicles_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasGlobalStartTime() {
            return (this.bitField0_ & 0x10) != 0;
        }

        @Override
        public Timestamp getGlobalStartTime() {
            if (this.globalStartTimeBuilder_ == null) {
                return this.globalStartTime_ == null ? Timestamp.getDefaultInstance() : this.globalStartTime_;
            }
            return (Timestamp)this.globalStartTimeBuilder_.getMessage();
        }

        public Builder setGlobalStartTime(Timestamp value) {
            if (this.globalStartTimeBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.globalStartTime_ = value;
            } else {
                this.globalStartTimeBuilder_.setMessage((GeneratedMessage)value);
            }
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder setGlobalStartTime(Timestamp.Builder builderForValue) {
            if (this.globalStartTimeBuilder_ == null) {
                this.globalStartTime_ = builderForValue.build();
            } else {
                this.globalStartTimeBuilder_.setMessage((GeneratedMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder mergeGlobalStartTime(Timestamp value) {
            if (this.globalStartTimeBuilder_ == null) {
                if ((this.bitField0_ & 0x10) != 0 && this.globalStartTime_ != null && this.globalStartTime_ != Timestamp.getDefaultInstance()) {
                    this.getGlobalStartTimeBuilder().mergeFrom(value);
                } else {
                    this.globalStartTime_ = value;
                }
            } else {
                this.globalStartTimeBuilder_.mergeFrom((GeneratedMessage)value);
            }
            if (this.globalStartTime_ != null) {
                this.bitField0_ |= 0x10;
                this.onChanged();
            }
            return this;
        }

        public Builder clearGlobalStartTime() {
            this.bitField0_ &= 0xFFFFFFEF;
            this.globalStartTime_ = null;
            if (this.globalStartTimeBuilder_ != null) {
                this.globalStartTimeBuilder_.dispose();
                this.globalStartTimeBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Timestamp.Builder getGlobalStartTimeBuilder() {
            this.bitField0_ |= 0x10;
            this.onChanged();
            return (Timestamp.Builder)this.internalGetGlobalStartTimeFieldBuilder().getBuilder();
        }

        @Override
        public TimestampOrBuilder getGlobalStartTimeOrBuilder() {
            if (this.globalStartTimeBuilder_ != null) {
                return (TimestampOrBuilder)this.globalStartTimeBuilder_.getMessageOrBuilder();
            }
            return this.globalStartTime_ == null ? Timestamp.getDefaultInstance() : this.globalStartTime_;
        }

        private SingleFieldBuilder<Timestamp, Timestamp.Builder, TimestampOrBuilder> internalGetGlobalStartTimeFieldBuilder() {
            if (this.globalStartTimeBuilder_ == null) {
                this.globalStartTimeBuilder_ = new SingleFieldBuilder((GeneratedMessage)this.getGlobalStartTime(), this.getParentForChildren(), this.isClean());
                this.globalStartTime_ = null;
            }
            return this.globalStartTimeBuilder_;
        }

        @Override
        public boolean hasGlobalEndTime() {
            return (this.bitField0_ & 0x20) != 0;
        }

        @Override
        public Timestamp getGlobalEndTime() {
            if (this.globalEndTimeBuilder_ == null) {
                return this.globalEndTime_ == null ? Timestamp.getDefaultInstance() : this.globalEndTime_;
            }
            return (Timestamp)this.globalEndTimeBuilder_.getMessage();
        }

        public Builder setGlobalEndTime(Timestamp value) {
            if (this.globalEndTimeBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.globalEndTime_ = value;
            } else {
                this.globalEndTimeBuilder_.setMessage((GeneratedMessage)value);
            }
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        public Builder setGlobalEndTime(Timestamp.Builder builderForValue) {
            if (this.globalEndTimeBuilder_ == null) {
                this.globalEndTime_ = builderForValue.build();
            } else {
                this.globalEndTimeBuilder_.setMessage((GeneratedMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        public Builder mergeGlobalEndTime(Timestamp value) {
            if (this.globalEndTimeBuilder_ == null) {
                if ((this.bitField0_ & 0x20) != 0 && this.globalEndTime_ != null && this.globalEndTime_ != Timestamp.getDefaultInstance()) {
                    this.getGlobalEndTimeBuilder().mergeFrom(value);
                } else {
                    this.globalEndTime_ = value;
                }
            } else {
                this.globalEndTimeBuilder_.mergeFrom((GeneratedMessage)value);
            }
            if (this.globalEndTime_ != null) {
                this.bitField0_ |= 0x20;
                this.onChanged();
            }
            return this;
        }

        public Builder clearGlobalEndTime() {
            this.bitField0_ &= 0xFFFFFFDF;
            this.globalEndTime_ = null;
            if (this.globalEndTimeBuilder_ != null) {
                this.globalEndTimeBuilder_.dispose();
                this.globalEndTimeBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Timestamp.Builder getGlobalEndTimeBuilder() {
            this.bitField0_ |= 0x20;
            this.onChanged();
            return (Timestamp.Builder)this.internalGetGlobalEndTimeFieldBuilder().getBuilder();
        }

        @Override
        public TimestampOrBuilder getGlobalEndTimeOrBuilder() {
            if (this.globalEndTimeBuilder_ != null) {
                return (TimestampOrBuilder)this.globalEndTimeBuilder_.getMessageOrBuilder();
            }
            return this.globalEndTime_ == null ? Timestamp.getDefaultInstance() : this.globalEndTime_;
        }

        private SingleFieldBuilder<Timestamp, Timestamp.Builder, TimestampOrBuilder> internalGetGlobalEndTimeFieldBuilder() {
            if (this.globalEndTimeBuilder_ == null) {
                this.globalEndTimeBuilder_ = new SingleFieldBuilder((GeneratedMessage)this.getGlobalEndTime(), this.getParentForChildren(), this.isClean());
                this.globalEndTime_ = null;
            }
            return this.globalEndTimeBuilder_;
        }

        @Override
        public double getGlobalDurationCostPerHour() {
            return this.globalDurationCostPerHour_;
        }

        public Builder setGlobalDurationCostPerHour(double value) {
            this.globalDurationCostPerHour_ = value;
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        public Builder clearGlobalDurationCostPerHour() {
            this.bitField0_ &= 0xFFFFFFBF;
            this.globalDurationCostPerHour_ = 0.0;
            this.onChanged();
            return this;
        }

        private void ensureDurationDistanceMatricesIsMutable() {
            if ((this.bitField0_ & 0x80) == 0) {
                this.durationDistanceMatrices_ = new ArrayList<DurationDistanceMatrix>(this.durationDistanceMatrices_);
                this.bitField0_ |= 0x80;
            }
        }

        @Override
        public List<DurationDistanceMatrix> getDurationDistanceMatricesList() {
            if (this.durationDistanceMatricesBuilder_ == null) {
                return Collections.unmodifiableList(this.durationDistanceMatrices_);
            }
            return this.durationDistanceMatricesBuilder_.getMessageList();
        }

        @Override
        public int getDurationDistanceMatricesCount() {
            if (this.durationDistanceMatricesBuilder_ == null) {
                return this.durationDistanceMatrices_.size();
            }
            return this.durationDistanceMatricesBuilder_.getCount();
        }

        @Override
        public DurationDistanceMatrix getDurationDistanceMatrices(int index) {
            if (this.durationDistanceMatricesBuilder_ == null) {
                return this.durationDistanceMatrices_.get(index);
            }
            return (DurationDistanceMatrix)this.durationDistanceMatricesBuilder_.getMessage(index);
        }

        public Builder setDurationDistanceMatrices(int index, DurationDistanceMatrix value) {
            if (this.durationDistanceMatricesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureDurationDistanceMatricesIsMutable();
                this.durationDistanceMatrices_.set(index, value);
                this.onChanged();
            } else {
                this.durationDistanceMatricesBuilder_.setMessage(index, (GeneratedMessage)value);
            }
            return this;
        }

        public Builder setDurationDistanceMatrices(int index, DurationDistanceMatrix.Builder builderForValue) {
            if (this.durationDistanceMatricesBuilder_ == null) {
                this.ensureDurationDistanceMatricesIsMutable();
                this.durationDistanceMatrices_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.durationDistanceMatricesBuilder_.setMessage(index, (GeneratedMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addDurationDistanceMatrices(DurationDistanceMatrix value) {
            if (this.durationDistanceMatricesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureDurationDistanceMatricesIsMutable();
                this.durationDistanceMatrices_.add(value);
                this.onChanged();
            } else {
                this.durationDistanceMatricesBuilder_.addMessage((GeneratedMessage)value);
            }
            return this;
        }

        public Builder addDurationDistanceMatrices(int index, DurationDistanceMatrix value) {
            if (this.durationDistanceMatricesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureDurationDistanceMatricesIsMutable();
                this.durationDistanceMatrices_.add(index, value);
                this.onChanged();
            } else {
                this.durationDistanceMatricesBuilder_.addMessage(index, (GeneratedMessage)value);
            }
            return this;
        }

        public Builder addDurationDistanceMatrices(DurationDistanceMatrix.Builder builderForValue) {
            if (this.durationDistanceMatricesBuilder_ == null) {
                this.ensureDurationDistanceMatricesIsMutable();
                this.durationDistanceMatrices_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.durationDistanceMatricesBuilder_.addMessage((GeneratedMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addDurationDistanceMatrices(int index, DurationDistanceMatrix.Builder builderForValue) {
            if (this.durationDistanceMatricesBuilder_ == null) {
                this.ensureDurationDistanceMatricesIsMutable();
                this.durationDistanceMatrices_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.durationDistanceMatricesBuilder_.addMessage(index, (GeneratedMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllDurationDistanceMatrices(Iterable<? extends DurationDistanceMatrix> values) {
            if (this.durationDistanceMatricesBuilder_ == null) {
                this.ensureDurationDistanceMatricesIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.durationDistanceMatrices_);
                this.onChanged();
            } else {
                this.durationDistanceMatricesBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearDurationDistanceMatrices() {
            if (this.durationDistanceMatricesBuilder_ == null) {
                this.durationDistanceMatrices_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFF7F;
                this.onChanged();
            } else {
                this.durationDistanceMatricesBuilder_.clear();
            }
            return this;
        }

        public Builder removeDurationDistanceMatrices(int index) {
            if (this.durationDistanceMatricesBuilder_ == null) {
                this.ensureDurationDistanceMatricesIsMutable();
                this.durationDistanceMatrices_.remove(index);
                this.onChanged();
            } else {
                this.durationDistanceMatricesBuilder_.remove(index);
            }
            return this;
        }

        public DurationDistanceMatrix.Builder getDurationDistanceMatricesBuilder(int index) {
            return (DurationDistanceMatrix.Builder)this.internalGetDurationDistanceMatricesFieldBuilder().getBuilder(index);
        }

        @Override
        public DurationDistanceMatrixOrBuilder getDurationDistanceMatricesOrBuilder(int index) {
            if (this.durationDistanceMatricesBuilder_ == null) {
                return this.durationDistanceMatrices_.get(index);
            }
            return (DurationDistanceMatrixOrBuilder)this.durationDistanceMatricesBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends DurationDistanceMatrixOrBuilder> getDurationDistanceMatricesOrBuilderList() {
            if (this.durationDistanceMatricesBuilder_ != null) {
                return this.durationDistanceMatricesBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.durationDistanceMatrices_);
        }

        public DurationDistanceMatrix.Builder addDurationDistanceMatricesBuilder() {
            return (DurationDistanceMatrix.Builder)this.internalGetDurationDistanceMatricesFieldBuilder().addBuilder((GeneratedMessage)DurationDistanceMatrix.getDefaultInstance());
        }

        public DurationDistanceMatrix.Builder addDurationDistanceMatricesBuilder(int index) {
            return (DurationDistanceMatrix.Builder)this.internalGetDurationDistanceMatricesFieldBuilder().addBuilder(index, (GeneratedMessage)DurationDistanceMatrix.getDefaultInstance());
        }

        public List<DurationDistanceMatrix.Builder> getDurationDistanceMatricesBuilderList() {
            return this.internalGetDurationDistanceMatricesFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilder<DurationDistanceMatrix, DurationDistanceMatrix.Builder, DurationDistanceMatrixOrBuilder> internalGetDurationDistanceMatricesFieldBuilder() {
            if (this.durationDistanceMatricesBuilder_ == null) {
                this.durationDistanceMatricesBuilder_ = new RepeatedFieldBuilder(this.durationDistanceMatrices_, (this.bitField0_ & 0x80) != 0, this.getParentForChildren(), this.isClean());
                this.durationDistanceMatrices_ = null;
            }
            return this.durationDistanceMatricesBuilder_;
        }

        private void ensureDurationDistanceMatrixSrcTagsIsMutable() {
            if (!this.durationDistanceMatrixSrcTags_.isModifiable()) {
                this.durationDistanceMatrixSrcTags_ = new LazyStringArrayList((LazyStringList)this.durationDistanceMatrixSrcTags_);
            }
            this.bitField0_ |= 0x100;
        }

        public ProtocolStringList getDurationDistanceMatrixSrcTagsList() {
            this.durationDistanceMatrixSrcTags_.makeImmutable();
            return this.durationDistanceMatrixSrcTags_;
        }

        @Override
        public int getDurationDistanceMatrixSrcTagsCount() {
            return this.durationDistanceMatrixSrcTags_.size();
        }

        @Override
        public String getDurationDistanceMatrixSrcTags(int index) {
            return this.durationDistanceMatrixSrcTags_.get(index);
        }

        @Override
        public ByteString getDurationDistanceMatrixSrcTagsBytes(int index) {
            return this.durationDistanceMatrixSrcTags_.getByteString(index);
        }

        public Builder setDurationDistanceMatrixSrcTags(int index, String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureDurationDistanceMatrixSrcTagsIsMutable();
            this.durationDistanceMatrixSrcTags_.set(index, value);
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        public Builder addDurationDistanceMatrixSrcTags(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureDurationDistanceMatrixSrcTagsIsMutable();
            this.durationDistanceMatrixSrcTags_.add(value);
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        public Builder addAllDurationDistanceMatrixSrcTags(Iterable<String> values) {
            this.ensureDurationDistanceMatrixSrcTagsIsMutable();
            AbstractMessageLite.Builder.addAll(values, (List)this.durationDistanceMatrixSrcTags_);
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        public Builder clearDurationDistanceMatrixSrcTags() {
            this.durationDistanceMatrixSrcTags_ = LazyStringArrayList.emptyList();
            this.bitField0_ &= 0xFFFFFEFF;
            this.onChanged();
            return this;
        }

        public Builder addDurationDistanceMatrixSrcTagsBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            ShipmentModel.checkByteStringIsUtf8((ByteString)value);
            this.ensureDurationDistanceMatrixSrcTagsIsMutable();
            this.durationDistanceMatrixSrcTags_.add(value);
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        private void ensureDurationDistanceMatrixDstTagsIsMutable() {
            if (!this.durationDistanceMatrixDstTags_.isModifiable()) {
                this.durationDistanceMatrixDstTags_ = new LazyStringArrayList((LazyStringList)this.durationDistanceMatrixDstTags_);
            }
            this.bitField0_ |= 0x200;
        }

        public ProtocolStringList getDurationDistanceMatrixDstTagsList() {
            this.durationDistanceMatrixDstTags_.makeImmutable();
            return this.durationDistanceMatrixDstTags_;
        }

        @Override
        public int getDurationDistanceMatrixDstTagsCount() {
            return this.durationDistanceMatrixDstTags_.size();
        }

        @Override
        public String getDurationDistanceMatrixDstTags(int index) {
            return this.durationDistanceMatrixDstTags_.get(index);
        }

        @Override
        public ByteString getDurationDistanceMatrixDstTagsBytes(int index) {
            return this.durationDistanceMatrixDstTags_.getByteString(index);
        }

        public Builder setDurationDistanceMatrixDstTags(int index, String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureDurationDistanceMatrixDstTagsIsMutable();
            this.durationDistanceMatrixDstTags_.set(index, value);
            this.bitField0_ |= 0x200;
            this.onChanged();
            return this;
        }

        public Builder addDurationDistanceMatrixDstTags(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureDurationDistanceMatrixDstTagsIsMutable();
            this.durationDistanceMatrixDstTags_.add(value);
            this.bitField0_ |= 0x200;
            this.onChanged();
            return this;
        }

        public Builder addAllDurationDistanceMatrixDstTags(Iterable<String> values) {
            this.ensureDurationDistanceMatrixDstTagsIsMutable();
            AbstractMessageLite.Builder.addAll(values, (List)this.durationDistanceMatrixDstTags_);
            this.bitField0_ |= 0x200;
            this.onChanged();
            return this;
        }

        public Builder clearDurationDistanceMatrixDstTags() {
            this.durationDistanceMatrixDstTags_ = LazyStringArrayList.emptyList();
            this.bitField0_ &= 0xFFFFFDFF;
            this.onChanged();
            return this;
        }

        public Builder addDurationDistanceMatrixDstTagsBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            ShipmentModel.checkByteStringIsUtf8((ByteString)value);
            this.ensureDurationDistanceMatrixDstTagsIsMutable();
            this.durationDistanceMatrixDstTags_.add(value);
            this.bitField0_ |= 0x200;
            this.onChanged();
            return this;
        }

        private void ensureTransitionAttributesIsMutable() {
            if ((this.bitField0_ & 0x400) == 0) {
                this.transitionAttributes_ = new ArrayList<TransitionAttributes>(this.transitionAttributes_);
                this.bitField0_ |= 0x400;
            }
        }

        @Override
        public List<TransitionAttributes> getTransitionAttributesList() {
            if (this.transitionAttributesBuilder_ == null) {
                return Collections.unmodifiableList(this.transitionAttributes_);
            }
            return this.transitionAttributesBuilder_.getMessageList();
        }

        @Override
        public int getTransitionAttributesCount() {
            if (this.transitionAttributesBuilder_ == null) {
                return this.transitionAttributes_.size();
            }
            return this.transitionAttributesBuilder_.getCount();
        }

        @Override
        public TransitionAttributes getTransitionAttributes(int index) {
            if (this.transitionAttributesBuilder_ == null) {
                return this.transitionAttributes_.get(index);
            }
            return (TransitionAttributes)this.transitionAttributesBuilder_.getMessage(index);
        }

        public Builder setTransitionAttributes(int index, TransitionAttributes value) {
            if (this.transitionAttributesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureTransitionAttributesIsMutable();
                this.transitionAttributes_.set(index, value);
                this.onChanged();
            } else {
                this.transitionAttributesBuilder_.setMessage(index, (GeneratedMessage)value);
            }
            return this;
        }

        public Builder setTransitionAttributes(int index, TransitionAttributes.Builder builderForValue) {
            if (this.transitionAttributesBuilder_ == null) {
                this.ensureTransitionAttributesIsMutable();
                this.transitionAttributes_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.transitionAttributesBuilder_.setMessage(index, (GeneratedMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addTransitionAttributes(TransitionAttributes value) {
            if (this.transitionAttributesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureTransitionAttributesIsMutable();
                this.transitionAttributes_.add(value);
                this.onChanged();
            } else {
                this.transitionAttributesBuilder_.addMessage((GeneratedMessage)value);
            }
            return this;
        }

        public Builder addTransitionAttributes(int index, TransitionAttributes value) {
            if (this.transitionAttributesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureTransitionAttributesIsMutable();
                this.transitionAttributes_.add(index, value);
                this.onChanged();
            } else {
                this.transitionAttributesBuilder_.addMessage(index, (GeneratedMessage)value);
            }
            return this;
        }

        public Builder addTransitionAttributes(TransitionAttributes.Builder builderForValue) {
            if (this.transitionAttributesBuilder_ == null) {
                this.ensureTransitionAttributesIsMutable();
                this.transitionAttributes_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.transitionAttributesBuilder_.addMessage((GeneratedMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addTransitionAttributes(int index, TransitionAttributes.Builder builderForValue) {
            if (this.transitionAttributesBuilder_ == null) {
                this.ensureTransitionAttributesIsMutable();
                this.transitionAttributes_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.transitionAttributesBuilder_.addMessage(index, (GeneratedMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllTransitionAttributes(Iterable<? extends TransitionAttributes> values) {
            if (this.transitionAttributesBuilder_ == null) {
                this.ensureTransitionAttributesIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.transitionAttributes_);
                this.onChanged();
            } else {
                this.transitionAttributesBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearTransitionAttributes() {
            if (this.transitionAttributesBuilder_ == null) {
                this.transitionAttributes_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFBFF;
                this.onChanged();
            } else {
                this.transitionAttributesBuilder_.clear();
            }
            return this;
        }

        public Builder removeTransitionAttributes(int index) {
            if (this.transitionAttributesBuilder_ == null) {
                this.ensureTransitionAttributesIsMutable();
                this.transitionAttributes_.remove(index);
                this.onChanged();
            } else {
                this.transitionAttributesBuilder_.remove(index);
            }
            return this;
        }

        public TransitionAttributes.Builder getTransitionAttributesBuilder(int index) {
            return (TransitionAttributes.Builder)this.internalGetTransitionAttributesFieldBuilder().getBuilder(index);
        }

        @Override
        public TransitionAttributesOrBuilder getTransitionAttributesOrBuilder(int index) {
            if (this.transitionAttributesBuilder_ == null) {
                return this.transitionAttributes_.get(index);
            }
            return (TransitionAttributesOrBuilder)this.transitionAttributesBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends TransitionAttributesOrBuilder> getTransitionAttributesOrBuilderList() {
            if (this.transitionAttributesBuilder_ != null) {
                return this.transitionAttributesBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.transitionAttributes_);
        }

        public TransitionAttributes.Builder addTransitionAttributesBuilder() {
            return (TransitionAttributes.Builder)this.internalGetTransitionAttributesFieldBuilder().addBuilder((GeneratedMessage)TransitionAttributes.getDefaultInstance());
        }

        public TransitionAttributes.Builder addTransitionAttributesBuilder(int index) {
            return (TransitionAttributes.Builder)this.internalGetTransitionAttributesFieldBuilder().addBuilder(index, (GeneratedMessage)TransitionAttributes.getDefaultInstance());
        }

        public List<TransitionAttributes.Builder> getTransitionAttributesBuilderList() {
            return this.internalGetTransitionAttributesFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilder<TransitionAttributes, TransitionAttributes.Builder, TransitionAttributesOrBuilder> internalGetTransitionAttributesFieldBuilder() {
            if (this.transitionAttributesBuilder_ == null) {
                this.transitionAttributesBuilder_ = new RepeatedFieldBuilder(this.transitionAttributes_, (this.bitField0_ & 0x400) != 0, this.getParentForChildren(), this.isClean());
                this.transitionAttributes_ = null;
            }
            return this.transitionAttributesBuilder_;
        }

        private void ensureShipmentTypeIncompatibilitiesIsMutable() {
            if ((this.bitField0_ & 0x800) == 0) {
                this.shipmentTypeIncompatibilities_ = new ArrayList<ShipmentTypeIncompatibility>(this.shipmentTypeIncompatibilities_);
                this.bitField0_ |= 0x800;
            }
        }

        @Override
        public List<ShipmentTypeIncompatibility> getShipmentTypeIncompatibilitiesList() {
            if (this.shipmentTypeIncompatibilitiesBuilder_ == null) {
                return Collections.unmodifiableList(this.shipmentTypeIncompatibilities_);
            }
            return this.shipmentTypeIncompatibilitiesBuilder_.getMessageList();
        }

        @Override
        public int getShipmentTypeIncompatibilitiesCount() {
            if (this.shipmentTypeIncompatibilitiesBuilder_ == null) {
                return this.shipmentTypeIncompatibilities_.size();
            }
            return this.shipmentTypeIncompatibilitiesBuilder_.getCount();
        }

        @Override
        public ShipmentTypeIncompatibility getShipmentTypeIncompatibilities(int index) {
            if (this.shipmentTypeIncompatibilitiesBuilder_ == null) {
                return this.shipmentTypeIncompatibilities_.get(index);
            }
            return (ShipmentTypeIncompatibility)this.shipmentTypeIncompatibilitiesBuilder_.getMessage(index);
        }

        public Builder setShipmentTypeIncompatibilities(int index, ShipmentTypeIncompatibility value) {
            if (this.shipmentTypeIncompatibilitiesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureShipmentTypeIncompatibilitiesIsMutable();
                this.shipmentTypeIncompatibilities_.set(index, value);
                this.onChanged();
            } else {
                this.shipmentTypeIncompatibilitiesBuilder_.setMessage(index, (GeneratedMessage)value);
            }
            return this;
        }

        public Builder setShipmentTypeIncompatibilities(int index, ShipmentTypeIncompatibility.Builder builderForValue) {
            if (this.shipmentTypeIncompatibilitiesBuilder_ == null) {
                this.ensureShipmentTypeIncompatibilitiesIsMutable();
                this.shipmentTypeIncompatibilities_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.shipmentTypeIncompatibilitiesBuilder_.setMessage(index, (GeneratedMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addShipmentTypeIncompatibilities(ShipmentTypeIncompatibility value) {
            if (this.shipmentTypeIncompatibilitiesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureShipmentTypeIncompatibilitiesIsMutable();
                this.shipmentTypeIncompatibilities_.add(value);
                this.onChanged();
            } else {
                this.shipmentTypeIncompatibilitiesBuilder_.addMessage((GeneratedMessage)value);
            }
            return this;
        }

        public Builder addShipmentTypeIncompatibilities(int index, ShipmentTypeIncompatibility value) {
            if (this.shipmentTypeIncompatibilitiesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureShipmentTypeIncompatibilitiesIsMutable();
                this.shipmentTypeIncompatibilities_.add(index, value);
                this.onChanged();
            } else {
                this.shipmentTypeIncompatibilitiesBuilder_.addMessage(index, (GeneratedMessage)value);
            }
            return this;
        }

        public Builder addShipmentTypeIncompatibilities(ShipmentTypeIncompatibility.Builder builderForValue) {
            if (this.shipmentTypeIncompatibilitiesBuilder_ == null) {
                this.ensureShipmentTypeIncompatibilitiesIsMutable();
                this.shipmentTypeIncompatibilities_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.shipmentTypeIncompatibilitiesBuilder_.addMessage((GeneratedMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addShipmentTypeIncompatibilities(int index, ShipmentTypeIncompatibility.Builder builderForValue) {
            if (this.shipmentTypeIncompatibilitiesBuilder_ == null) {
                this.ensureShipmentTypeIncompatibilitiesIsMutable();
                this.shipmentTypeIncompatibilities_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.shipmentTypeIncompatibilitiesBuilder_.addMessage(index, (GeneratedMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllShipmentTypeIncompatibilities(Iterable<? extends ShipmentTypeIncompatibility> values) {
            if (this.shipmentTypeIncompatibilitiesBuilder_ == null) {
                this.ensureShipmentTypeIncompatibilitiesIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.shipmentTypeIncompatibilities_);
                this.onChanged();
            } else {
                this.shipmentTypeIncompatibilitiesBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearShipmentTypeIncompatibilities() {
            if (this.shipmentTypeIncompatibilitiesBuilder_ == null) {
                this.shipmentTypeIncompatibilities_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFF7FF;
                this.onChanged();
            } else {
                this.shipmentTypeIncompatibilitiesBuilder_.clear();
            }
            return this;
        }

        public Builder removeShipmentTypeIncompatibilities(int index) {
            if (this.shipmentTypeIncompatibilitiesBuilder_ == null) {
                this.ensureShipmentTypeIncompatibilitiesIsMutable();
                this.shipmentTypeIncompatibilities_.remove(index);
                this.onChanged();
            } else {
                this.shipmentTypeIncompatibilitiesBuilder_.remove(index);
            }
            return this;
        }

        public ShipmentTypeIncompatibility.Builder getShipmentTypeIncompatibilitiesBuilder(int index) {
            return (ShipmentTypeIncompatibility.Builder)this.internalGetShipmentTypeIncompatibilitiesFieldBuilder().getBuilder(index);
        }

        @Override
        public ShipmentTypeIncompatibilityOrBuilder getShipmentTypeIncompatibilitiesOrBuilder(int index) {
            if (this.shipmentTypeIncompatibilitiesBuilder_ == null) {
                return this.shipmentTypeIncompatibilities_.get(index);
            }
            return (ShipmentTypeIncompatibilityOrBuilder)this.shipmentTypeIncompatibilitiesBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends ShipmentTypeIncompatibilityOrBuilder> getShipmentTypeIncompatibilitiesOrBuilderList() {
            if (this.shipmentTypeIncompatibilitiesBuilder_ != null) {
                return this.shipmentTypeIncompatibilitiesBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.shipmentTypeIncompatibilities_);
        }

        public ShipmentTypeIncompatibility.Builder addShipmentTypeIncompatibilitiesBuilder() {
            return (ShipmentTypeIncompatibility.Builder)this.internalGetShipmentTypeIncompatibilitiesFieldBuilder().addBuilder((GeneratedMessage)ShipmentTypeIncompatibility.getDefaultInstance());
        }

        public ShipmentTypeIncompatibility.Builder addShipmentTypeIncompatibilitiesBuilder(int index) {
            return (ShipmentTypeIncompatibility.Builder)this.internalGetShipmentTypeIncompatibilitiesFieldBuilder().addBuilder(index, (GeneratedMessage)ShipmentTypeIncompatibility.getDefaultInstance());
        }

        public List<ShipmentTypeIncompatibility.Builder> getShipmentTypeIncompatibilitiesBuilderList() {
            return this.internalGetShipmentTypeIncompatibilitiesFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilder<ShipmentTypeIncompatibility, ShipmentTypeIncompatibility.Builder, ShipmentTypeIncompatibilityOrBuilder> internalGetShipmentTypeIncompatibilitiesFieldBuilder() {
            if (this.shipmentTypeIncompatibilitiesBuilder_ == null) {
                this.shipmentTypeIncompatibilitiesBuilder_ = new RepeatedFieldBuilder(this.shipmentTypeIncompatibilities_, (this.bitField0_ & 0x800) != 0, this.getParentForChildren(), this.isClean());
                this.shipmentTypeIncompatibilities_ = null;
            }
            return this.shipmentTypeIncompatibilitiesBuilder_;
        }

        private void ensureShipmentTypeRequirementsIsMutable() {
            if ((this.bitField0_ & 0x1000) == 0) {
                this.shipmentTypeRequirements_ = new ArrayList<ShipmentTypeRequirement>(this.shipmentTypeRequirements_);
                this.bitField0_ |= 0x1000;
            }
        }

        @Override
        public List<ShipmentTypeRequirement> getShipmentTypeRequirementsList() {
            if (this.shipmentTypeRequirementsBuilder_ == null) {
                return Collections.unmodifiableList(this.shipmentTypeRequirements_);
            }
            return this.shipmentTypeRequirementsBuilder_.getMessageList();
        }

        @Override
        public int getShipmentTypeRequirementsCount() {
            if (this.shipmentTypeRequirementsBuilder_ == null) {
                return this.shipmentTypeRequirements_.size();
            }
            return this.shipmentTypeRequirementsBuilder_.getCount();
        }

        @Override
        public ShipmentTypeRequirement getShipmentTypeRequirements(int index) {
            if (this.shipmentTypeRequirementsBuilder_ == null) {
                return this.shipmentTypeRequirements_.get(index);
            }
            return (ShipmentTypeRequirement)this.shipmentTypeRequirementsBuilder_.getMessage(index);
        }

        public Builder setShipmentTypeRequirements(int index, ShipmentTypeRequirement value) {
            if (this.shipmentTypeRequirementsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureShipmentTypeRequirementsIsMutable();
                this.shipmentTypeRequirements_.set(index, value);
                this.onChanged();
            } else {
                this.shipmentTypeRequirementsBuilder_.setMessage(index, (GeneratedMessage)value);
            }
            return this;
        }

        public Builder setShipmentTypeRequirements(int index, ShipmentTypeRequirement.Builder builderForValue) {
            if (this.shipmentTypeRequirementsBuilder_ == null) {
                this.ensureShipmentTypeRequirementsIsMutable();
                this.shipmentTypeRequirements_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.shipmentTypeRequirementsBuilder_.setMessage(index, (GeneratedMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addShipmentTypeRequirements(ShipmentTypeRequirement value) {
            if (this.shipmentTypeRequirementsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureShipmentTypeRequirementsIsMutable();
                this.shipmentTypeRequirements_.add(value);
                this.onChanged();
            } else {
                this.shipmentTypeRequirementsBuilder_.addMessage((GeneratedMessage)value);
            }
            return this;
        }

        public Builder addShipmentTypeRequirements(int index, ShipmentTypeRequirement value) {
            if (this.shipmentTypeRequirementsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureShipmentTypeRequirementsIsMutable();
                this.shipmentTypeRequirements_.add(index, value);
                this.onChanged();
            } else {
                this.shipmentTypeRequirementsBuilder_.addMessage(index, (GeneratedMessage)value);
            }
            return this;
        }

        public Builder addShipmentTypeRequirements(ShipmentTypeRequirement.Builder builderForValue) {
            if (this.shipmentTypeRequirementsBuilder_ == null) {
                this.ensureShipmentTypeRequirementsIsMutable();
                this.shipmentTypeRequirements_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.shipmentTypeRequirementsBuilder_.addMessage((GeneratedMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addShipmentTypeRequirements(int index, ShipmentTypeRequirement.Builder builderForValue) {
            if (this.shipmentTypeRequirementsBuilder_ == null) {
                this.ensureShipmentTypeRequirementsIsMutable();
                this.shipmentTypeRequirements_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.shipmentTypeRequirementsBuilder_.addMessage(index, (GeneratedMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllShipmentTypeRequirements(Iterable<? extends ShipmentTypeRequirement> values) {
            if (this.shipmentTypeRequirementsBuilder_ == null) {
                this.ensureShipmentTypeRequirementsIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.shipmentTypeRequirements_);
                this.onChanged();
            } else {
                this.shipmentTypeRequirementsBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearShipmentTypeRequirements() {
            if (this.shipmentTypeRequirementsBuilder_ == null) {
                this.shipmentTypeRequirements_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFEFFF;
                this.onChanged();
            } else {
                this.shipmentTypeRequirementsBuilder_.clear();
            }
            return this;
        }

        public Builder removeShipmentTypeRequirements(int index) {
            if (this.shipmentTypeRequirementsBuilder_ == null) {
                this.ensureShipmentTypeRequirementsIsMutable();
                this.shipmentTypeRequirements_.remove(index);
                this.onChanged();
            } else {
                this.shipmentTypeRequirementsBuilder_.remove(index);
            }
            return this;
        }

        public ShipmentTypeRequirement.Builder getShipmentTypeRequirementsBuilder(int index) {
            return (ShipmentTypeRequirement.Builder)this.internalGetShipmentTypeRequirementsFieldBuilder().getBuilder(index);
        }

        @Override
        public ShipmentTypeRequirementOrBuilder getShipmentTypeRequirementsOrBuilder(int index) {
            if (this.shipmentTypeRequirementsBuilder_ == null) {
                return this.shipmentTypeRequirements_.get(index);
            }
            return (ShipmentTypeRequirementOrBuilder)this.shipmentTypeRequirementsBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends ShipmentTypeRequirementOrBuilder> getShipmentTypeRequirementsOrBuilderList() {
            if (this.shipmentTypeRequirementsBuilder_ != null) {
                return this.shipmentTypeRequirementsBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.shipmentTypeRequirements_);
        }

        public ShipmentTypeRequirement.Builder addShipmentTypeRequirementsBuilder() {
            return (ShipmentTypeRequirement.Builder)this.internalGetShipmentTypeRequirementsFieldBuilder().addBuilder((GeneratedMessage)ShipmentTypeRequirement.getDefaultInstance());
        }

        public ShipmentTypeRequirement.Builder addShipmentTypeRequirementsBuilder(int index) {
            return (ShipmentTypeRequirement.Builder)this.internalGetShipmentTypeRequirementsFieldBuilder().addBuilder(index, (GeneratedMessage)ShipmentTypeRequirement.getDefaultInstance());
        }

        public List<ShipmentTypeRequirement.Builder> getShipmentTypeRequirementsBuilderList() {
            return this.internalGetShipmentTypeRequirementsFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilder<ShipmentTypeRequirement, ShipmentTypeRequirement.Builder, ShipmentTypeRequirementOrBuilder> internalGetShipmentTypeRequirementsFieldBuilder() {
            if (this.shipmentTypeRequirementsBuilder_ == null) {
                this.shipmentTypeRequirementsBuilder_ = new RepeatedFieldBuilder(this.shipmentTypeRequirements_, (this.bitField0_ & 0x1000) != 0, this.getParentForChildren(), this.isClean());
                this.shipmentTypeRequirements_ = null;
            }
            return this.shipmentTypeRequirementsBuilder_;
        }

        private void ensurePrecedenceRulesIsMutable() {
            if ((this.bitField0_ & 0x2000) == 0) {
                this.precedenceRules_ = new ArrayList<PrecedenceRule>(this.precedenceRules_);
                this.bitField0_ |= 0x2000;
            }
        }

        @Override
        public List<PrecedenceRule> getPrecedenceRulesList() {
            if (this.precedenceRulesBuilder_ == null) {
                return Collections.unmodifiableList(this.precedenceRules_);
            }
            return this.precedenceRulesBuilder_.getMessageList();
        }

        @Override
        public int getPrecedenceRulesCount() {
            if (this.precedenceRulesBuilder_ == null) {
                return this.precedenceRules_.size();
            }
            return this.precedenceRulesBuilder_.getCount();
        }

        @Override
        public PrecedenceRule getPrecedenceRules(int index) {
            if (this.precedenceRulesBuilder_ == null) {
                return this.precedenceRules_.get(index);
            }
            return (PrecedenceRule)this.precedenceRulesBuilder_.getMessage(index);
        }

        public Builder setPrecedenceRules(int index, PrecedenceRule value) {
            if (this.precedenceRulesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensurePrecedenceRulesIsMutable();
                this.precedenceRules_.set(index, value);
                this.onChanged();
            } else {
                this.precedenceRulesBuilder_.setMessage(index, (GeneratedMessage)value);
            }
            return this;
        }

        public Builder setPrecedenceRules(int index, PrecedenceRule.Builder builderForValue) {
            if (this.precedenceRulesBuilder_ == null) {
                this.ensurePrecedenceRulesIsMutable();
                this.precedenceRules_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.precedenceRulesBuilder_.setMessage(index, (GeneratedMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addPrecedenceRules(PrecedenceRule value) {
            if (this.precedenceRulesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensurePrecedenceRulesIsMutable();
                this.precedenceRules_.add(value);
                this.onChanged();
            } else {
                this.precedenceRulesBuilder_.addMessage((GeneratedMessage)value);
            }
            return this;
        }

        public Builder addPrecedenceRules(int index, PrecedenceRule value) {
            if (this.precedenceRulesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensurePrecedenceRulesIsMutable();
                this.precedenceRules_.add(index, value);
                this.onChanged();
            } else {
                this.precedenceRulesBuilder_.addMessage(index, (GeneratedMessage)value);
            }
            return this;
        }

        public Builder addPrecedenceRules(PrecedenceRule.Builder builderForValue) {
            if (this.precedenceRulesBuilder_ == null) {
                this.ensurePrecedenceRulesIsMutable();
                this.precedenceRules_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.precedenceRulesBuilder_.addMessage((GeneratedMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addPrecedenceRules(int index, PrecedenceRule.Builder builderForValue) {
            if (this.precedenceRulesBuilder_ == null) {
                this.ensurePrecedenceRulesIsMutable();
                this.precedenceRules_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.precedenceRulesBuilder_.addMessage(index, (GeneratedMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllPrecedenceRules(Iterable<? extends PrecedenceRule> values) {
            if (this.precedenceRulesBuilder_ == null) {
                this.ensurePrecedenceRulesIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.precedenceRules_);
                this.onChanged();
            } else {
                this.precedenceRulesBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearPrecedenceRules() {
            if (this.precedenceRulesBuilder_ == null) {
                this.precedenceRules_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFDFFF;
                this.onChanged();
            } else {
                this.precedenceRulesBuilder_.clear();
            }
            return this;
        }

        public Builder removePrecedenceRules(int index) {
            if (this.precedenceRulesBuilder_ == null) {
                this.ensurePrecedenceRulesIsMutable();
                this.precedenceRules_.remove(index);
                this.onChanged();
            } else {
                this.precedenceRulesBuilder_.remove(index);
            }
            return this;
        }

        public PrecedenceRule.Builder getPrecedenceRulesBuilder(int index) {
            return (PrecedenceRule.Builder)this.internalGetPrecedenceRulesFieldBuilder().getBuilder(index);
        }

        @Override
        public PrecedenceRuleOrBuilder getPrecedenceRulesOrBuilder(int index) {
            if (this.precedenceRulesBuilder_ == null) {
                return this.precedenceRules_.get(index);
            }
            return (PrecedenceRuleOrBuilder)this.precedenceRulesBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends PrecedenceRuleOrBuilder> getPrecedenceRulesOrBuilderList() {
            if (this.precedenceRulesBuilder_ != null) {
                return this.precedenceRulesBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.precedenceRules_);
        }

        public PrecedenceRule.Builder addPrecedenceRulesBuilder() {
            return (PrecedenceRule.Builder)this.internalGetPrecedenceRulesFieldBuilder().addBuilder((GeneratedMessage)PrecedenceRule.getDefaultInstance());
        }

        public PrecedenceRule.Builder addPrecedenceRulesBuilder(int index) {
            return (PrecedenceRule.Builder)this.internalGetPrecedenceRulesFieldBuilder().addBuilder(index, (GeneratedMessage)PrecedenceRule.getDefaultInstance());
        }

        public List<PrecedenceRule.Builder> getPrecedenceRulesBuilderList() {
            return this.internalGetPrecedenceRulesFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilder<PrecedenceRule, PrecedenceRule.Builder, PrecedenceRuleOrBuilder> internalGetPrecedenceRulesFieldBuilder() {
            if (this.precedenceRulesBuilder_ == null) {
                this.precedenceRulesBuilder_ = new RepeatedFieldBuilder(this.precedenceRules_, (this.bitField0_ & 0x2000) != 0, this.getParentForChildren(), this.isClean());
                this.precedenceRules_ = null;
            }
            return this.precedenceRulesBuilder_;
        }
    }

    public static final class PrecedenceRule
    extends GeneratedMessage
    implements PrecedenceRuleOrBuilder {
        private static final long serialVersionUID = 0L;
        private int bitField0_;
        public static final int FIRST_INDEX_FIELD_NUMBER = 1;
        private int firstIndex_ = 0;
        public static final int FIRST_IS_DELIVERY_FIELD_NUMBER = 3;
        private boolean firstIsDelivery_ = false;
        public static final int SECOND_INDEX_FIELD_NUMBER = 2;
        private int secondIndex_ = 0;
        public static final int SECOND_IS_DELIVERY_FIELD_NUMBER = 4;
        private boolean secondIsDelivery_ = false;
        public static final int OFFSET_DURATION_FIELD_NUMBER = 5;
        private Duration offsetDuration_;
        private byte memoizedIsInitialized = (byte)-1;
        private static final PrecedenceRule DEFAULT_INSTANCE;
        private static final Parser<PrecedenceRule> PARSER;

        private PrecedenceRule(GeneratedMessage.Builder<?> builder) {
            super(builder);
        }

        private PrecedenceRule() {
        }

        public static final Descriptors.Descriptor getDescriptor() {
            return RouteOptimizationServiceProto.internal_static_google_maps_routeoptimization_v1_ShipmentModel_PrecedenceRule_descriptor;
        }

        protected GeneratedMessage.FieldAccessorTable internalGetFieldAccessorTable() {
            return RouteOptimizationServiceProto.internal_static_google_maps_routeoptimization_v1_ShipmentModel_PrecedenceRule_fieldAccessorTable.ensureFieldAccessorsInitialized(PrecedenceRule.class, Builder.class);
        }

        @Override
        public boolean hasFirstIndex() {
            return (this.bitField0_ & 1) != 0;
        }

        @Override
        public int getFirstIndex() {
            return this.firstIndex_;
        }

        @Override
        public boolean getFirstIsDelivery() {
            return this.firstIsDelivery_;
        }

        @Override
        public boolean hasSecondIndex() {
            return (this.bitField0_ & 2) != 0;
        }

        @Override
        public int getSecondIndex() {
            return this.secondIndex_;
        }

        @Override
        public boolean getSecondIsDelivery() {
            return this.secondIsDelivery_;
        }

        @Override
        public boolean hasOffsetDuration() {
            return (this.bitField0_ & 4) != 0;
        }

        @Override
        public Duration getOffsetDuration() {
            return this.offsetDuration_ == null ? Duration.getDefaultInstance() : this.offsetDuration_;
        }

        @Override
        public DurationOrBuilder getOffsetDurationOrBuilder() {
            return this.offsetDuration_ == null ? Duration.getDefaultInstance() : this.offsetDuration_;
        }

        public final boolean isInitialized() {
            byte isInitialized = this.memoizedIsInitialized;
            if (isInitialized == 1) {
                return true;
            }
            if (isInitialized == 0) {
                return false;
            }
            this.memoizedIsInitialized = 1;
            return true;
        }

        public void writeTo(CodedOutputStream output) throws IOException {
            if ((this.bitField0_ & 1) != 0) {
                output.writeInt32(1, this.firstIndex_);
            }
            if ((this.bitField0_ & 2) != 0) {
                output.writeInt32(2, this.secondIndex_);
            }
            if (this.firstIsDelivery_) {
                output.writeBool(3, this.firstIsDelivery_);
            }
            if (this.secondIsDelivery_) {
                output.writeBool(4, this.secondIsDelivery_);
            }
            if ((this.bitField0_ & 4) != 0) {
                output.writeMessage(5, (MessageLite)this.getOffsetDuration());
            }
            this.getUnknownFields().writeTo(output);
        }

        public int getSerializedSize() {
            int size = this.memoizedSize;
            if (size != -1) {
                return size;
            }
            size = 0;
            if ((this.bitField0_ & 1) != 0) {
                size += CodedOutputStream.computeInt32Size((int)1, (int)this.firstIndex_);
            }
            if ((this.bitField0_ & 2) != 0) {
                size += CodedOutputStream.computeInt32Size((int)2, (int)this.secondIndex_);
            }
            if (this.firstIsDelivery_) {
                size += CodedOutputStream.computeBoolSize((int)3, (boolean)this.firstIsDelivery_);
            }
            if (this.secondIsDelivery_) {
                size += CodedOutputStream.computeBoolSize((int)4, (boolean)this.secondIsDelivery_);
            }
            if ((this.bitField0_ & 4) != 0) {
                size += CodedOutputStream.computeMessageSize((int)5, (MessageLite)this.getOffsetDuration());
            }
            this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
            return size;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof PrecedenceRule)) {
                return super.equals(obj);
            }
            PrecedenceRule other = (PrecedenceRule)obj;
            if (this.hasFirstIndex() != other.hasFirstIndex()) {
                return false;
            }
            if (this.hasFirstIndex() && this.getFirstIndex() != other.getFirstIndex()) {
                return false;
            }
            if (this.getFirstIsDelivery() != other.getFirstIsDelivery()) {
                return false;
            }
            if (this.hasSecondIndex() != other.hasSecondIndex()) {
                return false;
            }
            if (this.hasSecondIndex() && this.getSecondIndex() != other.getSecondIndex()) {
                return false;
            }
            if (this.getSecondIsDelivery() != other.getSecondIsDelivery()) {
                return false;
            }
            if (this.hasOffsetDuration() != other.hasOffsetDuration()) {
                return false;
            }
            if (this.hasOffsetDuration() && !this.getOffsetDuration().equals((Object)other.getOffsetDuration())) {
                return false;
            }
            return this.getUnknownFields().equals((Object)other.getUnknownFields());
        }

        public int hashCode() {
            if (this.memoizedHashCode != 0) {
                return this.memoizedHashCode;
            }
            int hash = 41;
            hash = 19 * hash + PrecedenceRule.getDescriptor().hashCode();
            if (this.hasFirstIndex()) {
                hash = 37 * hash + 1;
                hash = 53 * hash + this.getFirstIndex();
            }
            hash = 37 * hash + 3;
            hash = 53 * hash + Internal.hashBoolean((boolean)this.getFirstIsDelivery());
            if (this.hasSecondIndex()) {
                hash = 37 * hash + 2;
                hash = 53 * hash + this.getSecondIndex();
            }
            hash = 37 * hash + 4;
            hash = 53 * hash + Internal.hashBoolean((boolean)this.getSecondIsDelivery());
            if (this.hasOffsetDuration()) {
                hash = 37 * hash + 5;
                hash = 53 * hash + this.getOffsetDuration().hashCode();
            }
            this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
            return hash;
        }

        public static PrecedenceRule parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
            return (PrecedenceRule)PARSER.parseFrom(data);
        }

        public static PrecedenceRule parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (PrecedenceRule)PARSER.parseFrom(data, extensionRegistry);
        }

        public static PrecedenceRule parseFrom(ByteString data) throws InvalidProtocolBufferException {
            return (PrecedenceRule)PARSER.parseFrom(data);
        }

        public static PrecedenceRule parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (PrecedenceRule)PARSER.parseFrom(data, extensionRegistry);
        }

        public static PrecedenceRule parseFrom(byte[] data) throws InvalidProtocolBufferException {
            return (PrecedenceRule)PARSER.parseFrom(data);
        }

        public static PrecedenceRule parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (PrecedenceRule)PARSER.parseFrom(data, extensionRegistry);
        }

        public static PrecedenceRule parseFrom(InputStream input) throws IOException {
            return (PrecedenceRule)GeneratedMessage.parseWithIOException(PARSER, (InputStream)input);
        }

        public static PrecedenceRule parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (PrecedenceRule)GeneratedMessage.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static PrecedenceRule parseDelimitedFrom(InputStream input) throws IOException {
            return (PrecedenceRule)GeneratedMessage.parseDelimitedWithIOException(PARSER, (InputStream)input);
        }

        public static PrecedenceRule parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (PrecedenceRule)GeneratedMessage.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static PrecedenceRule parseFrom(CodedInputStream input) throws IOException {
            return (PrecedenceRule)GeneratedMessage.parseWithIOException(PARSER, (CodedInputStream)input);
        }

        public static PrecedenceRule parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (PrecedenceRule)GeneratedMessage.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public Builder newBuilderForType() {
            return PrecedenceRule.newBuilder();
        }

        public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(PrecedenceRule prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        public Builder toBuilder() {
            return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        protected Builder newBuilderForType(AbstractMessage.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
        }

        public static PrecedenceRule getDefaultInstance() {
            return DEFAULT_INSTANCE;
        }

        public static Parser<PrecedenceRule> parser() {
            return PARSER;
        }

        public Parser<PrecedenceRule> getParserForType() {
            return PARSER;
        }

        public PrecedenceRule getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
        }

        static {
            RuntimeVersion.validateProtobufGencodeVersion((RuntimeVersion.RuntimeDomain)RuntimeVersion.RuntimeDomain.PUBLIC, (int)4, (int)33, (int)0, (String)"", (String)"PrecedenceRule");
            DEFAULT_INSTANCE = new PrecedenceRule();
            PARSER = new AbstractParser<PrecedenceRule>(){

                public PrecedenceRule parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                    Builder builder = PrecedenceRule.newBuilder();
                    try {
                        builder.mergeFrom(input, extensionRegistry);
                    }
                    catch (InvalidProtocolBufferException e) {
                        throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
                    }
                    catch (UninitializedMessageException e) {
                        throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
                    }
                    catch (IOException e) {
                        throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
                    }
                    return builder.buildPartial();
                }
            };
        }

        public static final class Builder
        extends GeneratedMessage.Builder<Builder>
        implements PrecedenceRuleOrBuilder {
            private int bitField0_;
            private int firstIndex_;
            private boolean firstIsDelivery_;
            private int secondIndex_;
            private boolean secondIsDelivery_;
            private Duration offsetDuration_;
            private SingleFieldBuilder<Duration, Duration.Builder, DurationOrBuilder> offsetDurationBuilder_;

            public static final Descriptors.Descriptor getDescriptor() {
                return RouteOptimizationServiceProto.internal_static_google_maps_routeoptimization_v1_ShipmentModel_PrecedenceRule_descriptor;
            }

            protected GeneratedMessage.FieldAccessorTable internalGetFieldAccessorTable() {
                return RouteOptimizationServiceProto.internal_static_google_maps_routeoptimization_v1_ShipmentModel_PrecedenceRule_fieldAccessorTable.ensureFieldAccessorsInitialized(PrecedenceRule.class, Builder.class);
            }

            private Builder() {
                this.maybeForceBuilderInitialization();
            }

            private Builder(AbstractMessage.BuilderParent parent) {
                super(parent);
                this.maybeForceBuilderInitialization();
            }

            private void maybeForceBuilderInitialization() {
                if (alwaysUseFieldBuilders) {
                    this.internalGetOffsetDurationFieldBuilder();
                }
            }

            public Builder clear() {
                super.clear();
                this.bitField0_ = 0;
                this.firstIndex_ = 0;
                this.firstIsDelivery_ = false;
                this.secondIndex_ = 0;
                this.secondIsDelivery_ = false;
                this.offsetDuration_ = null;
                if (this.offsetDurationBuilder_ != null) {
                    this.offsetDurationBuilder_.dispose();
                    this.offsetDurationBuilder_ = null;
                }
                return this;
            }

            public Descriptors.Descriptor getDescriptorForType() {
                return RouteOptimizationServiceProto.internal_static_google_maps_routeoptimization_v1_ShipmentModel_PrecedenceRule_descriptor;
            }

            public PrecedenceRule getDefaultInstanceForType() {
                return PrecedenceRule.getDefaultInstance();
            }

            public PrecedenceRule build() {
                PrecedenceRule result = this.buildPartial();
                if (!result.isInitialized()) {
                    throw Builder.newUninitializedMessageException((Message)result);
                }
                return result;
            }

            public PrecedenceRule buildPartial() {
                PrecedenceRule result = new PrecedenceRule(this);
                if (this.bitField0_ != 0) {
                    this.buildPartial0(result);
                }
                this.onBuilt();
                return result;
            }

            private void buildPartial0(PrecedenceRule result) {
                int from_bitField0_ = this.bitField0_;
                int to_bitField0_ = 0;
                if ((from_bitField0_ & 1) != 0) {
                    result.firstIndex_ = this.firstIndex_;
                    to_bitField0_ |= 1;
                }
                if ((from_bitField0_ & 2) != 0) {
                    result.firstIsDelivery_ = this.firstIsDelivery_;
                }
                if ((from_bitField0_ & 4) != 0) {
                    result.secondIndex_ = this.secondIndex_;
                    to_bitField0_ |= 2;
                }
                if ((from_bitField0_ & 8) != 0) {
                    result.secondIsDelivery_ = this.secondIsDelivery_;
                }
                if ((from_bitField0_ & 0x10) != 0) {
                    result.offsetDuration_ = this.offsetDurationBuilder_ == null ? this.offsetDuration_ : (Duration)this.offsetDurationBuilder_.build();
                    to_bitField0_ |= 4;
                }
                PrecedenceRule precedenceRule = result;
                precedenceRule.bitField0_ = precedenceRule.bitField0_ | to_bitField0_;
            }

            public Builder mergeFrom(Message other) {
                if (other instanceof PrecedenceRule) {
                    return this.mergeFrom((PrecedenceRule)other);
                }
                super.mergeFrom(other);
                return this;
            }

            public Builder mergeFrom(PrecedenceRule other) {
                if (other == PrecedenceRule.getDefaultInstance()) {
                    return this;
                }
                if (other.hasFirstIndex()) {
                    this.setFirstIndex(other.getFirstIndex());
                }
                if (other.getFirstIsDelivery()) {
                    this.setFirstIsDelivery(other.getFirstIsDelivery());
                }
                if (other.hasSecondIndex()) {
                    this.setSecondIndex(other.getSecondIndex());
                }
                if (other.getSecondIsDelivery()) {
                    this.setSecondIsDelivery(other.getSecondIsDelivery());
                }
                if (other.hasOffsetDuration()) {
                    this.mergeOffsetDuration(other.getOffsetDuration());
                }
                this.mergeUnknownFields(other.getUnknownFields());
                this.onChanged();
                return this;
            }

            public final boolean isInitialized() {
                return true;
            }

            public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                if (extensionRegistry == null) {
                    throw new NullPointerException();
                }
                try {
                    boolean done = false;
                    block13: while (!done) {
                        int tag = input.readTag();
                        switch (tag) {
                            case 0: {
                                done = true;
                                continue block13;
                            }
                            case 8: {
                                this.firstIndex_ = input.readInt32();
                                this.bitField0_ |= 1;
                                continue block13;
                            }
                            case 16: {
                                this.secondIndex_ = input.readInt32();
                                this.bitField0_ |= 4;
                                continue block13;
                            }
                            case 24: {
                                this.firstIsDelivery_ = input.readBool();
                                this.bitField0_ |= 2;
                                continue block13;
                            }
                            case 32: {
                                this.secondIsDelivery_ = input.readBool();
                                this.bitField0_ |= 8;
                                continue block13;
                            }
                            case 42: {
                                input.readMessage((MessageLite.Builder)this.internalGetOffsetDurationFieldBuilder().getBuilder(), extensionRegistry);
                                this.bitField0_ |= 0x10;
                                continue block13;
                            }
                        }
                        if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                        done = true;
                    }
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.unwrapIOException();
                }
                finally {
                    this.onChanged();
                }
                return this;
            }

            @Override
            public boolean hasFirstIndex() {
                return (this.bitField0_ & 1) != 0;
            }

            @Override
            public int getFirstIndex() {
                return this.firstIndex_;
            }

            public Builder setFirstIndex(int value) {
                this.firstIndex_ = value;
                this.bitField0_ |= 1;
                this.onChanged();
                return this;
            }

            public Builder clearFirstIndex() {
                this.bitField0_ &= 0xFFFFFFFE;
                this.firstIndex_ = 0;
                this.onChanged();
                return this;
            }

            @Override
            public boolean getFirstIsDelivery() {
                return this.firstIsDelivery_;
            }

            public Builder setFirstIsDelivery(boolean value) {
                this.firstIsDelivery_ = value;
                this.bitField0_ |= 2;
                this.onChanged();
                return this;
            }

            public Builder clearFirstIsDelivery() {
                this.bitField0_ &= 0xFFFFFFFD;
                this.firstIsDelivery_ = false;
                this.onChanged();
                return this;
            }

            @Override
            public boolean hasSecondIndex() {
                return (this.bitField0_ & 4) != 0;
            }

            @Override
            public int getSecondIndex() {
                return this.secondIndex_;
            }

            public Builder setSecondIndex(int value) {
                this.secondIndex_ = value;
                this.bitField0_ |= 4;
                this.onChanged();
                return this;
            }

            public Builder clearSecondIndex() {
                this.bitField0_ &= 0xFFFFFFFB;
                this.secondIndex_ = 0;
                this.onChanged();
                return this;
            }

            @Override
            public boolean getSecondIsDelivery() {
                return this.secondIsDelivery_;
            }

            public Builder setSecondIsDelivery(boolean value) {
                this.secondIsDelivery_ = value;
                this.bitField0_ |= 8;
                this.onChanged();
                return this;
            }

            public Builder clearSecondIsDelivery() {
                this.bitField0_ &= 0xFFFFFFF7;
                this.secondIsDelivery_ = false;
                this.onChanged();
                return this;
            }

            @Override
            public boolean hasOffsetDuration() {
                return (this.bitField0_ & 0x10) != 0;
            }

            @Override
            public Duration getOffsetDuration() {
                if (this.offsetDurationBuilder_ == null) {
                    return this.offsetDuration_ == null ? Duration.getDefaultInstance() : this.offsetDuration_;
                }
                return (Duration)this.offsetDurationBuilder_.getMessage();
            }

            public Builder setOffsetDuration(Duration value) {
                if (this.offsetDurationBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.offsetDuration_ = value;
                } else {
                    this.offsetDurationBuilder_.setMessage((GeneratedMessage)value);
                }
                this.bitField0_ |= 0x10;
                this.onChanged();
                return this;
            }

            public Builder setOffsetDuration(Duration.Builder builderForValue) {
                if (this.offsetDurationBuilder_ == null) {
                    this.offsetDuration_ = builderForValue.build();
                } else {
                    this.offsetDurationBuilder_.setMessage((GeneratedMessage)builderForValue.build());
                }
                this.bitField0_ |= 0x10;
                this.onChanged();
                return this;
            }

            public Builder mergeOffsetDuration(Duration value) {
                if (this.offsetDurationBuilder_ == null) {
                    if ((this.bitField0_ & 0x10) != 0 && this.offsetDuration_ != null && this.offsetDuration_ != Duration.getDefaultInstance()) {
                        this.getOffsetDurationBuilder().mergeFrom(value);
                    } else {
                        this.offsetDuration_ = value;
                    }
                } else {
                    this.offsetDurationBuilder_.mergeFrom((GeneratedMessage)value);
                }
                if (this.offsetDuration_ != null) {
                    this.bitField0_ |= 0x10;
                    this.onChanged();
                }
                return this;
            }

            public Builder clearOffsetDuration() {
                this.bitField0_ &= 0xFFFFFFEF;
                this.offsetDuration_ = null;
                if (this.offsetDurationBuilder_ != null) {
                    this.offsetDurationBuilder_.dispose();
                    this.offsetDurationBuilder_ = null;
                }
                this.onChanged();
                return this;
            }

            public Duration.Builder getOffsetDurationBuilder() {
                this.bitField0_ |= 0x10;
                this.onChanged();
                return (Duration.Builder)this.internalGetOffsetDurationFieldBuilder().getBuilder();
            }

            @Override
            public DurationOrBuilder getOffsetDurationOrBuilder() {
                if (this.offsetDurationBuilder_ != null) {
                    return (DurationOrBuilder)this.offsetDurationBuilder_.getMessageOrBuilder();
                }
                return this.offsetDuration_ == null ? Duration.getDefaultInstance() : this.offsetDuration_;
            }

            private SingleFieldBuilder<Duration, Duration.Builder, DurationOrBuilder> internalGetOffsetDurationFieldBuilder() {
                if (this.offsetDurationBuilder_ == null) {
                    this.offsetDurationBuilder_ = new SingleFieldBuilder((GeneratedMessage)this.getOffsetDuration(), this.getParentForChildren(), this.isClean());
                    this.offsetDuration_ = null;
                }
                return this.offsetDurationBuilder_;
            }
        }
    }

    public static interface PrecedenceRuleOrBuilder
    extends MessageOrBuilder {
        public boolean hasFirstIndex();

        public int getFirstIndex();

        public boolean getFirstIsDelivery();

        public boolean hasSecondIndex();

        public int getSecondIndex();

        public boolean getSecondIsDelivery();

        public boolean hasOffsetDuration();

        public Duration getOffsetDuration();

        public DurationOrBuilder getOffsetDurationOrBuilder();
    }

    public static final class DurationDistanceMatrix
    extends GeneratedMessage
    implements DurationDistanceMatrixOrBuilder {
        private static final long serialVersionUID = 0L;
        public static final int ROWS_FIELD_NUMBER = 1;
        private List<Row> rows_;
        public static final int VEHICLE_START_TAG_FIELD_NUMBER = 2;
        private volatile Object vehicleStartTag_ = "";
        private byte memoizedIsInitialized = (byte)-1;
        private static final DurationDistanceMatrix DEFAULT_INSTANCE;
        private static final Parser<DurationDistanceMatrix> PARSER;

        private DurationDistanceMatrix(GeneratedMessage.Builder<?> builder) {
            super(builder);
        }

        private DurationDistanceMatrix() {
            this.rows_ = Collections.emptyList();
            this.vehicleStartTag_ = "";
        }

        public static final Descriptors.Descriptor getDescriptor() {
            return RouteOptimizationServiceProto.internal_static_google_maps_routeoptimization_v1_ShipmentModel_DurationDistanceMatrix_descriptor;
        }

        protected GeneratedMessage.FieldAccessorTable internalGetFieldAccessorTable() {
            return RouteOptimizationServiceProto.internal_static_google_maps_routeoptimization_v1_ShipmentModel_DurationDistanceMatrix_fieldAccessorTable.ensureFieldAccessorsInitialized(DurationDistanceMatrix.class, Builder.class);
        }

        @Override
        public List<Row> getRowsList() {
            return this.rows_;
        }

        @Override
        public List<? extends RowOrBuilder> getRowsOrBuilderList() {
            return this.rows_;
        }

        @Override
        public int getRowsCount() {
            return this.rows_.size();
        }

        @Override
        public Row getRows(int index) {
            return this.rows_.get(index);
        }

        @Override
        public RowOrBuilder getRowsOrBuilder(int index) {
            return this.rows_.get(index);
        }

        @Override
        public String getVehicleStartTag() {
            Object ref = this.vehicleStartTag_;
            if (ref instanceof String) {
                return (String)ref;
            }
            ByteString bs = (ByteString)ref;
            String s = bs.toStringUtf8();
            this.vehicleStartTag_ = s;
            return s;
        }

        @Override
        public ByteString getVehicleStartTagBytes() {
            Object ref = this.vehicleStartTag_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.vehicleStartTag_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public final boolean isInitialized() {
            byte isInitialized = this.memoizedIsInitialized;
            if (isInitialized == 1) {
                return true;
            }
            if (isInitialized == 0) {
                return false;
            }
            this.memoizedIsInitialized = 1;
            return true;
        }

        public void writeTo(CodedOutputStream output) throws IOException {
            for (int i = 0; i < this.rows_.size(); ++i) {
                output.writeMessage(1, (MessageLite)this.rows_.get(i));
            }
            if (!GeneratedMessage.isStringEmpty((Object)this.vehicleStartTag_)) {
                GeneratedMessage.writeString((CodedOutputStream)output, (int)2, (Object)this.vehicleStartTag_);
            }
            this.getUnknownFields().writeTo(output);
        }

        public int getSerializedSize() {
            int size = this.memoizedSize;
            if (size != -1) {
                return size;
            }
            size = 0;
            for (int i = 0; i < this.rows_.size(); ++i) {
                size += CodedOutputStream.computeMessageSize((int)1, (MessageLite)((MessageLite)this.rows_.get(i)));
            }
            if (!GeneratedMessage.isStringEmpty((Object)this.vehicleStartTag_)) {
                size += GeneratedMessage.computeStringSize((int)2, (Object)this.vehicleStartTag_);
            }
            this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
            return size;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof DurationDistanceMatrix)) {
                return super.equals(obj);
            }
            DurationDistanceMatrix other = (DurationDistanceMatrix)obj;
            if (!this.getRowsList().equals(other.getRowsList())) {
                return false;
            }
            if (!this.getVehicleStartTag().equals(other.getVehicleStartTag())) {
                return false;
            }
            return this.getUnknownFields().equals((Object)other.getUnknownFields());
        }

        public int hashCode() {
            if (this.memoizedHashCode != 0) {
                return this.memoizedHashCode;
            }
            int hash = 41;
            hash = 19 * hash + DurationDistanceMatrix.getDescriptor().hashCode();
            if (this.getRowsCount() > 0) {
                hash = 37 * hash + 1;
                hash = 53 * hash + this.getRowsList().hashCode();
            }
            hash = 37 * hash + 2;
            hash = 53 * hash + this.getVehicleStartTag().hashCode();
            this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
            return hash;
        }

        public static DurationDistanceMatrix parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
            return (DurationDistanceMatrix)PARSER.parseFrom(data);
        }

        public static DurationDistanceMatrix parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (DurationDistanceMatrix)PARSER.parseFrom(data, extensionRegistry);
        }

        public static DurationDistanceMatrix parseFrom(ByteString data) throws InvalidProtocolBufferException {
            return (DurationDistanceMatrix)PARSER.parseFrom(data);
        }

        public static DurationDistanceMatrix parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (DurationDistanceMatrix)PARSER.parseFrom(data, extensionRegistry);
        }

        public static DurationDistanceMatrix parseFrom(byte[] data) throws InvalidProtocolBufferException {
            return (DurationDistanceMatrix)PARSER.parseFrom(data);
        }

        public static DurationDistanceMatrix parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (DurationDistanceMatrix)PARSER.parseFrom(data, extensionRegistry);
        }

        public static DurationDistanceMatrix parseFrom(InputStream input) throws IOException {
            return (DurationDistanceMatrix)GeneratedMessage.parseWithIOException(PARSER, (InputStream)input);
        }

        public static DurationDistanceMatrix parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (DurationDistanceMatrix)GeneratedMessage.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static DurationDistanceMatrix parseDelimitedFrom(InputStream input) throws IOException {
            return (DurationDistanceMatrix)GeneratedMessage.parseDelimitedWithIOException(PARSER, (InputStream)input);
        }

        public static DurationDistanceMatrix parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (DurationDistanceMatrix)GeneratedMessage.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static DurationDistanceMatrix parseFrom(CodedInputStream input) throws IOException {
            return (DurationDistanceMatrix)GeneratedMessage.parseWithIOException(PARSER, (CodedInputStream)input);
        }

        public static DurationDistanceMatrix parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (DurationDistanceMatrix)GeneratedMessage.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public Builder newBuilderForType() {
            return DurationDistanceMatrix.newBuilder();
        }

        public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(DurationDistanceMatrix prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        public Builder toBuilder() {
            return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        protected Builder newBuilderForType(AbstractMessage.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
        }

        public static DurationDistanceMatrix getDefaultInstance() {
            return DEFAULT_INSTANCE;
        }

        public static Parser<DurationDistanceMatrix> parser() {
            return PARSER;
        }

        public Parser<DurationDistanceMatrix> getParserForType() {
            return PARSER;
        }

        public DurationDistanceMatrix getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
        }

        static {
            RuntimeVersion.validateProtobufGencodeVersion((RuntimeVersion.RuntimeDomain)RuntimeVersion.RuntimeDomain.PUBLIC, (int)4, (int)33, (int)0, (String)"", (String)"DurationDistanceMatrix");
            DEFAULT_INSTANCE = new DurationDistanceMatrix();
            PARSER = new AbstractParser<DurationDistanceMatrix>(){

                public DurationDistanceMatrix parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                    Builder builder = DurationDistanceMatrix.newBuilder();
                    try {
                        builder.mergeFrom(input, extensionRegistry);
                    }
                    catch (InvalidProtocolBufferException e) {
                        throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
                    }
                    catch (UninitializedMessageException e) {
                        throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
                    }
                    catch (IOException e) {
                        throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
                    }
                    return builder.buildPartial();
                }
            };
        }

        public static final class Builder
        extends GeneratedMessage.Builder<Builder>
        implements DurationDistanceMatrixOrBuilder {
            private int bitField0_;
            private List<Row> rows_ = Collections.emptyList();
            private RepeatedFieldBuilder<Row, Row.Builder, RowOrBuilder> rowsBuilder_;
            private Object vehicleStartTag_ = "";

            public static final Descriptors.Descriptor getDescriptor() {
                return RouteOptimizationServiceProto.internal_static_google_maps_routeoptimization_v1_ShipmentModel_DurationDistanceMatrix_descriptor;
            }

            protected GeneratedMessage.FieldAccessorTable internalGetFieldAccessorTable() {
                return RouteOptimizationServiceProto.internal_static_google_maps_routeoptimization_v1_ShipmentModel_DurationDistanceMatrix_fieldAccessorTable.ensureFieldAccessorsInitialized(DurationDistanceMatrix.class, Builder.class);
            }

            private Builder() {
            }

            private Builder(AbstractMessage.BuilderParent parent) {
                super(parent);
            }

            public Builder clear() {
                super.clear();
                this.bitField0_ = 0;
                if (this.rowsBuilder_ == null) {
                    this.rows_ = Collections.emptyList();
                } else {
                    this.rows_ = null;
                    this.rowsBuilder_.clear();
                }
                this.bitField0_ &= 0xFFFFFFFE;
                this.vehicleStartTag_ = "";
                return this;
            }

            public Descriptors.Descriptor getDescriptorForType() {
                return RouteOptimizationServiceProto.internal_static_google_maps_routeoptimization_v1_ShipmentModel_DurationDistanceMatrix_descriptor;
            }

            public DurationDistanceMatrix getDefaultInstanceForType() {
                return DurationDistanceMatrix.getDefaultInstance();
            }

            public DurationDistanceMatrix build() {
                DurationDistanceMatrix result = this.buildPartial();
                if (!result.isInitialized()) {
                    throw Builder.newUninitializedMessageException((Message)result);
                }
                return result;
            }

            public DurationDistanceMatrix buildPartial() {
                DurationDistanceMatrix result = new DurationDistanceMatrix(this);
                this.buildPartialRepeatedFields(result);
                if (this.bitField0_ != 0) {
                    this.buildPartial0(result);
                }
                this.onBuilt();
                return result;
            }

            private void buildPartialRepeatedFields(DurationDistanceMatrix result) {
                if (this.rowsBuilder_ == null) {
                    if ((this.bitField0_ & 1) != 0) {
                        this.rows_ = Collections.unmodifiableList(this.rows_);
                        this.bitField0_ &= 0xFFFFFFFE;
                    }
                    result.rows_ = this.rows_;
                } else {
                    result.rows_ = this.rowsBuilder_.build();
                }
            }

            private void buildPartial0(DurationDistanceMatrix result) {
                int from_bitField0_ = this.bitField0_;
                if ((from_bitField0_ & 2) != 0) {
                    result.vehicleStartTag_ = this.vehicleStartTag_;
                }
            }

            public Builder mergeFrom(Message other) {
                if (other instanceof DurationDistanceMatrix) {
                    return this.mergeFrom((DurationDistanceMatrix)other);
                }
                super.mergeFrom(other);
                return this;
            }

            public Builder mergeFrom(DurationDistanceMatrix other) {
                if (other == DurationDistanceMatrix.getDefaultInstance()) {
                    return this;
                }
                if (this.rowsBuilder_ == null) {
                    if (!other.rows_.isEmpty()) {
                        if (this.rows_.isEmpty()) {
                            this.rows_ = other.rows_;
                            this.bitField0_ &= 0xFFFFFFFE;
                        } else {
                            this.ensureRowsIsMutable();
                            this.rows_.addAll(other.rows_);
                        }
                        this.onChanged();
                    }
                } else if (!other.rows_.isEmpty()) {
                    if (this.rowsBuilder_.isEmpty()) {
                        this.rowsBuilder_.dispose();
                        this.rowsBuilder_ = null;
                        this.rows_ = other.rows_;
                        this.bitField0_ &= 0xFFFFFFFE;
                        this.rowsBuilder_ = alwaysUseFieldBuilders ? this.internalGetRowsFieldBuilder() : null;
                    } else {
                        this.rowsBuilder_.addAllMessages((Iterable)other.rows_);
                    }
                }
                if (!other.getVehicleStartTag().isEmpty()) {
                    this.vehicleStartTag_ = other.vehicleStartTag_;
                    this.bitField0_ |= 2;
                    this.onChanged();
                }
                this.mergeUnknownFields(other.getUnknownFields());
                this.onChanged();
                return this;
            }

            public final boolean isInitialized() {
                return true;
            }

            public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                if (extensionRegistry == null) {
                    throw new NullPointerException();
                }
                try {
                    boolean done = false;
                    block10: while (!done) {
                        int tag = input.readTag();
                        switch (tag) {
                            case 0: {
                                done = true;
                                continue block10;
                            }
                            case 10: {
                                Row m = (Row)input.readMessage(Row.parser(), extensionRegistry);
                                if (this.rowsBuilder_ == null) {
                                    this.ensureRowsIsMutable();
                                    this.rows_.add(m);
                                    continue block10;
                                }
                                this.rowsBuilder_.addMessage((GeneratedMessage)m);
                                continue block10;
                            }
                            case 18: {
                                this.vehicleStartTag_ = input.readStringRequireUtf8();
                                this.bitField0_ |= 2;
                                continue block10;
                            }
                        }
                        if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                        done = true;
                    }
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.unwrapIOException();
                }
                finally {
                    this.onChanged();
                }
                return this;
            }

            private void ensureRowsIsMutable() {
                if ((this.bitField0_ & 1) == 0) {
                    this.rows_ = new ArrayList<Row>(this.rows_);
                    this.bitField0_ |= 1;
                }
            }

            @Override
            public List<Row> getRowsList() {
                if (this.rowsBuilder_ == null) {
                    return Collections.unmodifiableList(this.rows_);
                }
                return this.rowsBuilder_.getMessageList();
            }

            @Override
            public int getRowsCount() {
                if (this.rowsBuilder_ == null) {
                    return this.rows_.size();
                }
                return this.rowsBuilder_.getCount();
            }

            @Override
            public Row getRows(int index) {
                if (this.rowsBuilder_ == null) {
                    return this.rows_.get(index);
                }
                return (Row)this.rowsBuilder_.getMessage(index);
            }

            public Builder setRows(int index, Row value) {
                if (this.rowsBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.ensureRowsIsMutable();
                    this.rows_.set(index, value);
                    this.onChanged();
                } else {
                    this.rowsBuilder_.setMessage(index, (GeneratedMessage)value);
                }
                return this;
            }

            public Builder setRows(int index, Row.Builder builderForValue) {
                if (this.rowsBuilder_ == null) {
                    this.ensureRowsIsMutable();
                    this.rows_.set(index, builderForValue.build());
                    this.onChanged();
                } else {
                    this.rowsBuilder_.setMessage(index, (GeneratedMessage)builderForValue.build());
                }
                return this;
            }

            public Builder addRows(Row value) {
                if (this.rowsBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.ensureRowsIsMutable();
                    this.rows_.add(value);
                    this.onChanged();
                } else {
                    this.rowsBuilder_.addMessage((GeneratedMessage)value);
                }
                return this;
            }

            public Builder addRows(int index, Row value) {
                if (this.rowsBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.ensureRowsIsMutable();
                    this.rows_.add(index, value);
                    this.onChanged();
                } else {
                    this.rowsBuilder_.addMessage(index, (GeneratedMessage)value);
                }
                return this;
            }

            public Builder addRows(Row.Builder builderForValue) {
                if (this.rowsBuilder_ == null) {
                    this.ensureRowsIsMutable();
                    this.rows_.add(builderForValue.build());
                    this.onChanged();
                } else {
                    this.rowsBuilder_.addMessage((GeneratedMessage)builderForValue.build());
                }
                return this;
            }

            public Builder addRows(int index, Row.Builder builderForValue) {
                if (this.rowsBuilder_ == null) {
                    this.ensureRowsIsMutable();
                    this.rows_.add(index, builderForValue.build());
                    this.onChanged();
                } else {
                    this.rowsBuilder_.addMessage(index, (GeneratedMessage)builderForValue.build());
                }
                return this;
            }

            public Builder addAllRows(Iterable<? extends Row> values) {
                if (this.rowsBuilder_ == null) {
                    this.ensureRowsIsMutable();
                    AbstractMessageLite.Builder.addAll(values, this.rows_);
                    this.onChanged();
                } else {
                    this.rowsBuilder_.addAllMessages(values);
                }
                return this;
            }

            public Builder clearRows() {
                if (this.rowsBuilder_ == null) {
                    this.rows_ = Collections.emptyList();
                    this.bitField0_ &= 0xFFFFFFFE;
                    this.onChanged();
                } else {
                    this.rowsBuilder_.clear();
                }
                return this;
            }

            public Builder removeRows(int index) {
                if (this.rowsBuilder_ == null) {
                    this.ensureRowsIsMutable();
                    this.rows_.remove(index);
                    this.onChanged();
                } else {
                    this.rowsBuilder_.remove(index);
                }
                return this;
            }

            public Row.Builder getRowsBuilder(int index) {
                return (Row.Builder)this.internalGetRowsFieldBuilder().getBuilder(index);
            }

            @Override
            public RowOrBuilder getRowsOrBuilder(int index) {
                if (this.rowsBuilder_ == null) {
                    return this.rows_.get(index);
                }
                return (RowOrBuilder)this.rowsBuilder_.getMessageOrBuilder(index);
            }

            @Override
            public List<? extends RowOrBuilder> getRowsOrBuilderList() {
                if (this.rowsBuilder_ != null) {
                    return this.rowsBuilder_.getMessageOrBuilderList();
                }
                return Collections.unmodifiableList(this.rows_);
            }

            public Row.Builder addRowsBuilder() {
                return (Row.Builder)this.internalGetRowsFieldBuilder().addBuilder((GeneratedMessage)Row.getDefaultInstance());
            }

            public Row.Builder addRowsBuilder(int index) {
                return (Row.Builder)this.internalGetRowsFieldBuilder().addBuilder(index, (GeneratedMessage)Row.getDefaultInstance());
            }

            public List<Row.Builder> getRowsBuilderList() {
                return this.internalGetRowsFieldBuilder().getBuilderList();
            }

            private RepeatedFieldBuilder<Row, Row.Builder, RowOrBuilder> internalGetRowsFieldBuilder() {
                if (this.rowsBuilder_ == null) {
                    this.rowsBuilder_ = new RepeatedFieldBuilder(this.rows_, (this.bitField0_ & 1) != 0, this.getParentForChildren(), this.isClean());
                    this.rows_ = null;
                }
                return this.rowsBuilder_;
            }

            @Override
            public String getVehicleStartTag() {
                Object ref = this.vehicleStartTag_;
                if (!(ref instanceof String)) {
                    ByteString bs = (ByteString)ref;
                    String s = bs.toStringUtf8();
                    this.vehicleStartTag_ = s;
                    return s;
                }
                return (String)ref;
            }

            @Override
            public ByteString getVehicleStartTagBytes() {
                Object ref = this.vehicleStartTag_;
                if (ref instanceof String) {
                    ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                    this.vehicleStartTag_ = b;
                    return b;
                }
                return (ByteString)ref;
            }

            public Builder setVehicleStartTag(String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.vehicleStartTag_ = value;
                this.bitField0_ |= 2;
                this.onChanged();
                return this;
            }

            public Builder clearVehicleStartTag() {
                this.vehicleStartTag_ = DurationDistanceMatrix.getDefaultInstance().getVehicleStartTag();
                this.bitField0_ &= 0xFFFFFFFD;
                this.onChanged();
                return this;
            }

            public Builder setVehicleStartTagBytes(ByteString value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                DurationDistanceMatrix.checkByteStringIsUtf8((ByteString)value);
                this.vehicleStartTag_ = value;
                this.bitField0_ |= 2;
                this.onChanged();
                return this;
            }
        }

        public static final class Row
        extends GeneratedMessage
        implements RowOrBuilder {
            private static final long serialVersionUID = 0L;
            public static final int DURATIONS_FIELD_NUMBER = 1;
            private List<Duration> durations_;
            public static final int METERS_FIELD_NUMBER = 2;
            private Internal.DoubleList meters_ = Row.emptyDoubleList();
            private int metersMemoizedSerializedSize = -1;
            private byte memoizedIsInitialized = (byte)-1;
            private static final Row DEFAULT_INSTANCE;
            private static final Parser<Row> PARSER;

            private Row(GeneratedMessage.Builder<?> builder) {
                super(builder);
            }

            private Row() {
                this.durations_ = Collections.emptyList();
                this.meters_ = Row.emptyDoubleList();
            }

            public static final Descriptors.Descriptor getDescriptor() {
                return RouteOptimizationServiceProto.internal_static_google_maps_routeoptimization_v1_ShipmentModel_DurationDistanceMatrix_Row_descriptor;
            }

            protected GeneratedMessage.FieldAccessorTable internalGetFieldAccessorTable() {
                return RouteOptimizationServiceProto.internal_static_google_maps_routeoptimization_v1_ShipmentModel_DurationDistanceMatrix_Row_fieldAccessorTable.ensureFieldAccessorsInitialized(Row.class, Builder.class);
            }

            @Override
            public List<Duration> getDurationsList() {
                return this.durations_;
            }

            @Override
            public List<? extends DurationOrBuilder> getDurationsOrBuilderList() {
                return this.durations_;
            }

            @Override
            public int getDurationsCount() {
                return this.durations_.size();
            }

            @Override
            public Duration getDurations(int index) {
                return this.durations_.get(index);
            }

            @Override
            public DurationOrBuilder getDurationsOrBuilder(int index) {
                return (DurationOrBuilder)this.durations_.get(index);
            }

            @Override
            public List<Double> getMetersList() {
                return this.meters_;
            }

            @Override
            public int getMetersCount() {
                return this.meters_.size();
            }

            @Override
            public double getMeters(int index) {
                return this.meters_.getDouble(index);
            }

            public final boolean isInitialized() {
                byte isInitialized = this.memoizedIsInitialized;
                if (isInitialized == 1) {
                    return true;
                }
                if (isInitialized == 0) {
                    return false;
                }
                this.memoizedIsInitialized = 1;
                return true;
            }

            public void writeTo(CodedOutputStream output) throws IOException {
                int i;
                this.getSerializedSize();
                for (i = 0; i < this.durations_.size(); ++i) {
                    output.writeMessage(1, (MessageLite)this.durations_.get(i));
                }
                if (this.getMetersList().size() > 0) {
                    output.writeUInt32NoTag(18);
                    output.writeUInt32NoTag(this.metersMemoizedSerializedSize);
                }
                for (i = 0; i < this.meters_.size(); ++i) {
                    output.writeDoubleNoTag(this.meters_.getDouble(i));
                }
                this.getUnknownFields().writeTo(output);
            }

            public int getSerializedSize() {
                int size = this.memoizedSize;
                if (size != -1) {
                    return size;
                }
                size = 0;
                for (int i = 0; i < this.durations_.size(); ++i) {
                    size += CodedOutputStream.computeMessageSize((int)1, (MessageLite)((MessageLite)this.durations_.get(i)));
                }
                int dataSize = 0;
                dataSize = 8 * this.getMetersList().size();
                size += dataSize;
                if (!this.getMetersList().isEmpty()) {
                    ++size;
                    size += CodedOutputStream.computeInt32SizeNoTag((int)dataSize);
                }
                this.metersMemoizedSerializedSize = dataSize;
                this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
                return size;
            }

            public boolean equals(Object obj) {
                if (obj == this) {
                    return true;
                }
                if (!(obj instanceof Row)) {
                    return super.equals(obj);
                }
                Row other = (Row)obj;
                if (!this.getDurationsList().equals(other.getDurationsList())) {
                    return false;
                }
                if (!this.getMetersList().equals(other.getMetersList())) {
                    return false;
                }
                return this.getUnknownFields().equals((Object)other.getUnknownFields());
            }

            public int hashCode() {
                if (this.memoizedHashCode != 0) {
                    return this.memoizedHashCode;
                }
                int hash = 41;
                hash = 19 * hash + Row.getDescriptor().hashCode();
                if (this.getDurationsCount() > 0) {
                    hash = 37 * hash + 1;
                    hash = 53 * hash + this.getDurationsList().hashCode();
                }
                if (this.getMetersCount() > 0) {
                    hash = 37 * hash + 2;
                    hash = 53 * hash + this.getMetersList().hashCode();
                }
                this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
                return hash;
            }

            public static Row parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
                return (Row)PARSER.parseFrom(data);
            }

            public static Row parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                return (Row)PARSER.parseFrom(data, extensionRegistry);
            }

            public static Row parseFrom(ByteString data) throws InvalidProtocolBufferException {
                return (Row)PARSER.parseFrom(data);
            }

            public static Row parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                return (Row)PARSER.parseFrom(data, extensionRegistry);
            }

            public static Row parseFrom(byte[] data) throws InvalidProtocolBufferException {
                return (Row)PARSER.parseFrom(data);
            }

            public static Row parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                return (Row)PARSER.parseFrom(data, extensionRegistry);
            }

            public static Row parseFrom(InputStream input) throws IOException {
                return (Row)GeneratedMessage.parseWithIOException(PARSER, (InputStream)input);
            }

            public static Row parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                return (Row)GeneratedMessage.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
            }

            public static Row parseDelimitedFrom(InputStream input) throws IOException {
                return (Row)GeneratedMessage.parseDelimitedWithIOException(PARSER, (InputStream)input);
            }

            public static Row parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                return (Row)GeneratedMessage.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
            }

            public static Row parseFrom(CodedInputStream input) throws IOException {
                return (Row)GeneratedMessage.parseWithIOException(PARSER, (CodedInputStream)input);
            }

            public static Row parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                return (Row)GeneratedMessage.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
            }

            public Builder newBuilderForType() {
                return Row.newBuilder();
            }

            public static Builder newBuilder() {
                return DEFAULT_INSTANCE.toBuilder();
            }

            public static Builder newBuilder(Row prototype) {
                return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
            }

            public Builder toBuilder() {
                return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
            }

            protected Builder newBuilderForType(AbstractMessage.BuilderParent parent) {
                Builder builder = new Builder(parent);
                return builder;
            }

            public static Row getDefaultInstance() {
                return DEFAULT_INSTANCE;
            }

            public static Parser<Row> parser() {
                return PARSER;
            }

            public Parser<Row> getParserForType() {
                return PARSER;
            }

            public Row getDefaultInstanceForType() {
                return DEFAULT_INSTANCE;
            }

            static /* synthetic */ Internal.DoubleList access$1300() {
                return Row.emptyDoubleList();
            }

            static {
                RuntimeVersion.validateProtobufGencodeVersion((RuntimeVersion.RuntimeDomain)RuntimeVersion.RuntimeDomain.PUBLIC, (int)4, (int)33, (int)0, (String)"", (String)"Row");
                DEFAULT_INSTANCE = new Row();
                PARSER = new AbstractParser<Row>(){

                    public Row parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                        Builder builder = Row.newBuilder();
                        try {
                            builder.mergeFrom(input, extensionRegistry);
                        }
                        catch (InvalidProtocolBufferException e) {
                            throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
                        }
                        catch (UninitializedMessageException e) {
                            throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
                        }
                        catch (IOException e) {
                            throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
                        }
                        return builder.buildPartial();
                    }
                };
            }

            public static final class Builder
            extends GeneratedMessage.Builder<Builder>
            implements RowOrBuilder {
                private int bitField0_;
                private List<Duration> durations_ = Collections.emptyList();
                private RepeatedFieldBuilder<Duration, Duration.Builder, DurationOrBuilder> durationsBuilder_;
                private Internal.DoubleList meters_ = Row.access$1300();

                public static final Descriptors.Descriptor getDescriptor() {
                    return RouteOptimizationServiceProto.internal_static_google_maps_routeoptimization_v1_ShipmentModel_DurationDistanceMatrix_Row_descriptor;
                }

                protected GeneratedMessage.FieldAccessorTable internalGetFieldAccessorTable() {
                    return RouteOptimizationServiceProto.internal_static_google_maps_routeoptimization_v1_ShipmentModel_DurationDistanceMatrix_Row_fieldAccessorTable.ensureFieldAccessorsInitialized(Row.class, Builder.class);
                }

                private Builder() {
                }

                private Builder(AbstractMessage.BuilderParent parent) {
                    super(parent);
                }

                public Builder clear() {
                    super.clear();
                    this.bitField0_ = 0;
                    if (this.durationsBuilder_ == null) {
                        this.durations_ = Collections.emptyList();
                    } else {
                        this.durations_ = null;
                        this.durationsBuilder_.clear();
                    }
                    this.bitField0_ &= 0xFFFFFFFE;
                    this.meters_ = Row.emptyDoubleList();
                    return this;
                }

                public Descriptors.Descriptor getDescriptorForType() {
                    return RouteOptimizationServiceProto.internal_static_google_maps_routeoptimization_v1_ShipmentModel_DurationDistanceMatrix_Row_descriptor;
                }

                public Row getDefaultInstanceForType() {
                    return Row.getDefaultInstance();
                }

                public Row build() {
                    Row result = this.buildPartial();
                    if (!result.isInitialized()) {
                        throw Builder.newUninitializedMessageException((Message)result);
                    }
                    return result;
                }

                public Row buildPartial() {
                    Row result = new Row(this);
                    this.buildPartialRepeatedFields(result);
                    if (this.bitField0_ != 0) {
                        this.buildPartial0(result);
                    }
                    this.onBuilt();
                    return result;
                }

                private void buildPartialRepeatedFields(Row result) {
                    if (this.durationsBuilder_ == null) {
                        if ((this.bitField0_ & 1) != 0) {
                            this.durations_ = Collections.unmodifiableList(this.durations_);
                            this.bitField0_ &= 0xFFFFFFFE;
                        }
                        result.durations_ = this.durations_;
                    } else {
                        result.durations_ = this.durationsBuilder_.build();
                    }
                }

                private void buildPartial0(Row result) {
                    int from_bitField0_ = this.bitField0_;
                    if ((from_bitField0_ & 2) != 0) {
                        this.meters_.makeImmutable();
                        result.meters_ = this.meters_;
                    }
                }

                public Builder mergeFrom(Message other) {
                    if (other instanceof Row) {
                        return this.mergeFrom((Row)other);
                    }
                    super.mergeFrom(other);
                    return this;
                }

                public Builder mergeFrom(Row other) {
                    if (other == Row.getDefaultInstance()) {
                        return this;
                    }
                    if (this.durationsBuilder_ == null) {
                        if (!other.durations_.isEmpty()) {
                            if (this.durations_.isEmpty()) {
                                this.durations_ = other.durations_;
                                this.bitField0_ &= 0xFFFFFFFE;
                            } else {
                                this.ensureDurationsIsMutable();
                                this.durations_.addAll(other.durations_);
                            }
                            this.onChanged();
                        }
                    } else if (!other.durations_.isEmpty()) {
                        if (this.durationsBuilder_.isEmpty()) {
                            this.durationsBuilder_.dispose();
                            this.durationsBuilder_ = null;
                            this.durations_ = other.durations_;
                            this.bitField0_ &= 0xFFFFFFFE;
                            this.durationsBuilder_ = alwaysUseFieldBuilders ? this.internalGetDurationsFieldBuilder() : null;
                        } else {
                            this.durationsBuilder_.addAllMessages((Iterable)other.durations_);
                        }
                    }
                    if (!other.meters_.isEmpty()) {
                        if (this.meters_.isEmpty()) {
                            this.meters_ = other.meters_;
                            this.meters_.makeImmutable();
                            this.bitField0_ |= 2;
                        } else {
                            this.ensureMetersIsMutable();
                            this.meters_.addAll((Collection)other.meters_);
                        }
                        this.onChanged();
                    }
                    this.mergeUnknownFields(other.getUnknownFields());
                    this.onChanged();
                    return this;
                }

                public final boolean isInitialized() {
                    return true;
                }

                public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                    if (extensionRegistry == null) {
                        throw new NullPointerException();
                    }
                    try {
                        boolean done = false;
                        block11: while (!done) {
                            int tag = input.readTag();
                            switch (tag) {
                                case 0: {
                                    done = true;
                                    continue block11;
                                }
                                case 10: {
                                    Duration m = (Duration)input.readMessage(Duration.parser(), extensionRegistry);
                                    if (this.durationsBuilder_ == null) {
                                        this.ensureDurationsIsMutable();
                                        this.durations_.add(m);
                                        continue block11;
                                    }
                                    this.durationsBuilder_.addMessage((GeneratedMessage)m);
                                    continue block11;
                                }
                                case 17: {
                                    double v = input.readDouble();
                                    this.ensureMetersIsMutable();
                                    this.meters_.addDouble(v);
                                    continue block11;
                                }
                                case 18: {
                                    int length = input.readRawVarint32();
                                    int limit = input.pushLimit(length);
                                    int alloc = length > 4096 ? 4096 : length;
                                    this.ensureMetersIsMutable(alloc / 8);
                                    while (input.getBytesUntilLimit() > 0) {
                                        this.meters_.addDouble(input.readDouble());
                                    }
                                    input.popLimit(limit);
                                    continue block11;
                                }
                            }
                            if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                            done = true;
                        }
                    }
                    catch (InvalidProtocolBufferException e) {
                        throw e.unwrapIOException();
                    }
                    finally {
                        this.onChanged();
                    }
                    return this;
                }

                private void ensureDurationsIsMutable() {
                    if ((this.bitField0_ & 1) == 0) {
                        this.durations_ = new ArrayList<Duration>(this.durations_);
                        this.bitField0_ |= 1;
                    }
                }

                @Override
                public List<Duration> getDurationsList() {
                    if (this.durationsBuilder_ == null) {
                        return Collections.unmodifiableList(this.durations_);
                    }
                    return this.durationsBuilder_.getMessageList();
                }

                @Override
                public int getDurationsCount() {
                    if (this.durationsBuilder_ == null) {
                        return this.durations_.size();
                    }
                    return this.durationsBuilder_.getCount();
                }

                @Override
                public Duration getDurations(int index) {
                    if (this.durationsBuilder_ == null) {
                        return this.durations_.get(index);
                    }
                    return (Duration)this.durationsBuilder_.getMessage(index);
                }

                public Builder setDurations(int index, Duration value) {
                    if (this.durationsBuilder_ == null) {
                        if (value == null) {
                            throw new NullPointerException();
                        }
                        this.ensureDurationsIsMutable();
                        this.durations_.set(index, value);
                        this.onChanged();
                    } else {
                        this.durationsBuilder_.setMessage(index, (GeneratedMessage)value);
                    }
                    return this;
                }

                public Builder setDurations(int index, Duration.Builder builderForValue) {
                    if (this.durationsBuilder_ == null) {
                        this.ensureDurationsIsMutable();
                        this.durations_.set(index, builderForValue.build());
                        this.onChanged();
                    } else {
                        this.durationsBuilder_.setMessage(index, (GeneratedMessage)builderForValue.build());
                    }
                    return this;
                }

                public Builder addDurations(Duration value) {
                    if (this.durationsBuilder_ == null) {
                        if (value == null) {
                            throw new NullPointerException();
                        }
                        this.ensureDurationsIsMutable();
                        this.durations_.add(value);
                        this.onChanged();
                    } else {
                        this.durationsBuilder_.addMessage((GeneratedMessage)value);
                    }
                    return this;
                }

                public Builder addDurations(int index, Duration value) {
                    if (this.durationsBuilder_ == null) {
                        if (value == null) {
                            throw new NullPointerException();
                        }
                        this.ensureDurationsIsMutable();
                        this.durations_.add(index, value);
                        this.onChanged();
                    } else {
                        this.durationsBuilder_.addMessage(index, (GeneratedMessage)value);
                    }
                    return this;
                }

                public Builder addDurations(Duration.Builder builderForValue) {
                    if (this.durationsBuilder_ == null) {
                        this.ensureDurationsIsMutable();
                        this.durations_.add(builderForValue.build());
                        this.onChanged();
                    } else {
                        this.durationsBuilder_.addMessage((GeneratedMessage)builderForValue.build());
                    }
                    return this;
                }

                public Builder addDurations(int index, Duration.Builder builderForValue) {
                    if (this.durationsBuilder_ == null) {
                        this.ensureDurationsIsMutable();
                        this.durations_.add(index, builderForValue.build());
                        this.onChanged();
                    } else {
                        this.durationsBuilder_.addMessage(index, (GeneratedMessage)builderForValue.build());
                    }
                    return this;
                }

                public Builder addAllDurations(Iterable<? extends Duration> values) {
                    if (this.durationsBuilder_ == null) {
                        this.ensureDurationsIsMutable();
                        AbstractMessageLite.Builder.addAll(values, this.durations_);
                        this.onChanged();
                    } else {
                        this.durationsBuilder_.addAllMessages(values);
                    }
                    return this;
                }

                public Builder clearDurations() {
                    if (this.durationsBuilder_ == null) {
                        this.durations_ = Collections.emptyList();
                        this.bitField0_ &= 0xFFFFFFFE;
                        this.onChanged();
                    } else {
                        this.durationsBuilder_.clear();
                    }
                    return this;
                }

                public Builder removeDurations(int index) {
                    if (this.durationsBuilder_ == null) {
                        this.ensureDurationsIsMutable();
                        this.durations_.remove(index);
                        this.onChanged();
                    } else {
                        this.durationsBuilder_.remove(index);
                    }
                    return this;
                }

                public Duration.Builder getDurationsBuilder(int index) {
                    return (Duration.Builder)this.internalGetDurationsFieldBuilder().getBuilder(index);
                }

                @Override
                public DurationOrBuilder getDurationsOrBuilder(int index) {
                    if (this.durationsBuilder_ == null) {
                        return (DurationOrBuilder)this.durations_.get(index);
                    }
                    return (DurationOrBuilder)this.durationsBuilder_.getMessageOrBuilder(index);
                }

                @Override
                public List<? extends DurationOrBuilder> getDurationsOrBuilderList() {
                    if (this.durationsBuilder_ != null) {
                        return this.durationsBuilder_.getMessageOrBuilderList();
                    }
                    return Collections.unmodifiableList(this.durations_);
                }

                public Duration.Builder addDurationsBuilder() {
                    return (Duration.Builder)this.internalGetDurationsFieldBuilder().addBuilder((GeneratedMessage)Duration.getDefaultInstance());
                }

                public Duration.Builder addDurationsBuilder(int index) {
                    return (Duration.Builder)this.internalGetDurationsFieldBuilder().addBuilder(index, (GeneratedMessage)Duration.getDefaultInstance());
                }

                public List<Duration.Builder> getDurationsBuilderList() {
                    return this.internalGetDurationsFieldBuilder().getBuilderList();
                }

                private RepeatedFieldBuilder<Duration, Duration.Builder, DurationOrBuilder> internalGetDurationsFieldBuilder() {
                    if (this.durationsBuilder_ == null) {
                        this.durationsBuilder_ = new RepeatedFieldBuilder(this.durations_, (this.bitField0_ & 1) != 0, this.getParentForChildren(), this.isClean());
                        this.durations_ = null;
                    }
                    return this.durationsBuilder_;
                }

                private void ensureMetersIsMutable() {
                    if (!this.meters_.isModifiable()) {
                        this.meters_ = (Internal.DoubleList)Row.makeMutableCopy((Internal.ProtobufList)((Internal.ProtobufList)this.meters_));
                    }
                    this.bitField0_ |= 2;
                }

                private void ensureMetersIsMutable(int capacity) {
                    if (!this.meters_.isModifiable()) {
                        this.meters_ = (Internal.DoubleList)Row.makeMutableCopy((Internal.ProtobufList)((Internal.ProtobufList)this.meters_), (int)capacity);
                    }
                    this.bitField0_ |= 2;
                }

                @Override
                public List<Double> getMetersList() {
                    this.meters_.makeImmutable();
                    return this.meters_;
                }

                @Override
                public int getMetersCount() {
                    return this.meters_.size();
                }

                @Override
                public double getMeters(int index) {
                    return this.meters_.getDouble(index);
                }

                public Builder setMeters(int index, double value) {
                    this.ensureMetersIsMutable();
                    this.meters_.setDouble(index, value);
                    this.bitField0_ |= 2;
                    this.onChanged();
                    return this;
                }

                public Builder addMeters(double value) {
                    this.ensureMetersIsMutable();
                    this.meters_.addDouble(value);
                    this.bitField0_ |= 2;
                    this.onChanged();
                    return this;
                }

                public Builder addAllMeters(Iterable<? extends Double> values) {
                    this.ensureMetersIsMutable();
                    AbstractMessageLite.Builder.addAll(values, (List)this.meters_);
                    this.bitField0_ |= 2;
                    this.onChanged();
                    return this;
                }

                public Builder clearMeters() {
                    this.meters_ = Row.emptyDoubleList();
                    this.bitField0_ &= 0xFFFFFFFD;
                    this.onChanged();
                    return this;
                }
            }
        }

        public static interface RowOrBuilder
        extends MessageOrBuilder {
            public List<Duration> getDurationsList();

            public Duration getDurations(int var1);

            public int getDurationsCount();

            public List<? extends DurationOrBuilder> getDurationsOrBuilderList();

            public DurationOrBuilder getDurationsOrBuilder(int var1);

            public List<Double> getMetersList();

            public int getMetersCount();

            public double getMeters(int var1);
        }
    }

    public static interface DurationDistanceMatrixOrBuilder
    extends MessageOrBuilder {
        public List<DurationDistanceMatrix.Row> getRowsList();

        public DurationDistanceMatrix.Row getRows(int var1);

        public int getRowsCount();

        public List<? extends DurationDistanceMatrix.RowOrBuilder> getRowsOrBuilderList();

        public DurationDistanceMatrix.RowOrBuilder getRowsOrBuilder(int var1);

        public String getVehicleStartTag();

        public ByteString getVehicleStartTagBytes();
    }

    public static final class Objective
    extends GeneratedMessage
    implements ObjectiveOrBuilder {
        private static final long serialVersionUID = 0L;
        private int bitField0_;
        public static final int TYPE_FIELD_NUMBER = 1;
        private int type_ = 0;
        public static final int WEIGHT_FIELD_NUMBER = 2;
        private double weight_ = 0.0;
        private byte memoizedIsInitialized = (byte)-1;
        private static final Objective DEFAULT_INSTANCE;
        private static final Parser<Objective> PARSER;

        private Objective(GeneratedMessage.Builder<?> builder) {
            super(builder);
        }

        private Objective() {
            this.type_ = 0;
        }

        public static final Descriptors.Descriptor getDescriptor() {
            return RouteOptimizationServiceProto.internal_static_google_maps_routeoptimization_v1_ShipmentModel_Objective_descriptor;
        }

        protected GeneratedMessage.FieldAccessorTable internalGetFieldAccessorTable() {
            return RouteOptimizationServiceProto.internal_static_google_maps_routeoptimization_v1_ShipmentModel_Objective_fieldAccessorTable.ensureFieldAccessorsInitialized(Objective.class, Builder.class);
        }

        @Override
        public boolean hasType() {
            return (this.bitField0_ & 1) != 0;
        }

        @Override
        public int getTypeValue() {
            return this.type_;
        }

        @Override
        public Type getType() {
            Type result = Type.forNumber(this.type_);
            return result == null ? Type.UNRECOGNIZED : result;
        }

        @Override
        public boolean hasWeight() {
            return (this.bitField0_ & 2) != 0;
        }

        @Override
        public double getWeight() {
            return this.weight_;
        }

        public final boolean isInitialized() {
            byte isInitialized = this.memoizedIsInitialized;
            if (isInitialized == 1) {
                return true;
            }
            if (isInitialized == 0) {
                return false;
            }
            this.memoizedIsInitialized = 1;
            return true;
        }

        public void writeTo(CodedOutputStream output) throws IOException {
            if ((this.bitField0_ & 1) != 0) {
                output.writeEnum(1, this.type_);
            }
            if ((this.bitField0_ & 2) != 0) {
                output.writeDouble(2, this.weight_);
            }
            this.getUnknownFields().writeTo(output);
        }

        public int getSerializedSize() {
            int size = this.memoizedSize;
            if (size != -1) {
                return size;
            }
            size = 0;
            if ((this.bitField0_ & 1) != 0) {
                size += CodedOutputStream.computeEnumSize((int)1, (int)this.type_);
            }
            if ((this.bitField0_ & 2) != 0) {
                size += CodedOutputStream.computeDoubleSize((int)2, (double)this.weight_);
            }
            this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
            return size;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Objective)) {
                return super.equals(obj);
            }
            Objective other = (Objective)obj;
            if (this.hasType() != other.hasType()) {
                return false;
            }
            if (this.hasType() && this.type_ != other.type_) {
                return false;
            }
            if (this.hasWeight() != other.hasWeight()) {
                return false;
            }
            if (this.hasWeight() && Double.doubleToLongBits(this.getWeight()) != Double.doubleToLongBits(other.getWeight())) {
                return false;
            }
            return this.getUnknownFields().equals((Object)other.getUnknownFields());
        }

        public int hashCode() {
            if (this.memoizedHashCode != 0) {
                return this.memoizedHashCode;
            }
            int hash = 41;
            hash = 19 * hash + Objective.getDescriptor().hashCode();
            if (this.hasType()) {
                hash = 37 * hash + 1;
                hash = 53 * hash + this.type_;
            }
            if (this.hasWeight()) {
                hash = 37 * hash + 2;
                hash = 53 * hash + Internal.hashLong((long)Double.doubleToLongBits(this.getWeight()));
            }
            this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
            return hash;
        }

        public static Objective parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
            return (Objective)PARSER.parseFrom(data);
        }

        public static Objective parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (Objective)PARSER.parseFrom(data, extensionRegistry);
        }

        public static Objective parseFrom(ByteString data) throws InvalidProtocolBufferException {
            return (Objective)PARSER.parseFrom(data);
        }

        public static Objective parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (Objective)PARSER.parseFrom(data, extensionRegistry);
        }

        public static Objective parseFrom(byte[] data) throws InvalidProtocolBufferException {
            return (Objective)PARSER.parseFrom(data);
        }

        public static Objective parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (Objective)PARSER.parseFrom(data, extensionRegistry);
        }

        public static Objective parseFrom(InputStream input) throws IOException {
            return (Objective)GeneratedMessage.parseWithIOException(PARSER, (InputStream)input);
        }

        public static Objective parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (Objective)GeneratedMessage.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static Objective parseDelimitedFrom(InputStream input) throws IOException {
            return (Objective)GeneratedMessage.parseDelimitedWithIOException(PARSER, (InputStream)input);
        }

        public static Objective parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (Objective)GeneratedMessage.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static Objective parseFrom(CodedInputStream input) throws IOException {
            return (Objective)GeneratedMessage.parseWithIOException(PARSER, (CodedInputStream)input);
        }

        public static Objective parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (Objective)GeneratedMessage.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public Builder newBuilderForType() {
            return Objective.newBuilder();
        }

        public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(Objective prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        public Builder toBuilder() {
            return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        protected Builder newBuilderForType(AbstractMessage.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
        }

        public static Objective getDefaultInstance() {
            return DEFAULT_INSTANCE;
        }

        public static Parser<Objective> parser() {
            return PARSER;
        }

        public Parser<Objective> getParserForType() {
            return PARSER;
        }

        public Objective getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
        }

        static {
            RuntimeVersion.validateProtobufGencodeVersion((RuntimeVersion.RuntimeDomain)RuntimeVersion.RuntimeDomain.PUBLIC, (int)4, (int)33, (int)0, (String)"", (String)"Objective");
            DEFAULT_INSTANCE = new Objective();
            PARSER = new AbstractParser<Objective>(){

                public Objective parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                    Builder builder = Objective.newBuilder();
                    try {
                        builder.mergeFrom(input, extensionRegistry);
                    }
                    catch (InvalidProtocolBufferException e) {
                        throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
                    }
                    catch (UninitializedMessageException e) {
                        throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
                    }
                    catch (IOException e) {
                        throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
                    }
                    return builder.buildPartial();
                }
            };
        }

        public static final class Builder
        extends GeneratedMessage.Builder<Builder>
        implements ObjectiveOrBuilder {
            private int bitField0_;
            private int type_ = 0;
            private double weight_;

            public static final Descriptors.Descriptor getDescriptor() {
                return RouteOptimizationServiceProto.internal_static_google_maps_routeoptimization_v1_ShipmentModel_Objective_descriptor;
            }

            protected GeneratedMessage.FieldAccessorTable internalGetFieldAccessorTable() {
                return RouteOptimizationServiceProto.internal_static_google_maps_routeoptimization_v1_ShipmentModel_Objective_fieldAccessorTable.ensureFieldAccessorsInitialized(Objective.class, Builder.class);
            }

            private Builder() {
            }

            private Builder(AbstractMessage.BuilderParent parent) {
                super(parent);
            }

            public Builder clear() {
                super.clear();
                this.bitField0_ = 0;
                this.type_ = 0;
                this.weight_ = 0.0;
                return this;
            }

            public Descriptors.Descriptor getDescriptorForType() {
                return RouteOptimizationServiceProto.internal_static_google_maps_routeoptimization_v1_ShipmentModel_Objective_descriptor;
            }

            public Objective getDefaultInstanceForType() {
                return Objective.getDefaultInstance();
            }

            public Objective build() {
                Objective result = this.buildPartial();
                if (!result.isInitialized()) {
                    throw Builder.newUninitializedMessageException((Message)result);
                }
                return result;
            }

            public Objective buildPartial() {
                Objective result = new Objective(this);
                if (this.bitField0_ != 0) {
                    this.buildPartial0(result);
                }
                this.onBuilt();
                return result;
            }

            private void buildPartial0(Objective result) {
                int from_bitField0_ = this.bitField0_;
                int to_bitField0_ = 0;
                if ((from_bitField0_ & 1) != 0) {
                    result.type_ = this.type_;
                    to_bitField0_ |= 1;
                }
                if ((from_bitField0_ & 2) != 0) {
                    result.weight_ = this.weight_;
                    to_bitField0_ |= 2;
                }
                Objective objective = result;
                objective.bitField0_ = objective.bitField0_ | to_bitField0_;
            }

            public Builder mergeFrom(Message other) {
                if (other instanceof Objective) {
                    return this.mergeFrom((Objective)other);
                }
                super.mergeFrom(other);
                return this;
            }

            public Builder mergeFrom(Objective other) {
                if (other == Objective.getDefaultInstance()) {
                    return this;
                }
                if (other.hasType()) {
                    this.setTypeValue(other.getTypeValue());
                }
                if (other.hasWeight()) {
                    this.setWeight(other.getWeight());
                }
                this.mergeUnknownFields(other.getUnknownFields());
                this.onChanged();
                return this;
            }

            public final boolean isInitialized() {
                return true;
            }

            public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                if (extensionRegistry == null) {
                    throw new NullPointerException();
                }
                try {
                    boolean done = false;
                    block10: while (!done) {
                        int tag = input.readTag();
                        switch (tag) {
                            case 0: {
                                done = true;
                                continue block10;
                            }
                            case 8: {
                                this.type_ = input.readEnum();
                                this.bitField0_ |= 1;
                                continue block10;
                            }
                            case 17: {
                                this.weight_ = input.readDouble();
                                this.bitField0_ |= 2;
                                continue block10;
                            }
                        }
                        if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                        done = true;
                    }
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.unwrapIOException();
                }
                finally {
                    this.onChanged();
                }
                return this;
            }

            @Override
            public boolean hasType() {
                return (this.bitField0_ & 1) != 0;
            }

            @Override
            public int getTypeValue() {
                return this.type_;
            }

            public Builder setTypeValue(int value) {
                this.type_ = value;
                this.bitField0_ |= 1;
                this.onChanged();
                return this;
            }

            @Override
            public Type getType() {
                Type result = Type.forNumber(this.type_);
                return result == null ? Type.UNRECOGNIZED : result;
            }

            public Builder setType(Type value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.bitField0_ |= 1;
                this.type_ = value.getNumber();
                this.onChanged();
                return this;
            }

            public Builder clearType() {
                this.bitField0_ &= 0xFFFFFFFE;
                this.type_ = 0;
                this.onChanged();
                return this;
            }

            @Override
            public boolean hasWeight() {
                return (this.bitField0_ & 2) != 0;
            }

            @Override
            public double getWeight() {
                return this.weight_;
            }

            public Builder setWeight(double value) {
                this.weight_ = value;
                this.bitField0_ |= 2;
                this.onChanged();
                return this;
            }

            public Builder clearWeight() {
                this.bitField0_ &= 0xFFFFFFFD;
                this.weight_ = 0.0;
                this.onChanged();
                return this;
            }
        }

        public static enum Type implements ProtocolMessageEnum
        {
            DEFAULT(0),
            MIN_DISTANCE(10),
            MIN_WORKING_TIME(11),
            MIN_TRAVEL_TIME(12),
            MIN_NUM_VEHICLES(13),
            UNRECOGNIZED(-1);

            public static final int DEFAULT_VALUE = 0;
            public static final int MIN_DISTANCE_VALUE = 10;
            public static final int MIN_WORKING_TIME_VALUE = 11;
            public static final int MIN_TRAVEL_TIME_VALUE = 12;
            public static final int MIN_NUM_VEHICLES_VALUE = 13;
            private static final Internal.EnumLiteMap<Type> internalValueMap;
            private static final Type[] VALUES;
            private final int value;

            public final int getNumber() {
                if (this == UNRECOGNIZED) {
                    throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
                }
                return this.value;
            }

            @Deprecated
            public static Type valueOf(int value) {
                return Type.forNumber(value);
            }

            public static Type forNumber(int value) {
                switch (value) {
                    case 0: {
                        return DEFAULT;
                    }
                    case 10: {
                        return MIN_DISTANCE;
                    }
                    case 11: {
                        return MIN_WORKING_TIME;
                    }
                    case 12: {
                        return MIN_TRAVEL_TIME;
                    }
                    case 13: {
                        return MIN_NUM_VEHICLES;
                    }
                }
                return null;
            }

            public static Internal.EnumLiteMap<Type> internalGetValueMap() {
                return internalValueMap;
            }

            public final Descriptors.EnumValueDescriptor getValueDescriptor() {
                if (this == UNRECOGNIZED) {
                    throw new IllegalStateException("Can't get the descriptor of an unrecognized enum value.");
                }
                return (Descriptors.EnumValueDescriptor)Type.getDescriptor().getValues().get(this.ordinal());
            }

            public final Descriptors.EnumDescriptor getDescriptorForType() {
                return Type.getDescriptor();
            }

            public static Descriptors.EnumDescriptor getDescriptor() {
                return (Descriptors.EnumDescriptor)Objective.getDescriptor().getEnumTypes().get(0);
            }

            public static Type valueOf(Descriptors.EnumValueDescriptor desc) {
                if (desc.getType() != Type.getDescriptor()) {
                    throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
                }
                if (desc.getIndex() == -1) {
                    return UNRECOGNIZED;
                }
                return VALUES[desc.getIndex()];
            }

            private Type(int value) {
                this.value = value;
            }

            static {
                RuntimeVersion.validateProtobufGencodeVersion((RuntimeVersion.RuntimeDomain)RuntimeVersion.RuntimeDomain.PUBLIC, (int)4, (int)33, (int)0, (String)"", (String)"Type");
                internalValueMap = new Internal.EnumLiteMap<Type>(){

                    public Type findValueByNumber(int number) {
                        return Type.forNumber(number);
                    }
                };
                VALUES = Type.values();
            }
        }
    }

    public static interface ObjectiveOrBuilder
    extends MessageOrBuilder {
        public boolean hasType();

        public int getTypeValue();

        public Objective.Type getType();

        public boolean hasWeight();

        public double getWeight();
    }
}

