/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.fleetengine.v1;

import com.google.maps.fleetengine.v1.ConsumableTrafficPolyline;
import com.google.maps.fleetengine.v1.ConsumableTrafficPolylineOrBuilder;
import com.google.maps.fleetengine.v1.FleetEngine;
import com.google.maps.fleetengine.v1.TerminalLocation;
import com.google.maps.fleetengine.v1.TerminalLocationOrBuilder;
import com.google.maps.fleetengine.v1.TripWaypointOrBuilder;
import com.google.maps.fleetengine.v1.WaypointType;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Duration;
import com.google.protobuf.DurationOrBuilder;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Int32Value;
import com.google.protobuf.Int32ValueOrBuilder;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.RepeatedFieldBuilderV3;
import com.google.protobuf.SingleFieldBuilderV3;
import com.google.protobuf.Timestamp;
import com.google.protobuf.TimestampOrBuilder;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import com.google.type.LatLng;
import com.google.type.LatLngOrBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class TripWaypoint
extends GeneratedMessageV3
implements TripWaypointOrBuilder {
    private static final long serialVersionUID = 0L;
    private int bitField0_;
    public static final int LOCATION_FIELD_NUMBER = 1;
    private TerminalLocation location_;
    public static final int TRIP_ID_FIELD_NUMBER = 2;
    private volatile Object tripId_ = "";
    public static final int WAYPOINT_TYPE_FIELD_NUMBER = 3;
    private int waypointType_ = 0;
    public static final int PATH_TO_WAYPOINT_FIELD_NUMBER = 4;
    private List<LatLng> pathToWaypoint_;
    public static final int ENCODED_PATH_TO_WAYPOINT_FIELD_NUMBER = 5;
    private volatile Object encodedPathToWaypoint_ = "";
    public static final int TRAFFIC_TO_WAYPOINT_FIELD_NUMBER = 10;
    private ConsumableTrafficPolyline trafficToWaypoint_;
    public static final int DISTANCE_METERS_FIELD_NUMBER = 6;
    private Int32Value distanceMeters_;
    public static final int ETA_FIELD_NUMBER = 7;
    private Timestamp eta_;
    public static final int DURATION_FIELD_NUMBER = 8;
    private Duration duration_;
    private byte memoizedIsInitialized = (byte)-1;
    private static final TripWaypoint DEFAULT_INSTANCE = new TripWaypoint();
    private static final Parser<TripWaypoint> PARSER = new AbstractParser<TripWaypoint>(){

        public TripWaypoint parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = TripWaypoint.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private TripWaypoint(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private TripWaypoint() {
        this.tripId_ = "";
        this.waypointType_ = 0;
        this.pathToWaypoint_ = Collections.emptyList();
        this.encodedPathToWaypoint_ = "";
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new TripWaypoint();
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return FleetEngine.internal_static_maps_fleetengine_v1_TripWaypoint_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return FleetEngine.internal_static_maps_fleetengine_v1_TripWaypoint_fieldAccessorTable.ensureFieldAccessorsInitialized(TripWaypoint.class, Builder.class);
    }

    @Override
    public boolean hasLocation() {
        return (this.bitField0_ & 1) != 0;
    }

    @Override
    public TerminalLocation getLocation() {
        return this.location_ == null ? TerminalLocation.getDefaultInstance() : this.location_;
    }

    @Override
    public TerminalLocationOrBuilder getLocationOrBuilder() {
        return this.location_ == null ? TerminalLocation.getDefaultInstance() : this.location_;
    }

    @Override
    public String getTripId() {
        Object ref = this.tripId_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.tripId_ = s;
        return s;
    }

    @Override
    public ByteString getTripIdBytes() {
        Object ref = this.tripId_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.tripId_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public int getWaypointTypeValue() {
        return this.waypointType_;
    }

    @Override
    public WaypointType getWaypointType() {
        WaypointType result = WaypointType.forNumber(this.waypointType_);
        return result == null ? WaypointType.UNRECOGNIZED : result;
    }

    @Override
    public List<LatLng> getPathToWaypointList() {
        return this.pathToWaypoint_;
    }

    @Override
    public List<? extends LatLngOrBuilder> getPathToWaypointOrBuilderList() {
        return this.pathToWaypoint_;
    }

    @Override
    public int getPathToWaypointCount() {
        return this.pathToWaypoint_.size();
    }

    @Override
    public LatLng getPathToWaypoint(int index) {
        return this.pathToWaypoint_.get(index);
    }

    @Override
    public LatLngOrBuilder getPathToWaypointOrBuilder(int index) {
        return (LatLngOrBuilder)this.pathToWaypoint_.get(index);
    }

    @Override
    public String getEncodedPathToWaypoint() {
        Object ref = this.encodedPathToWaypoint_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.encodedPathToWaypoint_ = s;
        return s;
    }

    @Override
    public ByteString getEncodedPathToWaypointBytes() {
        Object ref = this.encodedPathToWaypoint_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.encodedPathToWaypoint_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean hasTrafficToWaypoint() {
        return (this.bitField0_ & 2) != 0;
    }

    @Override
    public ConsumableTrafficPolyline getTrafficToWaypoint() {
        return this.trafficToWaypoint_ == null ? ConsumableTrafficPolyline.getDefaultInstance() : this.trafficToWaypoint_;
    }

    @Override
    public ConsumableTrafficPolylineOrBuilder getTrafficToWaypointOrBuilder() {
        return this.trafficToWaypoint_ == null ? ConsumableTrafficPolyline.getDefaultInstance() : this.trafficToWaypoint_;
    }

    @Override
    public boolean hasDistanceMeters() {
        return (this.bitField0_ & 4) != 0;
    }

    @Override
    public Int32Value getDistanceMeters() {
        return this.distanceMeters_ == null ? Int32Value.getDefaultInstance() : this.distanceMeters_;
    }

    @Override
    public Int32ValueOrBuilder getDistanceMetersOrBuilder() {
        return this.distanceMeters_ == null ? Int32Value.getDefaultInstance() : this.distanceMeters_;
    }

    @Override
    public boolean hasEta() {
        return (this.bitField0_ & 8) != 0;
    }

    @Override
    public Timestamp getEta() {
        return this.eta_ == null ? Timestamp.getDefaultInstance() : this.eta_;
    }

    @Override
    public TimestampOrBuilder getEtaOrBuilder() {
        return this.eta_ == null ? Timestamp.getDefaultInstance() : this.eta_;
    }

    @Override
    public boolean hasDuration() {
        return (this.bitField0_ & 0x10) != 0;
    }

    @Override
    public Duration getDuration() {
        return this.duration_ == null ? Duration.getDefaultInstance() : this.duration_;
    }

    @Override
    public DurationOrBuilder getDurationOrBuilder() {
        return this.duration_ == null ? Duration.getDefaultInstance() : this.duration_;
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        if ((this.bitField0_ & 1) != 0) {
            output.writeMessage(1, (MessageLite)this.getLocation());
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.tripId_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)2, (Object)this.tripId_);
        }
        if (this.waypointType_ != WaypointType.UNKNOWN_WAYPOINT_TYPE.getNumber()) {
            output.writeEnum(3, this.waypointType_);
        }
        for (int i = 0; i < this.pathToWaypoint_.size(); ++i) {
            output.writeMessage(4, (MessageLite)this.pathToWaypoint_.get(i));
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.encodedPathToWaypoint_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)5, (Object)this.encodedPathToWaypoint_);
        }
        if ((this.bitField0_ & 4) != 0) {
            output.writeMessage(6, (MessageLite)this.getDistanceMeters());
        }
        if ((this.bitField0_ & 8) != 0) {
            output.writeMessage(7, (MessageLite)this.getEta());
        }
        if ((this.bitField0_ & 0x10) != 0) {
            output.writeMessage(8, (MessageLite)this.getDuration());
        }
        if ((this.bitField0_ & 2) != 0) {
            output.writeMessage(10, (MessageLite)this.getTrafficToWaypoint());
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if ((this.bitField0_ & 1) != 0) {
            size += CodedOutputStream.computeMessageSize((int)1, (MessageLite)this.getLocation());
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.tripId_)) {
            size += GeneratedMessageV3.computeStringSize((int)2, (Object)this.tripId_);
        }
        if (this.waypointType_ != WaypointType.UNKNOWN_WAYPOINT_TYPE.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)3, (int)this.waypointType_);
        }
        for (int i = 0; i < this.pathToWaypoint_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)4, (MessageLite)((MessageLite)this.pathToWaypoint_.get(i)));
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.encodedPathToWaypoint_)) {
            size += GeneratedMessageV3.computeStringSize((int)5, (Object)this.encodedPathToWaypoint_);
        }
        if ((this.bitField0_ & 4) != 0) {
            size += CodedOutputStream.computeMessageSize((int)6, (MessageLite)this.getDistanceMeters());
        }
        if ((this.bitField0_ & 8) != 0) {
            size += CodedOutputStream.computeMessageSize((int)7, (MessageLite)this.getEta());
        }
        if ((this.bitField0_ & 0x10) != 0) {
            size += CodedOutputStream.computeMessageSize((int)8, (MessageLite)this.getDuration());
        }
        if ((this.bitField0_ & 2) != 0) {
            size += CodedOutputStream.computeMessageSize((int)10, (MessageLite)this.getTrafficToWaypoint());
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TripWaypoint)) {
            return super.equals(obj);
        }
        TripWaypoint other = (TripWaypoint)obj;
        if (this.hasLocation() != other.hasLocation()) {
            return false;
        }
        if (this.hasLocation() && !this.getLocation().equals(other.getLocation())) {
            return false;
        }
        if (!this.getTripId().equals(other.getTripId())) {
            return false;
        }
        if (this.waypointType_ != other.waypointType_) {
            return false;
        }
        if (!this.getPathToWaypointList().equals(other.getPathToWaypointList())) {
            return false;
        }
        if (!this.getEncodedPathToWaypoint().equals(other.getEncodedPathToWaypoint())) {
            return false;
        }
        if (this.hasTrafficToWaypoint() != other.hasTrafficToWaypoint()) {
            return false;
        }
        if (this.hasTrafficToWaypoint() && !this.getTrafficToWaypoint().equals(other.getTrafficToWaypoint())) {
            return false;
        }
        if (this.hasDistanceMeters() != other.hasDistanceMeters()) {
            return false;
        }
        if (this.hasDistanceMeters() && !this.getDistanceMeters().equals((Object)other.getDistanceMeters())) {
            return false;
        }
        if (this.hasEta() != other.hasEta()) {
            return false;
        }
        if (this.hasEta() && !this.getEta().equals((Object)other.getEta())) {
            return false;
        }
        if (this.hasDuration() != other.hasDuration()) {
            return false;
        }
        if (this.hasDuration() && !this.getDuration().equals((Object)other.getDuration())) {
            return false;
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + TripWaypoint.getDescriptor().hashCode();
        if (this.hasLocation()) {
            hash = 37 * hash + 1;
            hash = 53 * hash + this.getLocation().hashCode();
        }
        hash = 37 * hash + 2;
        hash = 53 * hash + this.getTripId().hashCode();
        hash = 37 * hash + 3;
        hash = 53 * hash + this.waypointType_;
        if (this.getPathToWaypointCount() > 0) {
            hash = 37 * hash + 4;
            hash = 53 * hash + this.getPathToWaypointList().hashCode();
        }
        hash = 37 * hash + 5;
        hash = 53 * hash + this.getEncodedPathToWaypoint().hashCode();
        if (this.hasTrafficToWaypoint()) {
            hash = 37 * hash + 10;
            hash = 53 * hash + this.getTrafficToWaypoint().hashCode();
        }
        if (this.hasDistanceMeters()) {
            hash = 37 * hash + 6;
            hash = 53 * hash + this.getDistanceMeters().hashCode();
        }
        if (this.hasEta()) {
            hash = 37 * hash + 7;
            hash = 53 * hash + this.getEta().hashCode();
        }
        if (this.hasDuration()) {
            hash = 37 * hash + 8;
            hash = 53 * hash + this.getDuration().hashCode();
        }
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static TripWaypoint parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (TripWaypoint)PARSER.parseFrom(data);
    }

    public static TripWaypoint parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (TripWaypoint)PARSER.parseFrom(data, extensionRegistry);
    }

    public static TripWaypoint parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (TripWaypoint)PARSER.parseFrom(data);
    }

    public static TripWaypoint parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (TripWaypoint)PARSER.parseFrom(data, extensionRegistry);
    }

    public static TripWaypoint parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (TripWaypoint)PARSER.parseFrom(data);
    }

    public static TripWaypoint parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (TripWaypoint)PARSER.parseFrom(data, extensionRegistry);
    }

    public static TripWaypoint parseFrom(InputStream input) throws IOException {
        return (TripWaypoint)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static TripWaypoint parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (TripWaypoint)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static TripWaypoint parseDelimitedFrom(InputStream input) throws IOException {
        return (TripWaypoint)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static TripWaypoint parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (TripWaypoint)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static TripWaypoint parseFrom(CodedInputStream input) throws IOException {
        return (TripWaypoint)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static TripWaypoint parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (TripWaypoint)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return TripWaypoint.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(TripWaypoint prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static TripWaypoint getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<TripWaypoint> parser() {
        return PARSER;
    }

    public Parser<TripWaypoint> getParserForType() {
        return PARSER;
    }

    public TripWaypoint getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements TripWaypointOrBuilder {
        private int bitField0_;
        private TerminalLocation location_;
        private SingleFieldBuilderV3<TerminalLocation, TerminalLocation.Builder, TerminalLocationOrBuilder> locationBuilder_;
        private Object tripId_ = "";
        private int waypointType_ = 0;
        private List<LatLng> pathToWaypoint_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<LatLng, LatLng.Builder, LatLngOrBuilder> pathToWaypointBuilder_;
        private Object encodedPathToWaypoint_ = "";
        private ConsumableTrafficPolyline trafficToWaypoint_;
        private SingleFieldBuilderV3<ConsumableTrafficPolyline, ConsumableTrafficPolyline.Builder, ConsumableTrafficPolylineOrBuilder> trafficToWaypointBuilder_;
        private Int32Value distanceMeters_;
        private SingleFieldBuilderV3<Int32Value, Int32Value.Builder, Int32ValueOrBuilder> distanceMetersBuilder_;
        private Timestamp eta_;
        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> etaBuilder_;
        private Duration duration_;
        private SingleFieldBuilderV3<Duration, Duration.Builder, DurationOrBuilder> durationBuilder_;

        public static final Descriptors.Descriptor getDescriptor() {
            return FleetEngine.internal_static_maps_fleetengine_v1_TripWaypoint_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return FleetEngine.internal_static_maps_fleetengine_v1_TripWaypoint_fieldAccessorTable.ensureFieldAccessorsInitialized(TripWaypoint.class, Builder.class);
        }

        private Builder() {
            this.maybeForceBuilderInitialization();
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            this.maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
            if (alwaysUseFieldBuilders) {
                this.getLocationFieldBuilder();
                this.getPathToWaypointFieldBuilder();
                this.getTrafficToWaypointFieldBuilder();
                this.getDistanceMetersFieldBuilder();
                this.getEtaFieldBuilder();
                this.getDurationFieldBuilder();
            }
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            this.location_ = null;
            if (this.locationBuilder_ != null) {
                this.locationBuilder_.dispose();
                this.locationBuilder_ = null;
            }
            this.tripId_ = "";
            this.waypointType_ = 0;
            if (this.pathToWaypointBuilder_ == null) {
                this.pathToWaypoint_ = Collections.emptyList();
            } else {
                this.pathToWaypoint_ = null;
                this.pathToWaypointBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFFF7;
            this.encodedPathToWaypoint_ = "";
            this.trafficToWaypoint_ = null;
            if (this.trafficToWaypointBuilder_ != null) {
                this.trafficToWaypointBuilder_.dispose();
                this.trafficToWaypointBuilder_ = null;
            }
            this.distanceMeters_ = null;
            if (this.distanceMetersBuilder_ != null) {
                this.distanceMetersBuilder_.dispose();
                this.distanceMetersBuilder_ = null;
            }
            this.eta_ = null;
            if (this.etaBuilder_ != null) {
                this.etaBuilder_.dispose();
                this.etaBuilder_ = null;
            }
            this.duration_ = null;
            if (this.durationBuilder_ != null) {
                this.durationBuilder_.dispose();
                this.durationBuilder_ = null;
            }
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return FleetEngine.internal_static_maps_fleetengine_v1_TripWaypoint_descriptor;
        }

        public TripWaypoint getDefaultInstanceForType() {
            return TripWaypoint.getDefaultInstance();
        }

        public TripWaypoint build() {
            TripWaypoint result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public TripWaypoint buildPartial() {
            TripWaypoint result = new TripWaypoint(this);
            this.buildPartialRepeatedFields(result);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.onBuilt();
            return result;
        }

        private void buildPartialRepeatedFields(TripWaypoint result) {
            if (this.pathToWaypointBuilder_ == null) {
                if ((this.bitField0_ & 8) != 0) {
                    this.pathToWaypoint_ = Collections.unmodifiableList(this.pathToWaypoint_);
                    this.bitField0_ &= 0xFFFFFFF7;
                }
                result.pathToWaypoint_ = this.pathToWaypoint_;
            } else {
                result.pathToWaypoint_ = this.pathToWaypointBuilder_.build();
            }
        }

        private void buildPartial0(TripWaypoint result) {
            int from_bitField0_ = this.bitField0_;
            int to_bitField0_ = 0;
            if ((from_bitField0_ & 1) != 0) {
                result.location_ = this.locationBuilder_ == null ? this.location_ : (TerminalLocation)this.locationBuilder_.build();
                to_bitField0_ |= 1;
            }
            if ((from_bitField0_ & 2) != 0) {
                result.tripId_ = this.tripId_;
            }
            if ((from_bitField0_ & 4) != 0) {
                result.waypointType_ = this.waypointType_;
            }
            if ((from_bitField0_ & 0x10) != 0) {
                result.encodedPathToWaypoint_ = this.encodedPathToWaypoint_;
            }
            if ((from_bitField0_ & 0x20) != 0) {
                result.trafficToWaypoint_ = this.trafficToWaypointBuilder_ == null ? this.trafficToWaypoint_ : (ConsumableTrafficPolyline)this.trafficToWaypointBuilder_.build();
                to_bitField0_ |= 2;
            }
            if ((from_bitField0_ & 0x40) != 0) {
                result.distanceMeters_ = this.distanceMetersBuilder_ == null ? this.distanceMeters_ : (Int32Value)this.distanceMetersBuilder_.build();
                to_bitField0_ |= 4;
            }
            if ((from_bitField0_ & 0x80) != 0) {
                result.eta_ = this.etaBuilder_ == null ? this.eta_ : (Timestamp)this.etaBuilder_.build();
                to_bitField0_ |= 8;
            }
            if ((from_bitField0_ & 0x100) != 0) {
                result.duration_ = this.durationBuilder_ == null ? this.duration_ : (Duration)this.durationBuilder_.build();
                to_bitField0_ |= 0x10;
            }
            TripWaypoint tripWaypoint = result;
            tripWaypoint.bitField0_ = tripWaypoint.bitField0_ | to_bitField0_;
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof TripWaypoint) {
                return this.mergeFrom((TripWaypoint)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(TripWaypoint other) {
            if (other == TripWaypoint.getDefaultInstance()) {
                return this;
            }
            if (other.hasLocation()) {
                this.mergeLocation(other.getLocation());
            }
            if (!other.getTripId().isEmpty()) {
                this.tripId_ = other.tripId_;
                this.bitField0_ |= 2;
                this.onChanged();
            }
            if (other.waypointType_ != 0) {
                this.setWaypointTypeValue(other.getWaypointTypeValue());
            }
            if (this.pathToWaypointBuilder_ == null) {
                if (!other.pathToWaypoint_.isEmpty()) {
                    if (this.pathToWaypoint_.isEmpty()) {
                        this.pathToWaypoint_ = other.pathToWaypoint_;
                        this.bitField0_ &= 0xFFFFFFF7;
                    } else {
                        this.ensurePathToWaypointIsMutable();
                        this.pathToWaypoint_.addAll(other.pathToWaypoint_);
                    }
                    this.onChanged();
                }
            } else if (!other.pathToWaypoint_.isEmpty()) {
                if (this.pathToWaypointBuilder_.isEmpty()) {
                    this.pathToWaypointBuilder_.dispose();
                    this.pathToWaypointBuilder_ = null;
                    this.pathToWaypoint_ = other.pathToWaypoint_;
                    this.bitField0_ &= 0xFFFFFFF7;
                    this.pathToWaypointBuilder_ = alwaysUseFieldBuilders ? this.getPathToWaypointFieldBuilder() : null;
                } else {
                    this.pathToWaypointBuilder_.addAllMessages((Iterable)other.pathToWaypoint_);
                }
            }
            if (!other.getEncodedPathToWaypoint().isEmpty()) {
                this.encodedPathToWaypoint_ = other.encodedPathToWaypoint_;
                this.bitField0_ |= 0x10;
                this.onChanged();
            }
            if (other.hasTrafficToWaypoint()) {
                this.mergeTrafficToWaypoint(other.getTrafficToWaypoint());
            }
            if (other.hasDistanceMeters()) {
                this.mergeDistanceMeters(other.getDistanceMeters());
            }
            if (other.hasEta()) {
                this.mergeEta(other.getEta());
            }
            if (other.hasDuration()) {
                this.mergeDuration(other.getDuration());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block17: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block17;
                        }
                        case 10: {
                            input.readMessage((MessageLite.Builder)this.getLocationFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 1;
                            continue block17;
                        }
                        case 18: {
                            this.tripId_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 2;
                            continue block17;
                        }
                        case 24: {
                            this.waypointType_ = input.readEnum();
                            this.bitField0_ |= 4;
                            continue block17;
                        }
                        case 34: {
                            LatLng m = (LatLng)input.readMessage(LatLng.parser(), extensionRegistry);
                            if (this.pathToWaypointBuilder_ == null) {
                                this.ensurePathToWaypointIsMutable();
                                this.pathToWaypoint_.add(m);
                                continue block17;
                            }
                            this.pathToWaypointBuilder_.addMessage((AbstractMessage)m);
                            continue block17;
                        }
                        case 42: {
                            this.encodedPathToWaypoint_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x10;
                            continue block17;
                        }
                        case 50: {
                            input.readMessage((MessageLite.Builder)this.getDistanceMetersFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x40;
                            continue block17;
                        }
                        case 58: {
                            input.readMessage((MessageLite.Builder)this.getEtaFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x80;
                            continue block17;
                        }
                        case 66: {
                            input.readMessage((MessageLite.Builder)this.getDurationFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x100;
                            continue block17;
                        }
                        case 82: {
                            input.readMessage((MessageLite.Builder)this.getTrafficToWaypointFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x20;
                            continue block17;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public boolean hasLocation() {
            return (this.bitField0_ & 1) != 0;
        }

        @Override
        public TerminalLocation getLocation() {
            if (this.locationBuilder_ == null) {
                return this.location_ == null ? TerminalLocation.getDefaultInstance() : this.location_;
            }
            return (TerminalLocation)this.locationBuilder_.getMessage();
        }

        public Builder setLocation(TerminalLocation value) {
            if (this.locationBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.location_ = value;
            } else {
                this.locationBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder setLocation(TerminalLocation.Builder builderForValue) {
            if (this.locationBuilder_ == null) {
                this.location_ = builderForValue.build();
            } else {
                this.locationBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder mergeLocation(TerminalLocation value) {
            if (this.locationBuilder_ == null) {
                if ((this.bitField0_ & 1) != 0 && this.location_ != null && this.location_ != TerminalLocation.getDefaultInstance()) {
                    this.getLocationBuilder().mergeFrom(value);
                } else {
                    this.location_ = value;
                }
            } else {
                this.locationBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.location_ != null) {
                this.bitField0_ |= 1;
                this.onChanged();
            }
            return this;
        }

        public Builder clearLocation() {
            this.bitField0_ &= 0xFFFFFFFE;
            this.location_ = null;
            if (this.locationBuilder_ != null) {
                this.locationBuilder_.dispose();
                this.locationBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public TerminalLocation.Builder getLocationBuilder() {
            this.bitField0_ |= 1;
            this.onChanged();
            return (TerminalLocation.Builder)this.getLocationFieldBuilder().getBuilder();
        }

        @Override
        public TerminalLocationOrBuilder getLocationOrBuilder() {
            if (this.locationBuilder_ != null) {
                return (TerminalLocationOrBuilder)this.locationBuilder_.getMessageOrBuilder();
            }
            return this.location_ == null ? TerminalLocation.getDefaultInstance() : this.location_;
        }

        private SingleFieldBuilderV3<TerminalLocation, TerminalLocation.Builder, TerminalLocationOrBuilder> getLocationFieldBuilder() {
            if (this.locationBuilder_ == null) {
                this.locationBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getLocation(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.location_ = null;
            }
            return this.locationBuilder_;
        }

        @Override
        public String getTripId() {
            Object ref = this.tripId_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.tripId_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getTripIdBytes() {
            Object ref = this.tripId_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.tripId_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setTripId(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.tripId_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        public Builder clearTripId() {
            this.tripId_ = TripWaypoint.getDefaultInstance().getTripId();
            this.bitField0_ &= 0xFFFFFFFD;
            this.onChanged();
            return this;
        }

        public Builder setTripIdBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            TripWaypoint.checkByteStringIsUtf8((ByteString)value);
            this.tripId_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        @Override
        public int getWaypointTypeValue() {
            return this.waypointType_;
        }

        public Builder setWaypointTypeValue(int value) {
            this.waypointType_ = value;
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        @Override
        public WaypointType getWaypointType() {
            WaypointType result = WaypointType.forNumber(this.waypointType_);
            return result == null ? WaypointType.UNRECOGNIZED : result;
        }

        public Builder setWaypointType(WaypointType value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 4;
            this.waypointType_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearWaypointType() {
            this.bitField0_ &= 0xFFFFFFFB;
            this.waypointType_ = 0;
            this.onChanged();
            return this;
        }

        private void ensurePathToWaypointIsMutable() {
            if ((this.bitField0_ & 8) == 0) {
                this.pathToWaypoint_ = new ArrayList<LatLng>(this.pathToWaypoint_);
                this.bitField0_ |= 8;
            }
        }

        @Override
        public List<LatLng> getPathToWaypointList() {
            if (this.pathToWaypointBuilder_ == null) {
                return Collections.unmodifiableList(this.pathToWaypoint_);
            }
            return this.pathToWaypointBuilder_.getMessageList();
        }

        @Override
        public int getPathToWaypointCount() {
            if (this.pathToWaypointBuilder_ == null) {
                return this.pathToWaypoint_.size();
            }
            return this.pathToWaypointBuilder_.getCount();
        }

        @Override
        public LatLng getPathToWaypoint(int index) {
            if (this.pathToWaypointBuilder_ == null) {
                return this.pathToWaypoint_.get(index);
            }
            return (LatLng)this.pathToWaypointBuilder_.getMessage(index);
        }

        public Builder setPathToWaypoint(int index, LatLng value) {
            if (this.pathToWaypointBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensurePathToWaypointIsMutable();
                this.pathToWaypoint_.set(index, value);
                this.onChanged();
            } else {
                this.pathToWaypointBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setPathToWaypoint(int index, LatLng.Builder builderForValue) {
            if (this.pathToWaypointBuilder_ == null) {
                this.ensurePathToWaypointIsMutable();
                this.pathToWaypoint_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.pathToWaypointBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addPathToWaypoint(LatLng value) {
            if (this.pathToWaypointBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensurePathToWaypointIsMutable();
                this.pathToWaypoint_.add(value);
                this.onChanged();
            } else {
                this.pathToWaypointBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addPathToWaypoint(int index, LatLng value) {
            if (this.pathToWaypointBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensurePathToWaypointIsMutable();
                this.pathToWaypoint_.add(index, value);
                this.onChanged();
            } else {
                this.pathToWaypointBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addPathToWaypoint(LatLng.Builder builderForValue) {
            if (this.pathToWaypointBuilder_ == null) {
                this.ensurePathToWaypointIsMutable();
                this.pathToWaypoint_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.pathToWaypointBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addPathToWaypoint(int index, LatLng.Builder builderForValue) {
            if (this.pathToWaypointBuilder_ == null) {
                this.ensurePathToWaypointIsMutable();
                this.pathToWaypoint_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.pathToWaypointBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllPathToWaypoint(Iterable<? extends LatLng> values) {
            if (this.pathToWaypointBuilder_ == null) {
                this.ensurePathToWaypointIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.pathToWaypoint_);
                this.onChanged();
            } else {
                this.pathToWaypointBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearPathToWaypoint() {
            if (this.pathToWaypointBuilder_ == null) {
                this.pathToWaypoint_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFF7;
                this.onChanged();
            } else {
                this.pathToWaypointBuilder_.clear();
            }
            return this;
        }

        public Builder removePathToWaypoint(int index) {
            if (this.pathToWaypointBuilder_ == null) {
                this.ensurePathToWaypointIsMutable();
                this.pathToWaypoint_.remove(index);
                this.onChanged();
            } else {
                this.pathToWaypointBuilder_.remove(index);
            }
            return this;
        }

        public LatLng.Builder getPathToWaypointBuilder(int index) {
            return (LatLng.Builder)this.getPathToWaypointFieldBuilder().getBuilder(index);
        }

        @Override
        public LatLngOrBuilder getPathToWaypointOrBuilder(int index) {
            if (this.pathToWaypointBuilder_ == null) {
                return (LatLngOrBuilder)this.pathToWaypoint_.get(index);
            }
            return (LatLngOrBuilder)this.pathToWaypointBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends LatLngOrBuilder> getPathToWaypointOrBuilderList() {
            if (this.pathToWaypointBuilder_ != null) {
                return this.pathToWaypointBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.pathToWaypoint_);
        }

        public LatLng.Builder addPathToWaypointBuilder() {
            return (LatLng.Builder)this.getPathToWaypointFieldBuilder().addBuilder((AbstractMessage)LatLng.getDefaultInstance());
        }

        public LatLng.Builder addPathToWaypointBuilder(int index) {
            return (LatLng.Builder)this.getPathToWaypointFieldBuilder().addBuilder(index, (AbstractMessage)LatLng.getDefaultInstance());
        }

        public List<LatLng.Builder> getPathToWaypointBuilderList() {
            return this.getPathToWaypointFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<LatLng, LatLng.Builder, LatLngOrBuilder> getPathToWaypointFieldBuilder() {
            if (this.pathToWaypointBuilder_ == null) {
                this.pathToWaypointBuilder_ = new RepeatedFieldBuilderV3(this.pathToWaypoint_, (this.bitField0_ & 8) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.pathToWaypoint_ = null;
            }
            return this.pathToWaypointBuilder_;
        }

        @Override
        public String getEncodedPathToWaypoint() {
            Object ref = this.encodedPathToWaypoint_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.encodedPathToWaypoint_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getEncodedPathToWaypointBytes() {
            Object ref = this.encodedPathToWaypoint_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.encodedPathToWaypoint_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setEncodedPathToWaypoint(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.encodedPathToWaypoint_ = value;
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder clearEncodedPathToWaypoint() {
            this.encodedPathToWaypoint_ = TripWaypoint.getDefaultInstance().getEncodedPathToWaypoint();
            this.bitField0_ &= 0xFFFFFFEF;
            this.onChanged();
            return this;
        }

        public Builder setEncodedPathToWaypointBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            TripWaypoint.checkByteStringIsUtf8((ByteString)value);
            this.encodedPathToWaypoint_ = value;
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasTrafficToWaypoint() {
            return (this.bitField0_ & 0x20) != 0;
        }

        @Override
        public ConsumableTrafficPolyline getTrafficToWaypoint() {
            if (this.trafficToWaypointBuilder_ == null) {
                return this.trafficToWaypoint_ == null ? ConsumableTrafficPolyline.getDefaultInstance() : this.trafficToWaypoint_;
            }
            return (ConsumableTrafficPolyline)this.trafficToWaypointBuilder_.getMessage();
        }

        public Builder setTrafficToWaypoint(ConsumableTrafficPolyline value) {
            if (this.trafficToWaypointBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.trafficToWaypoint_ = value;
            } else {
                this.trafficToWaypointBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        public Builder setTrafficToWaypoint(ConsumableTrafficPolyline.Builder builderForValue) {
            if (this.trafficToWaypointBuilder_ == null) {
                this.trafficToWaypoint_ = builderForValue.build();
            } else {
                this.trafficToWaypointBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        public Builder mergeTrafficToWaypoint(ConsumableTrafficPolyline value) {
            if (this.trafficToWaypointBuilder_ == null) {
                if ((this.bitField0_ & 0x20) != 0 && this.trafficToWaypoint_ != null && this.trafficToWaypoint_ != ConsumableTrafficPolyline.getDefaultInstance()) {
                    this.getTrafficToWaypointBuilder().mergeFrom(value);
                } else {
                    this.trafficToWaypoint_ = value;
                }
            } else {
                this.trafficToWaypointBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.trafficToWaypoint_ != null) {
                this.bitField0_ |= 0x20;
                this.onChanged();
            }
            return this;
        }

        public Builder clearTrafficToWaypoint() {
            this.bitField0_ &= 0xFFFFFFDF;
            this.trafficToWaypoint_ = null;
            if (this.trafficToWaypointBuilder_ != null) {
                this.trafficToWaypointBuilder_.dispose();
                this.trafficToWaypointBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public ConsumableTrafficPolyline.Builder getTrafficToWaypointBuilder() {
            this.bitField0_ |= 0x20;
            this.onChanged();
            return (ConsumableTrafficPolyline.Builder)this.getTrafficToWaypointFieldBuilder().getBuilder();
        }

        @Override
        public ConsumableTrafficPolylineOrBuilder getTrafficToWaypointOrBuilder() {
            if (this.trafficToWaypointBuilder_ != null) {
                return (ConsumableTrafficPolylineOrBuilder)this.trafficToWaypointBuilder_.getMessageOrBuilder();
            }
            return this.trafficToWaypoint_ == null ? ConsumableTrafficPolyline.getDefaultInstance() : this.trafficToWaypoint_;
        }

        private SingleFieldBuilderV3<ConsumableTrafficPolyline, ConsumableTrafficPolyline.Builder, ConsumableTrafficPolylineOrBuilder> getTrafficToWaypointFieldBuilder() {
            if (this.trafficToWaypointBuilder_ == null) {
                this.trafficToWaypointBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getTrafficToWaypoint(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.trafficToWaypoint_ = null;
            }
            return this.trafficToWaypointBuilder_;
        }

        @Override
        public boolean hasDistanceMeters() {
            return (this.bitField0_ & 0x40) != 0;
        }

        @Override
        public Int32Value getDistanceMeters() {
            if (this.distanceMetersBuilder_ == null) {
                return this.distanceMeters_ == null ? Int32Value.getDefaultInstance() : this.distanceMeters_;
            }
            return (Int32Value)this.distanceMetersBuilder_.getMessage();
        }

        public Builder setDistanceMeters(Int32Value value) {
            if (this.distanceMetersBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.distanceMeters_ = value;
            } else {
                this.distanceMetersBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        public Builder setDistanceMeters(Int32Value.Builder builderForValue) {
            if (this.distanceMetersBuilder_ == null) {
                this.distanceMeters_ = builderForValue.build();
            } else {
                this.distanceMetersBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        public Builder mergeDistanceMeters(Int32Value value) {
            if (this.distanceMetersBuilder_ == null) {
                if ((this.bitField0_ & 0x40) != 0 && this.distanceMeters_ != null && this.distanceMeters_ != Int32Value.getDefaultInstance()) {
                    this.getDistanceMetersBuilder().mergeFrom(value);
                } else {
                    this.distanceMeters_ = value;
                }
            } else {
                this.distanceMetersBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.distanceMeters_ != null) {
                this.bitField0_ |= 0x40;
                this.onChanged();
            }
            return this;
        }

        public Builder clearDistanceMeters() {
            this.bitField0_ &= 0xFFFFFFBF;
            this.distanceMeters_ = null;
            if (this.distanceMetersBuilder_ != null) {
                this.distanceMetersBuilder_.dispose();
                this.distanceMetersBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Int32Value.Builder getDistanceMetersBuilder() {
            this.bitField0_ |= 0x40;
            this.onChanged();
            return (Int32Value.Builder)this.getDistanceMetersFieldBuilder().getBuilder();
        }

        @Override
        public Int32ValueOrBuilder getDistanceMetersOrBuilder() {
            if (this.distanceMetersBuilder_ != null) {
                return (Int32ValueOrBuilder)this.distanceMetersBuilder_.getMessageOrBuilder();
            }
            return this.distanceMeters_ == null ? Int32Value.getDefaultInstance() : this.distanceMeters_;
        }

        private SingleFieldBuilderV3<Int32Value, Int32Value.Builder, Int32ValueOrBuilder> getDistanceMetersFieldBuilder() {
            if (this.distanceMetersBuilder_ == null) {
                this.distanceMetersBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getDistanceMeters(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.distanceMeters_ = null;
            }
            return this.distanceMetersBuilder_;
        }

        @Override
        public boolean hasEta() {
            return (this.bitField0_ & 0x80) != 0;
        }

        @Override
        public Timestamp getEta() {
            if (this.etaBuilder_ == null) {
                return this.eta_ == null ? Timestamp.getDefaultInstance() : this.eta_;
            }
            return (Timestamp)this.etaBuilder_.getMessage();
        }

        public Builder setEta(Timestamp value) {
            if (this.etaBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.eta_ = value;
            } else {
                this.etaBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        public Builder setEta(Timestamp.Builder builderForValue) {
            if (this.etaBuilder_ == null) {
                this.eta_ = builderForValue.build();
            } else {
                this.etaBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        public Builder mergeEta(Timestamp value) {
            if (this.etaBuilder_ == null) {
                if ((this.bitField0_ & 0x80) != 0 && this.eta_ != null && this.eta_ != Timestamp.getDefaultInstance()) {
                    this.getEtaBuilder().mergeFrom(value);
                } else {
                    this.eta_ = value;
                }
            } else {
                this.etaBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.eta_ != null) {
                this.bitField0_ |= 0x80;
                this.onChanged();
            }
            return this;
        }

        public Builder clearEta() {
            this.bitField0_ &= 0xFFFFFF7F;
            this.eta_ = null;
            if (this.etaBuilder_ != null) {
                this.etaBuilder_.dispose();
                this.etaBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Timestamp.Builder getEtaBuilder() {
            this.bitField0_ |= 0x80;
            this.onChanged();
            return (Timestamp.Builder)this.getEtaFieldBuilder().getBuilder();
        }

        @Override
        public TimestampOrBuilder getEtaOrBuilder() {
            if (this.etaBuilder_ != null) {
                return (TimestampOrBuilder)this.etaBuilder_.getMessageOrBuilder();
            }
            return this.eta_ == null ? Timestamp.getDefaultInstance() : this.eta_;
        }

        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> getEtaFieldBuilder() {
            if (this.etaBuilder_ == null) {
                this.etaBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getEta(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.eta_ = null;
            }
            return this.etaBuilder_;
        }

        @Override
        public boolean hasDuration() {
            return (this.bitField0_ & 0x100) != 0;
        }

        @Override
        public Duration getDuration() {
            if (this.durationBuilder_ == null) {
                return this.duration_ == null ? Duration.getDefaultInstance() : this.duration_;
            }
            return (Duration)this.durationBuilder_.getMessage();
        }

        public Builder setDuration(Duration value) {
            if (this.durationBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.duration_ = value;
            } else {
                this.durationBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        public Builder setDuration(Duration.Builder builderForValue) {
            if (this.durationBuilder_ == null) {
                this.duration_ = builderForValue.build();
            } else {
                this.durationBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        public Builder mergeDuration(Duration value) {
            if (this.durationBuilder_ == null) {
                if ((this.bitField0_ & 0x100) != 0 && this.duration_ != null && this.duration_ != Duration.getDefaultInstance()) {
                    this.getDurationBuilder().mergeFrom(value);
                } else {
                    this.duration_ = value;
                }
            } else {
                this.durationBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.duration_ != null) {
                this.bitField0_ |= 0x100;
                this.onChanged();
            }
            return this;
        }

        public Builder clearDuration() {
            this.bitField0_ &= 0xFFFFFEFF;
            this.duration_ = null;
            if (this.durationBuilder_ != null) {
                this.durationBuilder_.dispose();
                this.durationBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Duration.Builder getDurationBuilder() {
            this.bitField0_ |= 0x100;
            this.onChanged();
            return (Duration.Builder)this.getDurationFieldBuilder().getBuilder();
        }

        @Override
        public DurationOrBuilder getDurationOrBuilder() {
            if (this.durationBuilder_ != null) {
                return (DurationOrBuilder)this.durationBuilder_.getMessageOrBuilder();
            }
            return this.duration_ == null ? Duration.getDefaultInstance() : this.duration_;
        }

        private SingleFieldBuilderV3<Duration, Duration.Builder, DurationOrBuilder> getDurationFieldBuilder() {
            if (this.durationBuilder_ == null) {
                this.durationBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getDuration(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.duration_ = null;
            }
            return this.durationBuilder_;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }
}

