/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.android.ui;

import android.content.Context;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.widget.FrameLayout;

public class RotationLayout
extends FrameLayout {
    private int mRotation;

    public RotationLayout(Context context) {
        super(context);
    }

    public RotationLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public RotationLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.mRotation == 1 || this.mRotation == 3) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            this.setMeasuredDimension(this.getMeasuredHeight(), this.getMeasuredWidth());
        } else {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        }
    }

    public void setViewRotation(int degrees) {
        this.mRotation = (degrees + 360) % 360 / 90;
    }

    public void dispatchDraw(Canvas canvas) {
        if (this.mRotation == 0) {
            super.dispatchDraw(canvas);
            return;
        }
        if (this.mRotation == 1) {
            canvas.translate((float)this.getWidth(), 0.0f);
            canvas.rotate(90.0f, (float)(this.getWidth() / 2), 0.0f);
            canvas.translate((float)(this.getHeight() / 2), (float)(this.getWidth() / 2));
        } else if (this.mRotation == 2) {
            canvas.rotate(180.0f, (float)(this.getWidth() / 2), (float)(this.getHeight() / 2));
        } else {
            canvas.translate(0.0f, (float)this.getHeight());
            canvas.rotate(270.0f, (float)(this.getWidth() / 2), 0.0f);
            canvas.translate((float)(this.getHeight() / 2), (float)(-this.getWidth() / 2));
        }
        super.dispatchDraw(canvas);
    }
}

