/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.android.clustering.algo;

import androidx.collection.LongSparseArray;
import com.google.maps.android.clustering.Cluster;
import com.google.maps.android.clustering.ClusterItem;
import com.google.maps.android.clustering.algo.AbstractAlgorithm;
import com.google.maps.android.clustering.algo.StaticCluster;
import com.google.maps.android.projection.Point;
import com.google.maps.android.projection.SphericalMercatorProjection;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class GridBasedAlgorithm<T extends ClusterItem>
extends AbstractAlgorithm<T> {
    private static final int DEFAULT_GRID_SIZE = 100;
    private int mGridSize = 100;
    private final Set<T> mItems = Collections.synchronizedSet(new HashSet());

    @Override
    public boolean addItem(T item) {
        return this.mItems.add(item);
    }

    @Override
    public boolean addItems(Collection<T> items) {
        return this.mItems.addAll(items);
    }

    @Override
    public void clearItems() {
        this.mItems.clear();
    }

    @Override
    public boolean removeItem(T item) {
        return this.mItems.remove(item);
    }

    @Override
    public boolean removeItems(Collection<T> items) {
        return this.mItems.removeAll(items);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateItem(T item) {
        boolean result;
        Set<T> set = this.mItems;
        synchronized (set) {
            result = this.removeItem(item);
            if (result) {
                result = this.addItem(item);
            }
        }
        return result;
    }

    @Override
    public void setMaxDistanceBetweenClusteredItems(int maxDistance) {
        this.mGridSize = maxDistance;
    }

    @Override
    public int getMaxDistanceBetweenClusteredItems() {
        return this.mGridSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<? extends Cluster<T>> getClusters(float zoom) {
        long numCells = (long)Math.ceil(256.0 * Math.pow(2.0, zoom) / (double)this.mGridSize);
        SphericalMercatorProjection proj = new SphericalMercatorProjection(numCells);
        HashSet<StaticCluster<ClusterItem>> clusters = new HashSet<StaticCluster<ClusterItem>>();
        LongSparseArray sparseArray = new LongSparseArray();
        Set<T> set = this.mItems;
        synchronized (set) {
            for (ClusterItem item : this.mItems) {
                Point p = proj.toPoint(item.getPosition());
                long coord = GridBasedAlgorithm.getCoord(numCells, p.x, p.y);
                StaticCluster<ClusterItem> cluster = (StaticCluster<ClusterItem>)sparseArray.get(coord);
                if (cluster == null) {
                    cluster = new StaticCluster<ClusterItem>(proj.toLatLng(new com.google.maps.android.geometry.Point(Math.floor(p.x) + 0.5, Math.floor(p.y) + 0.5)));
                    sparseArray.put(coord, cluster);
                    clusters.add(cluster);
                }
                cluster.add(item);
            }
        }
        return clusters;
    }

    @Override
    public Collection<T> getItems() {
        return this.mItems;
    }

    private static long getCoord(long numCells, double x, double y) {
        return (long)((double)numCells * Math.floor(x) + Math.floor(y));
    }
}

