/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.android.clustering.algo;

import androidx.annotation.NonNull;
import com.google.android.gms.maps.model.LatLng;
import com.google.maps.android.clustering.Cluster;
import com.google.maps.android.clustering.ClusterItem;
import java.util.Collection;
import java.util.LinkedHashSet;

public class StaticCluster<T extends ClusterItem>
implements Cluster<T> {
    private final LatLng mCenter;
    private final Collection<T> mItems = new LinkedHashSet<T>();

    public StaticCluster(LatLng center) {
        this.mCenter = center;
    }

    public boolean add(T t) {
        return this.mItems.add(t);
    }

    @Override
    public LatLng getPosition() {
        return this.mCenter;
    }

    public boolean remove(T t) {
        return this.mItems.remove(t);
    }

    @Override
    public Collection<T> getItems() {
        return this.mItems;
    }

    @Override
    public int getSize() {
        return this.mItems.size();
    }

    @NonNull
    public String toString() {
        return "StaticCluster{mCenter=" + this.mCenter + ", mItems.size=" + this.mItems.size() + '}';
    }

    public int hashCode() {
        return this.mCenter.hashCode() + this.mItems.hashCode();
    }

    public boolean equals(Object other) {
        if (!(other instanceof StaticCluster)) {
            return false;
        }
        return ((StaticCluster)other).mCenter.equals((Object)this.mCenter) && ((StaticCluster)other).mItems.equals(this.mItems);
    }
}

