/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.android.clustering.algo;

import com.google.android.gms.maps.model.LatLng;
import com.google.maps.android.clustering.Cluster;
import com.google.maps.android.clustering.ClusterItem;
import com.google.maps.android.clustering.algo.NonHierarchicalDistanceBasedAlgorithm;
import com.google.maps.android.clustering.algo.StaticCluster;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class CentroidNonHierarchicalDistanceBasedAlgorithm<T extends ClusterItem>
extends NonHierarchicalDistanceBasedAlgorithm<T> {
    protected LatLng computeCentroid(Collection<T> items) {
        double latSum = 0.0;
        double lngSum = 0.0;
        int count = 0;
        for (ClusterItem item : items) {
            latSum += item.getPosition().latitude;
            lngSum += item.getPosition().longitude;
            ++count;
        }
        return new LatLng(latSum / (double)count, lngSum / (double)count);
    }

    @Override
    public Set<? extends Cluster<T>> getClusters(float zoom) {
        Set originalClusters = super.getClusters(zoom);
        HashSet newClusters = new HashSet();
        for (Cluster cluster : originalClusters) {
            LatLng centroid = this.computeCentroid(cluster.getItems());
            StaticCluster<ClusterItem> newCluster = new StaticCluster<ClusterItem>(centroid);
            for (ClusterItem item : cluster.getItems()) {
                newCluster.add(item);
            }
            newClusters.add(newCluster);
        }
        return newClusters;
    }
}

