/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.android.ui;

import android.os.Handler;
import android.os.SystemClock;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.Interpolator;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.Marker;

public class AnimationUtil {
    public static void animateMarkerTo(Marker marker, LatLng finalPosition) {
        LatLngInterpolator.Linear latLngInterpolator = new LatLngInterpolator.Linear();
        LatLng startPosition = marker.getPosition();
        Handler handler = new Handler();
        final long start = SystemClock.uptimeMillis();
        AccelerateDecelerateInterpolator interpolator = new AccelerateDecelerateInterpolator();
        float durationInMs = 2000.0f;
        handler.post(new Runnable(){
            long elapsed;
            float t;
            float v;
            final /* synthetic */ Interpolator val$interpolator;
            final /* synthetic */ Marker val$marker;
            final /* synthetic */ LatLngInterpolator val$latLngInterpolator;
            final /* synthetic */ LatLng val$startPosition;
            final /* synthetic */ LatLng val$finalPosition;
            final /* synthetic */ Handler val$handler;
            {
                this.val$interpolator = interpolator;
                this.val$marker = marker;
                this.val$latLngInterpolator = latLngInterpolator;
                this.val$startPosition = latLng;
                this.val$finalPosition = latLng2;
                this.val$handler = handler;
            }

            @Override
            public void run() {
                this.elapsed = SystemClock.uptimeMillis() - start;
                this.t = (float)this.elapsed / 2000.0f;
                this.v = this.val$interpolator.getInterpolation(this.t);
                this.val$marker.setPosition(this.val$latLngInterpolator.interpolate(this.v, this.val$startPosition, this.val$finalPosition));
                if (this.t < 1.0f) {
                    this.val$handler.postDelayed((Runnable)this, 16L);
                }
            }
        });
    }

    static interface LatLngInterpolator {
        public LatLng interpolate(float var1, LatLng var2, LatLng var3);

        public static class Linear
        implements LatLngInterpolator {
            @Override
            public LatLng interpolate(float fraction, LatLng a, LatLng b) {
                double lat = (b.latitude - a.latitude) * (double)fraction + a.latitude;
                double lngDelta = b.longitude - a.longitude;
                if (Math.abs(lngDelta) > 180.0) {
                    lngDelta -= Math.signum(lngDelta) * 360.0;
                }
                double lng = lngDelta * (double)fraction + a.longitude;
                return new LatLng(lat, lng);
            }
        }
    }
}

