/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.android.data.kml;

import com.google.maps.android.data.kml.KmlBoolean;
import com.google.maps.android.data.kml.KmlStyle;
import java.io.IOException;
import java.util.HashMap;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

class KmlStyleParser {
    private static final String STYLE_TAG = "styleUrl";
    private static final String ICON_STYLE_HEADING = "heading";
    private static final String ICON_STYLE_URL = "Icon";
    private static final String ICON_STYLE_SCALE = "scale";
    private static final String ICON_STYLE_HOTSPOT = "hotSpot";
    private static final String COLOR_STYLE_COLOR = "color";
    private static final String COLOR_STYLE_MODE = "colorMode";
    private static final String STYLE_MAP_KEY = "key";
    private static final String STYLE_MAP_NORMAL_STYLE = "normal";
    private static final String LINE_STYLE_WIDTH = "width";
    private static final String POLY_STYLE_OUTLINE = "outline";
    private static final String POLY_STYLE_FILL = "fill";

    KmlStyleParser() {
    }

    static KmlStyle createStyle(XmlPullParser parser) throws IOException, XmlPullParserException {
        KmlStyle styleProperties = new KmlStyle();
        KmlStyleParser.setStyleId(parser.getAttributeValue(null, "id"), styleProperties);
        int eventType = parser.getEventType();
        while (eventType != 3 || !parser.getName().equals("Style")) {
            if (eventType == 2) {
                if (parser.getName().equals("IconStyle")) {
                    KmlStyleParser.createIconStyle(parser, styleProperties);
                } else if (parser.getName().equals("LineStyle")) {
                    KmlStyleParser.createLineStyle(parser, styleProperties);
                } else if (parser.getName().equals("PolyStyle")) {
                    KmlStyleParser.createPolyStyle(parser, styleProperties);
                } else if (parser.getName().equals("BalloonStyle")) {
                    KmlStyleParser.createBalloonStyle(parser, styleProperties);
                }
            }
            eventType = parser.next();
        }
        return styleProperties;
    }

    private static void setStyleId(String id2, KmlStyle styleProperties) {
        if (id2 != null) {
            String styleId = "#" + id2;
            styleProperties.setStyleId(styleId);
        }
    }

    private static void createIconStyle(XmlPullParser parser, KmlStyle style2) throws XmlPullParserException, IOException {
        int eventType = parser.getEventType();
        while (eventType != 3 || !parser.getName().equals("IconStyle")) {
            if (eventType == 2) {
                if (parser.getName().equals(ICON_STYLE_HEADING)) {
                    style2.setHeading(Float.parseFloat(parser.nextText()));
                } else if (parser.getName().equals(ICON_STYLE_URL)) {
                    KmlStyleParser.setIconUrl(parser, style2);
                } else if (parser.getName().equals(ICON_STYLE_HOTSPOT)) {
                    KmlStyleParser.setIconHotSpot(parser, style2);
                } else if (parser.getName().equals(ICON_STYLE_SCALE)) {
                    style2.setIconScale(Double.parseDouble(parser.nextText()));
                } else if (parser.getName().equals(COLOR_STYLE_COLOR)) {
                    style2.setMarkerColor(parser.nextText());
                } else if (parser.getName().equals(COLOR_STYLE_MODE)) {
                    style2.setIconColorMode(parser.nextText());
                }
            }
            eventType = parser.next();
        }
    }

    static HashMap<String, String> createStyleMap(XmlPullParser parser) throws XmlPullParserException, IOException {
        HashMap<String, String> styleMaps = new HashMap<String, String>();
        Boolean isNormalStyleMapValue = false;
        String styleId = "#" + parser.getAttributeValue(null, "id");
        int eventType = parser.getEventType();
        while (eventType != 3 || !parser.getName().equals("StyleMap")) {
            if (eventType == 2) {
                if (parser.getName().equals(STYLE_MAP_KEY) && parser.nextText().equals(STYLE_MAP_NORMAL_STYLE)) {
                    isNormalStyleMapValue = true;
                } else if (parser.getName().equals(STYLE_TAG) && isNormalStyleMapValue.booleanValue()) {
                    styleMaps.put(styleId, parser.nextText());
                    isNormalStyleMapValue = false;
                }
            }
            eventType = parser.next();
        }
        return styleMaps;
    }

    private static void createBalloonStyle(XmlPullParser parser, KmlStyle style2) throws XmlPullParserException, IOException {
        int eventType = parser.getEventType();
        while (eventType != 3 || !parser.getName().equals("BalloonStyle")) {
            if (eventType == 2 && parser.getName().equals("text")) {
                style2.setInfoWindowText(parser.nextText());
            }
            eventType = parser.next();
        }
    }

    private static void setIconUrl(XmlPullParser parser, KmlStyle style2) throws XmlPullParserException, IOException {
        int eventType = parser.getEventType();
        while (eventType != 3 || !parser.getName().equals(ICON_STYLE_URL)) {
            if (eventType == 2 && parser.getName().equals("href")) {
                style2.setIconUrl(parser.nextText());
            }
            eventType = parser.next();
        }
    }

    private static void setIconHotSpot(XmlPullParser parser, KmlStyle style2) {
        Float xValue = Float.valueOf(Float.parseFloat(parser.getAttributeValue(null, "x")));
        Float yValue = Float.valueOf(Float.parseFloat(parser.getAttributeValue(null, "y")));
        String xUnits = parser.getAttributeValue(null, "xunits");
        String yUnits = parser.getAttributeValue(null, "yunits");
        style2.setHotSpot(xValue.floatValue(), yValue.floatValue(), xUnits, yUnits);
    }

    private static void createLineStyle(XmlPullParser parser, KmlStyle style2) throws XmlPullParserException, IOException {
        int eventType = parser.getEventType();
        while (eventType != 3 || !parser.getName().equals("LineStyle")) {
            if (eventType == 2) {
                if (parser.getName().equals(COLOR_STYLE_COLOR)) {
                    style2.setOutlineColor(parser.nextText());
                } else if (parser.getName().equals(LINE_STYLE_WIDTH)) {
                    style2.setWidth(Float.valueOf(parser.nextText()));
                } else if (parser.getName().equals(COLOR_STYLE_MODE)) {
                    style2.setLineColorMode(parser.nextText());
                }
            }
            eventType = parser.next();
        }
    }

    private static void createPolyStyle(XmlPullParser parser, KmlStyle style2) throws XmlPullParserException, IOException {
        int eventType = parser.getEventType();
        while (eventType != 3 || !parser.getName().equals("PolyStyle")) {
            if (eventType == 2) {
                if (parser.getName().equals(COLOR_STYLE_COLOR)) {
                    style2.setFillColor(parser.nextText());
                } else if (parser.getName().equals(POLY_STYLE_OUTLINE)) {
                    style2.setOutline(KmlBoolean.parseBoolean(parser.nextText()));
                } else if (parser.getName().equals(POLY_STYLE_FILL)) {
                    style2.setFill(KmlBoolean.parseBoolean(parser.nextText()));
                } else if (parser.getName().equals(COLOR_STYLE_MODE)) {
                    style2.setPolyColorMode(parser.nextText());
                }
            }
            eventType = parser.next();
        }
    }
}

