/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.android.data;

import com.google.maps.android.data.Geometry;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;

public class Feature
extends Observable {
    private final String mId;
    private final Map<String, String> mProperties;
    private Geometry mGeometry;

    public Feature(Geometry featureGeometry, String id, Map<String, String> properties) {
        this.mGeometry = featureGeometry;
        this.mId = id;
        this.mProperties = properties == null ? new HashMap<String, String>() : properties;
    }

    public Iterable<String> getPropertyKeys() {
        return this.mProperties.keySet();
    }

    public Iterable getProperties() {
        return this.mProperties.entrySet();
    }

    public String getProperty(String property) {
        return this.mProperties.get(property);
    }

    public String getId() {
        return this.mId;
    }

    public boolean hasProperty(String property) {
        return this.mProperties.containsKey(property);
    }

    public Geometry getGeometry() {
        return this.mGeometry;
    }

    public boolean hasProperties() {
        return this.mProperties.size() > 0;
    }

    public boolean hasGeometry() {
        return this.mGeometry != null;
    }

    protected String setProperty(String property, String propertyValue) {
        return this.mProperties.put(property, propertyValue);
    }

    protected String removeProperty(String property) {
        return this.mProperties.remove(property);
    }

    protected void setGeometry(Geometry geometry) {
        this.mGeometry = geometry;
    }
}

