/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.android.kml;

import android.graphics.Color;
import com.google.android.gms.maps.model.BitmapDescriptorFactory;
import com.google.android.gms.maps.model.MarkerOptions;
import com.google.android.gms.maps.model.PolygonOptions;
import com.google.android.gms.maps.model.PolylineOptions;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;

class KmlStyle {
    private static final int HSV_VALUES = 3;
    private static final int HUE_VALUE = 0;
    private static final int INITIAL_SCALE = 1;
    private final MarkerOptions mMarkerOptions = new MarkerOptions();
    private final PolylineOptions mPolylineOptions = new PolylineOptions();
    private final PolygonOptions mPolygonOptions = new PolygonOptions();
    private final HashMap<String, String> mBalloonOptions = new HashMap();
    private final HashSet<String> mStylesSet = new HashSet();
    private boolean mFill = true;
    private boolean mOutline = true;
    private String mIconUrl;
    private double mScale = 1.0;
    private String mStyleId = null;
    private boolean mIconRandomColorMode = false;
    private boolean mLineRandomColorMode = false;
    private boolean mPolyRandomColorMode = false;
    private float mMarkerColor = 0.0f;

    KmlStyle() {
    }

    void setInfoWindowText(String text) {
        this.mBalloonOptions.put("text", text);
    }

    String getStyleId() {
        return this.mStyleId;
    }

    void setStyleId(String styleId) {
        this.mStyleId = styleId;
    }

    boolean isStyleSet(String style2) {
        return this.mStylesSet.contains(style2);
    }

    boolean hasFill() {
        return this.mFill;
    }

    void setFill(boolean fill) {
        this.mFill = fill;
    }

    double getIconScale() {
        return this.mScale;
    }

    void setIconScale(double scale) {
        this.mScale = scale;
        this.mStylesSet.add("iconScale");
    }

    boolean hasOutline() {
        return this.mOutline;
    }

    boolean hasBalloonStyle() {
        return this.mBalloonOptions.size() > 0;
    }

    void setOutline(boolean outline) {
        this.mOutline = outline;
        this.mStylesSet.add("outline");
    }

    String getIconUrl() {
        return this.mIconUrl;
    }

    void setIconUrl(String iconUrl) {
        this.mIconUrl = iconUrl;
        if (!this.mIconUrl.startsWith("http://")) {
            this.mMarkerOptions.icon(BitmapDescriptorFactory.fromPath((String)iconUrl));
        }
        this.mStylesSet.add("iconUrl");
    }

    void setFillColor(String color) {
        String string = String.valueOf(KmlStyle.convertColor(color));
        this.mPolygonOptions.fillColor(Color.parseColor((String)(string.length() != 0 ? "#".concat(string) : new String("#"))));
        this.mStylesSet.add("fillColor");
    }

    void setMarkerColor(String color) {
        String string = String.valueOf(KmlStyle.convertColor(color));
        int integerColor = Color.parseColor((String)(string.length() != 0 ? "#".concat(string) : new String("#")));
        this.mMarkerColor = KmlStyle.getHueValue(integerColor);
        this.mMarkerOptions.icon(BitmapDescriptorFactory.defaultMarker((float)this.mMarkerColor));
        this.mStylesSet.add("markerColor");
    }

    private static float getHueValue(int integerColor) {
        float[] hsvValues = new float[3];
        Color.colorToHSV((int)integerColor, (float[])hsvValues);
        return hsvValues[0];
    }

    private static String convertColor(String color) {
        String newColor;
        if (color.length() > 6) {
            String string = String.valueOf(color.substring(0, 2));
            String string2 = String.valueOf(color.substring(6, 8));
            String string3 = String.valueOf(color.substring(4, 6));
            String string4 = String.valueOf(color.substring(2, 4));
            newColor = new StringBuilder(0 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(string4).length()).append(string).append(string2).append(string3).append(string4).toString();
        } else {
            String string = String.valueOf(color.substring(4, 6));
            String string5 = String.valueOf(color.substring(2, 4));
            String string6 = String.valueOf(color.substring(0, 2));
            newColor = new StringBuilder(0 + String.valueOf(string).length() + String.valueOf(string5).length() + String.valueOf(string6).length()).append(string).append(string5).append(string6).toString();
        }
        return newColor;
    }

    void setHeading(float heading) {
        this.mMarkerOptions.rotation(heading);
        this.mStylesSet.add("heading");
    }

    void setHotSpot(float x, float y, String xUnits, String yUnits) {
        float xAnchor = 0.5f;
        float yAnchor = 1.0f;
        if (xUnits.equals("fraction")) {
            xAnchor = x;
        }
        if (yUnits.equals("fraction")) {
            yAnchor = y;
        }
        this.mMarkerOptions.anchor(xAnchor, yAnchor);
        this.mStylesSet.add("hotSpot");
    }

    void setIconColorMode(String colorMode) {
        this.mIconRandomColorMode = colorMode.equals("random");
        this.mStylesSet.add("iconColorMode");
    }

    boolean isIconRandomColorMode() {
        return this.mIconRandomColorMode;
    }

    void setLineColorMode(String colorMode) {
        this.mLineRandomColorMode = colorMode.equals("random");
        this.mStylesSet.add("lineColorMode");
    }

    boolean isLineRandomColorMode() {
        return this.mLineRandomColorMode;
    }

    void setPolyColorMode(String colorMode) {
        this.mPolyRandomColorMode = colorMode.equals("random");
        this.mStylesSet.add("polyColorMode");
    }

    boolean isPolyRandomColorMode() {
        return this.mPolyRandomColorMode;
    }

    void setOutlineColor(String color) {
        String string = String.valueOf(KmlStyle.convertColor(color));
        this.mPolylineOptions.color(Color.parseColor((String)(string.length() != 0 ? "#".concat(string) : new String("#"))));
        String string2 = String.valueOf(color);
        this.mPolygonOptions.strokeColor(Color.parseColor((String)(string2.length() != 0 ? "#".concat(string2) : new String("#"))));
        this.mStylesSet.add("outlineColor");
    }

    void setWidth(Float width) {
        this.mPolylineOptions.width(width.floatValue());
        this.mPolygonOptions.strokeWidth(width.floatValue());
        this.mStylesSet.add("width");
    }

    HashMap<String, String> getBalloonOptions() {
        return this.mBalloonOptions;
    }

    private static MarkerOptions createMarkerOptions(MarkerOptions originalMarkerOption, boolean iconRandomColorMode, float markerColor) {
        MarkerOptions newMarkerOption = new MarkerOptions();
        newMarkerOption.rotation(originalMarkerOption.getRotation());
        newMarkerOption.anchor(originalMarkerOption.getAnchorU(), originalMarkerOption.getAnchorV());
        if (iconRandomColorMode) {
            float hue = KmlStyle.getHueValue(KmlStyle.computeRandomColor((int)markerColor));
            originalMarkerOption.icon(BitmapDescriptorFactory.defaultMarker((float)hue));
        }
        newMarkerOption.icon(originalMarkerOption.getIcon());
        return newMarkerOption;
    }

    private static PolylineOptions createPolylineOptions(PolylineOptions originalPolylineOption) {
        PolylineOptions polylineOptions = new PolylineOptions();
        polylineOptions.color(originalPolylineOption.getColor());
        polylineOptions.width(originalPolylineOption.getWidth());
        return polylineOptions;
    }

    private static PolygonOptions createPolygonOptions(PolygonOptions originalPolygonOption, boolean isFill, boolean isOutline) {
        PolygonOptions polygonOptions = new PolygonOptions();
        if (isFill) {
            polygonOptions.fillColor(originalPolygonOption.getFillColor());
        }
        if (isOutline) {
            polygonOptions.strokeColor(originalPolygonOption.getStrokeColor());
            polygonOptions.strokeWidth(originalPolygonOption.getStrokeWidth());
        }
        return polygonOptions;
    }

    MarkerOptions getMarkerOptions() {
        return KmlStyle.createMarkerOptions(this.mMarkerOptions, this.isIconRandomColorMode(), this.mMarkerColor);
    }

    PolylineOptions getPolylineOptions() {
        return KmlStyle.createPolylineOptions(this.mPolylineOptions);
    }

    PolygonOptions getPolygonOptions() {
        return KmlStyle.createPolygonOptions(this.mPolygonOptions, this.mFill, this.mOutline);
    }

    static int computeRandomColor(int color) {
        Random random = new Random();
        int red = Color.red((int)color);
        int green = Color.green((int)color);
        int blue = Color.blue((int)color);
        if (red != 0) {
            red = random.nextInt(red);
        }
        if (blue != 0) {
            blue = random.nextInt(blue);
        }
        if (green != 0) {
            green = random.nextInt(green);
        }
        return Color.rgb((int)red, (int)green, (int)blue);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Style").append("{");
        sb.append("\n balloon options=").append(this.mBalloonOptions);
        sb.append(",\n fill=").append(this.mFill);
        sb.append(",\n outline=").append(this.mOutline);
        sb.append(",\n icon url=").append(this.mIconUrl);
        sb.append(",\n scale=").append(this.mScale);
        sb.append(",\n style id=").append(this.mStyleId);
        sb.append("\n}\n");
        return sb.toString();
    }
}

