/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.android.ui;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.google.maps.android.R;
import com.google.maps.android.ui.BubbleDrawable;
import com.google.maps.android.ui.RotationLayout;

public class IconGenerator {
    private final Context mContext;
    private ViewGroup mContainer;
    private RotationLayout mRotationLayout;
    private TextView mTextView;
    private View mContentView;
    private int mRotation;
    private float mAnchorU = 0.5f;
    private float mAnchorV = 1.0f;
    private BubbleDrawable mBackground;
    public static final int STYLE_DEFAULT = 1;
    public static final int STYLE_WHITE = 2;
    public static final int STYLE_RED = 3;
    public static final int STYLE_BLUE = 4;
    public static final int STYLE_GREEN = 5;
    public static final int STYLE_PURPLE = 6;
    public static final int STYLE_ORANGE = 7;

    public IconGenerator(Context context) {
        this.mContext = context;
        this.mBackground = new BubbleDrawable(this.mContext.getResources());
        this.mContainer = (ViewGroup)LayoutInflater.from((Context)this.mContext).inflate(R.layout.text_bubble, null);
        this.mRotationLayout = (RotationLayout)this.mContainer.getChildAt(0);
        this.mTextView = (TextView)this.mRotationLayout.findViewById(R.id.text);
        this.mContentView = this.mTextView;
        this.setStyle(1);
    }

    public Bitmap makeIcon(String text) {
        if (this.mTextView != null) {
            this.mTextView.setText((CharSequence)text);
        }
        return this.makeIcon();
    }

    public Bitmap makeIcon() {
        int measureSpec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        this.mContainer.measure(measureSpec, measureSpec);
        int measuredWidth = this.mContainer.getMeasuredWidth();
        int measuredHeight = this.mContainer.getMeasuredHeight();
        this.mContainer.layout(0, 0, measuredWidth, measuredHeight);
        if (this.mRotation == 1 || this.mRotation == 3) {
            measuredHeight = this.mContainer.getMeasuredWidth();
            measuredWidth = this.mContainer.getMeasuredHeight();
        }
        Bitmap r = Bitmap.createBitmap((int)measuredWidth, (int)measuredHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        r.eraseColor(0);
        Canvas canvas = new Canvas(r);
        if (this.mRotation != 0) {
            if (this.mRotation == 1) {
                canvas.translate((float)measuredWidth, 0.0f);
                canvas.rotate(90.0f);
            } else if (this.mRotation == 2) {
                canvas.rotate(180.0f, (float)(measuredWidth / 2), (float)(measuredHeight / 2));
            } else {
                canvas.translate(0.0f, (float)measuredHeight);
                canvas.rotate(270.0f);
            }
        }
        this.mContainer.draw(canvas);
        return r;
    }

    public void setContentView(View contentView) {
        this.mRotationLayout.removeAllViews();
        this.mRotationLayout.addView(contentView);
        this.mContentView = contentView;
        View view = this.mRotationLayout.findViewById(R.id.text);
        this.mTextView = view instanceof TextView ? (TextView)view : null;
    }

    public void setContentRotation(int degrees) {
        this.mRotationLayout.setViewRotation(degrees);
    }

    public void setRotation(int degrees) {
        this.mRotation = (degrees + 360) % 360 / 90;
    }

    public float getAnchorU() {
        return this.rotateAnchor(this.mAnchorU, this.mAnchorV);
    }

    public float getAnchorV() {
        return this.rotateAnchor(this.mAnchorV, this.mAnchorU);
    }

    private float rotateAnchor(float u, float v) {
        switch (this.mRotation) {
            case 0: {
                return u;
            }
            case 1: {
                return 1.0f - v;
            }
            case 2: {
                return 1.0f - u;
            }
            case 3: {
                return v;
            }
        }
        throw new IllegalStateException();
    }

    public void setTextAppearance(Context context, int resid) {
        if (this.mTextView != null) {
            this.mTextView.setTextAppearance(context, resid);
        }
    }

    public void setTextAppearance(int resid) {
        this.setTextAppearance(this.mContext, resid);
    }

    public void setStyle(int style2) {
        this.setColor(IconGenerator.getStyleColor(style2));
        this.setTextAppearance(this.mContext, IconGenerator.getTextStyle(style2));
    }

    public void setColor(int color) {
        this.mBackground.setColor(color);
        this.setBackground(this.mBackground);
    }

    public void setBackground(Drawable background) {
        this.mContainer.setBackgroundDrawable(background);
        if (background != null) {
            Rect rect = new Rect();
            background.getPadding(rect);
            this.mContainer.setPadding(rect.left, rect.top, rect.right, rect.bottom);
        } else {
            this.mContainer.setPadding(0, 0, 0, 0);
        }
    }

    public void setContentPadding(int left, int top, int right, int bottom) {
        this.mContentView.setPadding(left, top, right, bottom);
    }

    private static int getStyleColor(int style2) {
        switch (style2) {
            default: {
                return -1;
            }
            case 3: {
                return -3407872;
            }
            case 4: {
                return -16737844;
            }
            case 5: {
                return -10053376;
            }
            case 6: {
                return -6736948;
            }
            case 7: 
        }
        return -30720;
    }

    private static int getTextStyle(int style2) {
        switch (style2) {
            default: {
                return R.style.Bubble_TextAppearance_Dark;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
        }
        return R.style.Bubble_TextAppearance_Light;
    }
}

