/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.android.clustering.algo;

import com.google.android.gms.maps.model.LatLng;
import com.google.maps.android.clustering.Cluster;
import com.google.maps.android.clustering.ClusterItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class StaticCluster<T extends ClusterItem>
implements Cluster<T> {
    private final LatLng mCenter;
    private final List<T> mItems = new ArrayList<T>();

    public StaticCluster(LatLng center) {
        this.mCenter = center;
    }

    public boolean add(T t) {
        return this.mItems.add(t);
    }

    @Override
    public LatLng getPosition() {
        return this.mCenter;
    }

    public boolean remove(T t) {
        return this.mItems.remove(t);
    }

    @Override
    public Collection<T> getItems() {
        return this.mItems;
    }

    @Override
    public int getSize() {
        return this.mItems.size();
    }

    public String toString() {
        String string = String.valueOf("StaticCluster{mCenter=");
        String string2 = String.valueOf(this.mCenter);
        int n = this.mItems.size();
        return new StringBuilder(26 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(string2).append(", mItems.size=").append(n).append("}").toString();
    }
}

