/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.transpile;

import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.jscomp.jarjar.com.google.common.escape.Escaper;
import com.google.javascript.jscomp.jarjar.com.google.common.net.PercentEscaper;
import java.net.URI;
import java.util.Objects;

public final class TranspileResult {
    private final URI path;
    private final String original;
    private final String transpiled;
    private final String sourceMap;
    private static final Escaper ESCAPER = new PercentEscaper("-_.*", false);

    public TranspileResult(URI path, String original, String transpiled, String sourceMap) {
        this.path = Preconditions.checkNotNull(path);
        this.original = Preconditions.checkNotNull(original);
        this.transpiled = Preconditions.checkNotNull(transpiled);
        this.sourceMap = Preconditions.checkNotNull(sourceMap);
    }

    public URI path() {
        return this.path;
    }

    public String original() {
        return this.original;
    }

    public String sourceMap() {
        return this.sourceMap;
    }

    public TranspileResult embedSourcemapUrl(String url) {
        if (this.sourceMap.isEmpty()) {
            return this;
        }
        String embedded = this.transpiled + "\n//# sourceMappingURL=" + url + "\n";
        return new TranspileResult(this.path, this.original, embedded, this.sourceMap);
    }

    public TranspileResult embedSourcemap() {
        if (this.sourceMap.isEmpty()) {
            return this;
        }
        String embedded = this.transpiled + "\n//# sourceMappingURL=data:," + ESCAPER.escape(this.sourceMap) + "\n";
        return new TranspileResult(this.path, this.original, embedded, "");
    }

    public String transpiled() {
        return this.transpiled;
    }

    public boolean wasTranspiled() {
        return !this.transpiled.equals(this.original);
    }

    public boolean equals(Object other) {
        return other instanceof TranspileResult && ((TranspileResult)other).path.equals(this.path) && ((TranspileResult)other).original.equals(this.original) && ((TranspileResult)other).transpiled.equals(this.transpiled) && ((TranspileResult)other).sourceMap.equals(this.sourceMap);
    }

    public int hashCode() {
        return Objects.hash(this.path, this.original, this.transpiled, this.sourceMap);
    }

    public String toString() {
        return String.format("TranspileResut{path=%s, original=%s, transpiled=%s, sourceMapURL=%s}", this.path, this.original, this.transpiled, this.sourceMap);
    }
}

