/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.transpile;

import com.google.javascript.jscomp.bundle.TranspilationException;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Supplier;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Suppliers;
import com.google.javascript.jscomp.jarjar.com.google.common.cache.CacheBuilder;
import com.google.javascript.jscomp.jarjar.com.google.common.cache.CacheLoader;
import com.google.javascript.jscomp.jarjar.com.google.common.cache.LoadingCache;
import com.google.javascript.jscomp.jarjar.com.google.common.util.concurrent.UncheckedExecutionException;
import com.google.javascript.jscomp.transpile.TranspileResult;
import com.google.javascript.jscomp.transpile.Transpiler;
import java.net.URI;
import java.util.Objects;

public final class CachingTranspiler
implements Transpiler {
    private final LoadingCache<Key, TranspileResult> cache;
    private final Supplier<String> runtime;

    public CachingTranspiler(final Transpiler delegate, CacheBuilder<Object, ? super TranspileResult> builder) {
        Preconditions.checkNotNull(delegate);
        this.cache = builder.build(new CacheLoader<Key, TranspileResult>(){

            @Override
            public TranspileResult load(Key key) {
                return delegate.transpile(key.path, key.code);
            }
        });
        this.runtime = Suppliers.memoize(delegate::runtime);
    }

    @Override
    public TranspileResult transpile(URI path, String code) {
        try {
            return this.cache.getUnchecked(new Key(path, code));
        }
        catch (UncheckedExecutionException e) {
            if (e.getCause() instanceof TranspilationException) {
                throw new TranspilationException(e);
            }
            throw e;
        }
    }

    @Override
    public String runtime() {
        return this.runtime.get();
    }

    private static final class Key {
        private final URI path;
        private final String code;

        Key(URI path, String code) {
            this.path = Preconditions.checkNotNull(path);
            this.code = Preconditions.checkNotNull(code);
        }

        public boolean equals(Object other) {
            return other instanceof Key && ((Key)other).path.equals(this.path) && ((Key)other).code.equals(this.code);
        }

        public int hashCode() {
            return Objects.hash(this.path, this.code);
        }
    }
}

