/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.transpile;

import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.DiagnosticGroups;
import com.google.javascript.jscomp.PropertyRenamingPolicy;
import com.google.javascript.jscomp.Result;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.jscomp.SourceMap;
import com.google.javascript.jscomp.VariableRenamingPolicy;
import com.google.javascript.jscomp.bundle.TranspilationException;
import com.google.javascript.jscomp.deps.ModuleLoader;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Strings;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableMap;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.jscomp.transpile.TranspileResult;
import com.google.javascript.jscomp.transpile.Transpiler;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;

public final class BaseTranspiler
implements Transpiler {
    private final CompilerSupplier compilerSupplier;
    private final String runtimeLibraryName;
    public static final BaseTranspiler LATEST_TRANSPILER = BaseTranspiler.to(FeatureSet.latest(), "");
    public static final BaseTranspiler ES5_TRANSPILER = BaseTranspiler.to(CompilerOptions.LanguageMode.ECMASCRIPT5.toFeatureSet());

    public BaseTranspiler(CompilerSupplier compilerSupplier, String runtimeLibraryName) {
        this.compilerSupplier = Preconditions.checkNotNull(compilerSupplier);
        this.runtimeLibraryName = Preconditions.checkNotNull(runtimeLibraryName);
    }

    @Override
    public TranspileResult transpile(URI path, String code) {
        CompileResult result = this.compilerSupplier.compile(path, code);
        if (!result.transpiled) {
            return new TranspileResult(path, code, code, "");
        }
        return new TranspileResult(path, code, result.source, result.sourceMap);
    }

    @Override
    public String runtime() {
        StringBuilder sb = new StringBuilder();
        if (!Strings.isNullOrEmpty(this.runtimeLibraryName)) {
            sb.append(this.compilerSupplier.runtime(this.runtimeLibraryName));
        }
        sb.append(this.compilerSupplier.runtime("modules"));
        return sb.toString();
    }

    public static final BaseTranspiler to(FeatureSet featureSet, String runtime) {
        return new BaseTranspiler(new CompilerSupplier(featureSet), runtime);
    }

    public static final BaseTranspiler to(FeatureSet featureSet) {
        return BaseTranspiler.to(featureSet, "es6_runtime");
    }

    public static class CompileResult {
        public final String source;
        public final boolean transpiled;
        public final String sourceMap;

        public CompileResult(String source, boolean transpiled, String sourceMap) {
            this.source = Preconditions.checkNotNull(source);
            this.transpiled = transpiled;
            this.sourceMap = Preconditions.checkNotNull(sourceMap);
        }
    }

    public static class CompilerSupplier {
        protected final ModuleLoader.ResolutionMode moduleResolution;
        protected final ImmutableList<String> moduleRoots;
        protected final ImmutableMap<String, String> prefixReplacements;
        protected final FeatureSet outputFeatureSet;

        public CompilerSupplier() {
            this(CompilerOptions.LanguageMode.ECMASCRIPT5.toFeatureSet());
        }

        public CompilerSupplier(FeatureSet outputFeatureSet) {
            this(outputFeatureSet, new CompilerOptions().getModuleResolutionMode(), ImmutableList.of(), ImmutableMap.of());
        }

        public CompilerSupplier(FeatureSet outputFeatureSet, ModuleLoader.ResolutionMode moduleResolution, ImmutableList<String> moduleRoots, ImmutableMap<String, String> prefixReplacements) {
            this.outputFeatureSet = outputFeatureSet;
            this.moduleResolution = moduleResolution;
            this.moduleRoots = moduleRoots;
            this.prefixReplacements = prefixReplacements;
        }

        public CompileResult compile(URI path, String code) {
            boolean transpiled;
            Compiler compiler = this.compiler();
            Result result = compiler.compile(this.createTrivialExterns(), SourceFile.fromCode(path.toString(), code), this.options());
            String source = compiler.toSource();
            StringBuilder sourceMap = new StringBuilder();
            if (result.sourceMap != null) {
                try {
                    result.sourceMap.appendTo(sourceMap, path.toString());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            boolean bl = transpiled = !result.transpiledFiles.isEmpty();
            if (!result.errors.isEmpty()) {
                throw new TranspilationException(compiler, result.errors, result.warnings);
            }
            return new CompileResult(source, transpiled, transpiled ? sourceMap.toString() : "");
        }

        public String runtime(String library) {
            Compiler compiler = this.compiler();
            CompilerOptions options = this.options();
            options.setForceLibraryInjection(ImmutableList.of(library));
            compiler.compile(this.createTrivialExterns(), this.createEmptySource(), options);
            return compiler.toSource();
        }

        protected Compiler compiler() {
            return new Compiler();
        }

        protected CompilerOptions options() {
            CompilerOptions options = new CompilerOptions();
            this.setOptions(options);
            return options;
        }

        protected void setOptions(CompilerOptions options) {
            options.setLanguageIn(CompilerOptions.LanguageMode.ECMASCRIPT_NEXT);
            options.setOutputFeatureSet(this.outputFeatureSet.without(FeatureSet.Feature.MODULES, new FeatureSet.Feature[0]));
            options.setEmitUseStrict(false);
            options.setQuoteKeywordProperties(true);
            options.setSkipNonTranspilationPasses(true);
            options.setVariableRenaming(VariableRenamingPolicy.OFF);
            options.setPropertyRenaming(PropertyRenamingPolicy.OFF);
            options.setWrapGoogModulesForWhitespaceOnly(false);
            options.setPrettyPrint(true);
            options.setWarningLevel(DiagnosticGroups.NON_STANDARD_JSDOC, CheckLevel.OFF);
            options.setEs6ModuleTranspilation(CompilerOptions.Es6ModuleTranspilation.TO_COMMON_JS_LIKE_MODULES);
            options.setModuleResolutionMode(this.moduleResolution);
            options.setModuleRoots(this.moduleRoots);
            options.setBrowserResolverPrefixReplacements(this.prefixReplacements);
            options.setWarningLevel(DiagnosticGroups.MODULE_LOAD, CheckLevel.OFF);
            options.setPathEscaper(ModuleLoader.PathEscaper.CANONICALIZE_ONLY);
            options.setSourceMapOutputPath("/dev/null");
            options.setSourceMapIncludeSourcesContent(true);
            options.setSourceMapLocationMappings(ImmutableList.of(location -> {
                try {
                    if (new URI(location).getScheme() != null) {
                        return location;
                    }
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
                return new SourceMap.PrefixLocationMapping("", "/").map(location);
            }));
        }

        protected SourceFile createTrivialExterns() {
            return SourceFile.fromCode("externs.js", "function Symbol() {}");
        }

        protected SourceFile createEmptySource() {
            return SourceFile.fromCode("empty.js", "");
        }
    }
}

