/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.disambiguate;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.InvalidatingTypes;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.diagnostic.LogFile;
import com.google.javascript.jscomp.disambiguate.ClusterPropagator;
import com.google.javascript.jscomp.disambiguate.FindPropertyReferences;
import com.google.javascript.jscomp.disambiguate.FlatType;
import com.google.javascript.jscomp.disambiguate.PropertyClustering;
import com.google.javascript.jscomp.disambiguate.TypeFlattener;
import com.google.javascript.jscomp.disambiguate.TypeGraphBuilder;
import com.google.javascript.jscomp.disambiguate.UseSiteRenamer;
import com.google.javascript.jscomp.graph.DiGraph;
import com.google.javascript.jscomp.graph.FixedPointGraphTraversal;
import com.google.javascript.jscomp.graph.LinkedDirectedGraph;
import com.google.javascript.jscomp.graph.LowestCommonAncestorFinder;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Supplier;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableMap;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableSortedMap;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableSortedSet;
import com.google.javascript.jscomp.jarjar.com.google.gson.Gson;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;

public final class DisambiguateProperties2
implements CompilerPass {
    private static final Gson GSON = new Gson();
    private final AbstractCompiler compiler;
    private final ImmutableMap<String, CheckLevel> invalidationReportingLevelByProp;
    private final JSTypeRegistry registry;
    private final InvalidatingTypes invalidations;

    public DisambiguateProperties2(AbstractCompiler compiler, ImmutableMap<String, CheckLevel> invalidationReportingLevelByProp) {
        this.compiler = compiler;
        this.invalidationReportingLevelByProp = invalidationReportingLevelByProp;
        this.registry = this.compiler.getTypeRegistry();
        this.invalidations = new InvalidatingTypes.Builder(this.registry).addAllTypeMismatches(compiler.getTypeMismatches()).addAllTypeMismatches(compiler.getImplicitInterfaceUses()).allowEnums().allowScalars().build();
    }

    @Override
    public void process(Node externs, Node root) {
        Preconditions.checkArgument(externs.getParent() == root.getParent());
        TypeFlattener flattener = new TypeFlattener(this.registry, this.invalidations::isInvalidating);
        FindPropertyReferences findRefs = new FindPropertyReferences(flattener, this.compiler::report, this.compiler.getCodingConvention()::isPropertyRenameFunction);
        TypeGraphBuilder graphBuilder = new TypeGraphBuilder(flattener, LowestCommonAncestorFinder::new);
        ClusterPropagator propagator = new ClusterPropagator();
        UseSiteRenamer renamer = new UseSiteRenamer(this.invalidationReportingLevelByProp, this.compiler::report, this.compiler::reportChangeToEnclosingScope);
        NodeTraversal.traverse(this.compiler, externs.getParent(), findRefs);
        LinkedHashMap<String, PropertyClustering> propIndex = findRefs.getPropertyIndex();
        this.logForDiagnostics("prop_refs", () -> propIndex.values().stream().map(PropertyReferenceIndexJson::new).collect(ImmutableSortedMap.toImmutableSortedMap(Comparator.naturalOrder(), x -> x.name, x -> x)));
        graphBuilder.addAll(flattener.getAllKnownTypes());
        LinkedDirectedGraph<FlatType, Object> graph = graphBuilder.build();
        this.logForDiagnostics("graph", () -> graph.getNodes().stream().map(TypeNodeJson::new).sorted(Comparator.comparingInt(x -> x.id)).collect(ImmutableList.toImmutableList()));
        FixedPointGraphTraversal.newTraversal(propagator).computeFixedPoint(graph);
        propIndex.values().forEach(renamer::renameUses);
        this.logForDiagnostics("renaming_index", () -> ((ImmutableMap)renamer.getRenamingIndex().asMap()).entrySet().stream().collect(ImmutableSortedMap.toImmutableSortedMap(Comparator.naturalOrder(), Map.Entry::getKey, e -> ImmutableSortedSet.copyOf((Collection)e.getValue()))));
    }

    private void logForDiagnostics(String name, Supplier<Object> data) {
        try (LogFile log = this.compiler.createOrReopenLog(this.getClass(), name + ".log", new String[0]);){
            log.log(() -> GSON.toJson(data.get()));
        }
    }

    private static final class TypeEdgeJson
    implements Comparable<TypeEdgeJson> {
        final int dest;
        final Object value;

        TypeEdgeJson(DiGraph.DiGraphEdge<FlatType, Object> e) {
            this.dest = ((FlatType)e.getDestination().getValue()).getId();
            this.value = e.getValue();
        }

        @Override
        public int compareTo(TypeEdgeJson x) {
            Preconditions.checkArgument(this.dest != x.dest);
            return this.dest - x.dest;
        }
    }

    private static final class TypeNodeJson {
        final int id;
        final boolean invalidating;
        final String name;
        final ImmutableSortedSet<TypeEdgeJson> edges;
        final ImmutableSortedSet<String> props;

        TypeNodeJson(DiGraph.DiGraphNode<FlatType, Object> n) {
            FlatType t = (FlatType)n.getValue();
            this.id = t.getId();
            this.name = (t.hasArity(FlatType.Arity.SINGLE) ? t.getTypeSingle() : t.getTypeUnion()).toString();
            this.invalidating = t.isInvalidating();
            this.edges = n.getOutEdges().stream().map(TypeEdgeJson::new).collect(ImmutableSortedSet.toImmutableSortedSet(Comparator.naturalOrder()));
            this.props = t.getAssociatedProps().stream().map(PropertyClustering::getName).collect(ImmutableSortedSet.toImmutableSortedSet(Comparator.naturalOrder()));
        }
    }

    private static final class PropertyReferenceJson
    implements Comparable<PropertyReferenceJson> {
        final String location;
        final int receiver;

        PropertyReferenceJson(Node location, FlatType receiver) {
            this.location = location.getSourceFileName() + ":" + location.getLineno() + ":" + location.getCharno();
            this.receiver = receiver.getId();
        }

        @Override
        public int compareTo(PropertyReferenceJson x) {
            int location = this.location.compareTo(x.location);
            if (location != 0) {
                return location;
            }
            return this.receiver - x.receiver;
        }
    }

    private static final class PropertyReferenceIndexJson {
        final String name;
        final ImmutableSortedSet<PropertyReferenceJson> refs;

        PropertyReferenceIndexJson(PropertyClustering prop) {
            this.name = prop.getName();
            this.refs = prop.getUseSites().entrySet().stream().map(e -> new PropertyReferenceJson((Node)e.getKey(), (FlatType)e.getValue())).collect(ImmutableSortedSet.toImmutableSortedSet(Comparator.naturalOrder()));
        }
    }
}

