/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.disambiguate;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DestructuredTarget;
import com.google.javascript.jscomp.GatherGetterAndSetterProperties;
import com.google.javascript.jscomp.InvalidatingTypes;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.PropertyRenamingDiagnostics;
import com.google.javascript.jscomp.graph.StandardUnionFind;
import com.google.javascript.jscomp.graph.UnionFind;
import com.google.javascript.jscomp.jarjar.com.google.common.annotations.VisibleForTesting;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.HashMultimap;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.LinkedHashMultimap;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.Multimap;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.Table;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.Tables;
import com.google.javascript.jscomp.jarjar.javax.annotation.Nullable;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class DisambiguateProperties
implements CompilerPass {
    private static final int MAX_INVALIDATION_WARNINGS_PER_PROPERTY = 10;
    private static final Logger logger = Logger.getLogger(DisambiguateProperties.class.getName());
    private static final Pattern NONWORD_PATTERN = Pattern.compile("[^\\w$]");
    private final AbstractCompiler compiler;
    private final InvalidatingTypes invalidatingTypes;
    private final JSTypeRegistry registry;
    private final Multimap<JSType, Node> invalidationMap;
    private final Map<String, CheckLevel> propertiesToErrorFor;
    private Map<FunctionType, Iterable<ObjectType>> ancestorInterfaces;
    private final Table<String, JSType, ObjectType> representativeTypeCache = Tables.newCustomTable(new LinkedHashMap(), IdentityHashMap::new);
    private final ObjectType representativeTypeSentinel;
    private final Map<String, Property> properties = new LinkedHashMap<String, Property>();

    public DisambiguateProperties(AbstractCompiler compiler, Map<String, CheckLevel> propertiesToErrorFor) {
        this.compiler = compiler;
        this.registry = compiler.getTypeRegistry();
        this.representativeTypeSentinel = this.registry.getNativeType(JSTypeNative.NO_OBJECT_TYPE).toMaybeObjectType();
        this.propertiesToErrorFor = propertiesToErrorFor;
        this.invalidationMap = propertiesToErrorFor.isEmpty() ? null : LinkedHashMultimap.create();
        this.invalidatingTypes = new InvalidatingTypes.Builder(this.registry).writeInvalidationsInto(this.invalidationMap).addAllTypeMismatches(compiler.getTypeMismatches()).addAllTypeMismatches(compiler.getImplicitInterfaceUses()).allowEnums().allowScalars().build();
    }

    @Override
    public void process(Node externs, Node root) {
        Preconditions.checkState(this.compiler.getLifeCycleStage().isNormalized());
        this.ancestorInterfaces = new HashMap<FunctionType, Iterable<ObjectType>>();
        NodeTraversal.traverse(this.compiler, externs, new FindExternProperties());
        NodeTraversal.traverse(this.compiler, root, new FindRenamableProperties());
        this.renameProperties();
        GatherGetterAndSetterProperties.update(this.compiler, externs, root);
    }

    protected Property getProperty(String name) {
        this.properties.computeIfAbsent(name, x$0 -> new Property((String)x$0));
        return this.properties.get(name);
    }

    private void reportInvalidation(Node location, String propName, JSType receiver) {
        CheckLevel level = this.propertiesToErrorFor.getOrDefault(propName, CheckLevel.OFF);
        if (level.equals(CheckLevel.OFF)) {
            return;
        }
        ArrayList<String> locations = new ArrayList<String>();
        this.printErrorLocations(locations, receiver);
        String locationsMsg = locations.isEmpty() ? "This type is inherently invalidating" : String.join((CharSequence)"\n", locations);
        this.compiler.report(JSError.make(location, level, PropertyRenamingDiagnostics.INVALIDATION, propName, receiver.toString(), locationsMsg));
    }

    private void printErrorLocations(List<String> locations, JSType t) {
        if (!t.isObjectType() || t.isAllType()) {
            return;
        }
        if (t.isUnionType()) {
            for (JSType alt : t.getUnionMembers()) {
                this.printErrorLocations(locations, alt);
            }
            return;
        }
        if (t.isTemplatizedType()) {
            this.printErrorLocations(locations, t.toMaybeTemplatizedType().getReferencedType());
        }
        this.invalidationMap.get(t).stream().limit(10L).map(l -> l.getSourceFileName() + ":" + l.getLineno() + ":" + l.getCharno()).forEachOrdered(locations::add);
    }

    void renameProperties() {
        int propsRenamed = 0;
        int propsSkipped = 0;
        int instancesRenamed = 0;
        int instancesSkipped = 0;
        int singleTypeProps = 0;
        HashSet<String> reported = new HashSet<String>();
        for (Property prop : this.properties.values()) {
            if (!prop.wouldBeDisambiguatedByRenaming()) {
                if (!prop.isValidForRenaming) {
                    ++propsSkipped;
                    continue;
                }
                ++singleTypeProps;
                continue;
            }
            UnionFind<JSType> pTypes = prop.getTypes();
            Map<JSType, String> propNames = this.buildPropNames(prop);
            ++propsRenamed;
            prop.expandTypesToSkip();
            for (Map.Entry<Node, JSType> entry : prop.rootTypesByNode.entrySet()) {
                Node node = entry.getKey();
                JSType rootType = entry.getValue();
                if (prop.shouldRenameOnType(rootType)) {
                    String newName = propNames.get(pTypes.find(rootType));
                    node.setString(newName);
                    this.compiler.reportChangeToEnclosingScope(node);
                    ++instancesRenamed;
                    continue;
                }
                ++instancesSkipped;
                CheckLevel checkLevelForProp = this.propertiesToErrorFor.getOrDefault(prop.name, CheckLevel.OFF);
                if (prop.isValidForRenaming || checkLevelForProp == CheckLevel.OFF || reported.contains(prop.name)) continue;
                reported.add(prop.name);
                this.compiler.report(JSError.make(node, checkLevelForProp, PropertyRenamingDiagnostics.INVALIDATION_ON_TYPE, prop.name, rootType.toString(), ""));
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Renamed " + instancesRenamed + " instances of " + propsRenamed + " properties.");
            logger.fine("Skipped renaming " + instancesSkipped + " invalidated properties, " + propsSkipped + " instances of properties that were skipped for specific types and " + singleTypeProps + " properties that were referenced from only one type.");
        }
    }

    private Map<JSType, String> buildPropNames(Property prop) {
        UnionFind<JSType> pTypes = prop.getTypes();
        String pname = prop.name;
        HashMap<JSType, String> names = new HashMap<JSType, String>();
        for (Set set : pTypes.allEquivalenceClasses()) {
            Preconditions.checkState(!set.isEmpty());
            JSType representative = pTypes.find((JSType)set.iterator().next());
            String typeName = null;
            for (JSType type : set) {
                String typeString = type.toString();
                if (typeName != null && typeString.compareTo(typeName) >= 0) continue;
                typeName = typeString;
            }
            String newName = "{...}".equals(typeName) ? pname : NONWORD_PATTERN.matcher(typeName).replaceAll("_") + '$' + pname;
            names.put(representative, newName);
        }
        return names;
    }

    @VisibleForTesting
    Multimap<String, Collection<JSType>> getRenamedTypesForTesting() {
        HashMultimap<String, Collection<JSType>> ret = HashMultimap.create();
        for (Map.Entry<String, Property> entry : this.properties.entrySet()) {
            Property prop = entry.getValue();
            if (!prop.isValidForRenaming) continue;
            for (Collection collection : prop.getTypes().allEquivalenceClasses()) {
                if (collection.isEmpty() || prop.typesToSkip.contains(collection.iterator().next())) continue;
                ret.put(entry.getKey(), collection);
            }
        }
        return ret;
    }

    private JSType getType(Node node) {
        if (node == null || node.getJSType() == null) {
            return this.registry.getNativeType(JSTypeNative.UNKNOWN_TYPE);
        }
        return node.getJSType();
    }

    private ImmutableSet<JSType> getTypesToSkipForType(JSType type) {
        if ((type = type.restrictByNotNullOrUndefined()).isUnionType()) {
            ImmutableSet.Builder types = ImmutableSet.builder();
            types.add(type);
            for (JSType alt : type.getUnionMembers()) {
                types.addAll(this.getTypesToSkipForTypeNonUnion(alt));
            }
            return types.build();
        }
        if (type.isEnumElementType()) {
            return this.getTypesToSkipForType(type.getEnumeratedTypeOfEnumElement());
        }
        return ImmutableSet.copyOf(this.getTypesToSkipForTypeNonUnion(type));
    }

    private Set<JSType> getTypesToSkipForTypeNonUnion(JSType type) {
        HashSet<JSType> types = new HashSet<JSType>();
        JSType skipType = type;
        while (skipType != null) {
            types.add(skipType);
            ObjectType objSkipType = skipType.toMaybeObjectType();
            if (objSkipType == null) break;
            skipType = objSkipType.getImplicitPrototype();
        }
        return types;
    }

    private boolean isTypeToSkip(JSType type) {
        return type.isEnumType() || type.isBoxableScalar();
    }

    private Iterable<? extends JSType> getTypeAlternatives(JSType type) {
        FunctionType constructor;
        if (type.isUnionType()) {
            return type.getUnionMembers();
        }
        ObjectType objType = type.toMaybeObjectType();
        FunctionType functionType = constructor = objType != null ? objType.getConstructor() : null;
        if (constructor != null && constructor.isInterface()) {
            ArrayList<ObjectType> list = new ArrayList<ObjectType>();
            for (FunctionType impl : constructor.getDirectSubTypes()) {
                list.add(impl.getInstanceType());
            }
            return list.isEmpty() ? null : list;
        }
        return null;
    }

    private ObjectType getRepresentativeType(String field, JSType type) {
        if (type == null) {
            return null;
        }
        ObjectType foundType = this.representativeTypeCache.get(field, type);
        if (foundType != null) {
            return foundType.equals(this.representativeTypeSentinel) ? null : foundType;
        }
        if (type.isEnumElementType()) {
            foundType = this.getRepresentativeType(field, type.getEnumeratedTypeOfEnumElement());
            this.representativeTypeCache.put(field, type, foundType == null ? this.representativeTypeSentinel : foundType);
            return foundType;
        }
        if (!type.isObjectType()) {
            if (type.isBoxableScalar()) {
                foundType = this.getRepresentativeType(field, type.autobox());
                this.representativeTypeCache.put(field, type, foundType == null ? this.representativeTypeSentinel : foundType);
                return foundType;
            }
            this.representativeTypeCache.put(field, type, this.representativeTypeSentinel);
            return null;
        }
        if ("prototype".equals(field)) {
            this.representativeTypeCache.put(field, type, this.representativeTypeSentinel);
            return null;
        }
        ObjectType objType = type.toMaybeObjectType();
        if (objType != null) {
            foundType = objType.getTopMostDefiningType(field);
        }
        if (foundType == null) {
            ObjectType maybeType;
            JSType subtypeWithProp = type.getGreatestSubtypeWithProperty(field);
            ObjectType objectType = maybeType = subtypeWithProp == null ? null : subtypeWithProp.toMaybeObjectType();
            if (maybeType != null && maybeType.hasOwnProperty(field)) {
                foundType = maybeType;
            }
        }
        if (foundType != null && foundType.isTemplatizedType()) {
            foundType = foundType.getRawType();
        }
        if (foundType != null && foundType.isNamedType()) {
            foundType = foundType.toMaybeNamedType().getReferencedType().toMaybeObjectType();
        }
        this.representativeTypeCache.put(field, type, foundType == null ? this.representativeTypeSentinel : foundType);
        return foundType;
    }

    private static boolean isStructuralInterfacePrototype(JSType type) {
        if (!type.isFunctionPrototypeType()) {
            return false;
        }
        FunctionType constructor = type.toObjectType().getOwnerFunction();
        return constructor != null && constructor.isStructuralInterface();
    }

    @Nullable
    private static JSType getInstanceIfPrototype(JSType maybePrototype) {
        FunctionType constructor;
        if (maybePrototype.isFunctionPrototypeType() && (constructor = maybePrototype.toObjectType().getOwnerFunction()) != null) {
            if (!constructor.hasInstanceType()) {
                return null;
            }
            return constructor.getInstanceType();
        }
        return null;
    }

    private FunctionType getConstructor(JSType type) {
        ObjectType objType = type.toMaybeObjectType();
        if (objType == null) {
            return null;
        }
        if (objType.isFunctionType()) {
            return (FunctionType)this.registry.getNativeType(JSTypeNative.FUNCTION_FUNCTION_TYPE);
        }
        if (objType.isFunctionPrototypeType()) {
            return objType.getOwnerFunction();
        }
        return objType.getConstructor();
    }

    private class FindRenamableProperties
    extends NodeTraversal.AbstractScopedCallback {
        private FindRenamableProperties() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (NodeUtil.isNormalOrOptChainGetProp(n)) {
                this.handleGetProp(n);
            } else if (n.isObjectLit()) {
                this.handleObjectLit(n);
            } else if (NodeUtil.isNormalOrOptChainCall(n)) {
                this.handleCall(n);
            } else if (n.isClass()) {
                this.handleClass(n);
            } else if (n.isObjectPattern()) {
                this.handleObjectPattern(n);
            }
        }

        private void handleGetProp(Node n) {
            String name = n.getLastChild().getString();
            JSType type = DisambiguateProperties.this.getType(n.getFirstChild());
            Property prop = DisambiguateProperties.this.getProperty(name);
            if (!prop.scheduleRenaming(n.getLastChild(), type)) {
                DisambiguateProperties.this.reportInvalidation(n, name, type);
            }
        }

        private void handleObjectLit(Node n) {
            if (n.getParent().isCall() && NodeUtil.isObjectDefinePropertiesDefinition(n.getParent())) {
                return;
            }
            block4: for (Node child = n.getFirstChild(); child != null; child = child.getNext()) {
                switch (child.getToken()) {
                    case COMPUTED_PROP: 
                    case OBJECT_SPREAD: {
                        continue block4;
                    }
                    case STRING_KEY: 
                    case MEMBER_FUNCTION_DEF: 
                    case GETTER_DEF: 
                    case SETTER_DEF: {
                        if (child.isQuotedString()) continue block4;
                        String name = child.getString();
                        JSType objlitType = DisambiguateProperties.this.getType(n);
                        Property prop = DisambiguateProperties.this.getProperty(name);
                        if (prop.scheduleRenaming(child, objlitType)) continue block4;
                        DisambiguateProperties.this.reportInvalidation(n, name, objlitType);
                        continue block4;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected child of OBJECTLIT: " + child.toStringTree());
                    }
                }
            }
        }

        private void handleCall(Node call) {
            Node target = call.getFirstChild();
            if (!target.isQualifiedName()) {
                return;
            }
            String functionName = target.getOriginalQualifiedName();
            if (functionName != null && DisambiguateProperties.this.compiler.getCodingConvention().isPropertyRenameFunction(functionName)) {
                this.handlePropertyRenameFunctionCall(call, functionName);
            } else if (NodeUtil.isObjectDefinePropertiesDefinition(call)) {
                this.handleObjectDefineProperties(call);
            }
        }

        private void handleClass(Node classNode) {
            JSType classType = classNode.getJSType();
            ObjectType classInstanceType = classType.toMaybeFunctionType() != null ? classType.toMaybeFunctionType().getInstanceType() : DisambiguateProperties.this.registry.getNativeType(JSTypeNative.UNKNOWN_TYPE);
            for (Node member : NodeUtil.getClassMembers(classNode).children()) {
                JSType ownerType;
                if (member.isComputedProp() || member.isQuotedString()) continue;
                String name = member.getString();
                Property prop = DisambiguateProperties.this.getProperty(name);
                if (prop.scheduleRenaming(member, ownerType = member.isStaticMember() ? classType : classInstanceType)) continue;
                DisambiguateProperties.this.reportInvalidation(classNode, name, ownerType);
            }
        }

        private void handleObjectPattern(Node pattern) {
            JSType objectPatternType = Preconditions.checkNotNull(pattern.getJSType());
            for (DestructuredTarget target : DestructuredTarget.createAllNonEmptyTargetsInPattern(DisambiguateProperties.this.compiler.getTypeRegistry(), objectPatternType, pattern)) {
                String name;
                Property prop;
                Node stringKey;
                if (!target.hasStringKey() || (stringKey = target.getStringKey()).isQuotedString() || (prop = DisambiguateProperties.this.getProperty(name = stringKey.getString())).scheduleRenaming(stringKey, objectPatternType)) continue;
                DisambiguateProperties.this.reportInvalidation(stringKey, name, objectPatternType);
            }
        }

        private void handlePropertyRenameFunctionCall(Node call, String renameFunctionName) {
            int childCount = call.getChildCount();
            if (childCount != 2 && childCount != 3) {
                DisambiguateProperties.this.compiler.report(JSError.make(call, PropertyRenamingDiagnostics.INVALID_RENAME_FUNCTION, renameFunctionName, " Must be called with 1 or 2 arguments"));
                return;
            }
            if (!call.getSecondChild().isString()) {
                DisambiguateProperties.this.compiler.report(JSError.make(call, PropertyRenamingDiagnostics.INVALID_RENAME_FUNCTION, renameFunctionName, " The first argument must be a string literal."));
                return;
            }
            String propName = call.getSecondChild().getString();
            if (propName.contains(".")) {
                DisambiguateProperties.this.compiler.report(JSError.make(call, PropertyRenamingDiagnostics.INVALID_RENAME_FUNCTION, renameFunctionName, " The first argument must not be a property path."));
                return;
            }
            Node obj = call.getChildAtIndex(2);
            JSType type = DisambiguateProperties.this.getType(obj);
            Property prop = DisambiguateProperties.this.getProperty(propName);
            if (!prop.scheduleRenaming(call.getSecondChild(), type)) {
                DisambiguateProperties.this.reportInvalidation(obj, propName, type);
            }
        }

        private void handleObjectDefineProperties(Node call) {
            Node typeObj = call.getSecondChild();
            JSType type = DisambiguateProperties.this.getType(typeObj);
            Node objectLiteral = typeObj.getNext();
            if (!objectLiteral.isObjectLit()) {
                return;
            }
            block4: for (Node key : objectLiteral.children()) {
                switch (key.getToken()) {
                    case COMPUTED_PROP: 
                    case OBJECT_SPREAD: {
                        continue block4;
                    }
                    case STRING_KEY: 
                    case MEMBER_FUNCTION_DEF: 
                    case GETTER_DEF: 
                    case SETTER_DEF: {
                        if (key.isQuotedString()) continue block4;
                        Property prop = DisambiguateProperties.this.getProperty(key.getString());
                        prop.scheduleRenaming(key, type);
                        continue block4;
                    }
                }
                throw new IllegalStateException("Unrecognized child of object lit " + key);
            }
        }
    }

    private class FindExternProperties
    extends NodeTraversal.AbstractScopedCallback {
        private FindExternProperties() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n.isGetProp() || n.isOptChainGetProp()) {
                Node recv = n.getFirstChild();
                JSType recvType = DisambiguateProperties.this.getType(recv);
                Property prop = DisambiguateProperties.this.getProperty(n.getLastChild().getString());
                this.processExternsProperty(prop, recvType);
            } else if (n.isClass()) {
                JSType classType = n.getJSType();
                ObjectType classInstanceType = classType.toMaybeFunctionType() != null ? classType.toMaybeFunctionType().getPrototype() : DisambiguateProperties.this.registry.getNativeType(JSTypeNative.UNKNOWN_TYPE);
                for (Node member : NodeUtil.getClassMembers(n).children()) {
                    if (member.isComputedProp() || member.isQuotedString()) continue;
                    String name = member.getString();
                    JSType ownerType = member.isStaticMember() ? classType : classInstanceType;
                    Property prop = DisambiguateProperties.this.getProperty(name);
                    this.processExternsProperty(prop, ownerType);
                }
            }
        }

        private void processExternsProperty(Property prop, JSType ownerType) {
            if (DisambiguateProperties.this.invalidatingTypes.isInvalidating(ownerType) || DisambiguateProperties.isStructuralInterfacePrototype(ownerType)) {
                prop.invalidate();
            } else if (prop.isValidForRenaming) {
                prop.addTypeToSkip(ownerType);
                JSType instanceType = DisambiguateProperties.getInstanceIfPrototype(ownerType);
                if (instanceType != null) {
                    prop.getTypes().add(instanceType);
                    prop.typesToSkip.add(instanceType);
                }
            }
        }
    }

    private class Property {
        final String name;
        private UnionFind<JSType> types;
        Set<JSType> typesToSkip = new HashSet<JSType>();
        boolean isValidForRenaming = true;
        Map<Node, JSType> rootTypesByNode = new LinkedHashMap<Node, JSType>();
        private final Set<JSType> recordInterfacesCache = new HashSet<JSType>();

        Property(String name) {
            this.name = name;
        }

        UnionFind<JSType> getTypes() {
            if (this.types == null) {
                this.types = new StandardUnionFind<JSType>();
            }
            return this.types;
        }

        void addType(JSType type, JSType relatedType) {
            Preconditions.checkState(this.isValidForRenaming, "Attempt to record an invalidated property: %s", (Object)this.name);
            ObjectType top = DisambiguateProperties.this.getRepresentativeType(this.name, type);
            if (DisambiguateProperties.this.invalidatingTypes.isInvalidating(top)) {
                this.invalidate();
                return;
            }
            if (DisambiguateProperties.this.isTypeToSkip(top)) {
                this.addTypeToSkip(top);
            }
            if (relatedType == null) {
                this.getTypes().add(top);
            } else {
                this.getTypes().union(top, relatedType);
            }
            this.recordInterfaces(type, top);
        }

        void addTypeToSkip(JSType type) {
            for (JSType skipType : DisambiguateProperties.this.getTypesToSkipForType(type)) {
                this.typesToSkip.add(skipType);
                this.getTypes().union(skipType, type);
            }
        }

        void expandTypesToSkip() {
            if (!this.wouldBeDisambiguatedByRenaming()) {
                return;
            }
            for (int count = 0; count < 10; ++count) {
                HashSet<JSType> rootTypesToSkip = new HashSet<JSType>();
                for (JSType subType : this.typesToSkip) {
                    rootTypesToSkip.add(this.types.find(subType));
                }
                this.typesToSkip.addAll(rootTypesToSkip);
                HashSet<JSType> newTypesToSkip = new HashSet<JSType>();
                Set<JSType> allTypes = this.types.elements();
                int originalTypesSize = allTypes.size();
                for (JSType subType : allTypes) {
                    if (this.typesToSkip.contains(subType) || !this.typesToSkip.contains(this.types.find(subType))) continue;
                    newTypesToSkip.add(subType);
                }
                for (JSType newType : newTypesToSkip) {
                    this.addTypeToSkip(newType);
                }
                if (this.types.elements().size() != originalTypesSize) continue;
                return;
            }
            throw new IllegalStateException("Stuck in loop expanding types to skip.");
        }

        boolean wouldBeDisambiguatedByRenaming() {
            return this.isValidForRenaming && this.types != null && this.types.allEquivalenceClasses().size() > 1;
        }

        boolean shouldRenameOnType(JSType type) {
            return this.isValidForRenaming && !this.typesToSkip.contains(type);
        }

        boolean invalidate() {
            boolean changed = this.isValidForRenaming;
            this.isValidForRenaming = false;
            this.types = null;
            this.typesToSkip = null;
            this.rootTypesByNode = null;
            return changed;
        }

        boolean scheduleRenaming(Node node, JSType targetType) {
            JSType type = this.processProperty(targetType);
            if (this.isValidForRenaming) {
                if (DisambiguateProperties.this.invalidatingTypes.isInvalidating(type)) {
                    this.invalidate();
                    return false;
                }
                this.rootTypesByNode.put(node, type);
            }
            return true;
        }

        @Nullable
        private JSType processProperty(JSType type) {
            return this.processProperty(type, null);
        }

        @Nullable
        private JSType processProperty(JSType type, @Nullable JSType relatedType) {
            type = type.restrictByNotNullOrUndefined();
            if (!this.isValidForRenaming || DisambiguateProperties.this.invalidatingTypes.isInvalidating(type)) {
                return null;
            }
            Iterable alternatives = DisambiguateProperties.this.getTypeAlternatives(type);
            if (alternatives != null) {
                JSType firstType = relatedType;
                for (JSType subType : alternatives) {
                    JSType lastType = this.processProperty(subType, firstType);
                    if (firstType != null) continue;
                    firstType = lastType;
                }
                return firstType;
            }
            ObjectType topType = DisambiguateProperties.this.getRepresentativeType(this.name, type);
            if (DisambiguateProperties.this.invalidatingTypes.isInvalidating(topType)) {
                return null;
            }
            this.addType(type, relatedType);
            return topType;
        }

        private void recordInterfaces(JSType type, JSType relatedType) {
            FunctionType constructor = DisambiguateProperties.this.getConstructor(type);
            if (constructor == null || !this.recordInterfacesCache.add(type)) {
                return;
            }
            Iterable interfaces = DisambiguateProperties.this.ancestorInterfaces.computeIfAbsent(constructor, FunctionType::getAncestorInterfaces);
            for (ObjectType itype : interfaces) {
                ObjectType top = DisambiguateProperties.this.getRepresentativeType(this.name, itype);
                if (top != null) {
                    this.addType(itype, relatedType);
                }
                if (this.isValidForRenaming) continue;
                return;
            }
        }
    }
}

