/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.SourceAst;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.jscomp.jarjar.com.google.common.annotations.VisibleForTesting;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.InputId;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.StaticSourceFile;

public final class SyntheticAst
implements SourceAst {
    private static final long serialVersionUID = 1L;
    private final InputId inputId;
    private final SourceFile sourceFile;
    private Node root;

    @VisibleForTesting
    public static SyntheticAst emptyWithFileName(String sourceName) {
        return new SyntheticAst(sourceName);
    }

    SyntheticAst(String sourceName) {
        this.inputId = new InputId(sourceName);
        this.sourceFile = new SourceFile(sourceName, StaticSourceFile.SourceKind.STRONG);
        this.clearAst();
    }

    public SyntheticAst(Node root) {
        this.inputId = new InputId(root.getSourceFileName());
        this.sourceFile = new SourceFile(root.getSourceFileName(), StaticSourceFile.SourceKind.STRONG);
        this.root = Preconditions.checkNotNull(root);
    }

    @Override
    public Node getAstRoot(AbstractCompiler compiler) {
        return this.root;
    }

    @Override
    public void clearAst() {
        this.root = IR.script();
        this.root.setInputId(this.inputId);
        this.root.setStaticSourceFile(this.sourceFile);
    }

    @Override
    public InputId getInputId() {
        return this.inputId;
    }

    @Override
    public SourceFile getSourceFile() {
        return this.sourceFile;
    }

    @Override
    public void setSourceFile(SourceFile file) {
        throw new IllegalStateException("Cannot set a source file for a synthetic AST");
    }
}

