/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CombinedCompilerPass;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.JSModule;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.Var;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

final class RescopeGlobalSymbols
implements CompilerPass {
    private static final String DISAMBIGUATION_SUFFIX = "$";
    private final AbstractCompiler compiler;
    private final String globalSymbolNamespace;
    private final boolean addExtern;
    private final boolean assumeCrossModuleNames;
    private final Set<String> crossModuleNames = new HashSet<String>();
    private final Set<String> maybeReferencesThis = new HashSet<String>();
    private Set<String> externNames;

    RescopeGlobalSymbols(AbstractCompiler compiler, String globalSymbolNamespace, boolean assumeCrossModuleNames) {
        this(compiler, globalSymbolNamespace, true, assumeCrossModuleNames);
    }

    RescopeGlobalSymbols(AbstractCompiler compiler, String globalSymbolNamespace, boolean addExtern, boolean assumeCrossModuleNames) {
        this.compiler = compiler;
        this.globalSymbolNamespace = globalSymbolNamespace;
        this.addExtern = addExtern;
        this.assumeCrossModuleNames = assumeCrossModuleNames;
    }

    private boolean isCrossModuleName(String name) {
        return this.assumeCrossModuleNames || this.crossModuleNames.contains(name) || this.compiler.getCodingConvention().isExported(name, false);
    }

    private boolean isExternVar(String varname, NodeTraversal t) {
        if (varname.isEmpty()) {
            return false;
        }
        Var v = (Var)t.getScope().getVar(varname);
        return v == null || v.isExtern() || ((Scope)v.getScope()).isGlobal() && this.externNames.contains(varname);
    }

    private void addExternForGlobalSymbolNamespace() {
        Node varNode = IR.var(IR.name(this.globalSymbolNamespace));
        CompilerInput input = this.compiler.getSynthesizedExternsInput();
        input.getAstRoot(this.compiler).addChildToBack(varNode);
        this.compiler.reportChangeToEnclosingScope(varNode);
    }

    @Override
    public void process(Node externs, Node root) {
        this.externNames = NodeUtil.collectExternVariableNames(this.compiler, externs);
        if (this.addExtern) {
            this.addExternForGlobalSymbolNamespace();
        }
        NodeTraversal.traverse(this.compiler, root, new RewriteGlobalClassFunctionDeclarationsToVarAssignmentsCallback());
        ArrayList<NodeTraversal.Callback> nonMutatingPasses = new ArrayList<NodeTraversal.Callback>();
        nonMutatingPasses.add(new FindCrossModuleNamesCallback());
        nonMutatingPasses.add(new FindNamesReferencingThis());
        CombinedCompilerPass.traverse(this.compiler, root, nonMutatingPasses);
        RewriteScopeCallback rewriteScope = new RewriteScopeCallback();
        NodeTraversal.traverse(this.compiler, root, rewriteScope);
        NodeTraversal.traverse(this.compiler, root, new RemoveGlobalVarCallback());
        rewriteScope.declareModuleGlobals();
    }

    private class RemoveGlobalVarCallback
    extends NodeTraversal.AbstractShallowStatementCallback {
        private RemoveGlobalVarCallback() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (!NodeUtil.isNameDeclaration(n)) {
                return;
            }
            ArrayList<Node> commas = new ArrayList<Node>();
            ArrayList<Node> interestingChildren = new ArrayList<Node>();
            boolean allNameOrDestructuring = true;
            for (Node c : n.children()) {
                if (!c.isName() && !c.isDestructuringLhs()) {
                    allNameOrDestructuring = false;
                }
                if (!c.isAssign() && !NodeUtil.isAnyFor(parent)) continue;
                interestingChildren.add(c);
            }
            if (allNameOrDestructuring) {
                return;
            }
            for (Node c : interestingChildren) {
                if (NodeUtil.isAnyFor(parent) && parent.getFirstChild() == n) {
                    commas.add(c.cloneTree());
                    continue;
                }
                Node expr = IR.exprResult(c.cloneTree()).srcref(c);
                NodeUtil.markNewScopesChanged(expr, RescopeGlobalSymbols.this.compiler);
                parent.addChildBefore(expr, n);
            }
            if (!commas.isEmpty()) {
                Node comma = this.joinOnComma(commas, n);
                parent.addChildBefore(comma, n);
            }
            parent.removeChild(n);
            NodeUtil.markFunctionsDeleted(n, RescopeGlobalSymbols.this.compiler);
            RescopeGlobalSymbols.this.compiler.reportChangeToEnclosingScope(parent);
        }

        private Node joinOnComma(List<Node> commas, Node source) {
            Node comma = commas.get(0);
            for (int i = 1; i < commas.size(); ++i) {
                Node nextComma = IR.comma(comma, commas.get(i));
                nextComma.useSourceInfoIfMissingFrom(source);
                comma = nextComma;
            }
            return comma;
        }
    }

    private class RewriteScopeCallback
    implements NodeTraversal.Callback {
        List<ModuleGlobal> preDeclarations = new ArrayList<ModuleGlobal>();

        private RewriteScopeCallback() {
        }

        @Override
        public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
            if (NodeUtil.isNameDeclaration(n)) {
                this.visitNameDeclaration(t, n);
            }
            return true;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n.isName()) {
                this.visitName(t, n, parent);
            }
        }

        private void visitNameDeclaration(NodeTraversal t, Node declaration) {
            List<Node> allLhsNodes = NodeUtil.findLhsNodesInNode(declaration);
            if (allLhsNodes.isEmpty()) {
                return;
            }
            boolean hasImportantName = false;
            boolean isGlobalDeclaration = ((Var)t.getScope().getVar(allLhsNodes.get(0).getString())).isGlobal();
            for (Node lhs : allLhsNodes) {
                Preconditions.checkState(lhs.isName(), "Unexpected lhs node %s, expected NAME", (Object)lhs);
                if ((!isGlobalDeclaration || !RescopeGlobalSymbols.this.isCrossModuleName(lhs.getString())) && !RescopeGlobalSymbols.this.isExternVar(lhs.getString(), t)) continue;
                hasImportantName = true;
                break;
            }
            if (hasImportantName) {
                this.rewriteNameDeclaration(t, declaration, allLhsNodes, isGlobalDeclaration);
            }
        }

        private void rewriteNameDeclaration(NodeTraversal t, Node declaration, List<Node> allLhsNodes, boolean isGlobalDeclaration) {
            CompilerInput input = t.getInput();
            for (Node lhs : allLhsNodes) {
                String name = lhs.getString();
                if (isGlobalDeclaration && RescopeGlobalSymbols.this.isCrossModuleName(name) || RescopeGlobalSymbols.this.isExternVar(name, t)) continue;
                this.preDeclarations.add(new ModuleGlobal(input.getAstRoot(RescopeGlobalSymbols.this.compiler), IR.name(name).srcref(lhs)));
            }
            for (Node child : declaration.children()) {
                Node assign;
                if (child.isName() && child.hasChildren()) {
                    assign = IR.assign(child.cloneNode(), child.removeFirstChild());
                    child.replaceWith(assign);
                    assign.setJSDocInfo(declaration.getJSDocInfo());
                    continue;
                }
                if (!child.isDestructuringLhs()) continue;
                if (child.hasOneChild()) {
                    Preconditions.checkState(NodeUtil.isEnhancedFor(declaration.getParent()), "DESTRUCTURING_LHS should have two children: %s", (Object)declaration.toStringTree());
                    child.replaceWith(child.removeFirstChild());
                    continue;
                }
                assign = IR.assign(child.removeFirstChild(), child.removeFirstChild());
                child.replaceWith(assign);
                assign.setJSDocInfo(declaration.getJSDocInfo());
            }
            RescopeGlobalSymbols.this.compiler.reportChangeToEnclosingScope(declaration);
        }

        private void visitName(NodeTraversal t, Node n, Node parent) {
            String name = n.getString();
            if (parent.isFunction() && name.isEmpty()) {
                return;
            }
            if (RescopeGlobalSymbols.this.isExternVar(name, t)) {
                return;
            }
            Var var = (Var)t.getScope().getVar(name);
            if (!var.isGlobal() && (name.equals(RescopeGlobalSymbols.this.globalSymbolNamespace) || name.startsWith(RescopeGlobalSymbols.this.globalSymbolNamespace + RescopeGlobalSymbols.DISAMBIGUATION_SUFFIX))) {
                n.setString(name + RescopeGlobalSymbols.DISAMBIGUATION_SUFFIX);
                RescopeGlobalSymbols.this.compiler.reportChangeToEnclosingScope(n);
            }
            if (!var.isGlobal() || !RescopeGlobalSymbols.this.isCrossModuleName(name)) {
                return;
            }
            this.replaceSymbol(n, name);
        }

        private void replaceSymbol(Node node, String name) {
            Node parent = node.getParent();
            Node replacement = IR.getprop(IR.name(RescopeGlobalSymbols.this.globalSymbolNamespace), IR.string(name));
            replacement.useSourceInfoFromForTree(node);
            parent.replaceChild(node, replacement);
            RescopeGlobalSymbols.this.compiler.reportChangeToEnclosingScope(replacement);
            if (parent.isCall() && !RescopeGlobalSymbols.this.maybeReferencesThis.contains(name)) {
                parent.putBooleanProp(Node.FREE_CALL, false);
            }
            RescopeGlobalSymbols.this.compiler.reportChangeToEnclosingScope(parent);
        }

        void declareModuleGlobals() {
            for (ModuleGlobal global : this.preDeclarations) {
                if (global.root.hasChildren() && global.root.getFirstChild().isVar()) {
                    global.root.getFirstChild().addChildToBack(global.name);
                } else {
                    global.root.addChildToFront(IR.var(global.name).srcref(global.name));
                }
                RescopeGlobalSymbols.this.compiler.reportChangeToEnclosingScope(global.root);
            }
        }

        private class ModuleGlobal {
            final Node root;
            final Node name;

            ModuleGlobal(Node root, Node name) {
                this.root = root;
                this.name = name;
            }
        }
    }

    private class FindNamesReferencingThis
    extends NodeTraversal.AbstractPostOrderCallback {
        private FindNamesReferencingThis() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n.isName()) {
                String name = n.getString();
                if (name.isEmpty()) {
                    return;
                }
                Node value = null;
                if (parent.isAssign() && n == parent.getFirstChild()) {
                    value = parent.getLastChild();
                } else if (NodeUtil.isNameDeclaration(parent)) {
                    value = n.getFirstChild();
                } else if (parent.isFunction()) {
                    value = parent;
                }
                if (value == null && !NodeUtil.isLhsByDestructuring(n)) {
                    return;
                }
                if (RescopeGlobalSymbols.this.maybeReferencesThis.contains(name)) {
                    return;
                }
                Scope s = t.getScope();
                Var v = (Var)s.getVar(name);
                if (v == null || !v.isGlobal()) {
                    return;
                }
                if (value == null || !value.isFunction() || NodeUtil.referencesOwnReceiver(value)) {
                    RescopeGlobalSymbols.this.maybeReferencesThis.add(name);
                }
            }
        }
    }

    private class FindCrossModuleNamesCallback
    extends NodeTraversal.AbstractPostOrderCallback {
        private FindCrossModuleNamesCallback() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n.isName()) {
                String name = n.getString();
                if ("".equals(name) || RescopeGlobalSymbols.this.crossModuleNames.contains(name)) {
                    return;
                }
                Scope s = t.getScope();
                Var v = (Var)s.getVar(name);
                if (v == null || !v.isGlobal()) {
                    return;
                }
                CompilerInput input = v.getInput();
                if (input == null) {
                    RescopeGlobalSymbols.this.crossModuleNames.add(name);
                    return;
                }
                JSModule module = input.getModule();
                if (module != t.getModule()) {
                    RescopeGlobalSymbols.this.crossModuleNames.add(name);
                }
            }
        }
    }

    private class RewriteGlobalClassFunctionDeclarationsToVarAssignmentsCallback
    extends NodeTraversal.AbstractShallowStatementCallback {
        private RewriteGlobalClassFunctionDeclarationsToVarAssignmentsCallback() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (NodeUtil.isFunctionDeclaration(n) || NodeUtil.isClassDeclaration(n) && t.inGlobalScope()) {
                Node nameNode = NodeUtil.getNameNode(n);
                String name = nameNode.getString();
                if (n.isClass()) {
                    nameNode.replaceWith(IR.empty().srcref(nameNode));
                } else {
                    nameNode.setString("");
                    RescopeGlobalSymbols.this.compiler.reportChangeToEnclosingScope(nameNode);
                }
                Node prev = n.getPrevious();
                n.detach();
                Node var = NodeUtil.newVarNode(name, n);
                if (prev == null) {
                    parent.addChildToFront(var);
                } else {
                    parent.addChildAfter(var, prev);
                }
                RescopeGlobalSymbols.this.compiler.reportChangeToEnclosingScope(parent);
            }
        }
    }
}

