/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.debugging.sourcemap.proto.Mapping;
import com.google.javascript.jscomp.AbstractMessageFormatter;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.Region;
import com.google.javascript.jscomp.SourceExcerptProvider;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Splitter;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Strings;
import com.google.javascript.jscomp.jarjar.javax.annotation.Nullable;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.TokenUtil;
import java.util.List;

public final class LightweightMessageFormatter
extends AbstractMessageFormatter {
    private final SourceExcerptProvider.SourceExcerpt excerpt;
    private static final SourceExcerptProvider.ExcerptFormatter excerptFormatter = new LineNumberingFormatter();
    private boolean includeLocation = true;
    private boolean includeLevel = true;
    private static final int MAX_MULTILINE_ERROR_LENGTH = 4;

    private LightweightMessageFormatter() {
        super(null);
        this.excerpt = SourceExcerptProvider.SourceExcerpt.LINE;
    }

    public LightweightMessageFormatter(SourceExcerptProvider source) {
        this(source, SourceExcerptProvider.SourceExcerpt.LINE);
    }

    public LightweightMessageFormatter(SourceExcerptProvider source, SourceExcerptProvider.SourceExcerpt excerpt) {
        super(source);
        Preconditions.checkNotNull(source);
        this.excerpt = excerpt;
    }

    public static LightweightMessageFormatter withoutSource() {
        return new LightweightMessageFormatter();
    }

    public LightweightMessageFormatter setIncludeLocation(boolean includeLocation) {
        this.includeLocation = includeLocation;
        return this;
    }

    public LightweightMessageFormatter setIncludeLevel(boolean includeLevel) {
        this.includeLevel = includeLevel;
        return this;
    }

    @Override
    public String formatError(JSError error) {
        return this.format(error, false);
    }

    @Override
    public String formatWarning(JSError warning) {
        return this.format(warning, true);
    }

    private String format(JSError error, boolean warning) {
        SourceExcerptProvider source = this.getSource();
        String sourceName = error.getSourceName();
        int lineNumber = error.getLineNumber();
        int charno = error.getCharno();
        StringBuilder b = new StringBuilder();
        StringBuilder boldLine = new StringBuilder();
        if (this.includeLocation) {
            Mapping.OriginalMapping mapping;
            Mapping.OriginalMapping originalMapping = mapping = source == null ? null : source.getSourceMapping(error.getSourceName(), error.getLineNumber(), error.getCharno());
            if (mapping != null) {
                LightweightMessageFormatter.appendPosition(b, sourceName, lineNumber, charno);
                sourceName = mapping.getOriginalFile();
                lineNumber = mapping.getLineNumber();
                charno = mapping.getColumnPosition();
                b.append("\nOriginally at:\n");
            }
            LightweightMessageFormatter.appendPosition(boldLine, sourceName, lineNumber, charno);
        }
        if (this.includeLevel) {
            boldLine.append(this.getLevelName(warning ? CheckLevel.WARNING : CheckLevel.ERROR));
            boldLine.append(" - [");
            boldLine.append(error.getType().key);
            boldLine.append("] ");
        }
        boldLine.append(error.getDescription());
        b.append(this.maybeEmbolden(boldLine.toString()));
        b.append('\n');
        String sourceExcerptWithPositionIndicator = this.getExcerptWithPosition(error, sourceName, lineNumber, charno);
        if (sourceExcerptWithPositionIndicator != null) {
            b.append(sourceExcerptWithPositionIndicator);
        }
        return b.toString();
    }

    String getExcerptWithPosition(JSError error) {
        return this.getExcerptWithPosition(error, error.getSourceName(), error.getLineNumber(), error.getCharno());
    }

    private String getExcerptWithPosition(JSError error, String sourceName, int lineNumber, int charno) {
        String sourceExcerpt;
        StringBuilder b = new StringBuilder();
        SourceExcerptProvider source = this.getSource();
        int nodeLength = error.getNodeLength();
        int length = charno >= 0 && nodeLength >= 0 ? charno + nodeLength : -1;
        String string = sourceExcerpt = source == null ? null : this.excerpt.get(source, sourceName, lineNumber, length, excerptFormatter);
        if (sourceExcerpt != null) {
            if (this.excerpt.equals((Object)SourceExcerptProvider.SourceExcerpt.FULL)) {
                if (0 <= charno) {
                    this.padMultipleLines(charno, sourceExcerpt, b, error.getNode());
                } else {
                    b.append(sourceExcerpt);
                    b.append('\n');
                }
            } else {
                b.append(sourceExcerpt);
                b.append('\n');
                if (this.excerpt.equals((Object)SourceExcerptProvider.SourceExcerpt.LINE) && 0 <= charno && charno <= sourceExcerpt.length()) {
                    this.padLine(charno, sourceExcerpt, b, error.getNodeLength(), error.getNode());
                }
            }
        }
        return b.toString();
    }

    private static void appendPosition(StringBuilder b, String sourceName, int lineNumber, int charno) {
        if (sourceName != null) {
            b.append(sourceName);
            if (lineNumber > 0) {
                b.append(':').append(lineNumber);
                if (charno >= 0) {
                    b.append(':').append(charno);
                }
            }
            b.append(": ");
        }
    }

    private void padLine(int charno, String sourceExcerpt, StringBuilder b, int errLength, Node errorNode) {
        for (int i = 0; i < charno; ++i) {
            char c = sourceExcerpt.charAt(i);
            if (TokenUtil.isWhitespace(c)) {
                b.append(c);
                continue;
            }
            b.append(' ');
        }
        if (errorNode == null) {
            b.append("^");
        } else {
            int length = Math.max(1, Math.min(errLength, sourceExcerpt.length() - charno));
            for (int i = 0; i < length; ++i) {
                b.append("^");
            }
        }
        b.append("\n");
    }

    private void padMultipleLines(int startCharno, String sourceExcerpt, StringBuilder b, Node errorNode) {
        if (errorNode == null) {
            b.append(sourceExcerpt);
            b.append("\n");
            int charWithLineNumberOffset = startCharno + sourceExcerpt.indexOf(124) + 2;
            this.padLine(charWithLineNumberOffset, sourceExcerpt, b, -1, errorNode);
            return;
        }
        List<String> lines = Splitter.on('\n').splitToList(sourceExcerpt);
        boolean requiresTruncation = lines.size() > 4;
        int truncationStart = 2;
        int truncationEnd = lines.size() - 2;
        int remainingLength = errorNode.getLength();
        int charno = startCharno;
        for (int i = 0; i < lines.size(); ++i) {
            String line = lines.get(i);
            if (requiresTruncation && i == truncationStart) {
                b.append("...\n");
            }
            boolean shouldPrintLine = !requiresTruncation || i < truncationStart || i >= truncationEnd;
            int charWithLineNumberOffset = charno + line.indexOf(124) + 2;
            if (shouldPrintLine) {
                b.append(line);
                b.append("\n");
                this.padLine(charWithLineNumberOffset, line, b, remainingLength, errorNode);
            }
            remainingLength -= line.length() + 1 - charWithLineNumberOffset;
            charno = 0;
        }
    }

    static class LineNumberingFormatter
    implements SourceExcerptProvider.ExcerptFormatter {
        LineNumberingFormatter() {
        }

        @Override
        public String formatLine(String line, int lineNumber) {
            return line;
        }

        @Override
        public String formatRegion(@Nullable Region region) {
            if (region == null) {
                return null;
            }
            String code = region.getSourceExcerpt();
            if (code.isEmpty()) {
                return null;
            }
            int numberLength = Integer.toString(region.getEndingLineNumber()).length();
            StringBuilder builder = new StringBuilder(code.length() * 2);
            int start = 0;
            int end = code.indexOf(10, start);
            int lineNumber = region.getBeginningLineNumber();
            while (start >= 0) {
                String line;
                if (end < 0) {
                    line = code.substring(start);
                    if (line.isEmpty()) {
                        return builder.substring(0, builder.length() - 1);
                    }
                } else {
                    line = code.substring(start, end);
                }
                builder.append("  ");
                int spaces = numberLength - Integer.toString(lineNumber).length();
                builder.append(Strings.repeat(" ", spaces));
                builder.append(lineNumber);
                builder.append("| ");
                if (end < 0) {
                    builder.append(line);
                    start = -1;
                    continue;
                }
                builder.append(line);
                builder.append('\n');
                start = end + 1;
                end = code.indexOf(10, start);
                ++lineNumber;
            }
            return builder.toString();
        }
    }
}

