/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.BooleanLiteralSet;
import com.google.javascript.rhino.jstype.EquivalenceMethod;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.Property;
import com.google.javascript.rhino.jstype.PropertyMap;
import com.google.javascript.rhino.jstype.RelationshipVisitor;
import com.google.javascript.rhino.jstype.TemplateTypeMap;
import com.google.javascript.rhino.jstype.TemplatizedType;
import com.google.javascript.rhino.jstype.TernaryValue;
import com.google.javascript.rhino.jstype.Visitor;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nullable;

public abstract class ObjectType
extends JSType
implements Serializable {
    private boolean visited;
    private JSDocInfo docInfo = null;
    private boolean unknown = true;

    ObjectType(JSTypeRegistry registry) {
        super(registry);
    }

    ObjectType(JSTypeRegistry registry, TemplateTypeMap templateTypeMap) {
        super(registry, templateTypeMap);
    }

    public final ObjectType getParentScope() {
        return this.getImplicitPrototype();
    }

    PropertyMap getPropertyMap() {
        return PropertyMap.immutableEmptyMap();
    }

    public Property getSlot(String name) {
        return this.getPropertyMap().getSlot(name);
    }

    public final Property getOwnSlot(String name) {
        return this.getPropertyMap().getOwnProperty(name);
    }

    public JSType getTypeOfThis() {
        return null;
    }

    public ImmutableList<JSType> getTemplateTypes() {
        return null;
    }

    @Override
    public JSDocInfo getJSDocInfo() {
        return this.docInfo;
    }

    public void setJSDocInfo(JSDocInfo info) {
        this.docInfo = info;
    }

    final boolean detectImplicitPrototypeCycle() {
        ObjectType p;
        this.visited = true;
        for (p = this.getImplicitPrototype(); p != null; p = p.getImplicitPrototype()) {
            if (p.visited) {
                return true;
            }
            p.visited = true;
        }
        p = this;
        do {
            p.visited = false;
        } while ((p = p.getImplicitPrototype()) != null);
        return false;
    }

    final boolean detectInheritanceCycle() {
        if (this.detectImplicitPrototypeCycle() || Iterables.contains(this.getCtorImplementedInterfaces(), this)) {
            return true;
        }
        FunctionType fnType = this.getConstructor();
        return fnType != null && fnType.checkExtendsLoop() != null;
    }

    @Nullable
    public abstract String getReferenceName();

    public final boolean hasReferenceName() {
        return this.getReferenceName() != null;
    }

    @Nullable
    public final String getNormalizedReferenceName() {
        int start;
        String name = this.getReferenceName();
        if (name != null && (start = name.indexOf(40)) != -1) {
            int end = name.lastIndexOf(41);
            String prefix = name.substring(0, start);
            return end + 1 % name.length() == 0 ? prefix : prefix + name.substring(end + 1);
        }
        return name;
    }

    @Override
    public String getDisplayName() {
        return this.getNormalizedReferenceName();
    }

    public static String createDelegateSuffix(String suffix) {
        return "(" + suffix + ")";
    }

    public final boolean isAmbiguousObject() {
        return !this.hasReferenceName();
    }

    public final ObjectType getRawType() {
        TemplatizedType t = this.toMaybeTemplatizedType();
        return t == null ? this : t.getReferencedType();
    }

    public final ObjectType instantiateGenericsWithUnknown() {
        return this.registry.instantiateGenericsWithUnknown(this);
    }

    @Override
    public TernaryValue testForEquality(JSType that) {
        TernaryValue result = super.testForEquality(that);
        if (result != null) {
            return result;
        }
        if (that.isSubtypeOf(this.getNativeType(JSTypeNative.OBJECT_NUMBER_STRING_BOOLEAN_SYMBOL))) {
            return TernaryValue.UNKNOWN;
        }
        return TernaryValue.FALSE;
    }

    public abstract FunctionType getConstructor();

    public FunctionType getSuperClassConstructor() {
        ObjectType iproto = this.getPrototypeObject();
        if (iproto == null) {
            return null;
        }
        return (iproto = iproto.getPrototypeObject()) == null ? null : iproto.getConstructor();
    }

    public final ObjectType getTopDefiningInterface(String propertyName) {
        ObjectType foundType = null;
        if (this.hasProperty(propertyName)) {
            foundType = this;
        }
        for (ObjectType interfaceType : this.getCtorExtendedInterfaces()) {
            if (!interfaceType.hasProperty(propertyName)) continue;
            foundType = interfaceType.getTopDefiningInterface(propertyName);
        }
        return foundType;
    }

    public abstract ObjectType getImplicitPrototype();

    public final ObjectType getPrototypeObject() {
        return this.getImplicitPrototype();
    }

    public final boolean defineDeclaredProperty(String propertyName, JSType type, Node propertyNode) {
        boolean result = this.defineProperty(propertyName, type, false, propertyNode);
        this.registry.registerPropertyOnType(propertyName, this);
        return result;
    }

    public final boolean defineSynthesizedProperty(String propertyName, JSType type, Node propertyNode) {
        return this.defineProperty(propertyName, type, false, propertyNode);
    }

    public final boolean defineInferredProperty(String propertyName, JSType type, Node propertyNode) {
        if (this.hasProperty(propertyName)) {
            if (this.isPropertyTypeDeclared(propertyName)) {
                return true;
            }
            JSType originalType = this.getPropertyType(propertyName);
            type = originalType == null ? type : originalType.getLeastSupertype(type);
        }
        boolean result = this.defineProperty(propertyName, type, true, propertyNode);
        this.registry.registerPropertyOnType(propertyName, this);
        return result;
    }

    abstract boolean defineProperty(String var1, JSType var2, boolean var3, Node var4);

    public boolean removeProperty(String propertyName) {
        return false;
    }

    public final Node getPropertyNode(String propertyName) {
        Property p = this.getSlot(propertyName);
        return p == null ? null : p.getNode();
    }

    public final Node getPropertyDefSite(String propertyName) {
        return this.getPropertyNode(propertyName);
    }

    public final JSDocInfo getPropertyJSDocInfo(String propertyName) {
        Property p = this.getSlot(propertyName);
        return p == null ? null : p.getJSDocInfo();
    }

    public final JSDocInfo getOwnPropertyJSDocInfo(String propertyName) {
        Property p = this.getOwnSlot(propertyName);
        return p == null ? null : p.getJSDocInfo();
    }

    public final Node getOwnPropertyDefSite(String propertyName) {
        Property p = this.getOwnSlot(propertyName);
        return p == null ? null : p.getNode();
    }

    public void setPropertyJSDocInfo(String propertyName, JSDocInfo info) {
    }

    public void setPropertyNode(String propertyName, Node defSite) {
    }

    @Override
    public JSType findPropertyType(String propertyName) {
        return this.hasProperty(propertyName) ? this.getPropertyType(propertyName) : null;
    }

    public JSType getPropertyType(String propertyName) {
        Property slot = this.getSlot(propertyName);
        if (slot == null) {
            if (this.isNoResolvedType() || this.isCheckedUnknownType()) {
                return this.getNativeType(JSTypeNative.CHECKED_UNKNOWN_TYPE);
            }
            if (this.isEmptyType()) {
                return this.getNativeType(JSTypeNative.NO_TYPE);
            }
            return this.getNativeType(JSTypeNative.UNKNOWN_TYPE);
        }
        return slot.getType();
    }

    @Override
    public JSType.HasPropertyKind getPropertyKind(String propertyName, boolean autobox) {
        return JSType.HasPropertyKind.of(this.isEmptyType() || this.isUnknownType() || this.getSlot(propertyName) != null);
    }

    public final JSType.HasPropertyKind getOwnPropertyKind(String propertyName) {
        return this.getOwnSlot(propertyName) != null ? JSType.HasPropertyKind.KNOWN_PRESENT : JSType.HasPropertyKind.ABSENT;
    }

    public final boolean hasOwnProperty(String propertyName) {
        return !this.getOwnPropertyKind(propertyName).equals((Object)JSType.HasPropertyKind.ABSENT);
    }

    public Set<String> getOwnPropertyNames() {
        return this.getPropertyMap().getOwnPropertyNames();
    }

    public final boolean isPropertyTypeInferred(String propertyName) {
        Property slot = this.getSlot(propertyName);
        return slot == null ? false : slot.isTypeInferred();
    }

    public final boolean isPropertyTypeDeclared(String propertyName) {
        Property slot = this.getSlot(propertyName);
        return slot == null ? false : !slot.isTypeInferred();
    }

    @Override
    public boolean isStructuralType() {
        FunctionType constructor = this.getConstructor();
        return constructor != null && constructor.isStructuralInterface();
    }

    final boolean hasOwnDeclaredProperty(String name) {
        return this.hasOwnProperty(name) && this.isPropertyTypeDeclared(name);
    }

    public final boolean isPropertyInExterns(String propertyName) {
        Property p = this.getSlot(propertyName);
        return p == null ? false : p.isFromExterns();
    }

    public final int getPropertiesCount() {
        return this.getPropertyMap().getPropertiesCount();
    }

    final boolean checkStructuralEquivalenceHelper(ObjectType otherObject, EquivalenceMethod eqMethod, JSType.EqCache eqCache) {
        if (this.isTemplatizedType() && this.toMaybeTemplatizedType().wrapsSameRawType(otherObject)) {
            return this.getTemplateTypeMap().checkEquivalenceHelper(otherObject.getTemplateTypeMap(), eqMethod, eqCache, JSType.SubtypingMode.NORMAL);
        }
        JSType.MatchStatus result = eqCache.checkCache(this, otherObject);
        if (result != null) {
            return result.subtypeValue();
        }
        Set<String> keySet = this.getPropertyNames();
        Set<String> otherKeySet = otherObject.getPropertyNames();
        if (!otherKeySet.equals(keySet)) {
            eqCache.updateCache(this, otherObject, JSType.MatchStatus.NOT_MATCH);
            return false;
        }
        for (String key : keySet) {
            if (otherObject.getPropertyType(key).checkEquivalenceHelper(this.getPropertyType(key), eqMethod, eqCache)) continue;
            eqCache.updateCache(this, otherObject, JSType.MatchStatus.NOT_MATCH);
            return false;
        }
        eqCache.updateCache(this, otherObject, JSType.MatchStatus.MATCH);
        return true;
    }

    private static boolean isStructuralSubtypeHelper(ObjectType typeA, ObjectType typeB, JSType.ImplCache implicitImplCache, JSType.SubtypingMode subtypingMode) {
        for (String property : typeB.getPropertyNames()) {
            JSType propB = typeB.getPropertyType(property);
            if (!typeA.hasProperty(property)) {
                if (propB.isExplicitlyVoidable()) continue;
                return false;
            }
            JSType propA = typeA.getPropertyType(property);
            if (propA.isSubtype(propB, implicitImplCache, subtypingMode)) continue;
            return false;
        }
        return true;
    }

    final boolean isStructuralSubtype(ObjectType superType, JSType.ImplCache implicitImplCache, JSType.SubtypingMode subtypingMode) {
        Preconditions.checkArgument(!this.isUnionType());
        Preconditions.checkArgument(!superType.isUnionType());
        Preconditions.checkArgument(superType.isStructuralType(), "isStructuralSubtype should be called with structural supertype. Found %s", (Object)superType);
        JSType.MatchStatus cachedResult = implicitImplCache.checkCache(this, superType);
        if (cachedResult != null) {
            return cachedResult.subtypeValue();
        }
        boolean result = ObjectType.isStructuralSubtypeHelper(this, superType, implicitImplCache, subtypingMode);
        implicitImplCache.updateCache(this, superType, result ? JSType.MatchStatus.MATCH : JSType.MatchStatus.NOT_MATCH);
        return result;
    }

    public final Set<String> getPropertyNames() {
        TreeSet<String> props = new TreeSet<String>();
        this.collectPropertyNames(props);
        return props;
    }

    final void collectPropertyNames(Set<String> props) {
        this.getPropertyMap().collectPropertyNames(props);
    }

    @Override
    public <T> T visit(Visitor<T> visitor) {
        return visitor.caseObjectType(this);
    }

    @Override
    <T> T visit(RelationshipVisitor<T> visitor, JSType that) {
        return visitor.caseObjectType(this, that);
    }

    final boolean isImplicitPrototype(ObjectType prototype) {
        for (ObjectType current = this; current != null; current = current.getImplicitPrototype()) {
            if (current.isTemplatizedType()) {
                current = current.toMaybeTemplatizedType().getReferencedType();
            }
            if (!current.isEquivalentTo(prototype)) continue;
            return true;
        }
        return false;
    }

    @Override
    public BooleanLiteralSet getPossibleToBooleanOutcomes() {
        return BooleanLiteralSet.TRUE;
    }

    @Override
    public boolean isUnknownType() {
        if (this.unknown) {
            ObjectType implicitProto = this.getImplicitPrototype();
            if (implicitProto == null || implicitProto.isNativeObjectType()) {
                this.unknown = false;
                for (ObjectType interfaceType : this.getCtorExtendedInterfaces()) {
                    if (!interfaceType.isUnknownType()) continue;
                    this.unknown = true;
                    break;
                }
            } else {
                this.unknown = implicitProto.isUnknownType();
            }
        }
        return this.unknown;
    }

    @Override
    public boolean isObject() {
        return true;
    }

    public boolean hasCachedValues() {
        return !this.unknown;
    }

    public void clearCachedValues() {
        this.unknown = true;
    }

    @Override
    public boolean isNativeObjectType() {
        return false;
    }

    public final JSType getLegacyResolvedType() {
        return this.toMaybeNamedType().getReferencedType();
    }

    public static ObjectType cast(JSType type) {
        return type == null ? null : type.toObjectType();
    }

    @Override
    public final boolean isFunctionPrototypeType() {
        return this.getOwnerFunction() != null;
    }

    public FunctionType getOwnerFunction() {
        return null;
    }

    void setOwnerFunction(FunctionType type) {
    }

    public Iterable<ObjectType> getCtorImplementedInterfaces() {
        return ImmutableSet.of();
    }

    public Iterable<ObjectType> getCtorExtendedInterfaces() {
        return ImmutableSet.of();
    }

    public Map<String, JSType> getPropertyTypeMap() {
        ImmutableMap.Builder<String, JSType> propTypeMap = ImmutableMap.builder();
        for (String name : this.getPropertyNames()) {
            propTypeMap.put(name, this.getPropertyType(name));
        }
        return propTypeMap.build();
    }

    public JSType getEnumeratedTypeOfEnumObject() {
        return null;
    }
}

