/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.io.ByteStreams;
import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CodingConventions;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.ControlFlowGraph;
import com.google.javascript.jscomp.DefaultExterns;
import com.google.javascript.jscomp.DependencyOptions;
import com.google.javascript.jscomp.DiagnosticGroups;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.DotFormatter;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.JSModule;
import com.google.javascript.jscomp.JSModuleGraph;
import com.google.javascript.jscomp.JsonErrorReportGenerator;
import com.google.javascript.jscomp.ModuleIdentifier;
import com.google.javascript.jscomp.Result;
import com.google.javascript.jscomp.ShowByPathWarningsGuard;
import com.google.javascript.jscomp.SortingErrorManager;
import com.google.javascript.jscomp.SourceExcerptProvider;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.jscomp.SourceMap;
import com.google.javascript.jscomp.SourceMapInput;
import com.google.javascript.jscomp.VariableMap;
import com.google.javascript.jscomp.deps.SourceCodeEscapers;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.StaticSourceFile;
import com.google.javascript.rhino.TokenStream;
import com.google.protobuf.CodedOutputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.annotation.Nullable;

public abstract class AbstractCommandLineRunner<A extends Compiler, B extends CompilerOptions> {
    static final DiagnosticType OUTPUT_SAME_AS_INPUT_ERROR = DiagnosticType.error("JSC_OUTPUT_SAME_AS_INPUT_ERROR", "Bad output file (already listed as input file): {0}");
    static final DiagnosticType COULD_NOT_SERIALIZE_AST = DiagnosticType.error("JSC_COULD_NOT_SERIALIZE_AST", "Could not serialize ast to: {0}");
    static final DiagnosticType COULD_NOT_DESERIALIZE_AST = DiagnosticType.error("JSC_COULD_NOT_DESERIALIZE_AST", "Could not deserialize ast from: {0}");
    static final DiagnosticType NO_TREE_GENERATED_ERROR = DiagnosticType.error("JSC_NO_TREE_GENERATED_ERROR", "Code contains errors. No tree was generated.");
    static final DiagnosticType INVALID_MODULE_SOURCEMAP_PATTERN = DiagnosticType.error("JSC_INVALID_MODULE_SOURCEMAP_PATTERN", "When using --module flags, the --create_source_map flag must contain %outname% in the value.");
    static final DiagnosticType CONFLICTING_DUPLICATE_ZIP_CONTENTS = DiagnosticType.error("JSC_CONFLICTING_DUPLICATE_ZIP_CONTENTS", "Two zip entries containing conflicting contents with the same relative path.\nEntry 1: {0}\nEntry 2: {1}");
    static final String WAITING_FOR_INPUT_WARNING = "The compiler is waiting for input via stdin.";
    @GwtIncompatible(value="Unnecessary")
    private final CommandLineConfig config;
    @GwtIncompatible(value="Unnecessary")
    private final InputStream in;
    @GwtIncompatible(value="Unnecessary")
    private final PrintStream defaultJsOutput;
    @GwtIncompatible(value="Unnecessary")
    private final PrintStream err;
    @GwtIncompatible(value="Unnecessary")
    private A compiler;
    @GwtIncompatible(value="Unnecessary")
    private Charset inputCharset;
    @GwtIncompatible(value="Unnecessary")
    private Charset outputCharset2;
    @GwtIncompatible(value="Unnecessary")
    private Charset legacyOutputCharset;
    @GwtIncompatible(value="Unnecessary")
    private boolean testMode = false;
    @GwtIncompatible(value="Unnecessary")
    private Supplier<List<SourceFile>> externsSupplierForTesting = null;
    @GwtIncompatible(value="Unnecessary")
    private Supplier<List<SourceFile>> inputsSupplierForTesting = null;
    @GwtIncompatible(value="Unnecessary")
    private Supplier<List<JSModule>> modulesSupplierForTesting = null;
    @GwtIncompatible(value="Unnecessary")
    private Function<Integer, Void> exitCodeReceiver = SystemExitCodeReceiver.INSTANCE;
    @GwtIncompatible(value="Unnecessary")
    private Map<String, String> rootRelativePathsMap = null;
    @GwtIncompatible(value="Unnecessary")
    private Map<String, String> parsedModuleWrappers = null;
    @GwtIncompatible(value="Unnecessary")
    private final Gson gson;
    static final String OUTPUT_MARKER = "%output%";
    private static final String OUTPUT_MARKER_JS_STRING = "%output|jsstring%";
    @GwtIncompatible(value="Unnecessary")
    private final List<JsonFileSpec> filesToStreamOut = new ArrayList<JsonFileSpec>();

    @GwtIncompatible(value="Unnecessary")
    AbstractCommandLineRunner() {
        this(System.in, System.out, System.err);
    }

    @GwtIncompatible(value="Unnecessary")
    AbstractCommandLineRunner(PrintStream out, PrintStream err) {
        this(System.in, out, err);
    }

    @GwtIncompatible(value="Unnecessary")
    AbstractCommandLineRunner(InputStream in, PrintStream out, PrintStream err) {
        this.config = new CommandLineConfig();
        this.in = Preconditions.checkNotNull(in);
        this.defaultJsOutput = Preconditions.checkNotNull(out);
        this.err = Preconditions.checkNotNull(err);
        this.gson = new Gson();
    }

    @VisibleForTesting
    @GwtIncompatible(value="Unnecessary")
    void enableTestMode(Supplier<List<SourceFile>> externsSupplier, Supplier<List<SourceFile>> inputsSupplier, Supplier<List<JSModule>> modulesSupplier, Function<Integer, Void> exitCodeReceiver) {
        Preconditions.checkArgument(inputsSupplier == null ^ modulesSupplier == null);
        this.testMode = true;
        this.externsSupplierForTesting = externsSupplier;
        this.inputsSupplierForTesting = inputsSupplier;
        this.modulesSupplierForTesting = modulesSupplier;
        this.exitCodeReceiver = exitCodeReceiver;
    }

    @GwtIncompatible(value="Unnecessary")
    public void setExitCodeReceiver(Function<Integer, Void> newExitCodeReceiver) {
        this.exitCodeReceiver = Preconditions.checkNotNull(newExitCodeReceiver);
    }

    @GwtIncompatible(value="Unnecessary")
    protected boolean isInTestMode() {
        return this.testMode;
    }

    @GwtIncompatible(value="Unnecessary")
    private boolean isOutputInJson() {
        return this.config.jsonStreamMode == CompilerOptions.JsonStreamMode.OUT || this.config.jsonStreamMode == CompilerOptions.JsonStreamMode.BOTH;
    }

    @GwtIncompatible(value="Unnecessary")
    protected CommandLineConfig getCommandLineConfig() {
        return this.config;
    }

    @GwtIncompatible(value="Unnecessary")
    protected abstract A createCompiler();

    @GwtIncompatible(value="Unnecessary")
    protected abstract void prepForBundleAndAppendTo(Appendable var1, CompilerInput var2, String var3) throws IOException;

    @GwtIncompatible(value="Unnecessary")
    protected abstract void appendRuntimeTo(Appendable var1) throws IOException;

    @GwtIncompatible(value="Unnecessary")
    protected abstract B createOptions();

    @GwtIncompatible(value="Unnecessary")
    protected DiagnosticGroups getDiagnosticGroups() {
        if (this.compiler == null) {
            return new DiagnosticGroups();
        }
        return ((Compiler)this.compiler).getDiagnosticGroups();
    }

    public static DependencyOptions createDependencyOptions(CompilerOptions.DependencyMode dependencyMode, List<ModuleIdentifier> entryPoints) {
        if (dependencyMode == CompilerOptions.DependencyMode.STRICT) {
            if (entryPoints.isEmpty()) {
                throw new FlagUsageException("When dependency_mode=STRICT, you must specify at least one entry_point");
            }
            return new DependencyOptions().setDependencyPruning(true).setDependencySorting(true).setMoocherDropping(true).setEntryPoints(entryPoints);
        }
        if (dependencyMode == CompilerOptions.DependencyMode.LOOSE || !entryPoints.isEmpty()) {
            return new DependencyOptions().setDependencyPruning(true).setDependencySorting(true).setMoocherDropping(false).setEntryPoints(entryPoints);
        }
        return null;
    }

    @GwtIncompatible(value="Unnecessary")
    protected abstract void addWhitelistWarningsGuard(CompilerOptions var1, File var2);

    @GwtIncompatible(value="Unnecessary")
    protected static void setWarningGuardOptions(CompilerOptions options, ArrayList<FlagEntry<CheckLevel>> warningGuards, DiagnosticGroups diagnosticGroups) {
        if (warningGuards != null) {
            for (FlagEntry<CheckLevel> entry : warningGuards) {
                if ("*".equals(((FlagEntry)entry).value)) {
                    Set<String> groupNames = diagnosticGroups.getRegisteredGroups().keySet();
                    for (String groupName : groupNames) {
                        if (DiagnosticGroups.wildcardExcludedGroups.contains(groupName)) continue;
                        diagnosticGroups.setWarningLevel(options, groupName, (CheckLevel)((FlagEntry)entry).flag);
                    }
                    continue;
                }
                diagnosticGroups.setWarningLevel(options, ((FlagEntry)entry).value, (CheckLevel)((FlagEntry)entry).flag);
            }
        }
    }

    @GwtIncompatible(value="Unnecessary")
    protected void setRunOptions(CompilerOptions options) throws IOException {
        HashSet<String> uniqueNames;
        DiagnosticGroups diagnosticGroups = this.getDiagnosticGroups();
        AbstractCommandLineRunner.setWarningGuardOptions(options, this.config.warningGuards, diagnosticGroups);
        if (!this.config.warningsWhitelistFile.isEmpty()) {
            this.addWhitelistWarningsGuard(options, new File(this.config.warningsWhitelistFile));
        }
        if (!this.config.hideWarningsFor.isEmpty()) {
            options.addWarningsGuard(new ShowByPathWarningsGuard(this.config.hideWarningsFor.toArray(new String[0]), ShowByPathWarningsGuard.ShowType.EXCLUDE));
        }
        AbstractCommandLineRunner.createDefineOrTweakReplacements(this.config.define, options, false);
        options.setTweakProcessing(this.config.tweakProcessing);
        AbstractCommandLineRunner.createDefineOrTweakReplacements(this.config.tweak, options, true);
        DependencyOptions depOptions = AbstractCommandLineRunner.createDependencyOptions(this.config.dependencyMode, this.config.entryPoints);
        if (depOptions != null) {
            options.setDependencyOptions(depOptions);
        }
        options.devMode = this.config.jscompDevMode;
        options.setCodingConvention(this.config.codingConvention);
        options.setSummaryDetailLevel(this.config.summaryDetailLevel);
        options.setTrustedStrings(true);
        this.legacyOutputCharset = options.outputCharset = this.getLegacyOutputCharset();
        this.outputCharset2 = this.getOutputCharset2();
        this.inputCharset = this.getInputCharset();
        if (this.config.jsOutputFile.length() > 0 && this.config.skipNormalOutputs) {
            throw new FlagUsageException("skip_normal_outputs and js_output_file cannot be used together.");
        }
        if (this.config.skipNormalOutputs && this.config.printAst) {
            throw new FlagUsageException("skip_normal_outputs and print_ast cannot be used together.");
        }
        if (this.config.skipNormalOutputs && this.config.printTree) {
            throw new FlagUsageException("skip_normal_outputs and print_tree cannot be used together.");
        }
        if (this.config.createSourceMap.length() > 0) {
            options.sourceMapOutputPath = this.config.createSourceMap;
        } else if (this.isOutputInJson()) {
            options.sourceMapOutputPath = "%outname%";
        }
        options.sourceMapDetailLevel = this.config.sourceMapDetailLevel;
        options.sourceMapFormat = this.config.sourceMapFormat;
        options.sourceMapLocationMappings = this.config.sourceMapLocationMappings;
        options.parseInlineSourceMaps = this.config.parseInlineSourceMaps;
        options.applyInputSourceMaps = this.config.applyInputSourceMaps;
        ImmutableMap.Builder inputSourceMaps = new ImmutableMap.Builder();
        for (Map.Entry files : this.config.sourceMapInputFiles.entrySet()) {
            SourceFile sourceMap = SourceFile.fromFile((String)files.getValue());
            inputSourceMaps.put(files.getKey(), new SourceMapInput(sourceMap));
        }
        options.inputSourceMaps = inputSourceMaps.build();
        if (!this.config.variableMapInputFile.isEmpty()) {
            options.inputVariableMap = VariableMap.load(this.config.variableMapInputFile);
        }
        if (!this.config.propertyMapInputFile.isEmpty()) {
            options.inputPropertyMap = VariableMap.load(this.config.propertyMapInputFile);
        }
        if (!this.config.outputManifests.isEmpty()) {
            uniqueNames = new HashSet<String>();
            for (String filename : this.config.outputManifests) {
                if (uniqueNames.add(filename)) continue;
                throw new FlagUsageException("output_manifest flags specify duplicate file names: " + filename);
            }
        }
        if (!this.config.outputBundles.isEmpty()) {
            uniqueNames = new HashSet();
            for (String filename : this.config.outputBundles) {
                if (uniqueNames.add(filename)) continue;
                throw new FlagUsageException("output_bundle flags specify duplicate file names: " + filename);
            }
        }
        options.transformAMDToCJSModules = this.config.transformAMDToCJSModules;
        options.processCommonJSModules = this.config.processCommonJSModules;
        options.moduleRoots = this.config.moduleRoots;
        options.angularPass = this.config.angularPass;
        options.instrumentationTemplateFile = this.config.instrumentationTemplateFile;
        if (this.config.errorFormat == CommandLineConfig.ErrorFormatOption.JSON) {
            JsonErrorReportGenerator errorGenerator = new JsonErrorReportGenerator(this.getErrorPrintStream(), (SourceExcerptProvider)this.compiler);
            ((Compiler)this.compiler).setErrorManager(new SortingErrorManager(ImmutableSet.of(errorGenerator)));
        }
    }

    @GwtIncompatible(value="Unnecessary")
    protected final A getCompiler() {
        return this.compiler;
    }

    @GwtIncompatible(value="Unnecessary")
    public static List<SourceFile> getBuiltinExterns(CompilerOptions.Environment env) throws IOException {
        InputStream input = AbstractCommandLineRunner.class.getResourceAsStream("/externs.zip");
        if (input == null) {
            input = AbstractCommandLineRunner.class.getResourceAsStream("externs.zip");
        }
        Preconditions.checkNotNull(input);
        ZipInputStream zip = new ZipInputStream(input);
        String envPrefix = env.toString().toLowerCase() + "/";
        HashMap<String, SourceFile> mapFromExternsZip = new HashMap<String, SourceFile>();
        ZipEntry entry = null;
        while ((entry = zip.getNextEntry()) != null) {
            String filename = entry.getName();
            if (filename.contains("/")) {
                if (!filename.startsWith(envPrefix)) continue;
                filename = filename.substring(envPrefix.length());
            }
            BufferedInputStream entryStream = new BufferedInputStream(ByteStreams.limit(zip, entry.getSize()));
            mapFromExternsZip.put(filename, SourceFile.fromInputStream("externs.zip//" + filename, entryStream, StandardCharsets.UTF_8));
        }
        return DefaultExterns.prepareExterns(env, mapFromExternsZip);
    }

    @GwtIncompatible(value="Unnecessary")
    public final void run() {
        int result;
        try {
            result = this.doRun();
        }
        catch (FlagUsageException e) {
            this.err.println(e.getMessage());
            result = -1;
        }
        catch (Throwable t) {
            t.printStackTrace(this.err);
            result = -2;
        }
        this.exitCodeReceiver.apply(result);
    }

    @GwtIncompatible(value="Unnecessary")
    protected final PrintStream getErrorPrintStream() {
        return this.err;
    }

    @GwtIncompatible(value="Unnecessary")
    public List<JsonFileSpec> parseJsonFilesFromInputStream() throws IOException {
        ArrayList<JsonFileSpec> jsonFiles = new ArrayList<JsonFileSpec>();
        try (JsonReader reader = new JsonReader(new InputStreamReader(this.in, this.inputCharset));){
            reader.beginArray();
            while (reader.hasNext()) {
                JsonFileSpec jsonFile = (JsonFileSpec)this.gson.fromJson(reader, (Type)((Object)JsonFileSpec.class));
                jsonFiles.add(jsonFile);
            }
            reader.endArray();
        }
        return jsonFiles;
    }

    @GwtIncompatible(value="Unnecessary")
    protected List<SourceFile> createInputs(List<FlagEntry<JsSourceType>> files, boolean allowStdIn, List<JsModuleSpec> jsModuleSpecs) throws IOException {
        return this.createInputs(files, null, allowStdIn, jsModuleSpecs);
    }

    @GwtIncompatible(value="Unnecessary")
    protected List<SourceFile> createInputs(List<FlagEntry<JsSourceType>> files, List<JsonFileSpec> jsonFiles, List<JsModuleSpec> jsModuleSpecs) throws IOException {
        return this.createInputs(files, jsonFiles, false, jsModuleSpecs);
    }

    @GwtIncompatible(value="Unnecessary")
    protected List<SourceFile> createInputs(List<FlagEntry<JsSourceType>> files, List<JsonFileSpec> jsonFiles, boolean allowStdIn, List<JsModuleSpec> jsModuleSpecs) throws IOException {
        ArrayList<SourceFile> inputs = new ArrayList<SourceFile>(files.size());
        boolean usingStdin = false;
        int jsModuleIndex = 0;
        JsModuleSpec jsModuleSpec = Iterables.getFirst(jsModuleSpecs, null);
        int cumulatedInputFilesExpected = jsModuleSpec == null ? Integer.MAX_VALUE : jsModuleSpec.getNumInputs();
        for (int i = 0; i < files.size(); ++i) {
            FlagEntry<JsSourceType> file = files.get(i);
            String filename = ((FlagEntry)file).value;
            if (((FlagEntry)file).flag == JsSourceType.JS_ZIP) {
                if (!"-".equals(filename)) {
                    Object rootFilename;
                    List<SourceFile> newFiles = SourceFile.fromZipFile(filename, this.inputCharset);
                    if (this.rootRelativePathsMap.containsKey(filename)) {
                        rootFilename = this.rootRelativePathsMap.get(filename);
                        for (SourceFile zipEntry : newFiles) {
                            String zipEntryName = zipEntry.getName();
                            Preconditions.checkState(zipEntryName.contains(filename));
                            String zipmap = zipEntryName.replace(filename, (CharSequence)rootFilename);
                            this.rootRelativePathsMap.put(zipEntryName, zipmap);
                        }
                    }
                    inputs.addAll(newFiles);
                    if (jsModuleSpec != null) {
                        rootFilename = jsModuleSpec;
                        ((JsModuleSpec)rootFilename).numJsFiles = ((JsModuleSpec)rootFilename).numJsFiles + (newFiles.size() - 1);
                    }
                }
            } else if (!"-".equals(filename)) {
                StaticSourceFile.SourceKind kind = ((FlagEntry)file).flag == JsSourceType.WEAKDEP ? StaticSourceFile.SourceKind.WEAK : StaticSourceFile.SourceKind.STRONG;
                SourceFile newFile = SourceFile.fromFile(filename, this.inputCharset, kind);
                inputs.add(newFile);
            } else {
                if (!allowStdIn) {
                    throw new FlagUsageException("Can't specify stdin.");
                }
                if (usingStdin) {
                    throw new FlagUsageException("Can't specify stdin twice.");
                }
                if (!this.config.outputManifests.isEmpty()) {
                    throw new FlagUsageException("Manifest files cannot be generated when the input is from stdin.");
                }
                if (!this.config.outputBundles.isEmpty()) {
                    throw new FlagUsageException("Bundle files cannot be generated when the input is from stdin.");
                }
                this.err.println(WAITING_FOR_INPUT_WARNING);
                inputs.add(SourceFile.fromInputStream("stdin", this.in, this.inputCharset));
                usingStdin = true;
            }
            if (i < cumulatedInputFilesExpected - 1 || ++jsModuleIndex >= jsModuleSpecs.size()) continue;
            jsModuleSpec = jsModuleSpecs.get(jsModuleIndex);
            cumulatedInputFilesExpected += jsModuleSpec.getNumInputs();
        }
        if (jsonFiles != null) {
            for (JsonFileSpec jsonFile : jsonFiles) {
                inputs.add(SourceFile.fromCode(jsonFile.getPath(), jsonFile.getSrc()));
            }
        }
        for (JSError error : AbstractCommandLineRunner.removeDuplicateZipEntries(inputs, jsModuleSpecs)) {
            ((Compiler)this.compiler).report(error);
        }
        return inputs;
    }

    @GwtIncompatible(value="Unnecessary")
    public static ImmutableList<JSError> removeDuplicateZipEntries(List<SourceFile> sourceFiles, List<JsModuleSpec> jsModuleSpecs) throws IOException {
        ImmutableList.Builder errors = ImmutableList.builder();
        HashMap<String, SourceFile> sourceFilesByName = new HashMap<String, SourceFile>();
        Iterator<SourceFile> fileIterator = sourceFiles.iterator();
        int currentFileIndex = 0;
        Iterator<JsModuleSpec> moduleIterator = jsModuleSpecs.iterator();
        int cumulatedJsFileNum = 0;
        JsModuleSpec currentModule = null;
        while (fileIterator.hasNext()) {
            String fullPath;
            SourceFile sourceFile = fileIterator.next();
            if (moduleIterator.hasNext() && ++currentFileIndex > cumulatedJsFileNum) {
                currentModule = moduleIterator.next();
                cumulatedJsFileNum += currentModule.numJsFiles;
            }
            if (!(fullPath = sourceFile.getName()).contains("!/")) continue;
            String relativePath = fullPath.split("!")[1];
            if (!sourceFilesByName.containsKey(relativePath)) {
                sourceFilesByName.put(relativePath, sourceFile);
                continue;
            }
            SourceFile firstSourceFile = (SourceFile)sourceFilesByName.get(relativePath);
            if (firstSourceFile.getCode().equals(sourceFile.getCode())) {
                fileIterator.remove();
                if (currentModule == null) continue;
                currentModule.numJsFiles--;
                continue;
            }
            errors.add(JSError.make(CONFLICTING_DUPLICATE_ZIP_CONTENTS, firstSourceFile.getName(), sourceFile.getName()));
        }
        return errors.build();
    }

    @GwtIncompatible(value="Unnecessary")
    private List<SourceFile> createSourceInputs(List<JsModuleSpec> jsModuleSpecs, List<FlagEntry<JsSourceType>> files, List<JsonFileSpec> jsonFiles) throws IOException {
        if (this.isInTestMode()) {
            return this.inputsSupplierForTesting != null ? this.inputsSupplierForTesting.get() : null;
        }
        if (files.isEmpty() && jsonFiles == null) {
            files = Collections.singletonList(new FlagEntry<JsSourceType>(JsSourceType.JS, "-"));
        }
        try {
            if (jsonFiles != null) {
                return this.createInputs(files, jsonFiles, jsModuleSpecs);
            }
            return this.createInputs(files, true, jsModuleSpecs);
        }
        catch (FlagUsageException e) {
            throw new FlagUsageException("Bad --js flag. " + e.getMessage());
        }
    }

    @GwtIncompatible(value="Unnecessary")
    private List<SourceFile> createExternInputs(List<String> files) throws IOException {
        ArrayList<FlagEntry<JsSourceType>> externFiles = new ArrayList<FlagEntry<JsSourceType>>();
        for (String file : files) {
            externFiles.add(new FlagEntry<JsSourceType>(JsSourceType.EXTERN, file));
        }
        try {
            return this.createInputs(externFiles, false, new ArrayList<JsModuleSpec>());
        }
        catch (FlagUsageException e) {
            throw new FlagUsageException("Bad --externs flag. " + e.getMessage());
        }
    }

    public static List<JSModule> createJsModules(List<JsModuleSpec> specs, List<SourceFile> inputs) throws IOException {
        Preconditions.checkState(specs != null);
        Preconditions.checkState(!specs.isEmpty());
        Preconditions.checkState(inputs != null);
        ArrayList<String> moduleNames = new ArrayList<String>(specs.size());
        LinkedHashMap<String, JSModule> modulesByName = new LinkedHashMap<String, JSModule>();
        LinkedHashMap<String, Integer> modulesFileCountMap = new LinkedHashMap<String, Integer>();
        int numJsFilesExpected = 0;
        int minJsFilesRequired = 0;
        for (JsModuleSpec spec : specs) {
            if (modulesByName.containsKey(spec.name)) {
                throw new FlagUsageException("Duplicate module name: " + spec.name);
            }
            JSModule module = new JSModule(spec.name);
            for (String dep : spec.deps) {
                JSModule other = (JSModule)modulesByName.get(dep);
                if (other == null) {
                    throw new FlagUsageException("Module '" + spec.name + "' depends on unknown module '" + dep + "'. Be sure to list modules in dependency order.");
                }
                module.addDependency(other);
            }
            if (spec.numJsFiles < 0) {
                numJsFilesExpected = -1;
            } else {
                minJsFilesRequired += spec.numJsFiles;
            }
            if (numJsFilesExpected >= 0) {
                numJsFilesExpected += spec.numJsFiles;
            }
            moduleNames.add(0, spec.name);
            modulesFileCountMap.put(spec.name, spec.numJsFiles);
            modulesByName.put(spec.name, module);
        }
        int totalNumJsFiles = inputs.size();
        if (numJsFilesExpected >= 0 || minJsFilesRequired > totalNumJsFiles) {
            if (minJsFilesRequired > totalNumJsFiles) {
                numJsFilesExpected = minJsFilesRequired;
            }
            if (numJsFilesExpected > totalNumJsFiles) {
                throw new FlagUsageException("Not enough JS files specified. Expected " + numJsFilesExpected + " but found " + totalNumJsFiles);
            }
            if (numJsFilesExpected < totalNumJsFiles) {
                throw new FlagUsageException("Too many JS files specified. Expected " + numJsFilesExpected + " but found " + totalNumJsFiles);
            }
        }
        int numJsFilesLeft = totalNumJsFiles;
        int moduleIndex = 0;
        for (String moduleName : moduleNames) {
            int numJsFiles = (Integer)modulesFileCountMap.get(moduleName);
            JSModule module = (JSModule)modulesByName.get(moduleName);
            if (moduleIndex == moduleNames.size() - 1 && numJsFiles == -1) {
                numJsFiles = numJsFilesLeft;
            }
            List<SourceFile> moduleFiles = inputs.subList(numJsFilesLeft - numJsFiles, numJsFilesLeft);
            for (SourceFile input : moduleFiles) {
                module.add(input);
            }
            numJsFilesLeft -= numJsFiles;
            ++moduleIndex;
        }
        return new ArrayList<JSModule>(modulesByName.values());
    }

    @GwtIncompatible(value="Unnecessary")
    protected void checkModuleName(String name) {
        if (!TokenStream.isJSIdentifier(name)) {
            throw new FlagUsageException("Invalid module name: '" + name + "'");
        }
    }

    public static Map<String, String> parseModuleWrappers(List<String> specs, List<JSModule> chunks) {
        Preconditions.checkState(specs != null);
        HashMap<String, String> wrappers = Maps.newHashMapWithExpectedSize(chunks.size());
        for (JSModule c : chunks) {
            wrappers.put(c.getName(), "");
        }
        for (String spec : specs) {
            int pos = spec.indexOf(58);
            if (pos == -1) {
                throw new FlagUsageException("Expected module wrapper to have <name>:<wrapper> format: " + spec);
            }
            String name = spec.substring(0, pos);
            if (!wrappers.containsKey(name)) {
                throw new FlagUsageException("Unknown module: '" + name + "'");
            }
            String wrapper = spec.substring(pos + 1);
            if (!(wrapper = wrapper.replace(OUTPUT_MARKER, "%s").replace("%n%", "\n")).contains("%s")) {
                throw new FlagUsageException("No %s placeholder in module wrapper: '" + wrapper + "'");
            }
            wrappers.put(name, wrapper);
        }
        return wrappers;
    }

    @GwtIncompatible(value="Unnecessary")
    private String getModuleOutputFileName(JSModule m) {
        return this.config.moduleOutputPathPrefix + m.getName() + ".js";
    }

    @VisibleForTesting
    @GwtIncompatible(value="Unnecessary")
    void writeModuleOutput(Appendable out, JSModule m) throws IOException {
        if (this.parsedModuleWrappers == null) {
            this.parsedModuleWrappers = AbstractCommandLineRunner.parseModuleWrappers(this.config.moduleWrapper, ImmutableList.copyOf(((Compiler)this.compiler).getModuleGraph().getAllModules()));
        }
        String fileName = this.getModuleOutputFileName(m);
        String baseName = new File(fileName).getName();
        this.writeOutput(out, (Compiler)this.compiler, m, this.parsedModuleWrappers.get(m.getName()).replace("%basename%", baseName), "%s", null);
    }

    @GwtIncompatible(value="Unnecessary")
    void writeOutput(Appendable out, Compiler compiler, @Nullable JSModule module, String wrapper, String codePlaceholder, @Nullable Function<String, String> escaper) throws IOException {
        if (compiler.getOptions().outputJs == CompilerOptions.OutputJs.SENTINEL) {
            out.append("// No JS output because the compiler was run in checks-only mode.\n");
            return;
        }
        Preconditions.checkState(compiler.getOptions().outputJs == CompilerOptions.OutputJs.NORMAL);
        String code = module == null ? compiler.toSource() : compiler.toSource(module);
        this.writeOutput(out, compiler, code, wrapper, codePlaceholder, escaper);
    }

    @GwtIncompatible(value="Unnecessary")
    void writeOutput(Appendable out, Compiler compiler, String code, String wrapper, String codePlaceholder, @Nullable Function<String, String> escaper) throws IOException {
        int pos = wrapper.indexOf(codePlaceholder);
        if (pos != -1) {
            String prefix = "";
            if (pos > 0) {
                prefix = wrapper.substring(0, pos);
                out.append(prefix);
            }
            out.append(escaper == null ? code : (CharSequence)escaper.apply(code));
            int suffixStart = pos + codePlaceholder.length();
            if (suffixStart != wrapper.length()) {
                out.append(wrapper.substring(suffixStart));
            }
            out.append('\n');
            if (compiler != null && compiler.getSourceMap() != null) {
                compiler.getSourceMap().setWrapperPrefix(prefix);
            }
        } else {
            out.append(code);
            out.append('\n');
        }
    }

    @GwtIncompatible(value="Unnecessary")
    private static void maybeCreateDirsForPath(String pathPrefix) {
        if (!Strings.isNullOrEmpty(pathPrefix)) {
            String dirName;
            String string = dirName = pathPrefix.charAt(pathPrefix.length() - 1) == File.separatorChar ? pathPrefix.substring(0, pathPrefix.length() - 1) : new File(pathPrefix).getParent();
            if (dirName != null) {
                new File(dirName).mkdirs();
            }
        }
    }

    @GwtIncompatible(value="Unnecessary")
    private Appendable createDefaultOutput() throws IOException {
        boolean writeOutputToFile;
        boolean bl = writeOutputToFile = !this.config.jsOutputFile.isEmpty();
        if (writeOutputToFile) {
            return this.fileNameToLegacyOutputWriter(this.config.jsOutputFile);
        }
        return this.streamToLegacyOutputWriter(this.defaultJsOutput);
    }

    @GwtIncompatible(value="Unnecessary")
    private static void closeAppendable(Appendable output) throws IOException {
        if (output instanceof Flushable) {
            ((Flushable)((Object)output)).flush();
        }
        if (output instanceof Closeable) {
            ((Closeable)((Object)output)).close();
        }
    }

    @GwtIncompatible(value="Unnecessary")
    protected int doRun() throws IOException {
        Compiler.setLoggingLevel(Level.parse(this.config.loggingLevel));
        this.compiler = this.createCompiler();
        B options = this.createOptions();
        List<SourceFile> externs = this.createExterns((CompilerOptions)options);
        List<JSModule> modules = null;
        Result result = null;
        this.setRunOptions((CompilerOptions)options);
        this.rootRelativePathsMap = this.constructRootRelativePathsMap();
        boolean writeOutputToFile = !this.config.jsOutputFile.isEmpty();
        ArrayList<String> outputFileNames = new ArrayList<String>();
        if (writeOutputToFile) {
            outputFileNames.add(this.config.jsOutputFile);
        }
        boolean createCommonJsModules = false;
        if (((CompilerOptions)options).processCommonJSModules && this.config.module.size() == 1 && "auto".equals(this.config.module.get(0))) {
            createCommonJsModules = true;
            this.config.module.remove(0);
        }
        ArrayList<JsModuleSpec> jsModuleSpecs = new ArrayList<JsModuleSpec>();
        for (int i = 0; i < this.config.module.size(); ++i) {
            jsModuleSpecs.add(JsModuleSpec.create((String)this.config.module.get(i), i == 0));
        }
        List<JsonFileSpec> jsonFiles = null;
        if (this.config.jsonStreamMode == CompilerOptions.JsonStreamMode.IN || this.config.jsonStreamMode == CompilerOptions.JsonStreamMode.BOTH) {
            jsonFiles = this.parseJsonFilesFromInputStream();
            ImmutableMap.Builder<String, SourceMapInput> inputSourceMaps = new ImmutableMap.Builder<String, SourceMapInput>();
            Iterator inputPathByWebpackId = new ImmutableMap.Builder<String, String>();
            boolean foundJsonInputSourceMap = false;
            for (JsonFileSpec jsonFile : jsonFiles) {
                if (jsonFile.getSourceMap() != null && jsonFile.getSourceMap().length() > 0) {
                    String sourceMapPath = jsonFile.getPath() + ".map";
                    SourceFile sourceMap = SourceFile.fromCode(sourceMapPath, jsonFile.getSourceMap());
                    inputSourceMaps.put(jsonFile.getPath(), new SourceMapInput(sourceMap));
                    foundJsonInputSourceMap = true;
                }
                if (jsonFile.getWebpackId() == null) continue;
                ((ImmutableMap.Builder)((Object)inputPathByWebpackId)).put(jsonFile.getWebpackId(), jsonFile.getPath());
            }
            if (foundJsonInputSourceMap) {
                inputSourceMaps.putAll(((CompilerOptions)options).inputSourceMaps);
                ((CompilerOptions)options).inputSourceMaps = inputSourceMaps.build();
            }
            ((Compiler)this.compiler).initWebpackMap(((ImmutableMap.Builder)((Object)inputPathByWebpackId)).build());
        } else {
            ImmutableMap<String, String> emptyMap = ImmutableMap.of();
            ((Compiler)this.compiler).initWebpackMap(emptyMap);
        }
        ((Compiler)this.compiler).initWarningsGuard(((CompilerOptions)options).getWarningsGuard());
        List<SourceFile> inputs = this.createSourceInputs(jsModuleSpecs, this.config.mixedJsSources, jsonFiles);
        if (!jsModuleSpecs.isEmpty()) {
            if (this.isInTestMode()) {
                modules = this.modulesSupplierForTesting.get();
            } else {
                if (CompilerOptions.JsonStreamMode.IN.equals((Object)this.config.jsonStreamMode) || CompilerOptions.JsonStreamMode.NONE.equals((Object)this.config.jsonStreamMode)) {
                    for (JsModuleSpec m : jsModuleSpecs) {
                        this.checkModuleName(m.getName());
                    }
                }
                modules = AbstractCommandLineRunner.createJsModules(jsModuleSpecs, inputs);
            }
            for (JSModule m : modules) {
                outputFileNames.add(this.getModuleOutputFileName(m));
            }
            ((Compiler)this.compiler).initModules(externs, modules, (CompilerOptions)options);
        } else {
            ((Compiler)this.compiler).init(externs, inputs, (CompilerOptions)options);
        }
        if (((CompilerOptions)options).printConfig) {
            ((Compiler)this.compiler).printConfig(System.err);
        }
        String saveAfterChecksFilename = this.config.getSaveAfterChecksFileName();
        String continueSavedCompilationFilename = this.config.getContinueSavedCompilationFileName();
        if (this.config.skipNormalOutputs) {
            ((Compiler)this.compiler).orderInputsWithLargeStack();
        } else if (((Compiler)this.compiler).hasErrors()) {
            ((Compiler)this.compiler).generateReport();
            result = ((Compiler)this.compiler).getResult();
        } else if (((CompilerOptions)options).getInstrumentForCoverageOnly()) {
            result = this.instrumentForCoverage();
        } else if (saveAfterChecksFilename != null) {
            result = this.performStage1andSave(saveAfterChecksFilename);
        } else if (continueSavedCompilationFilename != null) {
            result = this.restoreAndPerformStage2(continueSavedCompilationFilename);
            if (modules != null) {
                modules = ImmutableList.copyOf(((Compiler)this.compiler).getModules());
            }
        } else {
            result = this.performFullCompilation();
        }
        if (createCommonJsModules) {
            modules = ImmutableList.copyOf(((Compiler)this.compiler).getModules());
            for (JSModule m : modules) {
                outputFileNames.add(this.getModuleOutputFileName(m));
            }
        }
        for (String outputFileName : outputFileNames) {
            if (((Compiler)this.compiler).getSourceFileByName(outputFileName) == null) continue;
            ((Compiler)this.compiler).report(JSError.make(OUTPUT_SAME_AS_INPUT_ERROR, outputFileName));
            return 1;
        }
        return this.processResults(result, modules, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GwtIncompatible(value="Unnecessary")
    private Result performStage1andSave(String filename) {
        try (BufferedOutputStream serializedOutputStream = new BufferedOutputStream(new FileOutputStream(filename));){
            ((Compiler)this.compiler).parseForCompilation();
            if (!((Compiler)this.compiler).hasErrors()) {
                ((Compiler)this.compiler).stage1Passes();
            }
            if (!((Compiler)this.compiler).hasErrors()) {
                ((Compiler)this.compiler).saveState(serializedOutputStream);
            }
            ((Compiler)this.compiler).performPostCompilationTasks();
        }
        catch (IOException e) {
            ((Compiler)this.compiler).report(JSError.make(COULD_NOT_SERIALIZE_AST, filename));
        }
        finally {
            ((Compiler)this.compiler).generateReport();
        }
        Result result = ((Compiler)this.compiler).getResult();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GwtIncompatible(value="Unnecessary")
    private Result restoreAndPerformStage2(String filename) {
        try (BufferedInputStream serializedInputStream = new BufferedInputStream(new FileInputStream(filename));){
            ((Compiler)this.compiler).restoreState(serializedInputStream);
            if (!((Compiler)this.compiler).hasErrors()) {
                ((Compiler)this.compiler).stage2Passes();
            }
            ((Compiler)this.compiler).performPostCompilationTasks();
        }
        catch (IOException | ClassNotFoundException e) {
            ((Compiler)this.compiler).report(JSError.make(COULD_NOT_DESERIALIZE_AST, filename));
        }
        finally {
            ((Compiler)this.compiler).generateReport();
        }
        Result result = ((Compiler)this.compiler).getResult();
        return result;
    }

    @GwtIncompatible(value="Unnecessary")
    private Result performFullCompilation() {
        try {
            ((Compiler)this.compiler).parseForCompilation();
            if (!((Compiler)this.compiler).hasErrors()) {
                ((Compiler)this.compiler).stage1Passes();
                if (!((Compiler)this.compiler).hasErrors()) {
                    ((Compiler)this.compiler).stage2Passes();
                }
                ((Compiler)this.compiler).performPostCompilationTasks();
            }
        }
        finally {
            ((Compiler)this.compiler).generateReport();
        }
        Result result = ((Compiler)this.compiler).getResult();
        return result;
    }

    @GwtIncompatible(value="Unnecessary")
    private Result instrumentForCoverage() {
        try {
            ((Compiler)this.compiler).parseForCompilation();
            if (!((Compiler)this.compiler).hasErrors()) {
                ((Compiler)this.compiler).instrumentForCoverage();
            }
        }
        finally {
            ((Compiler)this.compiler).generateReport();
        }
        Result result = ((Compiler)this.compiler).getResult();
        return result;
    }

    @GwtIncompatible(value="Unnecessary")
    int processResults(Result result, List<JSModule> modules, B options) throws IOException {
        if (this.config.printPassGraph) {
            if (((Compiler)this.compiler).getRoot() == null) {
                return 1;
            }
            Appendable jsOutput = this.createDefaultOutput();
            jsOutput.append(DotFormatter.toDot(((Compiler)this.compiler).getPassConfig().getPassGraph()));
            jsOutput.append('\n');
            AbstractCommandLineRunner.closeAppendable(jsOutput);
            return 0;
        }
        if (this.config.printAst) {
            if (((Compiler)this.compiler).getRoot() == null) {
                return 1;
            }
            Appendable jsOutput = this.createDefaultOutput();
            ControlFlowGraph<Node> cfg = ((Compiler)this.compiler).computeCFG();
            DotFormatter.appendDot(((Compiler)this.compiler).getRoot().getLastChild(), cfg, jsOutput);
            jsOutput.append('\n');
            AbstractCommandLineRunner.closeAppendable(jsOutput);
            return 0;
        }
        if (this.config.printTree) {
            if (((Compiler)this.compiler).getRoot() == null) {
                ((Compiler)this.compiler).report(JSError.make(NO_TREE_GENERATED_ERROR, new String[0]));
                return 1;
            }
            Appendable jsOutput = this.createDefaultOutput();
            ((Compiler)this.compiler).getRoot().appendStringTree(jsOutput);
            jsOutput.append("\n");
            AbstractCommandLineRunner.closeAppendable(jsOutput);
            return 0;
        }
        if (this.config.skipNormalOutputs) {
            this.outputManifest();
            this.outputBundle();
            this.outputModuleGraphJson();
            return 0;
        }
        if (((CompilerOptions)options).outputJs != CompilerOptions.OutputJs.NONE && result.success) {
            this.outputModuleGraphJson();
            if (modules == null) {
                this.outputSingleBinary(options);
                if (!this.isOutputInJson()) {
                    this.outputSourceMap(options, this.config.jsOutputFile);
                }
            } else {
                DiagnosticType error = this.outputModuleBinaryAndSourceMaps(modules, options);
                if (error != null) {
                    ((Compiler)this.compiler).report(JSError.make(error, new String[0]));
                    return 1;
                }
            }
            if (((CompilerOptions)options).externExportsPath != null) {
                try (Writer eeOut = this.openExternExportsStream(options, this.config.jsOutputFile);){
                    eeOut.append(result.externExport);
                }
            }
            this.outputNameMaps();
            this.outputStringMap();
            this.outputManifest();
            this.outputBundle();
            if (this.isOutputInJson()) {
                this.outputJsonStream();
            }
        }
        return Math.min(result.errors.length, 127);
    }

    @GwtIncompatible(value="Unnecessary")
    Function<String, String> getJavascriptEscaper() {
        return SourceCodeEscapers.javascriptEscaper().asFunction();
    }

    @GwtIncompatible(value="Unnecessary")
    void outputSingleBinary(B options) throws IOException {
        Function<String, String> escaper = null;
        String marker = OUTPUT_MARKER;
        if (this.config.outputWrapper.contains(OUTPUT_MARKER_JS_STRING)) {
            marker = OUTPUT_MARKER_JS_STRING;
            escaper = this.getJavascriptEscaper();
        }
        if (this.isOutputInJson()) {
            this.filesToStreamOut.add(this.createJsonFile(options, marker, escaper));
        } else {
            if (!this.config.jsOutputFile.isEmpty()) {
                AbstractCommandLineRunner.maybeCreateDirsForPath(this.config.jsOutputFile);
            }
            Appendable jsOutput = this.createDefaultOutput();
            this.writeOutput(jsOutput, (Compiler)this.compiler, (JSModule)null, this.config.outputWrapper, marker, escaper);
            AbstractCommandLineRunner.closeAppendable(jsOutput);
        }
    }

    @GwtIncompatible(value="Unnecessary")
    JsonFileSpec createJsonFile(B options, String outputMarker, Function<String, String> escaper) throws IOException {
        StringBuilder jsOutput = new StringBuilder();
        this.writeOutput((Appendable)jsOutput, (Compiler)this.compiler, (JSModule)null, this.config.outputWrapper, outputMarker, escaper);
        JsonFileSpec jsonOutput = new JsonFileSpec(((Object)jsOutput).toString(), Strings.isNullOrEmpty(this.config.jsOutputFile) ? "compiled.js" : this.config.jsOutputFile);
        if (!Strings.isNullOrEmpty(((CompilerOptions)options).sourceMapOutputPath)) {
            StringBuilder sourcemap = new StringBuilder();
            ((Compiler)this.compiler).getSourceMap().appendTo(sourcemap, jsonOutput.getPath());
            jsonOutput.setSourceMap(sourcemap.toString());
        }
        return jsonOutput;
    }

    @GwtIncompatible(value="Unnecessary")
    void outputJsonStream() throws IOException {
        try (JsonWriter jsonWriter = new JsonWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)this.defaultJsOutput, "UTF-8")));){
            jsonWriter.beginArray();
            for (JsonFileSpec jsonFile : this.filesToStreamOut) {
                jsonWriter.beginObject();
                jsonWriter.name("src").value(jsonFile.getSrc());
                jsonWriter.name("path").value(jsonFile.getPath());
                if (!Strings.isNullOrEmpty(jsonFile.getSourceMap())) {
                    jsonWriter.name("source_map").value(jsonFile.getSourceMap());
                }
                jsonWriter.endObject();
            }
            jsonWriter.endArray();
        }
    }

    @GwtIncompatible(value="Unnecessary")
    private DiagnosticType outputModuleBinaryAndSourceMaps(List<JSModule> modules, B options) throws IOException {
        this.parsedModuleWrappers = AbstractCommandLineRunner.parseModuleWrappers(this.config.moduleWrapper, modules);
        AbstractCommandLineRunner.maybeCreateDirsForPath(this.config.moduleOutputPathPrefix);
        Writer mapFileOut = null;
        if (!this.shouldGenerateMapPerModule(options) && ((CompilerOptions)options).sourceMapOutputPath != null && this.config.jsonStreamMode != CompilerOptions.JsonStreamMode.OUT && this.config.jsonStreamMode != CompilerOptions.JsonStreamMode.BOTH) {
            return INVALID_MODULE_SOURCEMAP_PATTERN;
        }
        for (JSModule m : modules) {
            if (this.isOutputInJson()) {
                this.filesToStreamOut.add(this.createJsonFileFromModule(m));
                continue;
            }
            if (this.shouldGenerateMapPerModule(options)) {
                mapFileOut = this.fileNameToOutputWriter2(this.expandSourceMapPath(options, m));
            }
            String moduleFilename = this.getModuleOutputFileName(m);
            try (Writer writer = this.fileNameToLegacyOutputWriter(moduleFilename);){
                if (((CompilerOptions)options).sourceMapOutputPath != null) {
                    ((Compiler)this.compiler).getSourceMap().reset();
                }
                this.writeModuleOutput(writer, m);
                if (((CompilerOptions)options).sourceMapOutputPath != null) {
                    ((Compiler)this.compiler).getSourceMap().appendTo(mapFileOut, moduleFilename);
                }
            }
            if (!this.shouldGenerateMapPerModule(options) || mapFileOut == null) continue;
            mapFileOut.close();
            mapFileOut = null;
        }
        if (mapFileOut != null) {
            mapFileOut.close();
        }
        return null;
    }

    @GwtIncompatible(value="Unnecessary")
    private JsonFileSpec createJsonFileFromModule(JSModule module) throws IOException {
        ((Compiler)this.compiler).getSourceMap().reset();
        StringBuilder output = new StringBuilder();
        this.writeModuleOutput(output, module);
        JsonFileSpec jsonFile = new JsonFileSpec(output.toString(), this.getModuleOutputFileName(module));
        StringBuilder moduleSourceMap = new StringBuilder();
        ((Compiler)this.compiler).getSourceMap().appendTo(moduleSourceMap, this.getModuleOutputFileName(module));
        jsonFile.setSourceMap(moduleSourceMap.toString());
        return jsonFile;
    }

    @GwtIncompatible(value="Unnecessary")
    private Charset getInputCharset() {
        if (!this.config.charset.isEmpty()) {
            if (!Charset.isSupported(this.config.charset)) {
                throw new FlagUsageException(this.config.charset + " is not a valid charset name.");
            }
            return Charset.forName(this.config.charset);
        }
        return StandardCharsets.UTF_8;
    }

    @GwtIncompatible(value="Unnecessary")
    private Charset getLegacyOutputCharset() {
        if (!this.config.charset.isEmpty()) {
            if (!Charset.isSupported(this.config.charset)) {
                throw new FlagUsageException(this.config.charset + " is not a valid charset name.");
            }
            return Charset.forName(this.config.charset);
        }
        return StandardCharsets.US_ASCII;
    }

    @GwtIncompatible(value="Unnecessary")
    private Charset getOutputCharset2() {
        if (!this.config.charset.isEmpty()) {
            if (!Charset.isSupported(this.config.charset)) {
                throw new FlagUsageException(this.config.charset + " is not a valid charset name.");
            }
            return Charset.forName(this.config.charset);
        }
        return StandardCharsets.UTF_8;
    }

    @GwtIncompatible(value="Unnecessary")
    protected List<SourceFile> createExterns(CompilerOptions options) throws IOException {
        return this.isInTestMode() ? this.externsSupplierForTesting.get() : this.createExternInputs(this.config.externs);
    }

    @GwtIncompatible(value="Unnecessary")
    private boolean shouldGenerateMapPerModule(B options) {
        return ((CompilerOptions)options).sourceMapOutputPath != null && ((CompilerOptions)options).sourceMapOutputPath.contains("%outname%");
    }

    @GwtIncompatible(value="Unnecessary")
    private Writer openExternExportsStream(B options, String path) throws IOException {
        if (((CompilerOptions)options).externExportsPath == null) {
            return null;
        }
        String exPath = ((CompilerOptions)options).externExportsPath;
        if (!exPath.contains(File.separator)) {
            File outputFile = new File(path);
            exPath = outputFile.getParent() + File.separatorChar + exPath;
        }
        return this.fileNameToOutputWriter2(exPath);
    }

    @GwtIncompatible(value="Unnecessary")
    private String expandCommandLinePath(String path, JSModule forModule) {
        String sub = forModule != null ? this.config.moduleOutputPathPrefix + forModule.getName() + ".js" : (!this.config.module.isEmpty() ? this.config.moduleOutputPathPrefix : this.config.jsOutputFile);
        return path.replace("%outname%", sub);
    }

    @VisibleForTesting
    @GwtIncompatible(value="Unnecessary")
    String expandSourceMapPath(B options, JSModule forModule) {
        if (Strings.isNullOrEmpty(((CompilerOptions)options).sourceMapOutputPath)) {
            return null;
        }
        return this.expandCommandLinePath(((CompilerOptions)options).sourceMapOutputPath, forModule);
    }

    @GwtIncompatible(value="Unnecessary")
    private Writer fileNameToLegacyOutputWriter(String fileName) throws IOException {
        if (fileName == null) {
            return null;
        }
        if (this.isInTestMode()) {
            return new StringWriter();
        }
        return this.streamToLegacyOutputWriter(this.filenameToOutputStream(fileName));
    }

    @GwtIncompatible(value="Unnecessary")
    private Writer fileNameToOutputWriter2(String fileName) throws IOException {
        if (fileName == null) {
            return null;
        }
        if (this.isInTestMode()) {
            return new StringWriter();
        }
        return this.streamToOutputWriter2(this.filenameToOutputStream(fileName));
    }

    @GwtIncompatible(value="Unnecessary")
    protected OutputStream filenameToOutputStream(String fileName) throws IOException {
        if (fileName == null) {
            return null;
        }
        return new FileOutputStream(fileName);
    }

    @GwtIncompatible(value="Unnecessary")
    private Writer streamToLegacyOutputWriter(OutputStream stream) throws IOException {
        if (this.legacyOutputCharset == null) {
            return new BufferedWriter(new OutputStreamWriter(stream, StandardCharsets.UTF_8));
        }
        return new BufferedWriter(new OutputStreamWriter(stream, this.legacyOutputCharset));
    }

    @GwtIncompatible(value="Unnecessary")
    private Writer streamToOutputWriter2(OutputStream stream) {
        if (this.outputCharset2 == null) {
            return new BufferedWriter(new OutputStreamWriter(stream, StandardCharsets.UTF_8));
        }
        return new BufferedWriter(new OutputStreamWriter(stream, this.outputCharset2));
    }

    @GwtIncompatible(value="Unnecessary")
    private void outputSourceMap(B options, String associatedName) throws IOException {
        if (Strings.isNullOrEmpty(((CompilerOptions)options).sourceMapOutputPath) || ((CompilerOptions)options).sourceMapOutputPath.equals("/dev/null")) {
            return;
        }
        String outName = this.expandSourceMapPath(options, null);
        AbstractCommandLineRunner.maybeCreateDirsForPath(outName);
        try (Writer out = this.fileNameToOutputWriter2(outName);){
            ((Compiler)this.compiler).getSourceMap().appendTo(out, associatedName);
        }
    }

    @GwtIncompatible(value="Unnecessary")
    private String getMapPath(String outputFile) {
        String basePath = "";
        if (outputFile.isEmpty()) {
            basePath = !this.config.moduleOutputPathPrefix.isEmpty() ? this.config.moduleOutputPathPrefix : "jscompiler";
        } else {
            String fileParent;
            File file = new File(outputFile);
            String outputFileName = file.getName();
            if (outputFileName.endsWith(".js")) {
                outputFileName = outputFileName.substring(0, outputFileName.length() - 3);
            }
            basePath = (fileParent = file.getParent()) == null ? outputFileName : file.getParent() + File.separatorChar + outputFileName;
        }
        return basePath;
    }

    @GwtIncompatible(value="Unnecessary")
    private void outputNameMaps() throws IOException {
        String propertyMapOutputPath = null;
        String variableMapOutputPath = null;
        String functionInformationMapOutputPath = null;
        if (this.config.createNameMapFiles) {
            String basePath = this.getMapPath(this.config.jsOutputFile);
            propertyMapOutputPath = basePath + "_props_map.out";
            variableMapOutputPath = basePath + "_vars_map.out";
            functionInformationMapOutputPath = basePath + "_functions_map.out";
        }
        if (!this.config.variableMapOutputFile.isEmpty()) {
            if (variableMapOutputPath != null) {
                throw new FlagUsageException("The flags variable_map_output_file and create_name_map_files cannot both be used simultaneously.");
            }
            variableMapOutputPath = this.config.variableMapOutputFile;
        }
        if (!this.config.propertyMapOutputFile.isEmpty()) {
            if (propertyMapOutputPath != null) {
                throw new FlagUsageException("The flags property_map_output_file and create_name_map_files cannot both be used simultaneously.");
            }
            propertyMapOutputPath = this.config.propertyMapOutputFile;
        }
        if (variableMapOutputPath != null && ((Compiler)this.compiler).getVariableMap() != null) {
            ((Compiler)this.compiler).getVariableMap().save(variableMapOutputPath);
        }
        if (propertyMapOutputPath != null && ((Compiler)this.compiler).getPropertyMap() != null) {
            ((Compiler)this.compiler).getPropertyMap().save(propertyMapOutputPath);
        }
        if (functionInformationMapOutputPath != null && ((Compiler)this.compiler).getFunctionalInformationMap() != null) {
            try (OutputStream file = this.filenameToOutputStream(functionInformationMapOutputPath);){
                CodedOutputStream outputStream = CodedOutputStream.newInstance(file);
                ((Compiler)this.compiler).getFunctionalInformationMap().writeTo(outputStream);
                outputStream.flush();
            }
        }
    }

    @GwtIncompatible(value="Unnecessary")
    private void outputStringMap() throws IOException {
        if (!this.config.stringMapOutputPath.isEmpty()) {
            if (((Compiler)this.compiler).getStringMap() == null) {
                if (!new File(this.config.stringMapOutputPath).createNewFile()) {
                    throw new IOException("Could not create file: " + this.config.stringMapOutputPath);
                }
            } else {
                ((Compiler)this.compiler).getStringMap().save(this.config.stringMapOutputPath);
            }
        }
    }

    @VisibleForTesting
    public static void createDefineOrTweakReplacements(List<String> definitions, CompilerOptions options, boolean tweaks) {
        for (String override : definitions) {
            block13: {
                String[] assignment = override.split("=", 2);
                String defName = assignment[0];
                if (defName.length() > 0) {
                    String defValue = assignment.length == 1 ? "true" : assignment[1];
                    boolean isTrue = defValue.equals("true");
                    boolean isFalse = defValue.equals("false");
                    if (isTrue || isFalse) {
                        if (tweaks) {
                            options.setTweakToBooleanLiteral(defName, isTrue);
                            continue;
                        }
                        options.setDefineToBooleanLiteral(defName, isTrue);
                        continue;
                    }
                    if (defValue.length() > 1 && (defValue.charAt(0) == '\'' && defValue.charAt(defValue.length() - 1) == '\'' || defValue.charAt(0) == '\"' && defValue.charAt(defValue.length() - 1) == '\"')) {
                        String maybeStringVal = defValue.substring(1, defValue.length() - 1);
                        if (maybeStringVal.indexOf(defValue.charAt(0)) == -1) {
                            if (tweaks) {
                                options.setTweakToStringLiteral(defName, maybeStringVal);
                                continue;
                            }
                            options.setDefineToStringLiteral(defName, maybeStringVal);
                            continue;
                        }
                    } else {
                        try {
                            double value = Double.parseDouble(defValue);
                            if (tweaks) {
                                options.setTweakToDoubleLiteral(defName, value);
                                continue;
                            }
                            options.setDefineToDoubleLiteral(defName, value);
                        }
                        catch (NumberFormatException numberFormatException) {
                            if (defValue.length() <= 0) break block13;
                            if (tweaks) {
                                options.setTweakToStringLiteral(defName, defValue);
                                continue;
                            }
                            options.setDefineToStringLiteral(defName, defValue);
                        }
                        continue;
                    }
                }
            }
            if (tweaks) {
                throw new RuntimeException("--tweak flag syntax invalid: " + override);
            }
            throw new RuntimeException("--define flag syntax invalid: " + override);
        }
    }

    @GwtIncompatible(value="Unnecessary")
    private boolean shouldGenerateOutputPerModule(String output) {
        return !this.config.module.isEmpty() && output != null && output.contains("%outname%");
    }

    @GwtIncompatible(value="Unnecessary")
    private void outputManifest() throws IOException {
        this.outputManifestOrBundle(this.config.outputManifests, true);
    }

    @GwtIncompatible(value="Unnecessary")
    private void outputBundle() throws IOException {
        this.outputManifestOrBundle(this.config.outputBundles, false);
    }

    @GwtIncompatible(value="Unnecessary")
    private void outputManifestOrBundle(List<String> outputFiles, boolean isManifest) throws IOException {
        if (outputFiles.isEmpty()) {
            return;
        }
        for (String output : outputFiles) {
            if (output.isEmpty()) continue;
            if (this.shouldGenerateOutputPerModule(output)) {
                Iterable<JSModule> modules = ((Compiler)this.compiler).getModuleGraph().getAllModules();
                for (JSModule module : modules) {
                    Writer out = this.fileNameToOutputWriter2(this.expandCommandLinePath(output, module));
                    Throwable throwable = null;
                    try {
                        if (isManifest) {
                            this.printManifestTo(module.getInputs(), out);
                            continue;
                        }
                        this.printBundleTo(module.getInputs(), out);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (out == null) continue;
                        if (throwable != null) {
                            try {
                                out.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        out.close();
                    }
                }
                continue;
            }
            Writer out = this.fileNameToOutputWriter2(this.expandCommandLinePath(output, null));
            Object object = null;
            try {
                if (this.config.module.isEmpty()) {
                    if (isManifest) {
                        this.printManifestTo(((Compiler)this.compiler).getInputsInOrder(), out);
                        continue;
                    }
                    this.printBundleTo(((Compiler)this.compiler).getInputsInOrder(), out);
                    continue;
                }
                this.printModuleGraphManifestOrBundleTo(((Compiler)this.compiler).getModuleGraph(), out, isManifest);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (out == null) continue;
                if (object != null) {
                    try {
                        out.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                    continue;
                }
                out.close();
            }
        }
    }

    @GwtIncompatible(value="Unnecessary")
    private void outputModuleGraphJson() throws IOException {
        if (this.config.outputModuleDependencies != null && this.config.outputModuleDependencies.length() != 0) {
            try (Writer out = this.fileNameToOutputWriter2(this.config.outputModuleDependencies);){
                this.printModuleGraphJsonTo(out);
            }
        }
    }

    @VisibleForTesting
    @GwtIncompatible(value="Unnecessary")
    void printModuleGraphJsonTo(Appendable out) throws IOException {
        out.append(((Compiler)this.compiler).getModuleGraph().toJson().toString());
    }

    @VisibleForTesting
    @GwtIncompatible(value="Unnecessary")
    void printModuleGraphManifestOrBundleTo(JSModuleGraph graph, Appendable out, boolean isManifest) throws IOException {
        Joiner commas = Joiner.on(",");
        boolean requiresNewline = false;
        for (JSModule module : graph.getAllModules()) {
            if (requiresNewline) {
                out.append("\n");
            }
            if (isManifest) {
                String dependencies = commas.join(module.getSortedDependencyNames());
                out.append(String.format("{%s%s}\n", module.getName(), dependencies.isEmpty() ? "" : ":" + dependencies));
                this.printManifestTo(module.getInputs(), out);
            } else {
                this.printBundleTo(module.getInputs(), out);
            }
            requiresNewline = true;
        }
    }

    @VisibleForTesting
    @GwtIncompatible(value="Unnecessary")
    void printManifestTo(Iterable<CompilerInput> inputs, Appendable out) throws IOException {
        for (CompilerInput input : inputs) {
            String rootRelativePath = this.rootRelativePathsMap.get(input.getName());
            String displayName = rootRelativePath != null ? rootRelativePath : input.getName();
            out.append(displayName);
            out.append("\n");
        }
    }

    @VisibleForTesting
    @GwtIncompatible(value="Unnecessary")
    void printBundleTo(Iterable<CompilerInput> inputs, Appendable out) throws IOException {
        if (!((Compiler)this.compiler).getOptions().preventLibraryInjection) {
            for (CompilerInput input : inputs) {
                if (!"es6".equals(input.getLoadFlags().get("module"))) continue;
                this.appendRuntimeTo(out);
                break;
            }
        }
        for (CompilerInput input : inputs) {
            String name = input.getName();
            String code = input.getSourceFile().getCode();
            if (Compiler.isFillFileName(name) && code.isEmpty()) continue;
            String rootRelativePath = this.rootRelativePathsMap.get(name);
            String displayName = rootRelativePath != null ? rootRelativePath : input.getName();
            out.append("//");
            out.append(displayName);
            out.append("\n");
            this.prepForBundleAndAppendTo(out, input, code);
            out.append("\n");
        }
    }

    @GwtIncompatible(value="Unnecessary")
    private Map<String, String> constructRootRelativePathsMap() {
        LinkedHashMap<String, String> rootRelativePathsMap = new LinkedHashMap<String, String>();
        for (String mapString : this.config.manifestMaps) {
            int colonIndex = mapString.indexOf(58);
            Preconditions.checkState(colonIndex > 0);
            String execPath = mapString.substring(0, colonIndex);
            String rootRelativePath = mapString.substring(colonIndex + 1);
            Preconditions.checkState(rootRelativePath.indexOf(58) == -1);
            rootRelativePathsMap.put(execPath, rootRelativePath);
        }
        return rootRelativePathsMap;
    }

    @GwtIncompatible(value="Unnecessary")
    static final class SystemExitCodeReceiver
    implements Function<Integer, Void> {
        static final SystemExitCodeReceiver INSTANCE = new SystemExitCodeReceiver();

        private SystemExitCodeReceiver() {
        }

        @Override
        public Void apply(Integer exitCode) {
            int exitCodeValue = Preconditions.checkNotNull(exitCode);
            int exitCodeByte = exitCodeValue;
            if (exitCodeByte == 0 && exitCodeValue != 0) {
                exitCodeByte = -1;
            }
            System.exit(exitCodeByte);
            return null;
        }
    }

    public static class JsModuleSpec {
        private final String name;
        private final int numInputs;
        private final ImmutableList<String> deps;
        private int numJsFiles;

        private JsModuleSpec(String name, int numInputs, ImmutableList<String> deps) {
            this.name = name;
            this.numInputs = numInputs;
            this.deps = deps;
            this.numJsFiles = numInputs;
        }

        public static JsModuleSpec create(String specString, boolean isFirstModule) {
            String[] parts = specString.split(":");
            if (parts.length < 2 || parts.length > 4) {
                throw new FlagUsageException("Expected 2-4 colon-delimited parts in js module spec: " + specString);
            }
            String name = parts[0];
            String[] deps = parts.length > 2 && parts[2].length() > 0 ? parts[2].split(",") : new String[]{};
            int numInputs = -1;
            try {
                numInputs = Integer.parseInt(parts[1]);
            }
            catch (NumberFormatException ignored) {
                numInputs = -1;
            }
            if (numInputs < 0) {
                if (parts.length == 2 && "auto".equals(parts[1])) {
                    if (!isFirstModule) {
                        throw new FlagUsageException("Invalid JS file count '" + parts[1] + "' for module: " + name + ". Only the first module may specify a size of 'auto' and it must have no dependencies.");
                    }
                } else {
                    throw new FlagUsageException("Invalid JS file count '" + parts[1] + "' for module: " + name);
                }
            }
            return new JsModuleSpec(name, numInputs, ImmutableList.copyOf(deps));
        }

        public String getName() {
            return this.name;
        }

        public int getNumInputs() {
            return this.numInputs;
        }

        public ImmutableList<String> getDeps() {
            return this.deps;
        }

        public int getNumJsFiles() {
            return this.numJsFiles;
        }
    }

    @GwtIncompatible(value="Unnecessary")
    protected static class FlagEntry<T> {
        private final T flag;
        private final String value;

        protected FlagEntry(T flag, String value) {
            this.flag = flag;
            this.value = value;
        }

        public boolean equals(Object o) {
            if (o instanceof FlagEntry) {
                FlagEntry that = (FlagEntry)o;
                return that.flag.equals(this.flag) && that.value.equals(this.value);
            }
            return false;
        }

        public int hashCode() {
            return this.flag.hashCode() + this.value.hashCode();
        }

        public T getFlag() {
            return this.flag;
        }

        public String getValue() {
            return this.value;
        }
    }

    @GwtIncompatible(value="Unnecessary")
    protected static enum JsSourceType {
        EXTERN("extern"),
        JS("js"),
        JS_ZIP("jszip"),
        WEAKDEP("weakdep");

        @VisibleForTesting
        final String flagName;

        private JsSourceType(String flagName) {
            this.flagName = flagName;
        }
    }

    @GwtIncompatible(value="Unnecessary")
    public static class JsonFileSpec {
        private final String src;
        private final String path;
        private String sourceMap;
        @Nullable
        private final String webpackId;

        public JsonFileSpec(String src, String path) {
            this(src, path, null, null);
        }

        public JsonFileSpec(String src, String path, String sourceMap) {
            this(src, path, sourceMap, null);
        }

        public JsonFileSpec(String src, String path, String sourceMap, @Nullable String webpackId) {
            this.src = src;
            this.path = path;
            this.sourceMap = sourceMap;
            this.webpackId = webpackId;
        }

        public String getSrc() {
            return this.src;
        }

        public String getPath() {
            return this.path;
        }

        public String getSourceMap() {
            return this.sourceMap;
        }

        public String getWebpackId() {
            return this.webpackId;
        }

        public void setSourceMap(String map) {
            this.sourceMap = map;
        }
    }

    @GwtIncompatible(value="Unnecessary")
    protected static class CommandLineConfig {
        private boolean printTree = false;
        private boolean printAst = false;
        private boolean printPassGraph = false;
        private CompilerOptions.DevMode jscompDevMode = CompilerOptions.DevMode.OFF;
        private String loggingLevel = Level.WARNING.getName();
        private final List<String> externs = new ArrayList<String>();
        private final List<FlagEntry<JsSourceType>> mixedJsSources = new ArrayList<FlagEntry<JsSourceType>>();
        private String jsOutputFile = "";
        private String continueSavedCompilationFileName = null;
        private String saveAfterChecksFileName = null;
        private final List<String> module = new ArrayList<String>();
        private Map<String, String> sourceMapInputFiles = new HashMap<String, String>();
        private boolean parseInlineSourceMaps = false;
        private String variableMapInputFile = "";
        private String propertyMapInputFile = "";
        private String variableMapOutputFile = "";
        private boolean createNameMapFiles = false;
        private String propertyMapOutputFile = "";
        private String stringMapOutputPath = "";
        private CodingConvention codingConvention = CodingConventions.getDefault();
        private int summaryDetailLevel = 1;
        private String outputWrapper = "";
        private final List<String> moduleWrapper = new ArrayList<String>();
        private String moduleOutputPathPrefix = "";
        private String createSourceMap = "";
        private SourceMap.DetailLevel sourceMapDetailLevel = SourceMap.DetailLevel.ALL;
        private SourceMap.Format sourceMapFormat = SourceMap.Format.DEFAULT;
        private ImmutableList<SourceMap.LocationMapping> sourceMapLocationMappings = ImmutableList.of();
        private boolean applyInputSourceMaps = false;
        private final ArrayList<FlagEntry<CheckLevel>> warningGuards = new ArrayList();
        private final List<String> define = new ArrayList<String>();
        private final List<String> tweak = new ArrayList<String>();
        private CompilerOptions.TweakProcessing tweakProcessing = CompilerOptions.TweakProcessing.OFF;
        private String charset = "";
        private CompilerOptions.DependencyMode dependencyMode = CompilerOptions.DependencyMode.NONE;
        private List<ModuleIdentifier> entryPoints = ImmutableList.of();
        private List<String> outputManifests = ImmutableList.of();
        private String outputModuleDependencies = null;
        private List<String> outputBundles = ImmutableList.of();
        private boolean skipNormalOutputs = false;
        private List<String> manifestMaps = ImmutableList.of();
        private boolean transformAMDToCJSModules = false;
        private boolean processCommonJSModules = false;
        private List<String> moduleRoots = ImmutableList.of("./");
        private String warningsWhitelistFile = "";
        private List<String> hideWarningsFor = ImmutableList.of();
        private boolean angularPass = false;
        private String instrumentationTemplateFile = "";
        private CompilerOptions.JsonStreamMode jsonStreamMode = CompilerOptions.JsonStreamMode.NONE;
        private ErrorFormatOption errorFormat = ErrorFormatOption.STANDARD;

        protected CommandLineConfig() {
        }

        CommandLineConfig setPrintTree(boolean printTree) {
            this.printTree = printTree;
            return this;
        }

        public CommandLineConfig setPrintAst(boolean printAst) {
            this.printAst = printAst;
            return this;
        }

        public CommandLineConfig setPrintPassGraph(boolean printPassGraph) {
            this.printPassGraph = printPassGraph;
            return this;
        }

        public CommandLineConfig setJscompDevMode(CompilerOptions.DevMode jscompDevMode) {
            this.jscompDevMode = jscompDevMode;
            return this;
        }

        public CommandLineConfig setLoggingLevel(String loggingLevel) {
            this.loggingLevel = loggingLevel;
            return this;
        }

        public CommandLineConfig setExterns(List<String> externs) {
            this.externs.clear();
            this.externs.addAll(externs);
            return this;
        }

        public CommandLineConfig setMixedJsSources(List<FlagEntry<JsSourceType>> mixedJsSources) {
            this.mixedJsSources.clear();
            this.mixedJsSources.addAll(mixedJsSources);
            return this;
        }

        public CommandLineConfig setJsOutputFile(String jsOutputFile) {
            this.jsOutputFile = jsOutputFile;
            return this;
        }

        public CommandLineConfig setContinueSavedCompilationFileName(String fileName) {
            this.continueSavedCompilationFileName = fileName;
            return this;
        }

        String getContinueSavedCompilationFileName() {
            return this.continueSavedCompilationFileName;
        }

        public CommandLineConfig setSaveAfterChecksFileName(String fileName) {
            this.saveAfterChecksFileName = fileName;
            return this;
        }

        public String getSaveAfterChecksFileName() {
            return this.saveAfterChecksFileName;
        }

        public CommandLineConfig setModule(List<String> module) {
            this.module.clear();
            this.module.addAll(module);
            return this;
        }

        public CommandLineConfig setSourceMapInputFiles(Map<String, String> sourceMapInputFiles) {
            this.sourceMapInputFiles = sourceMapInputFiles;
            return this;
        }

        public CommandLineConfig setParseInlineSourceMaps(boolean parseInlineSourceMaps) {
            this.parseInlineSourceMaps = parseInlineSourceMaps;
            return this;
        }

        public CommandLineConfig setVariableMapInputFile(String variableMapInputFile) {
            this.variableMapInputFile = variableMapInputFile;
            return this;
        }

        public CommandLineConfig setPropertyMapInputFile(String propertyMapInputFile) {
            this.propertyMapInputFile = propertyMapInputFile;
            return this;
        }

        public CommandLineConfig setVariableMapOutputFile(String variableMapOutputFile) {
            this.variableMapOutputFile = variableMapOutputFile;
            return this;
        }

        public CommandLineConfig setCreateNameMapFiles(boolean createNameMapFiles) {
            this.createNameMapFiles = createNameMapFiles;
            return this;
        }

        public CommandLineConfig setPropertyMapOutputFile(String propertyMapOutputFile) {
            this.propertyMapOutputFile = propertyMapOutputFile;
            return this;
        }

        public CommandLineConfig setStringMapOutputFile(String stringMapOutputPath) {
            this.stringMapOutputPath = stringMapOutputPath;
            return this;
        }

        public CommandLineConfig setCodingConvention(CodingConvention codingConvention) {
            this.codingConvention = codingConvention;
            return this;
        }

        public CommandLineConfig setSummaryDetailLevel(int summaryDetailLevel) {
            this.summaryDetailLevel = summaryDetailLevel;
            return this;
        }

        public CommandLineConfig setOutputWrapper(String outputWrapper) {
            this.outputWrapper = outputWrapper;
            return this;
        }

        public CommandLineConfig setModuleWrapper(List<String> moduleWrapper) {
            this.moduleWrapper.clear();
            this.moduleWrapper.addAll(moduleWrapper);
            return this;
        }

        public CommandLineConfig setModuleOutputPathPrefix(String moduleOutputPathPrefix) {
            this.moduleOutputPathPrefix = moduleOutputPathPrefix;
            return this;
        }

        public CommandLineConfig setCreateSourceMap(String createSourceMap) {
            this.createSourceMap = createSourceMap;
            return this;
        }

        public CommandLineConfig setSourceMapDetailLevel(SourceMap.DetailLevel level) {
            this.sourceMapDetailLevel = level;
            return this;
        }

        public CommandLineConfig setSourceMapFormat(SourceMap.Format format) {
            this.sourceMapFormat = format;
            return this;
        }

        public CommandLineConfig setSourceMapLocationMappings(List<SourceMap.LocationMapping> locationMappings) {
            this.sourceMapLocationMappings = ImmutableList.copyOf(locationMappings);
            return this;
        }

        public CommandLineConfig setApplyInputSourceMaps(boolean applyInputSourceMaps) {
            this.applyInputSourceMaps = applyInputSourceMaps;
            return this;
        }

        public CommandLineConfig setWarningGuards(List<FlagEntry<CheckLevel>> warningGuards) {
            this.warningGuards.clear();
            this.warningGuards.addAll(warningGuards);
            return this;
        }

        public CommandLineConfig setDefine(List<String> define) {
            this.define.clear();
            this.define.addAll(define);
            return this;
        }

        public CommandLineConfig setTweak(List<String> tweak) {
            this.tweak.clear();
            this.tweak.addAll(tweak);
            return this;
        }

        public CommandLineConfig setTweakProcessing(CompilerOptions.TweakProcessing tweakProcessing) {
            this.tweakProcessing = tweakProcessing;
            return this;
        }

        public CommandLineConfig setCharset(String charset) {
            this.charset = charset;
            return this;
        }

        public CommandLineConfig setDependencyMode(CompilerOptions.DependencyMode newVal) {
            this.dependencyMode = newVal;
            return this;
        }

        public CommandLineConfig setEntryPoints(List<ModuleIdentifier> entryPoints) {
            Preconditions.checkNotNull(entryPoints);
            this.entryPoints = entryPoints;
            return this;
        }

        static CompilerOptions.DependencyMode depModeFromClosureDepOptions(boolean onlyClosureDependencies, boolean manageClosureDependencies) {
            if (onlyClosureDependencies) {
                return CompilerOptions.DependencyMode.STRICT;
            }
            if (manageClosureDependencies) {
                return CompilerOptions.DependencyMode.LOOSE;
            }
            return CompilerOptions.DependencyMode.NONE;
        }

        static List<ModuleIdentifier> moduleIdentifiersForEntryPoints(List<String> entryPoints) {
            ArrayList<ModuleIdentifier> mids = new ArrayList<ModuleIdentifier>();
            for (String entryPoint : entryPoints) {
                if (entryPoint.startsWith("goog:")) {
                    mids.add(ModuleIdentifier.forClosure(entryPoint));
                    continue;
                }
                mids.add(ModuleIdentifier.forFile(entryPoint));
            }
            return mids;
        }

        public CommandLineConfig setOutputManifest(List<String> outputManifests) {
            this.outputManifests = new ArrayList<String>();
            for (String manifestName : outputManifests) {
                if (manifestName.isEmpty()) continue;
                this.outputManifests.add(manifestName);
            }
            this.outputManifests = ImmutableList.copyOf(this.outputManifests);
            return this;
        }

        public CommandLineConfig setOutputModuleDependencies(String outputModuleDependencies) {
            this.outputModuleDependencies = outputModuleDependencies;
            return this;
        }

        public CommandLineConfig setOutputBundle(List<String> outputBundles) {
            this.outputBundles = outputBundles;
            return this;
        }

        public CommandLineConfig setSkipNormalOutputs(boolean skipNormalOutputs) {
            this.skipNormalOutputs = skipNormalOutputs;
            return this;
        }

        public CommandLineConfig setManifestMaps(List<String> manifestMaps) {
            this.manifestMaps = manifestMaps;
            return this;
        }

        public CommandLineConfig setTransformAMDToCJSModules(boolean transformAMDToCJSModules) {
            this.transformAMDToCJSModules = transformAMDToCJSModules;
            return this;
        }

        public CommandLineConfig setProcessCommonJSModules(boolean processCommonJSModules) {
            this.processCommonJSModules = processCommonJSModules;
            return this;
        }

        public CommandLineConfig setModuleRoots(List<String> jsModuleRoots) {
            this.moduleRoots = jsModuleRoots;
            return this;
        }

        public CommandLineConfig setWarningsWhitelistFile(String fileName) {
            this.warningsWhitelistFile = fileName;
            return this;
        }

        public CommandLineConfig setHideWarningsFor(List<String> hideWarningsFor) {
            this.hideWarningsFor = hideWarningsFor;
            return this;
        }

        public CommandLineConfig setAngularPass(boolean angularPass) {
            this.angularPass = angularPass;
            return this;
        }

        public CommandLineConfig setInstrumentationTemplateFile(String fileName) {
            this.instrumentationTemplateFile = fileName;
            return this;
        }

        public CommandLineConfig setJsonStreamMode(CompilerOptions.JsonStreamMode mode) {
            this.jsonStreamMode = mode;
            return this;
        }

        public CommandLineConfig setErrorFormat(ErrorFormatOption errorFormat) {
            this.errorFormat = errorFormat;
            return this;
        }

        protected static enum ErrorFormatOption {
            STANDARD,
            JSON;

        }
    }

    public static class FlagUsageException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public FlagUsageException(String message) {
            super(message);
        }
    }
}

