/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.GlobalNamespace;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.PolymerClassDefinition;
import com.google.javascript.jscomp.PolymerPass;
import com.google.javascript.jscomp.PolymerPassErrors;
import com.google.javascript.jscomp.PolymerPassStaticUtils;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import java.util.List;

final class PolymerBehaviorExtractor {
    private static final ImmutableSet<String> BEHAVIOR_NAMES_NOT_TO_COPY = ImmutableSet.of("created", "attached", "detached", "attributeChanged", "configure", "ready", new String[]{"properties", "listeners", "observers", "hostAttributes"});
    private final AbstractCompiler compiler;
    private final GlobalNamespace globalNames;

    PolymerBehaviorExtractor(AbstractCompiler compiler, GlobalNamespace globalNames) {
        this.compiler = compiler;
        this.globalNames = globalNames;
    }

    ImmutableList<BehaviorDefinition> extractBehaviors(Node behaviorArray) {
        if (behaviorArray == null) {
            return ImmutableList.of();
        }
        if (!behaviorArray.isArrayLit()) {
            this.compiler.report(JSError.make(behaviorArray, PolymerPassErrors.POLYMER_INVALID_BEHAVIOR_ARRAY, new String[0]));
            return ImmutableList.of();
        }
        ImmutableList.Builder behaviors = ImmutableList.builder();
        for (Node behaviorName : behaviorArray.children()) {
            Node behaviorValue;
            if (behaviorName.isObjectLit()) {
                PolymerPassStaticUtils.switchDollarSignPropsToBrackets(behaviorName, this.compiler);
                PolymerPassStaticUtils.quoteListenerAndHostAttributeKeys(behaviorName, this.compiler);
                if (NodeUtil.getFirstPropMatchingKey(behaviorName, "is") != null) {
                    this.compiler.report(JSError.make(behaviorName, PolymerPassErrors.POLYMER_INVALID_BEHAVIOR, new String[0]));
                }
                behaviors.add(new BehaviorDefinition(PolymerPassStaticUtils.extractProperties(behaviorName, PolymerClassDefinition.DefinitionType.ObjectLiteral, this.compiler), PolymerBehaviorExtractor.getBehaviorFunctionsToCopy(behaviorName), PolymerBehaviorExtractor.getNonPropertyMembersToCopy(behaviorName), !NodeUtil.isInFunction(behaviorName), (FeatureSet)NodeUtil.getEnclosingScript(behaviorName).getProp((byte)89)));
                continue;
            }
            GlobalNamespace.Name behaviorGlobalName = this.globalNames.getSlot(behaviorName.getQualifiedName());
            boolean isGlobalDeclaration = true;
            if (behaviorGlobalName == null) {
                this.compiler.report(JSError.make(behaviorName, PolymerPassErrors.POLYMER_UNQUALIFIED_BEHAVIOR, new String[0]));
                continue;
            }
            GlobalNamespace.Ref behaviorDeclaration = behaviorGlobalName.getDeclaration();
            if (behaviorDeclaration == null) {
                List<GlobalNamespace.Ref> behaviorRefs = behaviorGlobalName.getRefs();
                for (GlobalNamespace.Ref ref : behaviorRefs) {
                    if (!ref.isSet()) continue;
                    isGlobalDeclaration = false;
                    behaviorDeclaration = ref;
                    break;
                }
            }
            if (behaviorDeclaration == null) {
                this.compiler.report(JSError.make(behaviorName, PolymerPassErrors.POLYMER_UNQUALIFIED_BEHAVIOR, new String[0]));
                continue;
            }
            Node behaviorDeclarationNode = behaviorDeclaration.getNode();
            JSDocInfo behaviorInfo = NodeUtil.getBestJSDocInfo(behaviorDeclarationNode);
            if (behaviorInfo == null || !behaviorInfo.isPolymerBehavior()) {
                this.compiler.report(JSError.make(behaviorDeclarationNode, PolymerPassErrors.POLYMER_UNANNOTATED_BEHAVIOR, new String[0]));
            }
            if ((behaviorValue = NodeUtil.getRValueOfLValue(behaviorDeclarationNode)) == null) {
                this.compiler.report(JSError.make(behaviorName, PolymerPassErrors.POLYMER_UNQUALIFIED_BEHAVIOR, new String[0]));
                continue;
            }
            if (behaviorValue.isArrayLit()) {
                behaviors.addAll(this.extractBehaviors(behaviorValue));
                continue;
            }
            if (behaviorValue.isObjectLit()) {
                PolymerPassStaticUtils.switchDollarSignPropsToBrackets(behaviorValue, this.compiler);
                PolymerPassStaticUtils.quoteListenerAndHostAttributeKeys(behaviorValue, this.compiler);
                if (NodeUtil.getFirstPropMatchingKey(behaviorValue, "is") != null) {
                    this.compiler.report(JSError.make(behaviorValue, PolymerPassErrors.POLYMER_INVALID_BEHAVIOR, new String[0]));
                }
                behaviors.add(new BehaviorDefinition(PolymerPassStaticUtils.extractProperties(behaviorValue, PolymerClassDefinition.DefinitionType.ObjectLiteral, this.compiler), PolymerBehaviorExtractor.getBehaviorFunctionsToCopy(behaviorValue), PolymerBehaviorExtractor.getNonPropertyMembersToCopy(behaviorValue), isGlobalDeclaration, (FeatureSet)NodeUtil.getEnclosingScript(behaviorValue).getProp((byte)89)));
                continue;
            }
            this.compiler.report(JSError.make(behaviorName, PolymerPassErrors.POLYMER_UNQUALIFIED_BEHAVIOR, new String[0]));
        }
        return behaviors.build();
    }

    private static ImmutableList<PolymerPass.MemberDefinition> getBehaviorFunctionsToCopy(Node behaviorObjLit) {
        Preconditions.checkState(behaviorObjLit.isObjectLit());
        ImmutableList.Builder functionsToCopy = ImmutableList.builder();
        for (Node keyNode : behaviorObjLit.children()) {
            boolean isFunctionDefinition = keyNode.isStringKey() && keyNode.getFirstChild().isFunction() || keyNode.isMemberFunctionDef();
            if (!isFunctionDefinition || BEHAVIOR_NAMES_NOT_TO_COPY.contains(keyNode.getString())) continue;
            functionsToCopy.add(new PolymerPass.MemberDefinition(NodeUtil.getBestJSDocInfo(keyNode), keyNode, keyNode.getFirstChild()));
        }
        return functionsToCopy.build();
    }

    private static ImmutableList<PolymerPass.MemberDefinition> getNonPropertyMembersToCopy(Node behaviorObjLit) {
        Preconditions.checkState(behaviorObjLit.isObjectLit());
        ImmutableList.Builder membersToCopy = ImmutableList.builder();
        for (Node keyNode : behaviorObjLit.children()) {
            boolean isNonFunctionMember = keyNode.isGetterDef() || keyNode.isStringKey() && !keyNode.getFirstChild().isFunction();
            if (!isNonFunctionMember || BEHAVIOR_NAMES_NOT_TO_COPY.contains(keyNode.getString())) continue;
            membersToCopy.add(new PolymerPass.MemberDefinition(NodeUtil.getBestJSDocInfo(keyNode), keyNode, keyNode.getFirstChild()));
        }
        return membersToCopy.build();
    }

    static final class BehaviorDefinition {
        final List<PolymerPass.MemberDefinition> props;
        final List<PolymerPass.MemberDefinition> functionsToCopy;
        final List<PolymerPass.MemberDefinition> nonPropertyMembersToCopy;
        final boolean isGlobalDeclaration;
        final FeatureSet features;

        BehaviorDefinition(List<PolymerPass.MemberDefinition> props, List<PolymerPass.MemberDefinition> functionsToCopy, List<PolymerPass.MemberDefinition> nonPropertyMembersToCopy, boolean isGlobalDeclaration, FeatureSet features) {
            this.props = props;
            this.functionsToCopy = functionsToCopy;
            this.nonPropertyMembersToCopy = nonPropertyMembersToCopy;
            this.isGlobalDeclaration = isGlobalDeclaration;
            this.features = features;
        }
    }
}

