/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.Es6ToEs3Util;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.parsing.JsDocInfoParser;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfoBuilder;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;

class Es6TemplateLiterals {
    private static final String TEMPLATELIT_VAR = "$jscomp$templatelit$";

    Es6TemplateLiterals() {
    }

    static void visitTemplateLiteral(NodeTraversal t, Node n, boolean addTypes) {
        JSTypeRegistry registry = t.getCompiler().getTypeRegistry();
        JSType stringType = Es6ToEs3Util.createType(addTypes, registry, JSTypeNative.STRING_TYPE);
        int length = n.getChildCount();
        if (length == 0) {
            n.replaceWith(Es6ToEs3Util.withType(IR.string("\"\""), stringType));
        } else {
            Node first = n.removeFirstChild();
            Preconditions.checkState(first.isString());
            if (length == 1) {
                n.replaceWith(first);
            } else {
                Node add = Es6ToEs3Util.withType(IR.add(first, n.removeFirstChild().removeFirstChild()), n.getJSType());
                for (int i = 2; i < length; ++i) {
                    Node child = n.removeFirstChild();
                    if (child.isString()) {
                        if (child.getString().isEmpty()) continue;
                        if (i == 2 && first.getString().isEmpty()) {
                            add = add.getSecondChild().detach();
                        }
                    }
                    add = Es6ToEs3Util.withType(IR.add(add, child.isString() ? child : child.removeFirstChild()), n.getJSType());
                }
                n.replaceWith(add.useSourceInfoIfMissingFromForTree(n));
            }
        }
        t.reportCodeChange();
    }

    static void visitTaggedTemplateLiteral(NodeTraversal t, Node n, boolean addTypes) {
        JSTypeRegistry registry = t.getCompiler().getTypeRegistry();
        JSType stringType = Es6ToEs3Util.createType(addTypes, registry, JSTypeNative.STRING_TYPE);
        JSType arrayType = Es6ToEs3Util.createGenericType(addTypes, registry, JSTypeNative.ARRAY_TYPE, stringType);
        JSType templateArrayType = Es6ToEs3Util.createType(addTypes, registry, JSTypeNative.I_TEMPLATE_ARRAY_TYPE);
        Node templateLit = n.getLastChild();
        Node raw = Es6TemplateLiterals.createRawStringArray(templateLit, arrayType, stringType);
        Node cooked = Es6TemplateLiterals.createCookedStringArray(templateLit, templateArrayType, stringType);
        JSTypeExpression nonNullSiteObject = new JSTypeExpression(JsDocInfoParser.parseTypeString("!ITemplateArray"), "<Es6TemplateLiterals.java>");
        JSDocInfoBuilder info = new JSDocInfoBuilder(false);
        info.recordType(nonNullSiteObject);
        Node siteObject = Es6ToEs3Util.withType(IR.cast(cooked, info.build()), templateArrayType);
        Node callsiteId = Es6ToEs3Util.withType(IR.name(TEMPLATELIT_VAR + t.getCompiler().getUniqueNameIdSupplier().get()), templateArrayType);
        Node var = IR.var(callsiteId, siteObject).useSourceInfoIfMissingFromForTree(n);
        Node script = NodeUtil.getEnclosingScript(n);
        script.addChildToFront(var);
        t.reportCodeChange(var);
        Node defineRaw = IR.exprResult(Es6ToEs3Util.withType(IR.assign(Es6ToEs3Util.withType(IR.getprop(callsiteId.cloneNode(), Es6ToEs3Util.withType(IR.string("raw"), stringType)), arrayType), raw), arrayType)).useSourceInfoIfMissingFromForTree(n);
        script.addChildAfter(defineRaw, var);
        Node call = Es6ToEs3Util.withType(IR.call(n.removeFirstChild(), callsiteId.cloneNode()), n.getJSType());
        for (Node child = templateLit.getFirstChild(); child != null; child = child.getNext()) {
            if (child.isString()) continue;
            call.addChildToBack(child.removeFirstChild());
        }
        call.useSourceInfoIfMissingFromForTree(templateLit);
        call.putBooleanProp((byte)50, !call.getFirstChild().isGetProp());
        n.replaceWith(call);
        t.reportCodeChange();
    }

    private static Node createRawStringArray(Node n, JSType arrayType, JSType stringType) {
        Node array = Es6ToEs3Util.withType(IR.arraylit(new Node[0]), arrayType);
        for (Node child = n.getFirstChild(); child != null; child = child.getNext()) {
            if (!child.isString()) continue;
            array.addChildToBack(Es6ToEs3Util.withType(IR.string((String)child.getProp((byte)71)), stringType));
        }
        return array;
    }

    private static Node createCookedStringArray(Node n, JSType templateArrayType, JSType stringType) {
        Node array = Es6ToEs3Util.withType(IR.arraylit(new Node[0]), templateArrayType);
        for (Node child = n.getFirstChild(); child != null; child = child.getNext()) {
            if (!child.isString()) continue;
            Node string = Es6ToEs3Util.withType(IR.string(Es6TemplateLiterals.cookString((String)child.getProp((byte)71))), stringType);
            array.addChildToBack(string);
        }
        return array;
    }

    private static String cookString(String s) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        block10: while (i < s.length()) {
            char c;
            if ((c = s.charAt(i++)) == '\\') {
                char c2 = s.charAt(i++);
                switch (c2) {
                    case 't': {
                        sb.append('\t');
                        break;
                    }
                    case 'n': {
                        sb.append('\n');
                        break;
                    }
                    case 'r': {
                        sb.append('\r');
                        break;
                    }
                    case 'f': {
                        sb.append('\f');
                        break;
                    }
                    case 'b': {
                        sb.append('\b');
                        break;
                    }
                    case 'u': {
                        int unicodeValue = Integer.parseInt(s.substring(i, i + 4), 16);
                        sb.append((char)unicodeValue);
                        i += 4;
                        break;
                    }
                    case '\n': 
                    case '\u2028': 
                    case '\u2029': {
                        break;
                    }
                    case '\r': {
                        if (s.charAt(i + 1) != '\n') continue block10;
                        ++i;
                        break;
                    }
                    default: {
                        sb.append(c);
                        sb.append(c2);
                        break;
                    }
                }
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

