/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.Es6ToEs3Util;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.TranspilationPasses;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSDocInfoBuilder;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import com.google.javascript.rhino.TokenStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;

public final class Es6RewriteDestructuring
implements NodeTraversal.Callback,
HotSwapCompilerPass {
    public static final DiagnosticType UNEXPECTED_DESTRUCTURING_REST_PARAMETER = DiagnosticType.error("JSC_UNEXPECTED_DESTRUCTURING_REST_PARAMETER", "Es6RewriteDestructuring not expecting object pattern rest parameter");
    private final AbstractCompiler compiler;
    private final ObjectDestructuringRewriteMode rewriteMode;
    private final FeatureSet featuresToTriggerRunningPass;
    private final FeatureSet featuresToMarkAsRemoved;
    private final Deque<PatternNestingLevel> patternNestingStack = new ArrayDeque<PatternNestingLevel>();
    static final String DESTRUCTURING_TEMP_VAR = "$jscomp$destructuring$var";
    private int destructuringVarCounter = 0;

    private Es6RewriteDestructuring(Builder builder) {
        this.compiler = builder.compiler;
        this.rewriteMode = builder.rewriteMode;
        switch (this.rewriteMode) {
            case REWRITE_ALL_OBJECT_PATTERNS: {
                this.featuresToTriggerRunningPass = FeatureSet.BARE_MINIMUM.with(FeatureSet.Feature.DEFAULT_PARAMETERS, FeatureSet.Feature.DESTRUCTURING, FeatureSet.Feature.ARRAY_PATTERN_REST);
                this.featuresToMarkAsRemoved = this.featuresToTriggerRunningPass.with(FeatureSet.Feature.OBJECT_PATTERN_REST);
                break;
            }
            case REWRITE_OBJECT_REST: {
                this.featuresToMarkAsRemoved = this.featuresToTriggerRunningPass = FeatureSet.BARE_MINIMUM.with(FeatureSet.Feature.OBJECT_PATTERN_REST);
                break;
            }
            default: {
                throw new AssertionError((Object)("Es6RewriteDestructuring cannot handle ObjectDestructuringRewriteMode " + (Object)((Object)this.rewriteMode)));
            }
        }
    }

    @Override
    public void process(Node externs, Node root) {
        Preconditions.checkState(this.patternNestingStack.isEmpty());
        TranspilationPasses.processTranspile(this.compiler, externs, this.featuresToTriggerRunningPass, this);
        TranspilationPasses.processTranspile(this.compiler, root, this.featuresToTriggerRunningPass, this);
        TranspilationPasses.maybeMarkFeaturesAsTranspiledAway(this.compiler, this.featuresToMarkAsRemoved);
        Preconditions.checkState(this.patternNestingStack.isEmpty());
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        Preconditions.checkState(this.patternNestingStack.isEmpty());
        TranspilationPasses.hotSwapTranspile(this.compiler, scriptRoot, this.featuresToTriggerRunningPass, this);
        TranspilationPasses.maybeMarkFeaturesAsTranspiledAway(this.compiler, this.featuresToMarkAsRemoved);
        Preconditions.checkState(this.patternNestingStack.isEmpty());
    }

    @Override
    public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
        switch (n.getToken()) {
            case FUNCTION: {
                this.ensureArrowFunctionsHaveBlockBodies(t, n);
                break;
            }
            case PARAM_LIST: {
                this.pullDestructuringOutOfParams(n, parent);
                break;
            }
            case ARRAY_PATTERN: 
            case OBJECT_PATTERN: {
                boolean hasRest;
                boolean bl = hasRest = n.isObjectPattern() && n.hasChildren() && n.getLastChild().isRest();
                if (!this.patternNestingStack.isEmpty() && hasRest) {
                    for (PatternNestingLevel level : this.patternNestingStack) {
                        if (level.hasNestedObjectRest) break;
                        level.hasNestedObjectRest = true;
                    }
                    this.patternNestingStack.peekLast().hasNestedObjectRest = true;
                }
                this.patternNestingStack.addLast(new PatternNestingLevel(n, hasRest));
                break;
            }
        }
        return true;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (parent != null && parent.isDestructuringLhs()) {
            parent = parent.getParent();
        }
        switch (n.getToken()) {
            case ARRAY_PATTERN: 
            case OBJECT_PATTERN: {
                this.visitPattern(t, n, parent);
                if (n != this.patternNestingStack.getLast().pattern) break;
                this.patternNestingStack.removeLast();
                break;
            }
        }
    }

    private void ensureArrowFunctionsHaveBlockBodies(NodeTraversal t, Node function) {
        Node body = function.getLastChild();
        if (!body.isBlock()) {
            body.detach();
            Node replacement = IR.block(IR.returnNode(body)).useSourceInfoIfMissingFromForTree(body);
            function.addChildToBack(replacement);
            t.reportCodeChange();
        }
    }

    private void pullDestructuringOutOfParams(Node paramList, Node function) {
        Node insertSpot = null;
        Node body = function.getLastChild();
        int i = 0;
        Node next = null;
        Node param = paramList.getFirstChild();
        while (param != null) {
            next = param.getNext();
            if (param.isDefaultValue()) {
                Node newParam;
                Node nameOrPattern = param.removeFirstChild();
                JSDocInfo jsDoc = nameOrPattern.getJSDocInfo();
                nameOrPattern.setJSDocInfo(null);
                Node defaultValue = param.removeFirstChild();
                boolean isNoop = false;
                if (nameOrPattern.isName()) {
                    if (defaultValue.isName()) {
                        isNoop = "undefined".equals(defaultValue.getString());
                    } else if (defaultValue.isVoid()) {
                        isNoop = NodeUtil.isImmutableValue(defaultValue.getFirstChild());
                    }
                }
                if (isNoop) {
                    newParam = nameOrPattern.cloneTree();
                } else {
                    newParam = nameOrPattern.isName() ? nameOrPattern : IR.name(this.getTempParameterName(function, i));
                    Node lhs = nameOrPattern.cloneTree();
                    Node rhs = Es6RewriteDestructuring.defaultValueHook(newParam.cloneTree(), defaultValue);
                    Node newStatement = nameOrPattern.isName() ? IR.exprResult(IR.assign(lhs, rhs)) : IR.var(lhs, rhs);
                    newStatement.useSourceInfoIfMissingFromForTree(param);
                    body.addChildAfter(newStatement, insertSpot);
                    insertSpot = newStatement;
                }
                paramList.replaceChild(param, newParam);
                newParam.setOptionalArg(true);
                newParam.setJSDocInfo(jsDoc);
                this.compiler.reportChangeToChangeScope(function);
            } else if (param.isDestructuringPattern()) {
                insertSpot = this.replacePatternParamWithTempVar(function, insertSpot, param, this.getTempParameterName(function, i));
                this.compiler.reportChangeToChangeScope(function);
            } else if (param.isRest() && param.getFirstChild().isDestructuringPattern()) {
                insertSpot = this.replacePatternParamWithTempVar(function, insertSpot, param.getFirstChild(), this.getTempParameterName(function, i));
                this.compiler.reportChangeToChangeScope(function);
            }
            param = next;
            ++i;
        }
    }

    private Node replacePatternParamWithTempVar(Node function, Node insertSpot, Node patternParam, String tempVarName) {
        Node newParam = IR.name(tempVarName);
        newParam.setJSDocInfo(patternParam.getJSDocInfo());
        patternParam.replaceWith(newParam);
        Node newDecl = IR.var(patternParam, IR.name(tempVarName));
        function.getLastChild().addChildAfter(newDecl, insertSpot);
        return newDecl;
    }

    private String getTempParameterName(Node function, int parameterIndex) {
        JSDocInfo fnJSDoc = NodeUtil.getBestJSDocInfo(function);
        String tempVarName = fnJSDoc != null && fnJSDoc.getParameterNameAt(parameterIndex) != null ? fnJSDoc.getParameterNameAt(parameterIndex) : DESTRUCTURING_TEMP_VAR + this.destructuringVarCounter++;
        Preconditions.checkState(TokenStream.isJSIdentifier(tempVarName));
        return tempVarName;
    }

    private void visitPattern(NodeTraversal t, Node pattern, Node parent) {
        if (NodeUtil.isNameDeclaration(parent) && !NodeUtil.isEnhancedFor(parent.getParent())) {
            this.replacePattern(t, pattern, pattern.getNext(), parent, parent);
        } else if (parent.isAssign()) {
            if (parent.getParent().isExprResult()) {
                this.replacePattern(t, pattern, pattern.getNext(), parent, parent.getParent());
            } else {
                this.wrapAssignmentInCallToArrow(t, parent);
            }
        } else if (!(parent.isRest() || parent.isStringKey() || parent.isArrayPattern() || parent.isDefaultValue() || parent.isComputedProp())) {
            if (NodeUtil.isEnhancedFor(parent) || NodeUtil.isEnhancedFor(parent.getParent())) {
                this.visitDestructuringPatternInEnhancedFor(pattern);
            } else if (parent.isCatch()) {
                this.visitDestructuringPatternInCatch(t, pattern);
            } else {
                throw new IllegalStateException("unexpected parent");
            }
        }
    }

    private void replacePattern(NodeTraversal t, Node pattern, Node rhs, Node parent, Node nodeToDetach) {
        switch (pattern.getToken()) {
            case ARRAY_PATTERN: {
                this.replaceArrayPattern(t, pattern, rhs, parent, nodeToDetach);
                break;
            }
            case OBJECT_PATTERN: {
                this.replaceObjectPattern(t, pattern, rhs, parent, nodeToDetach);
                break;
            }
            default: {
                throw new IllegalStateException("unexpected");
            }
        }
    }

    private void replaceObjectPattern(NodeTraversal t, Node objectPattern, Node rhs, Node parent, Node nodeToDetach) {
        String tempVarName = DESTRUCTURING_TEMP_VAR + this.destructuringVarCounter++;
        String restTempVarName = null;
        ArrayList<Node> propsToDeleteForRest = null;
        if (objectPattern.hasChildren() && objectPattern.getLastChild().isRest()) {
            propsToDeleteForRest = new ArrayList<Node>();
            restTempVarName = DESTRUCTURING_TEMP_VAR + this.destructuringVarCounter++;
        } else if (this.rewriteMode == ObjectDestructuringRewriteMode.REWRITE_OBJECT_REST && !this.patternNestingStack.peekLast().hasNestedObjectRest) {
            --this.destructuringVarCounter;
            return;
        }
        Node tempDecl = IR.var(IR.name(tempVarName), rhs.detach()).useSourceInfoIfMissingFromForTree(objectPattern);
        if (parent.isConst()) {
            JSDocInfoBuilder jsDoc = new JSDocInfoBuilder(false);
            jsDoc.recordConstancy();
            tempDecl.setJSDocInfo(jsDoc.build());
        }
        nodeToDetach.getParent().addChildBefore(tempDecl, nodeToDetach);
        Node child = objectPattern.getFirstChild();
        while (child != null) {
            Node newNode;
            Node defaultValue;
            Node newRHS;
            Node newLHS;
            Node next = child.getNext();
            if (child.isStringKey()) {
                if (!child.hasChildren()) {
                    Node name = IR.name(child.getString());
                    name.useSourceInfoIfMissingFrom(child);
                    child.addChildToBack(name);
                }
                Node getprop = new Node(child.isQuotedString() ? Token.GETELEM : Token.GETPROP, IR.name(tempVarName), IR.string(child.getString()));
                Node value = child.removeFirstChild();
                if (!value.isDefaultValue()) {
                    newLHS = value;
                    newRHS = getprop;
                } else {
                    newLHS = value.removeFirstChild();
                    defaultValue = value.removeFirstChild();
                    newRHS = Es6RewriteDestructuring.defaultValueHook(getprop, defaultValue);
                }
                if (propsToDeleteForRest != null) {
                    Node propName = IR.string(child.getString());
                    if (child.isQuotedString()) {
                        propName.setQuotedString();
                    }
                    propsToDeleteForRest.add(propName);
                }
            } else if (child.isComputedProp()) {
                boolean hasDefault = child.getLastChild().isDefaultValue();
                Node defaultNode = null;
                defaultValue = null;
                Node propExpr = child.removeFirstChild();
                if (hasDefault) {
                    defaultNode = child.getLastChild();
                    newLHS = defaultNode.removeFirstChild();
                    defaultValue = defaultNode.removeFirstChild();
                } else {
                    newLHS = child.removeFirstChild();
                }
                if (propsToDeleteForRest != null) {
                    String exprEvalTempVarName = DESTRUCTURING_TEMP_VAR + this.destructuringVarCounter++;
                    Node exprEvalDecl = IR.var(IR.name(exprEvalTempVarName), propExpr);
                    exprEvalDecl.useSourceInfoIfMissingFromForTree(child);
                    nodeToDetach.getParent().addChildBefore(exprEvalDecl, nodeToDetach);
                    propExpr = IR.name(exprEvalTempVarName);
                    propsToDeleteForRest.add(IR.name(exprEvalTempVarName));
                }
                if (hasDefault) {
                    Node getelem = IR.getelem(IR.name(tempVarName), propExpr);
                    String intermediateTempVarName = DESTRUCTURING_TEMP_VAR + this.destructuringVarCounter++;
                    Node intermediateDecl = IR.var(IR.name(intermediateTempVarName), getelem);
                    intermediateDecl.useSourceInfoIfMissingFromForTree(child);
                    nodeToDetach.getParent().addChildBefore(intermediateDecl, nodeToDetach);
                    newRHS = Es6RewriteDestructuring.defaultValueHook(IR.name(intermediateTempVarName), defaultValue);
                } else {
                    newRHS = IR.getelem(IR.name(tempVarName), propExpr);
                }
            } else if (child.isDefaultValue()) {
                newLHS = child.removeFirstChild();
                Node defaultValue2 = child.removeFirstChild();
                Node getprop = IR.getprop(IR.name(tempVarName), IR.string(newLHS.getString()));
                newRHS = Es6RewriteDestructuring.defaultValueHook(getprop, defaultValue2);
                if (propsToDeleteForRest != null) {
                    propsToDeleteForRest.add(IR.stringKey(newLHS.getString()));
                }
            } else if (child.isRest()) {
                if (next != null) {
                    throw new IllegalStateException("object rest may not be followed by any properties");
                }
                Node assignCall = IR.call(NodeUtil.newQName(this.compiler, "Object.assign"), new Node[0]);
                assignCall.addChildToBack(IR.objectlit(new Node[0]));
                assignCall.addChildToBack(IR.name(tempVarName));
                Node restTempDecl = IR.var(IR.name(restTempVarName), assignCall);
                restTempDecl.useSourceInfoIfMissingFromForTree(objectPattern);
                nodeToDetach.getParent().addChildAfter(restTempDecl, tempDecl);
                newLHS = IR.name(child.getOnlyChild().getString());
                newRHS = this.objectPatternRestRHS(objectPattern, child, restTempVarName, propsToDeleteForRest);
            } else {
                throw new IllegalStateException("unexpected child");
            }
            if (NodeUtil.isNameDeclaration(parent)) {
                newNode = IR.declaration(newLHS, newRHS, parent.getToken());
            } else if (parent.isAssign()) {
                newNode = IR.exprResult(IR.assign(newLHS, newRHS));
            } else {
                throw new IllegalStateException("not reached");
            }
            newNode.useSourceInfoIfMissingFromForTree(child);
            nodeToDetach.getParent().addChildBefore(newNode, nodeToDetach);
            this.visit(t, newLHS, newLHS.getParent());
            child = next;
        }
        nodeToDetach.detach();
        t.reportCodeChange();
    }

    private Node objectPatternRestRHS(Node objectPattern, Node rest, String restTempVarName, ArrayList<Node> statedProperties) {
        Preconditions.checkArgument(objectPattern.getLastChild() == rest);
        Node result = IR.name(restTempVarName);
        if (!statedProperties.isEmpty()) {
            Iterator<Node> propItr = statedProperties.iterator();
            Node comma = this.deletionNodeForRestProperty(restTempVarName, propItr.next());
            while (propItr.hasNext()) {
                comma = IR.comma(comma, this.deletionNodeForRestProperty(restTempVarName, propItr.next()));
            }
            result = IR.comma(comma, result);
        }
        result.useSourceInfoIfMissingFromForTree(rest);
        return result;
    }

    private Node deletionNodeForRestProperty(String restTempVarName, Node property) {
        boolean useSquareBrackets = !property.isString() || property.isQuotedString();
        return new Node(Token.DELPROP, new Node(useSquareBrackets ? Token.GETELEM : Token.GETPROP, IR.name(restTempVarName), property));
    }

    private void replaceArrayPattern(NodeTraversal t, Node arrayPattern, Node rhs, Node parent, Node nodeToDetach) {
        if (this.rewriteMode == ObjectDestructuringRewriteMode.REWRITE_OBJECT_REST && (this.patternNestingStack.isEmpty() || !this.patternNestingStack.peekLast().hasNestedObjectRest)) {
            return;
        }
        String tempVarName = DESTRUCTURING_TEMP_VAR + this.destructuringVarCounter++;
        Node tempDecl = IR.var(IR.name(tempVarName), Es6ToEs3Util.makeIterator(this.compiler, rhs.detach()));
        tempDecl.useSourceInfoIfMissingFromForTree(arrayPattern);
        nodeToDetach.getParent().addChildBefore(tempDecl, nodeToDetach);
        Node child = arrayPattern.getFirstChild();
        while (child != null) {
            Node next = child.getNext();
            if (child.isEmpty()) {
                Node nextCall = IR.exprResult(IR.call(IR.getprop(IR.name(tempVarName), IR.string("next")), new Node[0]));
                nextCall.useSourceInfoIfMissingFromForTree(child);
                nodeToDetach.getParent().addChildBefore(nextCall, nodeToDetach);
            } else {
                Node newNode;
                Node newRHS;
                Node newLHS;
                if (child.isDefaultValue()) {
                    String nextVarName = DESTRUCTURING_TEMP_VAR + this.destructuringVarCounter++;
                    Node var = IR.var(IR.name(nextVarName), IR.getprop(IR.call(IR.getprop(IR.name(tempVarName), IR.string("next")), new Node[0]), IR.string("value")));
                    var.useSourceInfoIfMissingFromForTree(child);
                    nodeToDetach.getParent().addChildBefore(var, nodeToDetach);
                    newLHS = child.getFirstChild().detach();
                    newRHS = Es6RewriteDestructuring.defaultValueHook(IR.name(nextVarName), child.getLastChild().detach());
                } else if (child.isRest()) {
                    newLHS = child.getFirstChild().detach();
                    newRHS = Es6ToEs3Util.arrayFromIterator(this.compiler, IR.name(tempVarName));
                } else {
                    newLHS = child.detach();
                    newRHS = IR.getprop(IR.call(IR.getprop(IR.name(tempVarName), IR.string("next")), new Node[0]), IR.string("value"));
                }
                if (parent.isAssign()) {
                    Node assignment = IR.assign(newLHS, newRHS);
                    newNode = IR.exprResult(assignment);
                } else {
                    newNode = IR.declaration(newLHS, newRHS, parent.getToken());
                }
                newNode.useSourceInfoIfMissingFromForTree(arrayPattern);
                nodeToDetach.getParent().addChildBefore(newNode, nodeToDetach);
                this.visit(t, newLHS, newLHS.getParent());
            }
            child = next;
        }
        nodeToDetach.detach();
        t.reportCodeChange();
    }

    private void wrapAssignmentInCallToArrow(NodeTraversal t, Node assignment) {
        String tempVarName = DESTRUCTURING_TEMP_VAR + this.destructuringVarCounter++;
        Node rhs = assignment.getLastChild().detach();
        Node newAssignment = IR.let(IR.name(tempVarName), rhs);
        NodeUtil.addFeatureToScript(t.getCurrentFile(), FeatureSet.Feature.LET_DECLARATIONS);
        Node replacementExpr = IR.assign(assignment.getFirstChild().detach(), IR.name(tempVarName));
        Node exprResult = IR.exprResult(replacementExpr);
        Node returnNode = IR.returnNode(IR.name(tempVarName));
        Node block = IR.block(newAssignment, exprResult, returnNode);
        Node call = IR.call(IR.arrowFunction(IR.name(""), IR.paramList(), block), new Node[0]);
        NodeUtil.addFeatureToScript(t.getCurrentFile(), FeatureSet.Feature.ARROW_FUNCTIONS);
        call.useSourceInfoIfMissingFromForTree(assignment);
        call.putBooleanProp((byte)50, true);
        assignment.getParent().replaceChild(assignment, call);
        NodeUtil.markNewScopesChanged(call, this.compiler);
        this.replacePattern(t, replacementExpr.getFirstChild(), replacementExpr.getLastChild(), replacementExpr, exprResult);
    }

    private void visitDestructuringPatternInEnhancedFor(Node pattern) {
        Preconditions.checkArgument(pattern.isDestructuringPattern());
        String tempVarName = DESTRUCTURING_TEMP_VAR + this.destructuringVarCounter++;
        if (NodeUtil.isEnhancedFor(pattern.getParent())) {
            Node forNode = pattern.getParent();
            Node block = forNode.getLastChild();
            Node decl = IR.var(IR.name(tempVarName));
            decl.useSourceInfoIfMissingFromForTree(pattern);
            forNode.replaceChild(pattern, decl);
            Node exprResult = IR.exprResult(IR.assign(pattern, IR.name(tempVarName)));
            exprResult.useSourceInfoIfMissingFromForTree(pattern);
            block.addChildToFront(exprResult);
        } else {
            Node destructuringLhs = pattern.getParent();
            Preconditions.checkState(destructuringLhs.isDestructuringLhs());
            Node declarationNode = destructuringLhs.getParent();
            Node forNode = declarationNode.getParent();
            Preconditions.checkState(NodeUtil.isEnhancedFor(forNode));
            Node block = forNode.getLastChild();
            declarationNode.replaceChild(destructuringLhs, IR.name(tempVarName).useSourceInfoFrom(pattern));
            Token declarationType = declarationNode.getToken();
            Node decl = IR.declaration(pattern.detach(), IR.name(tempVarName), declarationType);
            decl.useSourceInfoIfMissingFromForTree(pattern);
            Node newBlock = IR.block(decl);
            block.replaceWith(newBlock);
            newBlock.addChildToBack(block);
        }
    }

    private void visitDestructuringPatternInCatch(NodeTraversal t, Node pattern) {
        String tempVarName = DESTRUCTURING_TEMP_VAR + this.destructuringVarCounter++;
        Node catchBlock = pattern.getNext();
        pattern.replaceWith(IR.name(tempVarName));
        catchBlock.addChildToFront(IR.declaration(pattern, IR.name(tempVarName), Token.LET));
        NodeUtil.addFeatureToScript(t.getCurrentFile(), FeatureSet.Feature.LET_DECLARATIONS);
    }

    private static Node defaultValueHook(Node getprop, Node defaultValue) {
        return IR.hook(IR.sheq(getprop, IR.name("undefined")), defaultValue, getprop.cloneTree());
    }

    private static final class PatternNestingLevel {
        final Node pattern;
        boolean hasNestedObjectRest;

        public PatternNestingLevel(Node pattern, boolean hasNestedRest) {
            this.pattern = pattern;
            this.hasNestedObjectRest = hasNestedRest;
        }
    }

    static class Builder {
        private final AbstractCompiler compiler;
        private ObjectDestructuringRewriteMode rewriteMode = ObjectDestructuringRewriteMode.REWRITE_ALL_OBJECT_PATTERNS;

        public Builder(AbstractCompiler compiler) {
            this.compiler = compiler;
        }

        public Builder setDestructuringRewriteMode(ObjectDestructuringRewriteMode rewriteMode) {
            this.rewriteMode = rewriteMode;
            return this;
        }

        public Es6RewriteDestructuring build() {
            return new Es6RewriteDestructuring(this);
        }
    }

    static enum ObjectDestructuringRewriteMode {
        REWRITE_ALL_OBJECT_PATTERNS,
        REWRITE_OBJECT_REST;

    }
}

