/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.Es6ToEs3Util;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.TranspilationPasses;
import com.google.javascript.jscomp.Var;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;

public final class Es6InjectRuntimeLibraries
extends NodeTraversal.AbstractPostOrderCallback
implements HotSwapCompilerPass {
    private final AbstractCompiler compiler;
    private final boolean getterSetterSupported;
    private static final FeatureSet requiredForFeatures = FeatureSet.ES6.without(FeatureSet.ES5);
    private static final FeatureSet knownToRequireSymbol = FeatureSet.BARE_MINIMUM.with(FeatureSet.Feature.FOR_OF, FeatureSet.Feature.SPREAD_EXPRESSIONS);

    public Es6InjectRuntimeLibraries(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.getterSetterSupported = !FeatureSet.ES3.contains(compiler.getOptions().getOutputFeatureSet());
    }

    @Override
    public void process(Node externs, Node root) {
        FeatureSet used = FeatureSet.ES3;
        for (Node script : root.children()) {
            used = used.with(Es6InjectRuntimeLibraries.getScriptFeatures(script));
        }
        if (used.contains(FeatureSet.Feature.FOR_OF)) {
            Es6ToEs3Util.preloadEs6RuntimeFunction(this.compiler, "makeIterator");
        }
        if (used.contains(FeatureSet.Feature.SPREAD_EXPRESSIONS)) {
            Es6ToEs3Util.preloadEs6RuntimeFunction(this.compiler, "arrayfromiterable");
        }
        if (used.contains(FeatureSet.Feature.GENERATORS)) {
            this.compiler.ensureLibraryInjected("es6/generator_engine", false);
        }
        boolean requiresSymbol = used.contains(knownToRequireSymbol);
        TranspilationPasses.processTranspile(this.compiler, root, requiredForFeatures, this);
    }

    private static FeatureSet getScriptFeatures(Node script) {
        FeatureSet features = NodeUtil.getFeatureSetOfScript(script);
        return features != null ? features : FeatureSet.ES3;
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        TranspilationPasses.hotSwapTranspile(this.compiler, scriptRoot, requiredForFeatures, this);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        switch (n.getToken()) {
            case NAME: {
                if (n.isFromExterns() || !this.isGlobalSymbol(t, n)) break;
                this.initSymbolBefore(n);
                break;
            }
            case GETPROP: {
                if (n.isFromExterns()) break;
                this.visitGetprop(t, n);
                break;
            }
            case GETTER_DEF: 
            case SETTER_DEF: {
                if (this.getterSetterSupported) break;
                Es6ToEs3Util.cannotConvert(this.compiler, n, "ES5 getters/setters (consider using --language_out=ES5)");
                break;
            }
        }
    }

    private boolean isGlobalSymbol(NodeTraversal t, Node n) {
        if (!n.matchesQualifiedName("Symbol")) {
            return false;
        }
        Var var = (Var)t.getScope().getVar("Symbol");
        return var == null || var.isGlobal();
    }

    private void initSymbolBefore(Node n) {
        this.compiler.ensureLibraryInjected("es6/symbol", false);
        Node statement = NodeUtil.getEnclosingStatement(n);
        Node initSymbol = IR.exprResult(IR.call(NodeUtil.newQName(this.compiler, "$jscomp.initSymbol"), new Node[0]));
        statement.getParent().addChildBefore(initSymbol.useSourceInfoFromForTree(statement), statement);
        this.compiler.reportChangeToEnclosingScope(initSymbol);
    }

    private void visitGetprop(NodeTraversal t, Node n) {
        if (!n.matchesQualifiedName("Symbol.iterator")) {
            return;
        }
        if (this.isGlobalSymbol(t, n.getFirstChild())) {
            this.compiler.ensureLibraryInjected("es6/symbol", false);
            Node statement = NodeUtil.getEnclosingStatement(n);
            Node init = IR.exprResult(IR.call(NodeUtil.newQName(this.compiler, "$jscomp.initSymbolIterator"), new Node[0]));
            statement.getParent().addChildBefore(init.useSourceInfoFromForTree(statement), statement);
            this.compiler.reportChangeToEnclosingScope(init);
        }
    }
}

