/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Objects;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.ErrorManager;
import com.google.javascript.jscomp.JSError;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.PriorityQueue;
import java.util.Set;

public abstract class BasicErrorManager
implements ErrorManager {
    final PriorityQueue<ErrorWithLevel> messages = new PriorityQueue<ErrorWithLevel>(1, new LeveledJSErrorComparator());
    private final Set<ErrorWithLevel> alreadyAdded = new HashSet<ErrorWithLevel>();
    private int originalErrorCount = 0;
    private int promotedErrorCount = 0;
    private int warningCount = 0;
    private double typedPercent = 0.0;

    @Override
    public void report(CheckLevel level, JSError error) {
        ErrorWithLevel e = new ErrorWithLevel(error, level);
        if (this.alreadyAdded.add(e)) {
            this.messages.add(e);
            if (level == CheckLevel.ERROR) {
                if (error.getType().level == CheckLevel.ERROR) {
                    ++this.originalErrorCount;
                } else {
                    ++this.promotedErrorCount;
                }
            } else if (level == CheckLevel.WARNING) {
                ++this.warningCount;
            }
        }
    }

    @Override
    public void generateReport() {
        ArrayList<ErrorWithLevel> list = new ArrayList<ErrorWithLevel>();
        ErrorWithLevel message = this.messages.poll();
        while (message != null) {
            this.println(message.level, message.error);
            list.add(message);
            message = this.messages.poll();
        }
        this.messages.addAll(list);
        this.printSummary();
    }

    public abstract void println(CheckLevel var1, JSError var2);

    protected abstract void printSummary();

    @Override
    public boolean hasHaltingErrors() {
        return this.originalErrorCount != 0;
    }

    @Override
    public int getErrorCount() {
        return this.originalErrorCount + this.promotedErrorCount;
    }

    @Override
    public int getWarningCount() {
        return this.warningCount;
    }

    @Override
    public JSError[] getErrors() {
        return this.toArray(CheckLevel.ERROR);
    }

    @Override
    public JSError[] getWarnings() {
        return this.toArray(CheckLevel.WARNING);
    }

    @Override
    public void setTypedPercent(double typedPercent) {
        this.typedPercent = typedPercent;
    }

    @Override
    public double getTypedPercent() {
        return this.typedPercent;
    }

    private JSError[] toArray(CheckLevel level) {
        ArrayList<JSError> errors = new ArrayList<JSError>(this.messages.size());
        for (ErrorWithLevel p : this.messages) {
            if (p.level != level) continue;
            errors.add(p.error);
        }
        return errors.toArray(new JSError[0]);
    }

    static class ErrorWithLevel {
        final JSError error;
        final CheckLevel level;

        ErrorWithLevel(JSError error, CheckLevel level) {
            this.error = error;
            this.level = level;
        }

        public int hashCode() {
            return Objects.hashCode(this.level, this.error.description, this.error.sourceName, this.error.lineNumber, this.error.getCharno());
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            return obj.hashCode() == this.hashCode();
        }
    }

    static final class LeveledJSErrorComparator
    implements Comparator<ErrorWithLevel> {
        private static final int P1_LT_P2 = -1;
        private static final int P1_GT_P2 = 1;

        LeveledJSErrorComparator() {
        }

        @Override
        public int compare(ErrorWithLevel p1, ErrorWithLevel p2) {
            int charno2;
            int lineno2;
            int lineno1;
            if (p2 == null) {
                if (p1 == null) {
                    return 0;
                }
                return 1;
            }
            if (p1.level != p2.level) {
                return p2.level.compareTo(p1.level);
            }
            String source1 = p1.error.sourceName;
            String source2 = p2.error.sourceName;
            if (source1 != null && source2 != null) {
                int sourceCompare = source1.compareTo(source2);
                if (sourceCompare != 0) {
                    return sourceCompare;
                }
            } else {
                if (source1 == null && source2 != null) {
                    return -1;
                }
                if (source1 != null && source2 == null) {
                    return 1;
                }
            }
            if ((lineno1 = p1.error.lineNumber) != (lineno2 = p2.error.lineNumber)) {
                return lineno1 - lineno2;
            }
            if (lineno1 < 0 && 0 <= lineno2) {
                return -1;
            }
            if (0 <= lineno1 && lineno2 < 0) {
                return 1;
            }
            int charno1 = p1.error.getCharno();
            if (charno1 != (charno2 = p2.error.getCharno())) {
                return charno1 - charno2;
            }
            if (charno1 < 0 && 0 <= charno2) {
                return -1;
            }
            if (0 <= charno1 && charno2 < 0) {
                return 1;
            }
            return p1.error.description.compareTo(p2.error.description);
        }
    }
}

