/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.TypeI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class RemoveUnusedClassProperties
implements CompilerPass,
NodeTraversal.Callback {
    private final AbstractCompiler compiler;
    private Set<String> used = new HashSet<String>();
    private List<Node> candidates = new ArrayList<Node>();
    private final boolean removeUnusedConstructorProperties;

    RemoveUnusedClassProperties(AbstractCompiler compiler, boolean removeUnusedConstructorProperties) {
        this.compiler = compiler;
        this.used.addAll(compiler.getExternProperties());
        this.removeUnusedConstructorProperties = removeUnusedConstructorProperties;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverseEs6(this.compiler, root, this);
        this.removeUnused();
    }

    private void removeUnused() {
        for (Node n : this.candidates) {
            Node replacement;
            Preconditions.checkState((boolean)n.isGetProp());
            String propName = n.getLastChild().getString();
            if (this.used.contains(propName)) continue;
            Node parent = n.getParent();
            if (NodeUtil.isAssignmentOp(parent)) {
                Node assign = parent;
                Preconditions.checkState((assign != null && NodeUtil.isAssignmentOp(assign) && assign.getFirstChild() == n ? 1 : 0) != 0);
                this.compiler.reportChangeToEnclosingScope(assign);
                replacement = assign.getLastChild().detachFromParent();
            } else if (parent.isInc() || parent.isDec()) {
                this.compiler.reportChangeToEnclosingScope(parent);
                replacement = IR.number(0.0).srcref(parent);
            } else {
                throw new IllegalStateException("unexpected: " + parent);
            }
            if (!n.isQualifiedName()) {
                Node preserved = n.getFirstChild();
                while (preserved.isGetProp()) {
                    preserved = preserved.getFirstChild();
                }
                replacement = IR.comma(preserved.detachFromParent(), replacement).srcref(parent);
            }
            this.compiler.reportChangeToEnclosingScope(parent);
            parent.getParent().replaceChild(parent, replacement);
        }
    }

    @Override
    public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
        return true;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        switch (n.getType()) {
            case 33: {
                String propName = n.getLastChild().getString();
                if (this.compiler.getCodingConvention().isExported(propName) || RemoveUnusedClassProperties.isPinningPropertyUse(n) || !this.isRemovablePropertyDefinition(n)) {
                    this.used.add(propName);
                    break;
                }
                this.candidates.add(n);
                break;
            }
            case 64: {
                for (Node c : n.children()) {
                    this.used.add(c.getString());
                }
                break;
            }
            case 37: {
                Node propName;
                Node target = n.getFirstChild();
                if (!n.hasMoreThanOneChild() || !target.isName() || !target.getString().equals("JSCompiler_renameProperty") || !(propName = target.getNext()).isString()) break;
                this.used.add(propName.getString());
            }
        }
    }

    private boolean isRemovablePropertyDefinition(Node n) {
        Preconditions.checkState((boolean)n.isGetProp());
        Node target = n.getFirstChild();
        return target.isThis() || this.removeUnusedConstructorProperties && this.isConstructor(target) || target.isGetProp() && target.getLastChild().getString().equals("prototype");
    }

    private boolean isConstructor(Node n) {
        TypeI type = n.getTypeI();
        return type != null && (type.isConstructor() || type.isInterface());
    }

    private static boolean isPinningPropertyUse(Node n) {
        Node parent = n.getParent();
        if (n == parent.getFirstChild()) {
            if (parent.isAssign()) {
                return false;
            }
            if (NodeUtil.isAssignmentOp(parent) || parent.isInc() || parent.isDec()) {
                return NodeUtil.isExpressionResultUsed(parent);
            }
        }
        return true;
    }
}

